/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.PageSetupImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XColumns;
import com.sun.star.helper.writer.XPageSetup;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.TextColumn;
import com.sun.star.text.XTextColumns;
import com.sun.star.uno.UnoRuntime;

public class ColumnsImpl
extends HelperInterfaceAdaptor
implements XColumns,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.TextColumns";
    private XTextColumns xTextColumns;
    private XPropertySet xPropertySet;
    private XPropertySet xColumnsProps;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public ColumnsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XTextColumns xTextColumns, XPropertySet xPropertySet) {
        super(__serviceName, helperInterfaceAdaptor);
        this.xTextColumns = xTextColumns;
        this.xPropertySet = xPropertySet;
        this.xColumnsProps = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ColumnsImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextColumns);
    }

    public XPageSetup getParent() {
        return (PageSetupImpl)this.getParentHelper();
    }

    public int getTextWidth() {
        int n = 0;
        try {
            int n2 = (Integer)this.xPropertySet.getPropertyValue("Width");
            int n3 = (Integer)this.xPropertySet.getPropertyValue("LeftMargin");
            int n4 = (Integer)this.xPropertySet.getPropertyValue("RightMargin");
            n = n2 - n3 - n4;
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        return n;
    }

    public void setCount(short s) {
        int n = 0;
        int n2 = 0;
        this.xTextColumns.setColumnCount(s);
        try {
            int n3 = this.getTextWidth();
            n = (n3 - (s - 1) * 1270) / s;
            if (n >= 1270) {
                this.xColumnsProps.setPropertyValue("AutomaticDistance", (Object)new Integer(1270));
            } else {
                n2 = (n3 - s * 1270) / (s - 1);
                this.xColumnsProps.setPropertyValue("AutomaticDistance", (Object)new Integer(n2));
            }
            this.xPropertySet.setPropertyValue("TextColumns", (Object)this.xTextColumns);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public void setWidth(int n) {
        int n2 = WriterUtilities.pointsToHundredthsMillimeter(n);
        short s = this.xTextColumns.getColumnCount();
        int n3 = this.getTextWidth();
        int n4 = (n3 - s * n2) / (s - 1);
        try {
            this.xColumnsProps.setPropertyValue("AutomaticDistance", (Object)new Integer(n4));
            this.xPropertySet.setPropertyValue("TextColumns", (Object)this.xTextColumns);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public int getWidth() {
        int n;
        int n2 = n = this.getTextWidth();
        TextColumn[] textColumnArray = this.xTextColumns.getColumns();
        int n3 = this.xTextColumns.getReferenceValue();
        int n4 = 0;
        while (n4 < textColumnArray.length) {
            int n5 = new Double(n * textColumnArray[n4].Width / n3).intValue();
            if ((n5 = n5 - textColumnArray[n4].LeftMargin - textColumnArray[n4].RightMargin) < n2) {
                n2 = n5;
            }
            ++n4;
        }
        Float f = new Float(WriterUtilities.hundredthsMillimeterToPoints(n2));
        return f.intValue();
    }

    public void setLineBetween(boolean bl) {
        try {
            this.xColumnsProps.setPropertyValue("SeparatorLineIsOn", (Object)new Boolean(bl));
            this.xColumnsProps.setPropertyValue("SeparatorLineWidth", (Object)new Integer(2));
            this.xPropertySet.setPropertyValue("TextColumns", (Object)this.xTextColumns);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public boolean getLineBetween() {
        boolean bl = false;
        try {
            bl = (Boolean)this.xColumnsProps.getPropertyValue("SeparatorLineIsOn");
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        return bl;
    }

    public void setEvenlySpaced(boolean bl) {
        block2: {
            if (!bl) break block2;
            TextColumn[] textColumnArray = this.xTextColumns.getColumns();
            int n = textColumnArray[0].RightMargin * 2;
            short s = this.xTextColumns.getColumnCount();
            this.xTextColumns.setColumnCount(s);
            try {
                this.xColumnsProps.setPropertyValue("AutomaticDistance", (Object)new Integer(n));
                this.xPropertySet.setPropertyValue("TextColumns", (Object)this.xTextColumns);
            }
            catch (Exception exception) {
                HelperUtilities.exception(exception);
            }
        }
    }

    public boolean getEvenlySpaced() {
        boolean bl = false;
        try {
            bl = (Boolean)this.xColumnsProps.getPropertyValue("IsAutomatic");
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        return bl;
    }

    public void setSpacing(float f) {
        int n = WriterUtilities.pointsToHundredthsMillimeter(f);
        if (!this.getEvenlySpaced()) {
            short s = this.xTextColumns.getColumnCount();
            this.xTextColumns.setColumnCount(s);
        }
        try {
            this.xColumnsProps.setPropertyValue("AutomaticDistance", (Object)new Integer(n));
            this.xPropertySet.setPropertyValue("TextColumns", (Object)this.xTextColumns);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public float getSpacing() {
        float f = 0.0f;
        int n = 0;
        if (!this.getEvenlySpaced()) {
            f = 9999999.0f;
        } else {
            try {
                n = (Integer)this.xColumnsProps.getPropertyValue("AutomaticDistance");
            }
            catch (Exception exception) {
                HelperUtilities.exception(exception);
            }
            f = WriterUtilities.hundredthsMillimeterToPoints(n);
        }
        return f;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xTextColumns;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

