/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XApplication;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.BookmarksImpl;
import com.sun.star.helper.writer.CharactersImpl;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.FieldsImpl;
import com.sun.star.helper.writer.FindImpl;
import com.sun.star.helper.writer.FontImpl;
import com.sun.star.helper.writer.ListFormatImpl;
import com.sun.star.helper.writer.ParagraphFormatImpl;
import com.sun.star.helper.writer.ParagraphsImpl;
import com.sun.star.helper.writer.RangeHelper;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.RangeMovementHelper;
import com.sun.star.helper.writer.RangeProperties;
import com.sun.star.helper.writer.SelectionImpl;
import com.sun.star.helper.writer.StylesImpl;
import com.sun.star.helper.writer.WordsImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.helper.writer.XBookmarks;
import com.sun.star.helper.writer.XBorders;
import com.sun.star.helper.writer.XCharacters;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XFields;
import com.sun.star.helper.writer.XFind;
import com.sun.star.helper.writer.XFont;
import com.sun.star.helper.writer.XListFormat;
import com.sun.star.helper.writer.XPageSetup;
import com.sun.star.helper.writer.XParagraph;
import com.sun.star.helper.writer.XParagraphFormat;
import com.sun.star.helper.writer.XParagraphs;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XRangeDelegateIfc;
import com.sun.star.helper.writer.XSpellingSuggestions;
import com.sun.star.helper.writer.XTables;
import com.sun.star.helper.writer.XTextFrame;
import com.sun.star.helper.writer.XWords;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XPageCursor;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XSentenceCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextField;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XWordCursor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public abstract class BaseRangeImpl
implements XRangeDelegateIfc,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Range";
    protected ParagraphsImpl m_cacheParagraphs = null;
    protected FontImpl m_cacheFont = null;
    protected RangeProperties m_props = new RangeProperties();
    static /* synthetic */ Class class$com$sun$star$text$XTextRangeCompare;
    static /* synthetic */ Class class$com$sun$star$text$XWordCursor;
    static /* synthetic */ Class class$com$sun$star$text$XParagraphCursor;
    static /* synthetic */ Class class$com$sun$star$text$XSentenceCursor;
    static /* synthetic */ Class class$com$sun$star$text$XTextField;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$text$XPageCursor;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;

    public boolean getEmpty() {
        return this.m_props.getXTextCursor().isCollapsed();
    }

    public XDocument getParent() {
        return this.m_props.getRangeImpl().getParent();
    }

    protected DocumentImpl getDocumentImpl() {
        return this.m_props.getDocumentImpl();
    }

    protected void initCursor(XTextRange xTextRange) {
        block7: {
            boolean bl = false;
            XText xText = this.m_props.getXText();
            try {
                this.m_props.setXTextCursor(xText.createTextCursorByRange(xTextRange));
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
            }
            if (!bl) {
                try {
                    XText xText2 = xTextRange.getText();
                    this.m_props.setXTextCursor(xText2.createTextCursor());
                    bl = true;
                }
                catch (Throwable throwable) {
                    DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
                }
            }
            if (bl) break block7;
            try {
                this.m_props.setXTextCursor(xText.createTextCursor());
                bl = true;
            }
            catch (Throwable throwable) {
                DebugHelper.warning(new com.sun.star.uno.Exception(throwable.getMessage()));
            }
        }
    }

    public XTextRange getXTextRange() {
        return this.m_props.getXTextCursor();
    }

    public XRange Range(XRange xRange, XRange xRange2) {
        return new RangeImpl(this.m_props.getRangeImpl().getParentAdaptor(), xRange, xRange2);
    }

    public XRange getStartAsRange() {
        return new RangeImpl((HelperInterfaceAdaptor)this.getDocumentImpl(), this.m_props.getXTextCursor().getStart(), false);
    }

    public int getStart() {
        DocumentImpl documentImpl = (DocumentImpl)this.getParent();
        XText xText = documentImpl.getXTextRange().getText();
        int n = RangeHelper.getPosition(xText, this.m_props.getXTextCursor().getStart());
        return n;
    }

    public XRange getEndAsRange() {
        return new RangeImpl((HelperInterfaceAdaptor)this.getDocumentImpl(), this.m_props.getXTextCursor().getEnd(), false);
    }

    public int getEnd() throws BasicErrorException {
        DocumentImpl documentImpl = (DocumentImpl)this.getParent();
        XText xText = documentImpl.getXTextRange().getText();
        XTables xTables = this.getTables();
        int n = RangeHelper.getTableAdjustment(xTables);
        int n2 = RangeHelper.getPosition(xText, this.m_props.getXTextCursor().getEnd());
        return n2;
    }

    public void Collapse(Object object) {
        int n = 1;
        try {
            n = OptionalParamUtility.getInt("Direction", object, 1, false);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        if (n == 0) {
            this.m_props.getXTextCursor().collapseToEnd();
        } else {
            this.m_props.getXTextCursor().collapseToStart();
        }
    }

    public void Select() {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        selectionImpl.select(this.m_props.getRangeImpl());
    }

    public void InsertBreak(byte by) {
    }

    public void setBold(int n) {
        this.getFont().setBold(n);
    }

    public int getBold() {
        return this.getFont().getBold();
    }

    public XBookmarks getBookmarks() throws BasicErrorException {
        return new BookmarksImpl(this.m_props.getRangeImpl());
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int n) {
        this.getFont().setUnderline(n);
    }

    public XParagraphs getParagraphs() {
        if (this.m_cacheParagraphs == null) {
            this.m_cacheParagraphs = new ParagraphsImpl(this.m_props.getRangeImpl());
        }
        return this.m_cacheParagraphs;
    }

    public XParagraphFormat getParagraphFormat() {
        return new ParagraphFormatImpl(this.m_props.getRangeImpl());
    }

    public XBorders getBorders() throws BasicErrorException {
        ParagraphFormatImpl paragraphFormatImpl = new ParagraphFormatImpl(this.m_props.getRangeImpl());
        return paragraphFormatImpl.getBorders();
    }

    public Object getStyle() {
        String string = StylesImpl.getHelperStyleName(this.getDocument(), this.m_props.getRangeImpl());
        return ((StylesImpl)this.getDocument().getStyles()).getStyleByName(string);
    }

    public void setStyle(Object object) throws BasicErrorException {
        StylesImpl.setHelperStyleAny(this.getDocument(), this.m_props.getRangeImpl(), object);
    }

    public XParagraph getParagraph(int n) throws BasicErrorException {
        return this.getParagraphs().Item(n);
    }

    public XFont getFont() {
        if (this.m_cacheFont == null) {
            this.m_cacheFont = new FontImpl(this.m_props.getRangeImpl());
        }
        return this.m_cacheFont;
    }

    public void setFont(XFont xFont) {
        this.m_cacheFont.setFontProperties(xFont);
    }

    public boolean rangeAtEndOfDocument() {
        DocumentImpl documentImpl = (DocumentImpl)this.getDocument();
        XTextRange xTextRange = documentImpl.getXTextRange().getEnd();
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BaseRangeImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)documentImpl.getXTextRange());
        try {
            if (xTextRangeCompare.compareRegionEnds(xTextRange, (XTextRange)this.m_props.getXTextCursor()) == 0 || xTextRangeCompare.compareRegionStarts(xTextRange, (XTextRange)this.m_props.getXTextCursor()) == 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return false;
    }

    public String getText() {
        String string = this.m_props.getXTextCursor().getString();
        int n = string.length();
        if (this.m_props.getMaySpanEndOfDocument() && n > 0 && string.charAt(n - 1) != '\n' && this.rangeAtEndOfDocument()) {
            return string + System.getProperty("line.separator", "\r\n");
        }
        if (n == 0) {
            if (this.m_props.getXTextCursor().isCollapsed()) {
                this.m_props.getXTextCursor().goRight((short)1, true);
                string = this.m_props.getXTextCursor().getString();
                this.m_props.getXTextCursor().collapseToStart();
            } else {
                XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
                XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
                this.m_props.getXTextCursor().collapseToEnd();
                this.m_props.getXTextCursor().goRight((short)1, true);
                string = this.m_props.getXTextCursor().getString();
                this.m_props.getXTextCursor().gotoRange(xTextRange, false);
                this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
            }
        }
        return string;
    }

    public void setText(String string) throws BasicErrorException {
        if (string != null) {
            if (string.indexOf(10) != -1) {
                this.m_props.getXTextCursor().setString("");
                RangeHelper.insertString((XTextRange)this.m_props.getXTextCursor(), this.m_props.getXText(), string, true);
            } else {
                this.m_props.getXTextCursor().setString(string);
            }
        }
    }

    public XRange getFormattedText() {
        return null;
    }

    public void setFormattedText(XRange xRange) {
    }

    public void setStart(XRange xRange) {
        this.setStartRange((XTextRange)((RangeImpl)xRange).getXTextCursor());
    }

    public void setEnd(XRange xRange) {
        this.m_props.setMaySpanEndOfDocument(((RangeImpl)xRange).getMaySpanEndOfDocument());
        this.setEndRange((XTextRange)((RangeImpl)xRange).getXTextCursor());
    }

    public XDocument getDocument() {
        return this.getParent();
    }

    public boolean IsEqual(XRange xRange) {
        return RangeHelper.compareRanges(xRange.getXTextRange(), (XTextRange)this.m_props.getXTextCursor());
    }

    public XApplication Application() {
        return ApplicationImpl.getInstance();
    }

    public int getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(int n) {
        this.getFont().setItalic(n);
    }

    public void setXTextRange(XTextRange xTextRange, XTextRange xTextRange2) {
        this.m_props.getXTextCursor().gotoRange(xTextRange.getStart(), false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2.getEnd(), true);
    }

    public void setXTextRange(XTextRange xTextRange) {
        this.m_props.setXTextRange(xTextRange);
    }

    public void setRange(XRange xRange, XRange xRange2) {
        this.m_props.setMaySpanEndOfDocument(((RangeImpl)xRange2).getMaySpanEndOfDocument());
        this.setXTextRange((XTextRange)((RangeImpl)xRange).getXTextCursor(), (XTextRange)((RangeImpl)xRange2).getXTextCursor());
    }

    public void InsertBefore(String string) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        RangeHelper.insertString(xTextRange, this.m_props.getXText(), string, true);
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
    }

    public void InsertAfter(String string) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
        RangeHelper.insertString(xTextRange, this.m_props.getXText(), string, true);
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
    }

    public int nextUnit(int n, int n2, boolean bl) throws BasicErrorException {
        return RangeMovementHelper.nextUnit(this.m_props, n, n2, bl);
    }

    public int previousUnit(int n, int n2, boolean bl) throws BasicErrorException {
        return RangeMovementHelper.previousUnit(this.m_props, n, n2, bl);
    }

    protected int startOfSelection(int n, boolean bl) throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocumentImpl().getActiveWindow().getSelection();
        XTextRange xTextRange = selectionImpl.getXTextRange();
        XTextRange xTextRange2 = xTextRange.getStart();
        XTextRange xTextRange3 = xTextRange.getEnd();
        boolean bl2 = selectionImpl.getVisible();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        int n2 = selectionImpl.startOf(n, bl);
        this.setXTextRange(selectionImpl.getXTextRange());
        selectionImpl.setXTextRange(xTextRange2, xTextRange3);
        return n2;
    }

    protected int endOfSelection(int n, boolean bl) throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocumentImpl().getActiveWindow().getSelection();
        XTextRange xTextRange = selectionImpl.getXTextRange();
        XTextRange xTextRange2 = xTextRange.getStart();
        XTextRange xTextRange3 = xTextRange.getEnd();
        boolean bl2 = selectionImpl.getVisible();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        int n2 = selectionImpl.endOf(n, bl);
        this.setXTextRange(selectionImpl.getXTextRange());
        selectionImpl.setXTextRange(xTextRange2, xTextRange3);
        return n2;
    }

    public XRange Next(Object object, Object object2) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        RangeImpl rangeImpl = (RangeImpl)this.Duplicate();
        int n2 = RangeHelper.getTextUnit(object, 1);
        if (n > 0) {
            if (!rangeImpl.getXTextCursor().isCollapsed()) {
                --n;
                RangeHelper.collapseLeftOrRight(true, rangeImpl.getXTextCursor(), rangeImpl.getDocument());
            }
            rangeImpl.nextUnit(n2, n, false);
            rangeImpl.nextUnit(n2, 1, true);
        } else if (n < 0) {
            ++n;
            if (!rangeImpl.getXTextCursor().isCollapsed()) {
                RangeHelper.collapseLeftOrRight(false, rangeImpl.getXTextCursor(), rangeImpl.getDocument());
            }
            rangeImpl.nextUnit(n2, n, false);
            rangeImpl.nextUnit(n2, -1, true);
        }
        return rangeImpl;
    }

    public XRange Previous(Object object, Object object2) throws BasicErrorException {
        int n = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        return this.Next(object, new Integer(-n));
    }

    public int StartOf(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 2);
        boolean bl = false;
        try {
            bl = NumericalHelper.toBoolean(object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        int n2 = 0;
        int n3 = n;
        RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        if (bl && this.m_props.getXTextCursor().isCollapsed()) {
            return this.previousUnit(n, 1, true);
        }
        XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().collapseToStart();
        switch (n3) {
            case 2: {
                XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XWordCursor == null ? (class$com$sun$star$text$XWordCursor = BaseRangeImpl.class$("com.sun.star.text.XWordCursor")) : class$com$sun$star$text$XWordCursor), (Object)this.m_props.getXTextCursor());
                if (xWordCursor.isStartOfWord()) break;
                xWordCursor.gotoStartOfWord(false);
                break;
            }
            case 4: {
                XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = BaseRangeImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)this.m_props.getXTextCursor());
                if (xParagraphCursor.isStartOfParagraph()) break;
                xParagraphCursor.gotoStartOfParagraph(false);
                break;
            }
            case 3: {
                XSentenceCursor xSentenceCursor = (XSentenceCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XSentenceCursor == null ? (class$com$sun$star$text$XSentenceCursor = BaseRangeImpl.class$("com.sun.star.text.XSentenceCursor")) : class$com$sun$star$text$XSentenceCursor), (Object)this.m_props.getXTextCursor());
                if (xSentenceCursor.isStartOfSentence()) break;
                xSentenceCursor.gotoStartOfSentence(false);
                break;
            }
            case 5: {
                n2 = this.startOfSelection(n, false);
                break;
            }
            case 6: {
                this.m_props.getXTextCursor().gotoRange(this.getDocumentImpl().getXTextRange().getStart(), false);
                break;
            }
            default: {
                throw new java.lang.IllegalArgumentException("Unsupported Unit " + n + " for Range/Selection StartOf");
            }
        }
        if (bl) {
            this.m_props.getXTextCursor().gotoRange(xTextRange, true);
        }
        return n2;
    }

    public int EndOf(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = 0;
        try {
            n2 = NumericalHelper.toInt(object2);
            if (n2 == -1) {
                n2 = 1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            n2 = 0;
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        int n3 = 0;
        int n4 = n;
        if (n2 == 0) {
            RangeHelper.collapseLeftOrRight(true, this.m_props.getXTextCursor(), this.getDocument());
        } else {
            RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        }
        this.m_props.setMaySpanEndOfDocument(true);
        XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XWordCursor == null ? (class$com$sun$star$text$XWordCursor = BaseRangeImpl.class$("com.sun.star.text.XWordCursor")) : class$com$sun$star$text$XWordCursor), (Object)this.m_props.getXTextCursor());
        switch (n4) {
            case 2: {
                xWordCursor.gotoEndOfWord(n2 == 1);
                break;
            }
            case 4: {
                XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = BaseRangeImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)this.m_props.getXTextCursor());
                xParagraphCursor.gotoEndOfParagraph(n2 == 1);
                break;
            }
            case 3: {
                XSentenceCursor xSentenceCursor = (XSentenceCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XSentenceCursor == null ? (class$com$sun$star$text$XSentenceCursor = BaseRangeImpl.class$("com.sun.star.text.XSentenceCursor")) : class$com$sun$star$text$XSentenceCursor), (Object)this.m_props.getXTextCursor());
                xSentenceCursor.gotoEndOfSentence(n2 == 1);
                break;
            }
            case 5: {
                n3 = this.endOfSelection(n, n2 == 1);
                break;
            }
            default: {
                throw new java.lang.IllegalArgumentException("Unsupported Unit " + n + " for Range/Selection StartOf");
            }
        }
        if (n4 != 5 || n2 == 1) {
            if (n4 != 3) {
                int n5;
                XTextRange xTextRange = xWordCursor.getStart();
                xWordCursor.collapseToEnd();
                xWordCursor.gotoNextWord(n2 == 1);
                String string = xWordCursor.getString();
                int n6 = string.length();
                if (n6 > 0 && (n5 = string.indexOf(10)) != -1 && n5 != n6 - 1) {
                    n3 += n5;
                    xWordCursor.collapseToStart();
                    xWordCursor.goRight((short)n5, true);
                }
                if (n2 == 1) {
                    XTextRange xTextRange2 = xWordCursor.getEnd();
                    xWordCursor.gotoRange(xTextRange, false);
                    xWordCursor.gotoRange(xTextRange2, true);
                } else {
                    xWordCursor.collapseToEnd();
                }
            } else {
                xWordCursor.gotoNextWord(n2 == 1);
            }
        }
        return n3;
    }

    public int Move(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        if (n2 > 0) {
            RangeHelper.collapseLeftOrRight(false, this.m_props.getXTextCursor(), this.getDocument());
            return this.nextUnit(n, n2, false);
        }
        RangeHelper.collapseLeftOrRight(true, this.m_props.getXTextCursor(), this.getDocument());
        return this.previousUnit(n, -n2, false);
    }

    public int MoveStart(Object object, Object object2) throws BasicErrorException {
        int n;
        block4: {
            int n2 = RangeHelper.getTextUnit(object, 1);
            n = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
            RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
            if (n == 0) {
                return 0;
            }
            XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
            this.m_props.getXTextCursor().collapseToStart();
            n = this.nextUnit(n2, n, false);
            XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(this.getDocument());
            try {
                if (xTextRangeCompare.compareRegionStarts((XTextRange)this.m_props.getXTextCursor(), xTextRange) < 0) {
                    this.m_props.getXTextCursor().collapseToStart();
                    break block4;
                }
                this.m_props.getXTextCursor().gotoRange(xTextRange, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
                this.m_props.getXTextCursor().gotoRange(xTextRange, true);
            }
        }
        return n;
    }

    public int MoveEnd(Object object, Object object2) throws BasicErrorException {
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        if (n2 == 0) {
            return 0;
        }
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        this.m_props.getXTextCursor().collapseToEnd();
        n2 = this.nextUnit(n, n2, false);
        XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(this.getDocument());
        try {
            if (xTextRangeCompare.compareRegionStarts((XTextRange)this.m_props.getXTextCursor(), xTextRange) < 0) {
                this.m_props.getXTextCursor().gotoRange(xTextRange, true);
                RangeHelper.swapDirection(this.m_props.getXTextCursor());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return n2;
    }

    public int MoveWhile(String string, Object object) {
        return 0;
    }

    public int MoveStartWhile(String string, Object object) {
        return 0;
    }

    public int MoveEndWhile(String string, Object object) {
        return 0;
    }

    public int MoveUntil(String string, Object object) {
        return 0;
    }

    public int MoveStartUntil(String string, Object object) {
        return 0;
    }

    public int MoveEndUntil(String string, Object object) {
        return 0;
    }

    public void Cut() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        selectionImpl.Cut();
    }

    public void Copy() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        selectionImpl.Copy();
    }

    public void Paste() throws BasicErrorException {
        SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
        RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
        selectionImpl.Paste();
    }

    public boolean InRange(XRange xRange) {
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BaseRangeImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)this.m_props.getXTextCursor().getText());
        try {
            if (xTextRangeCompare.compareRegionStarts(xRange.getXTextRange(), (XTextRange)this.m_props.getXTextCursor()) >= 0 && xTextRangeCompare.compareRegionEnds(xRange.getXTextRange(), (XTextRange)this.m_props.getXTextCursor()) <= 0) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return false;
    }

    public void Delete(Object object, Object object2) throws BasicErrorException {
        RangeImpl rangeImpl;
        int n = RangeHelper.getTextUnit(object, 1);
        int n2 = (int)OptionalParamUtility.getAnyNumber("Count", object2, 1L, false);
        int n3 = n;
        RangeHelper.collapseLeftOrRight(false, this.m_props.getXTextCursor(), this.getDocument());
        if (n2 == 0) {
            return;
        }
        if (n3 == 1 || n3 == 2) {
            rangeImpl = new RangeImpl((HelperInterfaceAdaptor)this.getDocumentImpl(), this.getXTextCursor().getStart(), false);
            if (n2 > 0) {
                rangeImpl.nextUnit(n, n2, true);
            } else {
                rangeImpl.previousUnit(n, -n2, true);
            }
            boolean bl = false;
            if (n2 < 0) {
                String string = rangeImpl.getXTextCursor().getString();
                if (string.indexOf(10) != -1) {
                    bl = true;
                }
                if (string.length() > 0 && string.charAt(string.length() - 1) != ' ') {
                    String string2;
                    int n4;
                    rangeImpl.getXTextCursor().collapseToStart();
                    do {
                        n4 = rangeImpl.previousUnit(1, 1, true);
                        string2 = rangeImpl.getXTextCursor().getString();
                    } while (n4 == 1 && string2.length() > 0 && string2.charAt(0) == ' ');
                    if (n4 == 1) {
                        rangeImpl.nextUnit(1, 1, true);
                    }
                    rangeImpl.setEndRange(this.getXTextRange());
                }
            }
            if (bl) {
                rangeImpl.getXTextCursor().setString(" ");
            } else {
                rangeImpl.getXTextCursor().setString("");
            }
        } else {
            throw new java.lang.IllegalArgumentException("Unit to delete must be either Character or Word");
        }
        this.m_props.getXTextCursor().gotoRange(rangeImpl.getXTextCursor().getStart(), false);
    }

    public int extendNext(boolean bl) throws BasicErrorException {
        int n;
        int n2 = n = 1;
        boolean bl2 = RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
        XTextRangeCompare xTextRangeCompare = RangeHelper.getRangeComparator(this.getDocument());
        try {
            do {
                if (n == 4) {
                    this.m_props.getXTextCursor().gotoRange(this.getDocumentImpl().getXTextRange().getStart(), false);
                } else if (n == 8) {
                    this.m_props.getXTextCursor().gotoRange(this.getDocumentImpl().getXTextRange().getStart(), false);
                } else {
                    this.m_props.getXTextCursor().collapseToStart();
                }
                n2 = n;
                n = RangeHelper.getNextExtent(n);
                this.nextUnit(n, 1, true);
                short s = xTextRangeCompare.compareRegionEnds((XTextRange)this.m_props.getXTextCursor(), xTextRange2);
                if (s > 0) continue;
                if (s == 0) {
                    n2 = n;
                }
                break;
            } while (n < 6);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        if (bl) {
            if (n == n2) {
                n2 = RangeHelper.getNextExtent(n);
                this.nextUnit(n2, 1, true);
            }
        } else {
            if (n > 4) {
                this.m_props.getXTextCursor().gotoRange(xTextRange, false);
            } else {
                this.m_props.getXTextCursor().collapseToStart();
            }
            this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
            if (bl2) {
                RangeHelper.forceStartPrecedesEnd(this.m_props.getXTextCursor(), this.getDocument());
            }
        }
        return n2;
    }

    public int Expand(Object object) throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().collapseToStart();
        int n = 0;
        try {
            n = this.nextUnit(RangeHelper.getTextUnit(object, 1), (int)OptionalParamUtility.getAnyNumber("Count", HelperUtilities.ANY_VOID, 1L, false), NumericalHelper.toBoolean(HelperUtilities.INTEGER_ONE));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        DocumentImpl documentImpl = (DocumentImpl)this.getDocument();
        XTextRangeCompare xTextRangeCompare = (XTextRangeCompare)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRangeCompare == null ? (class$com$sun$star$text$XTextRangeCompare = BaseRangeImpl.class$("com.sun.star.text.XTextRangeCompare")) : class$com$sun$star$text$XTextRangeCompare), (Object)documentImpl.getXTextRange());
        try {
            if (xTextRangeCompare.compareRegionEnds(xTextRange, (XTextRange)this.m_props.getXTextCursor()) > 0) {
                return n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
        return 0;
    }

    protected void setStartRange(XTextRange xTextRange) {
        XTextRange xTextRange2 = this.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().gotoRange(xTextRange, false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
    }

    public void setEndRange(XTextRange xTextRange) {
        this.m_props.getXTextCursor().collapseToStart();
        this.m_props.getXTextCursor().gotoRange(xTextRange, true);
    }

    public void InsertParagraph() throws BasicErrorException {
        this.m_props.getXTextCursor().setString("");
        RangeHelper.insertControlCharacter((XTextRange)this.m_props.getXTextCursor(), this.m_props.getXText(), (short)0, true);
    }

    public void InsertParagraphBefore() throws BasicErrorException {
        RangeHelper.insertControlCharacter(this.m_props.getXTextCursor().getStart(), this.m_props.getXText(), (short)0, true);
        this.m_props.getXTextCursor().goLeft((short)1, true);
        this.m_props.setXText(this.m_props.getXTextCursor().getText());
    }

    public void InsertParagraphAfter() throws BasicErrorException {
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        RangeHelper.insertControlCharacter(this.m_props.getXTextCursor().getEnd(), this.m_props.getXText(), (short)0, true);
        this.m_props.getXTextCursor().goRight((short)1, true);
        XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().gotoRange(xTextRange, false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
        this.m_props.setXText(this.m_props.getXTextCursor().getText());
    }

    public void WholeStory() {
        this.m_props.getXTextCursor().gotoRange(((DocumentImpl)this.getDocument()).getXTextRange(), false);
        this.m_props.setMaySpanEndOfDocument(true);
    }

    public void InsertDateTime(Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        Object object6 = null;
        String string = OptionalParamUtility.getString("DateTimeFormat", object, null, false);
        boolean bl = OptionalParamUtility.getBoolean("InsertAsField", object2, true, false);
        boolean bl2 = OptionalParamUtility.getBoolean("InsertAsFullWidth", object3, false, false);
        try {
            StringBuffer stringBuffer;
            XMultiServiceFactory xMultiServiceFactory = ((DocumentImpl)this.getDocument()).getXMultiServiceFactory();
            object6 = xMultiServiceFactory.createInstance("com.sun.star.text.TextField.DateTime");
            XTextField xTextField = (XTextField)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextField == null ? (class$com$sun$star$text$XTextField = BaseRangeImpl.class$("com.sun.star.text.XTextField")) : class$com$sun$star$text$XTextField), (Object)object6);
            if (bl2) {
                if (string == null) {
                    string = xTextField.getPresentation(true);
                }
                string = RangeHelper.doubleUp(stringBuffer = new StringBuffer(string), 'D') || RangeHelper.doubleUp(stringBuffer, 'M') ? stringBuffer.toString() : null;
            }
            stringBuffer = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xTextField);
            stringBuffer.setPropertyValue("IsFixed", Boolean.TRUE);
            if (string != null) {
                stringBuffer.setPropertyValue("NumberFormat", string);
            }
            this.m_props.getXText().insertTextContent((XTextRange)this.m_props.getXTextCursor(), (XTextContent)xTextField, bl);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getStatisticLineCount(int n) {
        XTextRange xTextRange = this.m_props.getXTextCursor().getStart();
        XTextRange xTextRange2 = this.m_props.getXTextCursor().getEnd();
        this.m_props.getXTextCursor().collapseToStart();
        int n2 = 0;
        switch (n) {
            case 1: {
                while (this.m_props.getXTextCursor().goRight((short)1, false)) {
                    ++n2;
                }
                break;
            }
            case 2: {
                XWordCursor xWordCursor = (XWordCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XWordCursor == null ? (class$com$sun$star$text$XWordCursor = BaseRangeImpl.class$("com.sun.star.text.XWordCursor")) : class$com$sun$star$text$XWordCursor), (Object)this.m_props.getXTextCursor());
                while (xWordCursor.gotoNextWord(false)) {
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XParagraphCursor == null ? (class$com$sun$star$text$XParagraphCursor = BaseRangeImpl.class$("com.sun.star.text.XParagraphCursor")) : class$com$sun$star$text$XParagraphCursor), (Object)this.m_props.getXTextCursor());
                while (xParagraphCursor.gotoNextParagraph(false)) {
                    ++n2;
                }
                break;
            }
            case 7: {
                XPageCursor xPageCursor = (XPageCursor)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XPageCursor == null ? (class$com$sun$star$text$XPageCursor = BaseRangeImpl.class$("com.sun.star.text.XPageCursor")) : class$com$sun$star$text$XPageCursor), (Object)this.m_props.getXTextCursor());
                if (xPageCursor == null) break;
                xPageCursor.jumpToLastPage();
                n2 = xPageCursor.getPage();
                break;
            }
            default: {
                while (this.m_props.getXTextCursor().goRight((short)1, false)) {
                    ++n2;
                }
                break block0;
            }
        }
        this.m_props.getXTextCursor().gotoRange(xTextRange, false);
        this.m_props.getXTextCursor().gotoRange(xTextRange2, true);
        return n2;
    }

    public XPageSetup PageSetup() {
        XDocument xDocument = this.getParent();
        return xDocument.getPageSetup();
    }

    public XWords Words() throws BasicErrorException {
        return new WordsImpl(this.m_props.getRangeImpl(), null);
    }

    public int getOrientation() throws BasicErrorException {
        int n = 0;
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.m_props.getRangeImpl().getParentAdaptor();
        if (helperInterfaceAdaptor instanceof XTextFrame) {
            try {
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_props.getXTextCursor());
                Object object = xPropertySet.getPropertyValue("CharRotation");
                short s = NumericalHelper.toShort(object);
                n = RangeHelper.getOrientationFromRotation(s);
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        } else {
            DebugHelper.exception(438, "");
        }
        return n;
    }

    public void setOrientation(int n) throws BasicErrorException {
        HelperInterfaceAdaptor helperInterfaceAdaptor = this.m_props.getRangeImpl().getParentAdaptor();
        if (helperInterfaceAdaptor instanceof XTextFrame) {
            short s = 0;
            try {
                s = RangeHelper.getRotationFromOrientation(n);
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = BaseRangeImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_props.getXTextCursor());
                xPropertySet.setPropertyValue("CharRotation", (Object)new Short(s));
            }
            catch (UnknownPropertyException unknownPropertyException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)unknownPropertyException));
            }
            catch (PropertyVetoException propertyVetoException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)propertyVetoException));
            }
            catch (NoSupportException noSupportException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)noSupportException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        } else {
            DebugHelper.exception(438, "");
        }
    }

    public XCharacters Characters() throws BasicErrorException {
        return new CharactersImpl(this.m_props.getRangeImpl());
    }

    public XFields Fields() throws BasicErrorException {
        return new FieldsImpl(this.m_props.getRangeImpl());
    }

    public int getLanguageID() throws BasicErrorException {
        int n = 9999999;
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object = xSelectionSupplier.getSelection();
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
            n = selectionImpl.getLanguageID();
            xSelectionSupplier.select(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n;
    }

    public void setLanguageID(int n) throws BasicErrorException {
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object = xSelectionSupplier.getSelection();
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            RangeHelper.setXTextRange(selectionImpl.getTextViewCursor(), this.getXTextRange());
            selectionImpl.setLanguageID(n);
            xSelectionSupplier.select(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    public XListFormat ListFormat() throws BasicErrorException {
        return new ListFormatImpl(this.m_props.getRangeImpl());
    }

    public XFind Find() throws BasicErrorException {
        FindImpl findImpl = null;
        try {
            findImpl = new FindImpl(this.m_props.getRangeImpl());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return findImpl;
    }

    public int Information(int n) throws BasicErrorException {
        int n2 = 9999999;
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object = xSelectionSupplier.getSelection();
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            xSelectionSupplier.select((Object)this.getXTextRange());
            n2 = selectionImpl.Information(n);
            xSelectionSupplier.select(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return n2;
    }

    public XTextCursor getXTextCursor() {
        return this.m_props.getXTextCursor();
    }

    public void setXTextCursor(XTextCursor xTextCursor) {
        this.m_props.setXTextCursor(xTextCursor);
    }

    public XText getXText() {
        return this.m_props.getXText();
    }

    public void setXText(XText xText) {
        this.m_props.setXText(xText);
    }

    public boolean getMaySpanEndOfDocument() {
        return this.m_props.getMaySpanEndOfDocument();
    }

    public void setMaySpanEndOfDocument(boolean bl) {
        this.m_props.setMaySpanEndOfDocument(bl);
    }

    public XRange GoTo(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        XRange xRange = null;
        try {
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = BaseRangeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.m_props.getRangeImpl().getXModel().getCurrentController());
            Object object5 = xSelectionSupplier.getSelection();
            xSelectionSupplier.select((Object)this.getXTextRange());
            SelectionImpl selectionImpl = (SelectionImpl)this.getDocument().getActiveWindow().getSelection();
            xRange = selectionImpl.GoTo(object, object2, object3, object4);
            xSelectionSupplier.select(object5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return xRange;
    }

    public RangeImpl getRangeImpl() {
        return this.m_props.getRangeImpl();
    }

    public XSpellingSuggestions GetSpellingSuggestions(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) throws BasicErrorException {
        XSpellingSuggestions xSpellingSuggestions = null;
        try {
            XRange xRange = this.Words().Item(new Integer(1));
            String string = xRange.getText();
            WriterImpl writerImpl = ApplicationImpl.getWriterImpl();
            xSpellingSuggestions = writerImpl.GetSpellingSuggestions(string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return xSpellingSuggestions;
    }

    public Object getUnoObject() {
        return this.m_props.getXTextRange();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

