/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XWindow2;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.XWindow;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.UnoRuntime;

public class WindowImpl
extends HelperInterfaceAdaptor
implements XWindow {
    private XFrame m_xFrame;
    private int m_nLeft;
    private int m_nTop;
    private int m_nHeight;
    private int m_nWidth;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$awt$XWindow2;

    public WindowImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XFrame xFrame, String string) {
        super(string, helperInterfaceAdaptor);
        com.sun.star.awt.XWindow xWindow;
        this.m_xFrame = xFrame;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            DebugHelper.writeInfo("#i43250# workaround");
            Rectangle rectangle = xWindow.getPosSize();
            this.m_nHeight = rectangle.Height;
            this.m_nWidth = rectangle.Width;
            this.m_nLeft = rectangle.X;
            this.m_nTop = rectangle.Y;
        }
    }

    public XFrame getXFrame() {
        return this.m_xFrame;
    }

    public void Activate() {
        this.m_xFrame.activate();
        this.m_xFrame.getContainerWindow().setFocus();
    }

    public XModel getXModel() {
        return (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = WindowImpl.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), (Object)this.m_xFrame.getController().getModel());
    }

    public int getWindowState() {
        return 0;
    }

    public void setWindowState(int n) throws NoSupportException {
        if (n == 0) {
            return;
        }
        throw new NoSupportException("Restriction in VCL, we can't handle the WindowState to minimize or maximize.");
    }

    public void setWidth(int n) {
        com.sun.star.awt.XWindow xWindow;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            xWindow.setPosSize(0, 0, n, this.m_nHeight, (short)4);
        }
    }

    public int getWidth() {
        com.sun.star.awt.XWindow xWindow;
        int n = 0;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            Rectangle rectangle = xWindow.getPosSize();
            n = rectangle.Width;
        }
        return n;
    }

    public void setHeight(int n) {
        com.sun.star.awt.XWindow xWindow;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            xWindow.setPosSize(0, 0, this.m_nWidth, n, (short)8);
        }
    }

    public int getHeight() {
        com.sun.star.awt.XWindow xWindow;
        int n = 0;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            Rectangle rectangle = xWindow.getPosSize();
            n = rectangle.Height;
        }
        return n;
    }

    public void setLeft(int n) {
        com.sun.star.awt.XWindow xWindow;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            xWindow.setPosSize(n, this.m_nTop, 0, 0, (short)1);
            if (CommonUtilities.isVersion7()) {
                this.m_nLeft = n;
            }
        }
    }

    public int getLeft() {
        com.sun.star.awt.XWindow xWindow;
        int n = 0;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            Rectangle rectangle = xWindow.getPosSize();
            n = rectangle.X;
            if (CommonUtilities.isVersion7()) {
                n = this.m_nLeft;
            }
        }
        return n;
    }

    public void setTop(int n) {
        com.sun.star.awt.XWindow xWindow;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            xWindow.setPosSize(this.m_nLeft, n, 0, 0, (short)2);
            if (CommonUtilities.isVersion7()) {
                this.m_nTop = n;
            }
        }
    }

    public int getTop() {
        com.sun.star.awt.XWindow xWindow;
        int n = 0;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            Rectangle rectangle = xWindow.getPosSize();
            n = rectangle.Y;
            if (CommonUtilities.isVersion7()) {
                n = this.m_nTop;
            }
        }
        return n;
    }

    public void setCaption(String string) {
        this.setDocumentNameInWindowTitle(string);
    }

    void setDocumentNameInWindowTitle(String string) {
        XFrame xFrame = this.getXFrame();
        PropertySetHelper propertySetHelper = new PropertySetHelper(xFrame);
        String string2 = propertySetHelper.getPropertyValueAsString("Title", "");
        int n = string2.lastIndexOf(" - ");
        String string3 = n >= 0 ? string + string2.substring(n) : string;
        propertySetHelper.setPropertyValueDontThrow("Title", string3);
    }

    public String getCaption() {
        XFrame xFrame = this.getXFrame();
        PropertySetHelper propertySetHelper = new PropertySetHelper(xFrame);
        String string = propertySetHelper.getPropertyValueAsString("Title", "");
        int n = string.lastIndexOf(" - ");
        String string2 = n >= 0 ? string.substring(0, n) : string;
        return string2;
    }

    void setApplicationNameInWindowTitle(String string) {
        XFrame xFrame = this.getXFrame();
        PropertySetHelper propertySetHelper = new PropertySetHelper(xFrame);
        String string2 = propertySetHelper.getPropertyValueAsString("Title", "");
        int n = string2.lastIndexOf(" - ");
        String string3 = n >= 0 ? string2.substring(0, n) : string2;
        string3 = string3 + " - " + string;
        propertySetHelper.setPropertyValueDontThrow("Title", string3);
    }

    public void setSplit(boolean bl) throws BasicErrorException {
        if (bl) {
            DispatchCommand.execute(".uno:NewWindow", this.getXFrame());
        }
    }

    public void setVisible(boolean bl) {
        com.sun.star.awt.XWindow xWindow;
        if (this.m_xFrame != null && (xWindow = this.m_xFrame.getContainerWindow()) != null) {
            xWindow.setVisible(bl);
        }
    }

    public boolean getVisible() {
        com.sun.star.awt.XWindow xWindow;
        XWindow2 xWindow2;
        boolean bl = true;
        if (this.m_xFrame != null && (xWindow2 = (XWindow2)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XWindow2 == null ? (class$com$sun$star$awt$XWindow2 = WindowImpl.class$("com.sun.star.awt.XWindow2")) : class$com$sun$star$awt$XWindow2), (Object)(xWindow = this.m_xFrame.getContainerWindow()))) != null) {
            bl = xWindow2.isVisible();
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

