/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.XFastPropertySet;
import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.MSO2SOIntMapping;
import com.sun.star.helper.common.MSO2SOStringMapping;
import com.sun.star.uno.UnoRuntime;

public class PropertiesMapping
extends MSO2SOStringMapping {
    private static final char FLAG_PROP_STATIC = ':';
    private static final char FLAG_PROP_DYNAMIC = ':';
    private final XPropertySet xDefaultPropertySet;
    private final MSO2SOIntMapping indexMapping;
    static /* synthetic */ Class class$com$sun$star$beans$XFastPropertySet;

    public PropertiesMapping(String[][] stringArray, XPropertySet xPropertySet) {
        this(stringArray, xPropertySet, null);
    }

    public PropertiesMapping(String[][] stringArray, XPropertySet xPropertySet, MSO2SOIntMapping mSO2SOIntMapping) {
        super(stringArray);
        this.xDefaultPropertySet = xPropertySet;
        this.indexMapping = mSO2SOIntMapping;
        this.sanityCheck();
    }

    private void sanityCheck() {
        if (this.indexMapping != null && this.indexMapping.size() != this.size()) {
            throw new IllegalStateException("An MSO2SOIntMapping was provided but it is not the same length as the MSO2SOStringMapping");
        }
    }

    public XPropertySet getDefaultPropertySet() {
        return this.xDefaultPropertySet;
    }

    public Object getPropertyValue(String string) {
        return this.getPropertyValue(string, this.xDefaultPropertySet);
    }

    public Object getPropertyValue(String string, XPropertySet xPropertySet) {
        String string2 = this.getSOFromMSO(string);
        if (string2 == null || string2.length() < 2) {
            return null;
        }
        Object object = null;
        char c = string2.charAt(0);
        if (c == ':') {
            object = this.getDynamicPropertyValue(string, string2);
            if (object == null) {
                object = string2.charAt(1) == 'n' ? HelperUtilities.INTEGER_ZERO : "";
            }
        } else {
            object = c == ':' ? this.getStaticPropertyValue(string, string2) : this.getSoPropertyValue(string2, xPropertySet);
        }
        return object;
    }

    public Object getSoPropertyValue(String string, XPropertySet xPropertySet) {
        try {
            return xPropertySet.getPropertyValue(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            HelperUtilities.exception(exception);
            return null;
        }
    }

    public Object getPropertyValue(int n) {
        return this.getPropertyValue(n, this.xDefaultPropertySet);
    }

    public Object getPropertyValue(int n, XPropertySet xPropertySet) {
        if (this.indexMapping != null) {
            return this.getSoPropertyValue(this.indexMapping.getSOIndexFromMSO(n), xPropertySet);
        }
        throw new IllegalArgumentException("Invalid property index " + n);
    }

    public Object getSoPropertyValue(int n, XPropertySet xPropertySet) {
        XFastPropertySet xFastPropertySet = (XFastPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XFastPropertySet == null ? (class$com$sun$star$beans$XFastPropertySet = PropertiesMapping.class$("com.sun.star.beans.XFastPropertySet")) : class$com$sun$star$beans$XFastPropertySet), (Object)xPropertySet);
        int n2 = this.indexMapping.getSOValueAtIndex(n);
        Object object = null;
        if (xFastPropertySet == null || n2 == -1) {
            String string = this.getSOAtIndex(n);
            HelperUtilities.debug("Not a XFastPropertySet, assume index " + n + " corresponds to SO property " + string);
            object = this.getSoPropertyValue(string, xPropertySet);
        }
        try {
            object = xFastPropertySet.getFastPropertyValue(n2);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        return object;
    }

    public Object getDynamicPropertyValue(String string, String string2) {
        throw new IllegalStateException("Please subclass PropertiesMapping and override getDynamicPropertyValue() to handle dynamic property " + string2);
    }

    public Object getStaticPropertyValue(String string, String string2) {
        String string3 = string2.substring(1);
        boolean bl = true;
        int n = string3.length() - 1;
        while (n > 0) {
            if (!Character.isDigit(string3.charAt(n))) {
                bl = false;
                break;
            }
            --n;
        }
        if (bl) {
            return Integer.valueOf(string3);
        }
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

