/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexReplace;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;

public class PresetPropertiesForListTemplates {
    public static final int TEMPLATE_TYPE1 = 1;
    public static final int TEMPLATE_TYPE2 = 2;
    public static final int TEMPLATE_TYPE3 = 3;
    public static final int TEMPLATE_TYPE4 = 4;
    public static final int TEMPLATE_TYPE5 = 5;
    public static final int TEMPLATE_TYPE6 = 6;
    public static final int TEMPLATE_TYPE7 = 7;
    public static final int TEMPLATE_TYPE_MIN = 1;
    public static final int TEMPLATE_TYPE_MAX = 7;
    public static final int BULLET_LIST_TEMPLATES_COUNT = 1;
    public static final int NUMBERED_LIST_TEMPLATES_COUNT = 1;
    public static final int OUTLINE_LIST_TEMPLATES_COUNT = 9;
    public static final int INDEX_NUMBERING_TYPE = 0;
    public static final int INDEX_SUFFIX = 1;
    public static final int INDEX_PREFIX = 2;
    public static final int INDEX_PARENT_NUMBERING = 3;
    public static final int INDEX_CHAR_STYLE_NAME = 4;
    public static final int INDEX_BULLET_ID = 5;
    public static final int INDEX_COUNT = 6;
    public static final int LIST_LEVEL0 = 0;
    public static final int LIST_LEVEL1 = 1;
    public static final int LIST_LEVEL2 = 2;
    public static final int LIST_LEVEL3 = 3;
    public static final int LIST_LEVEL4 = 4;
    public static final int LIST_LEVEL5 = 5;
    public static final int LIST_LEVEL6 = 6;
    public static final int LIST_LEVEL7 = 7;
    public static final int LIST_LEVEL8 = 8;
    public static final int LIST_LEVEL_COUNT = 9;
    private PropertyValue[][] properties;
    private XIndexAccess xNumberingRules;
    private int iListType;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$container$XIndexReplace;

    public PresetPropertiesForListTemplates(XTextDocument xTextDocument, int n, int n2) throws BasicErrorException {
        if (n2 < 1 || n2 > 7) {
            DebugHelper.exception(14, "index");
        }
        this.xNumberingRules = this.createNumberingRules(xTextDocument);
        this.createPropertyPreset();
        switch (n) {
            case 1: {
                this.createBulletListTemplate(n2);
                break;
            }
            case 2: {
                this.createNumberedListTemplate(n2);
                break;
            }
            case 3: {
                this.createOutlineNumberedListTemplate(n2);
                break;
            }
            default: {
                DebugHelper.exception(14, "type");
            }
        }
        this.iListType = n;
        this.completeNumberingRules();
    }

    public XIndexAccess getNumberingRules() {
        return this.xNumberingRules;
    }

    public int getTemplatesCount() throws BasicErrorException {
        int n = 0;
        switch (this.iListType) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 9;
                break;
            }
            default: {
                DebugHelper.exception(51, "");
            }
        }
        return n;
    }

    private void createBulletListTemplate(int n) {
        this.properties[0][4].Value = "Bullet Symbols";
        this.properties[0][0].Value = new Short(6);
        switch (n) {
            case 1: {
                this.properties[0][5].Value = new Short(8226);
                break;
            }
            case 2: {
                this.properties[0][5].Value = new Short(111);
                break;
            }
            case 3: {
                this.properties[0][5].Value = new Short(9632);
                break;
            }
            case 4: {
                this.properties[0][5].Value = new Short(10026);
                break;
            }
            case 5: {
                this.properties[0][5].Value = new Short(10070);
                break;
            }
            case 6: {
                this.properties[0][5].Value = new Short(10146);
                break;
            }
            case 7: {
                this.properties[0][5].Value = new Short(10003);
                break;
            }
            default: {
                this.properties[0][5].Value = new Short(8226);
            }
        }
    }

    private void createNumberedListTemplate(int n) {
        switch (n) {
            case 1: {
                this.properties[0][0].Value = new Short(4);
                this.properties[0][1].Value = ".";
                break;
            }
            case 2: {
                this.properties[0][0].Value = new Short(4);
                this.properties[0][1].Value = ")";
                break;
            }
            case 3: {
                this.properties[0][0].Value = new Short(2);
                this.properties[0][1].Value = ".";
                break;
            }
            case 4: {
                this.properties[0][0].Value = new Short(0);
                this.properties[0][1].Value = ".";
                break;
            }
            case 5: {
                this.properties[0][0].Value = new Short(1);
                this.properties[0][1].Value = ")";
                break;
            }
            case 6: {
                this.properties[0][0].Value = new Short(1);
                this.properties[0][1].Value = ".";
                break;
            }
            case 7: {
                this.properties[0][0].Value = new Short(3);
                this.properties[0][1].Value = ".";
                break;
            }
            default: {
                this.properties[0][0].Value = new Short(12);
                this.properties[0][1].Value = ".";
            }
        }
    }

    private XIndexAccess createNumberingRules(XTextDocument xTextDocument) throws BasicErrorException {
        XIndexAccess xIndexAccess = null;
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = PresetPropertiesForListTemplates.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
            Object object = xMultiServiceFactory.createInstance("com.sun.star.text.NumberingRules");
            if (object == null) {
                DebugHelper.exception(51, "Cannote create numbering rules.");
            } else {
                xIndexAccess = (XIndexAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = PresetPropertiesForListTemplates.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess, object);
                int n = xIndexAccess.getCount();
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = PresetPropertiesForListTemplates.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object);
                String string = (String)xPropertySet.getPropertyValue("Name");
                DebugHelper.writeInfo("Name: '" + string + "'  Count: " + n);
                if (n < 9) {
                    DebugHelper.exception(51, "LevelCount");
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return xIndexAccess;
    }

    private void completeNumberingRules() throws BasicErrorException {
        int n;
        int n2 = 1;
        while (n2 < 9) {
            n = 0;
            while (n < 6) {
                if (AnyConverter.isVoid((Object)this.properties[n2][n].Value)) {
                    this.properties[n2][n] = this.properties[0][n];
                }
                ++n;
            }
            ++n2;
        }
        try {
            n = 0;
            while (n < 9) {
                PropertyValue[] propertyValueArray = (PropertyValue[])this.xNumberingRules.getByIndex(n);
                int n3 = 0;
                while (n3 < propertyValueArray.length) {
                    int n4 = 0;
                    while (n4 < this.properties[0].length) {
                        if (propertyValueArray[n3].Name.equals(this.properties[n][n4].Name)) {
                            propertyValueArray[n3].Value = this.properties[n][n4].Value;
                            DebugHelper.writeDebug("Property Name: " + this.properties[n][n4].Name + "  Value: " + this.properties[n][n4].Value);
                        }
                        ++n4;
                    }
                    ++n3;
                }
                XIndexReplace xIndexReplace = (XIndexReplace)OptionalParamUtility.getObject(class$com$sun$star$container$XIndexReplace == null ? PresetPropertiesForListTemplates.class$("com.sun.star.container.XIndexReplace") : class$com$sun$star$container$XIndexReplace, this.xNumberingRules);
                xIndexReplace.replaceByIndex(n, (Object)propertyValueArray);
                ++n;
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    private void createOutlineNumberedListTemplate(int n) {
        switch (n) {
            case 1: {
                this.createOutlineNumberForType1();
                break;
            }
            case 2: {
                this.createOutlineNumberForType2();
                break;
            }
            case 3: {
                this.createOutlineNumberForType3();
                break;
            }
            case 4: {
                this.createOutlineNumberForType4();
                break;
            }
            case 5: {
                this.createOutlineNumberForType5();
                break;
            }
            case 6: {
                this.createOutlineNumberForType6();
                break;
            }
            case 7: {
                this.createOutlineNumberForType7();
                break;
            }
        }
    }

    private void createOutlineNumberForType1() {
        this.properties[0][0].Value = new Short(4);
        this.properties[0][1].Value = ")";
        this.properties[1][0].Value = new Short(4);
        this.properties[1][1].Value = ")";
        this.properties[2][0].Value = new Short(3);
        this.properties[2][1].Value = ")";
        this.properties[3][0].Value = new Short(4);
        this.properties[3][2].Value = "(";
        this.properties[3][1].Value = ")";
        this.properties[4][0].Value = new Short(1);
        this.properties[4][2].Value = "(";
        this.properties[4][1].Value = ")";
        this.properties[5][0].Value = new Short(3);
        this.properties[5][2].Value = "(";
        this.properties[5][1].Value = ")";
        this.properties[6][0].Value = new Short(4);
        this.properties[6][1].Value = ".";
        this.properties[7][0].Value = new Short(1);
        this.properties[7][1].Value = ".";
        this.properties[8][0].Value = new Short(3);
        this.properties[8][1].Value = ".";
    }

    private void createOutlineNumberForType2() {
        this.properties[0][0].Value = new Short(4);
        this.properties[0][1].Value = ".";
        int n = 1;
        while (n < 9) {
            this.properties[n][0].Value = new Short(4);
            this.properties[n][1].Value = ".";
            this.properties[n][3].Value = new Short((short)(n - 1));
            ++n;
        }
    }

    private void createOutlineNumberForType3() {
        int n = 0;
        while (n < 9) {
            this.properties[n][4].Value = "Bullet Symbols";
            this.properties[n][0].Value = new Short(6);
            ++n;
        }
        this.properties[0][5].Value = new Short(10070);
        this.properties[1][5].Value = new Short(10146);
        this.properties[2][5].Value = new Short(9632);
        this.properties[3][5].Value = new Short(8226);
        this.properties[4][5].Value = new Short(10022);
        this.properties[5][5].Value = new Short(10146);
        this.properties[6][5].Value = new Short(9632);
        this.properties[7][5].Value = new Short(8226);
        this.properties[8][5].Value = new Short(10022);
    }

    private void createOutlineNumberForType4() {
        this.properties[0][0].Value = new Short(2);
        this.properties[0][1].Value = ".";
        this.properties[1][0].Value = new Short(4);
        this.properties[1][3].Value = new Short(0);
        this.properties[2][0].Value = new Short(1);
        this.properties[2][2].Value = "(";
        this.properties[2][1].Value = ")";
        this.properties[3][0].Value = new Short(3);
        this.properties[3][2].Value = "(";
        this.properties[3][1].Value = ")";
        this.properties[4][0].Value = new Short(4);
        this.properties[4][1].Value = ")";
        this.properties[5][0].Value = new Short(1);
        this.properties[5][1].Value = ")";
        this.properties[6][0].Value = new Short(3);
        this.properties[6][1].Value = ")";
        this.properties[7][0].Value = new Short(1);
        this.properties[7][1].Value = ".";
        this.properties[8][0].Value = new Short(3);
        this.properties[8][1].Value = ".";
    }

    private void createOutlineNumberForType5() {
        this.properties[0][0].Value = new Short(4);
        this.properties[0][1].Value = ".";
        int n = 1;
        while (n < 9) {
            this.properties[n][0].Value = new Short(4);
            this.properties[n][1].Value = ".";
            this.properties[n][3].Value = new Short((short)(n - 1));
            ++n;
        }
    }

    private void createOutlineNumberForType6() {
        this.properties[0][0].Value = new Short(2);
        this.properties[0][1].Value = ".";
        this.properties[1][0].Value = new Short(0);
        this.properties[1][1].Value = ".";
        this.properties[2][0].Value = new Short(4);
        this.properties[2][1].Value = ".";
        this.properties[3][0].Value = new Short(1);
        this.properties[3][1].Value = ")";
        this.properties[4][0].Value = new Short(4);
        this.properties[4][2].Value = "(";
        this.properties[4][1].Value = ")";
        this.properties[5][0].Value = new Short(1);
        this.properties[5][2].Value = "(";
        this.properties[5][1].Value = ")";
        this.properties[6][0].Value = new Short(3);
        this.properties[6][2].Value = "(";
        this.properties[6][1].Value = ")";
        this.properties[7][0].Value = new Short(1);
        this.properties[7][2].Value = "(";
        this.properties[7][1].Value = ")";
        this.properties[8][0].Value = new Short(3);
        this.properties[8][2].Value = "(";
        this.properties[8][1].Value = ")";
    }

    private void createOutlineNumberForType7() {
        this.properties[0][0].Value = new Short(4);
        int n = 1;
        while (n < 9) {
            this.properties[n][0].Value = new Short(5);
            ++n;
        }
    }

    private void createPropertyPreset() {
        this.properties = new PropertyValue[9][6];
        this.properties[0][0] = new PropertyValue();
        this.properties[0][0].Name = "NumberingType";
        this.properties[0][0].Value = new Short(5);
        this.properties[0][3] = new PropertyValue();
        this.properties[0][3].Name = "ParentNumbering";
        this.properties[0][3].Value = new Short(0);
        this.properties[1][3] = new PropertyValue();
        this.properties[1][3].Value = new Short(1);
        this.properties[2][3] = new PropertyValue();
        this.properties[2][3].Value = new Short(2);
        this.properties[3][3] = new PropertyValue();
        this.properties[3][3].Value = new Short(3);
        this.properties[4][3] = new PropertyValue();
        this.properties[4][3].Value = new Short(4);
        this.properties[5][3] = new PropertyValue();
        this.properties[5][3].Value = new Short(5);
        this.properties[6][3] = new PropertyValue();
        this.properties[6][3].Value = new Short(6);
        this.properties[7][3] = new PropertyValue();
        this.properties[7][3].Value = new Short(7);
        this.properties[8][3] = new PropertyValue();
        this.properties[8][3].Value = new Short(8);
        this.properties[0][2] = new PropertyValue();
        this.properties[0][2].Name = "Prefix";
        this.properties[0][2].Value = "";
        this.properties[0][1] = new PropertyValue();
        this.properties[0][1].Name = "Suffix";
        this.properties[0][1].Value = "";
        this.properties[0][4] = new PropertyValue();
        this.properties[0][4].Name = "CharStyleName";
        this.properties[0][4].Value = "";
        this.properties[0][5] = new PropertyValue();
        this.properties[0][5].Name = "BulletId";
        int n = 1;
        while (n < 9) {
            int n2 = 0;
            while (n2 < 6) {
                if (this.properties[n][n2] == null) {
                    this.properties[n][n2] = new PropertyValue();
                    this.properties[n][n2].Name = this.properties[0][n2].Name;
                }
                ++n2;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

