/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.helper.common.ContainerUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;

public class NumericalHelper {
    public static final int UNKNOWN_TYPE = Short.MIN_VALUE;
    public static final int BYTE_TYPE = 0;
    public static final int SHORT_TYPE = 1;
    public static final int INT_TYPE = 2;
    public static final int LONG_TYPE = 3;
    public static final int FLOAT_TYPE = 4;
    public static final int DOUBLE_TYPE = 5;
    public static final int STRING_TYPE = -1;
    public static final int BOOLEAN_TYPE = -2;
    public static final int ARRAY_TYPE = -3;
    public static final int SEQUENCE_TYPE = -4;
    public static final int A_ASCII_VALUE = 65;
    public static final int COUNT_CHARS_IN_ALPHABET = 26;
    private static final int HEX_BASE = 16;
    private static final int DEC_BASE = 10;
    private static final int ASCII_LETTER_A_OFFSET = 55;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Z;

    private NumericalHelper() {
    }

    public static int getType(Object object) {
        try {
            TypeObject typeObject = NumericalHelper.getTypeObject(object);
            return typeObject.iType;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Short.MIN_VALUE;
        }
    }

    public static byte toByte(Object object) throws IllegalArgumentException {
        int n = 0;
        boolean bl = false;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                n = (byte)NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = (byte)NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (byte)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (byte)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (byte)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Byte by = new Byte((String)typeObject.aValue);
                    n = by.byteValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to byte: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return (byte)n;
    }

    public static short toShort(Object object) throws IllegalArgumentException {
        int n = 0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                n = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = (short)NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (short)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (short)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (short)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Short s = new Short((String)typeObject.aValue);
                    n = s.shortValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return (short)n;
    }

    public static boolean isValidAndNumerical(Object object) throws IllegalArgumentException {
        if (object != null && !AnyConverter.isVoid((Object)object)) {
            return NumericalHelper.isNumerical(object);
        }
        return false;
    }

    public static boolean isValid(Object object) {
        return object != null && !AnyConverter.isVoid((Object)object);
    }

    public static boolean isNumerical(Object object) {
        try {
            TypeObject typeObject = NumericalHelper.getTypeObject(object);
            switch (typeObject.iType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return true;
                }
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isRealNumber(Object object) {
        return NumericalHelper.isNumerical(object);
    }

    public static boolean isInteger(Object object) throws IllegalArgumentException {
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringArray(Object object) {
        try {
            NumericalHelper.toStringArray(object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static boolean isIntegerArray(Object object) {
        try {
            NumericalHelper.toIntArray(object);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static int toIntWithErrorMessage(Object object) throws BasicErrorException {
        try {
            return NumericalHelper.toInt(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception(13, "");
            return 0;
        }
    }

    public static String toStringWithErrorMessage(Object object) throws BasicErrorException {
        try {
            return NumericalHelper.toString(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception(13, "");
            return "";
        }
    }

    public static int toIntWithErrorMessage(Object object, int n) throws BasicErrorException {
        try {
            return NumericalHelper.toInt(object, n);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(13, "");
            return 0;
        }
    }

    public static boolean toBooleanWithErrorMessage(Object object, int n, int n2) throws BasicErrorException {
        return NumericalHelper.toBooleanWithErrorMessage(object, new int[]{n}, new int[]{n2});
    }

    public static boolean toBooleanWithErrorMessage(Object object, int[] nArray, int[] nArray2) throws BasicErrorException {
        try {
            int n = NumericalHelper.toIntWithErrorMessage(object);
            if (ContainerUtilities.FieldInIntTable(nArray, n) > -1) {
                return true;
            }
            if (ContainerUtilities.FieldInIntTable(nArray2, n) > -1) {
                return false;
            }
            DebugHelper.exception(9, "");
            return false;
        }
        catch (Exception exception) {
            DebugHelper.exception(9, "");
            return false;
        }
    }

    public static boolean toBooleanWithErrorMessage(Object object, int n, int n2, boolean bl) throws BasicErrorException {
        return NumericalHelper.toBooleanWithErrorMessage(object, new int[]{n}, new int[]{n2}, bl);
    }

    public static boolean toBooleanWithErrorMessage(Object object, int[] nArray, int[] nArray2, boolean bl) throws BasicErrorException {
        try {
            if (object == null || AnyConverter.isVoid((Object)object)) {
                return bl;
            }
            int n = NumericalHelper.toIntWithErrorMessage(object);
            if (ContainerUtilities.FieldInIntTable(nArray, n) > -1) {
                return true;
            }
            if (ContainerUtilities.FieldInIntTable(nArray2, n) > -1) {
                return false;
            }
            DebugHelper.exception(9, "");
            return false;
        }
        catch (Exception exception) {
            DebugHelper.exception(9, "");
            return false;
        }
    }

    public static int toInt(Object object) throws IllegalArgumentException {
        int n = 0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                n = NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                n = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                n = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                n = (int)NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                n = (int)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                n = (int)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Integer n2 = new Integer((String)typeObject.aValue);
                    n = n2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to int: " + typeObject.aValue);
                }
            }
            case -2: {
                n = NumericalHelper.getBool(typeObject) ? -1 : 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return n;
    }

    public static long toLong(Object object) throws IllegalArgumentException {
        long l = 0L;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                l = NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                l = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                l = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                l = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                l = (long)NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                l = (long)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Long l2 = new Long((String)typeObject.aValue);
                    l = l2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                l = NumericalHelper.getBool(typeObject) ? -1L : 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return l;
    }

    public static float toFloat(Object object) throws IllegalArgumentException {
        float f = 0.0f;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                f = NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                f = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                f = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                f = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                f = NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                f = (float)NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Float f2 = new Float((String)typeObject.aValue);
                    f = f2.floatValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                f = NumericalHelper.getBool(typeObject) ? -1.0f : 0.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return f;
    }

    public static double toDouble(Object object) throws IllegalArgumentException {
        double d = 0.0;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                d = NumericalHelper.getByte(typeObject);
                break;
            }
            case 1: {
                d = NumericalHelper.getShort(typeObject);
                break;
            }
            case 2: {
                d = NumericalHelper.getInt(typeObject);
                break;
            }
            case 3: {
                d = NumericalHelper.getLong(typeObject);
                break;
            }
            case 4: {
                d = NumericalHelper.getFloat(typeObject);
                break;
            }
            case 5: {
                d = NumericalHelper.getDouble(typeObject);
                break;
            }
            case -1: {
                try {
                    Float f = new Float((String)typeObject.aValue);
                    d = f.floatValue();
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                d = NumericalHelper.getBool(typeObject) ? -1.0 : 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return d;
    }

    public static String toString(Object object) throws IllegalArgumentException {
        String string = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                string = ((Byte)typeObject.aValue).toString();
                break;
            }
            case 1: {
                string = ((Short)typeObject.aValue).toString();
                break;
            }
            case 2: {
                string = ((Integer)typeObject.aValue).toString();
                break;
            }
            case 3: {
                string = ((Long)typeObject.aValue).toString();
                break;
            }
            case 4: {
                string = ((Float)typeObject.aValue).toString();
                break;
            }
            case 5: {
                string = ((Double)typeObject.aValue).toString();
                break;
            }
            case -1: {
                string = (String)typeObject.aValue;
                break;
            }
            case -2: {
                string = ((Boolean)typeObject.aValue).toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return string;
    }

    public static boolean toBoolean(Object object) throws IllegalArgumentException {
        boolean bl = true;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        switch (typeObject.iType) {
            case 0: {
                bl = (Byte)typeObject.aValue != 0;
                break;
            }
            case 1: {
                bl = (Short)typeObject.aValue != 0;
                break;
            }
            case 2: {
                bl = (Integer)typeObject.aValue != 0;
                break;
            }
            case 3: {
                bl = (Long)typeObject.aValue != 0L;
                break;
            }
            case 4: {
                bl = ((Float)typeObject.aValue).floatValue() != 0.0f;
                break;
            }
            case 5: {
                bl = (Double)typeObject.aValue != 0.0;
                break;
            }
            case -1: {
                try {
                    Boolean bl2 = new Boolean((String)typeObject.aValue);
                    bl = bl2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Cannot convert to short: " + typeObject.aValue);
                }
            }
            case -2: {
                bl = (Boolean)typeObject.aValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return bl;
    }

    public static int[] toIntArray(Object object) throws IllegalArgumentException {
        int[] nArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -4) {
            typeObject = NumericalHelper.convertSequenceToObjectArray(typeObject);
        }
        if (typeObject.iType == -3) {
            Object[] objectArray = (Object[])typeObject.aValue;
            nArray = new int[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                nArray[n] = NumericalHelper.toInt(objectArray[n]);
                ++n;
            }
        } else {
            nArray = new int[]{NumericalHelper.toInt(object)};
        }
        return nArray;
    }

    public static short[] toShortArray(Object object) throws IllegalArgumentException {
        short[] sArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -4) {
            typeObject = NumericalHelper.convertSequenceToObjectArray(typeObject);
        }
        if (typeObject.iType == -3) {
            Object[] objectArray = (Object[])typeObject.aValue;
            sArray = new short[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                sArray[n] = NumericalHelper.toShort(objectArray[n]);
                ++n;
            }
        } else {
            sArray = new short[]{NumericalHelper.toShort(object)};
        }
        return sArray;
    }

    public static String[] toStringArray(Object object) throws IllegalArgumentException {
        String[] stringArray = null;
        TypeObject typeObject = NumericalHelper.getTypeObject(object);
        if (typeObject.iType == -4) {
            typeObject = NumericalHelper.convertSequenceToObjectArray(typeObject);
        }
        if (typeObject.iType == -3) {
            Object[] objectArray = (Object[])typeObject.aValue;
            stringArray = new String[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                stringArray[n] = NumericalHelper.toString(objectArray[n]);
                ++n;
            }
        } else {
            stringArray = new String[]{NumericalHelper.toString(object)};
        }
        return stringArray;
    }

    public static int toInt(Object object, int n) throws BasicErrorException {
        int n2;
        block3: {
            n2 = n;
            try {
                if (object == null || AnyConverter.isVoid((Object)object)) break block3;
                if (NumericalHelper.isInteger(object)) {
                    n2 = NumericalHelper.toInt(object);
                    break block3;
                }
                DebugHelper.exception(13, "");
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(1004, "");
            }
        }
        return n2;
    }

    public static long toLong(Object object, long l) {
        try {
            return NumericalHelper.toLong(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return l;
        }
    }

    public static float toFloat(Object object, float f) {
        try {
            return NumericalHelper.toFloat(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return f;
        }
    }

    public static double toDouble(Object object, double d) {
        try {
            return NumericalHelper.toDouble(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return d;
        }
    }

    public static String toString(Object object, String string) {
        try {
            return NumericalHelper.toString(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string;
        }
    }

    public static boolean toBoolean(Object object, boolean bl) {
        try {
            return NumericalHelper.toBoolean(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return bl;
        }
    }

    public static int[] toIntArray(Object object, int[] nArray) {
        try {
            return NumericalHelper.toIntArray(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return nArray;
        }
    }

    public static short[] toShortArray(Object object, short[] sArray) {
        try {
            return NumericalHelper.toShortArray(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return sArray;
        }
    }

    public static String[] toStringArray(Object object, String[] stringArray) {
        try {
            return NumericalHelper.toStringArray(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return stringArray;
        }
    }

    public static String getHexStringFromNumber(long l) {
        TransformNumToHex transformNumToHex = new TransformNumToHex(l);
        return transformNumToHex.getResult();
    }

    public static String getRomanEquivalent(int n) throws BasicErrorException {
        return RomanNumbering.getRomanEquivalent(n);
    }

    private static TypeObject getTypeObject(Object object) throws IllegalArgumentException {
        TypeObject typeObject = new TypeObject();
        if (object == null || AnyConverter.isVoid((Object)object)) {
            throw new IllegalArgumentException("Cannot convert a null object.");
        }
        int n = AnyConverter.getType((Object)object).getTypeClass().getValue();
        switch (n) {
            case 3: {
                typeObject.iType = 0;
                typeObject.aValue = new Byte(AnyConverter.toByte((Object)object));
                break;
            }
            case 4: {
                typeObject.iType = 1;
                typeObject.aValue = new Short(AnyConverter.toShort((Object)object));
                break;
            }
            case 6: {
                typeObject.iType = 2;
                typeObject.aValue = new Integer(AnyConverter.toInt((Object)object));
                break;
            }
            case 8: {
                typeObject.iType = 3;
                typeObject.aValue = new Long(AnyConverter.toLong((Object)object));
                break;
            }
            case 10: {
                typeObject.iType = 4;
                typeObject.aValue = new Float(AnyConverter.toFloat((Object)object));
                break;
            }
            case 11: {
                typeObject.iType = 5;
                typeObject.aValue = new Double(AnyConverter.toDouble((Object)object));
                break;
            }
            case 12: {
                typeObject.iType = -1;
                typeObject.aValue = new String(AnyConverter.toString((Object)object));
                break;
            }
            case 2: {
                typeObject.iType = -2;
                typeObject.aValue = new Boolean(AnyConverter.toBoolean((Object)object));
                break;
            }
            case 21: {
                typeObject.iType = -3;
                typeObject.aValue = new Object[]{AnyConverter.toArray((Object)object)};
                break;
            }
            case 20: {
                typeObject.iType = -4;
                typeObject.aValue = object;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot convert this type: " + object.getClass().getName());
            }
        }
        return typeObject;
    }

    private static byte getByte(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 0) {
            throw new IllegalArgumentException("Given argument is not a byte type.");
        }
        return (Byte)typeObject.aValue;
    }

    private static short getShort(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 1) {
            throw new IllegalArgumentException("Given argument is not a short type.");
        }
        return (Short)typeObject.aValue;
    }

    public static int getInt(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 2) {
            throw new IllegalArgumentException("Given argument is not an int type.");
        }
        return (Integer)typeObject.aValue;
    }

    public static float getFloat(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 4) {
            throw new IllegalArgumentException("Given argument is not a float type.");
        }
        return ((Float)typeObject.aValue).floatValue();
    }

    private static double getDouble(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 5) {
            throw new IllegalArgumentException("Given argument is not a double type.");
        }
        return (Double)typeObject.aValue;
    }

    private static long getLong(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != 3) {
            throw new IllegalArgumentException("Given argument is not a long type.");
        }
        return (Long)typeObject.aValue;
    }

    private static boolean getBool(TypeObject typeObject) throws IllegalArgumentException {
        if (typeObject.iType != -2) {
            throw new IllegalArgumentException("Given argument is not a boolean type.");
        }
        return (Boolean)typeObject.aValue;
    }

    private static TypeObject convertSequenceToObjectArray(TypeObject typeObject) throws IllegalArgumentException {
        Object[] objectArray;
        TypeObject typeObject2 = new TypeObject();
        Object object = typeObject.aValue;
        typeObject2.iType = -3;
        Class<?> clazz = object.getClass();
        Object[] objectArray2 = null;
        if (clazz.equals(array$B == null ? (array$B = NumericalHelper.class$("[B")) : array$B)) {
            objectArray = (byte[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Byte(objectArray[n]);
                ++n;
            }
        } else if (clazz.equals(array$S == null ? (array$S = NumericalHelper.class$("[S")) : array$S)) {
            objectArray = (short[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Short(objectArray[n]);
                ++n;
            }
        } else if (clazz.equals(array$I == null ? (array$I = NumericalHelper.class$("[I")) : array$I)) {
            objectArray = (int[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Integer(objectArray[n]);
                ++n;
            }
        } else if (clazz.equals(array$J == null ? (array$J = NumericalHelper.class$("[J")) : array$J)) {
            objectArray = (long[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Long(objectArray[n]);
                ++n;
            }
        } else if (clazz.equals(array$F == null ? (array$F = NumericalHelper.class$("[F")) : array$F)) {
            objectArray = (float[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Float(objectArray[n]);
                ++n;
            }
        } else if (clazz.equals(array$D == null ? (array$D = NumericalHelper.class$("[D")) : array$D)) {
            objectArray = (double[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Double(objectArray[n]);
                ++n;
            }
        } else if (clazz.equals(array$Z == null ? (array$Z = NumericalHelper.class$("[Z")) : array$Z)) {
            objectArray = (boolean[])object;
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = new Boolean(objectArray[n]);
                ++n;
            }
        }
        if (objectArray2 == null) {
            try {
                objectArray2 = (Object[])object;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Cannot convert unknown type: '" + classCastException.getMessage() + "'");
            }
        }
        typeObject2.aValue = objectArray2;
        return typeObject2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RomanNumbering {
        private static final String[] ROMAN_EQUIV = new String[]{"I", "V", "X", "L", "C", "D", "M"};
        private static final int MAX_NUMBER = 3999;
        private static final int MIN_NUMBER = 1;
        private static final int ASCII_CODE_0 = 48;
        private static final int FOUR = 4;
        private static final int FIVE = 5;
        private static final int NINE = 9;

        private RomanNumbering() {
        }

        public static String getRomanEquivalent(int n) throws BasicErrorException {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (n > 3999 || n < 1) {
                    DebugHelper.exception(9, "");
                }
                String string = NumericalHelper.toString(new Integer(n));
                int n2 = 0;
                int n3 = string.length() - 1;
                while (n3 >= 0) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    int n4 = string.charAt(n3) - 48;
                    if (n4 == 4) {
                        stringBuffer2.append(ROMAN_EQUIV[n2]);
                        stringBuffer2.append(ROMAN_EQUIV[n2 + 1]);
                    } else if (n4 == 9) {
                        stringBuffer2.append(ROMAN_EQUIV[n2]);
                        stringBuffer2.append(ROMAN_EQUIV[n2 + 2]);
                    } else {
                        if (n4 >= 5) {
                            stringBuffer2.append(ROMAN_EQUIV[n2 + 1]);
                            n4 -= 5;
                        }
                        int n5 = 0;
                        while (n5 < n4) {
                            stringBuffer2.append(ROMAN_EQUIV[n2]);
                            ++n5;
                        }
                    }
                    n2 += 2;
                    stringBuffer.append(stringBuffer2.reverse());
                    --n3;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            return stringBuffer.reverse().toString();
        }
    }

    private static class TransformNumToHex {
        private StringBuffer val = new StringBuffer();

        public TransformNumToHex(long l) {
            this.transform(l);
        }

        private void transform(long l) {
            int n = (int)(l % 16L);
            l /= 16L;
            if (n < 10) {
                this.val.insert(0, n);
            } else {
                this.val.insert(0, (char)(55 + n));
            }
            if (l > 0L) {
                this.transform(l);
            }
        }

        public String getResult() {
            return this.val.toString();
        }
    }

    private static class TypeObject {
        public int iType;
        public Object aValue;

        private TypeObject() {
        }
    }
}

