/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

public class MSO2SOIntMapping {
    public static final int INDEX_MSO = 0;
    public static final int INDEX_SO = 1;
    private final int[][] mapping;
    private final boolean soValuesSorted;

    public MSO2SOIntMapping(int[][] nArray) {
        this(nArray, false);
    }

    public MSO2SOIntMapping(int[][] nArray, boolean bl) {
        this.mapping = nArray;
        this.soValuesSorted = bl;
        this.sanityCheck();
    }

    public int size() {
        return this.mapping.length;
    }

    public int getSOValueAtIndex(int n) {
        return this.mapping[n][1];
    }

    public int getSOIndexFromMSO(int n) {
        int n2 = 0;
        while (n2 < this.mapping.length) {
            if (this.mapping[n2][0] == n) {
                return n2;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid value " + n);
    }

    public int getSOFromMSO(int n) {
        return this.getSOValueAtIndex(this.getSOIndexFromMSO(n));
    }

    public int getNearestSOFromMSO(int n) {
        if (!this.soValuesSorted) {
            throw new IllegalStateException("IntMapping was not declared to have SO values sorted");
        }
        int n2 = 0;
        while (n2 < this.mapping.length) {
            int n3 = this.mapping[n2][1];
            if (n3 == n) {
                return this.mapping[n2][0];
            }
            if (n > n3) {
                if (n2 == 0) {
                    return n3;
                }
                int n4 = this.mapping[n2 - 1][1];
                if (n - n3 < n - n4) {
                    return n3;
                }
                return n4;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid value " + n);
    }

    public int getMSOFromSO(int n) {
        int n2 = 0;
        while (n2 < this.mapping.length) {
            if (this.mapping[n2][1] == n) {
                return this.mapping[n2][0];
            }
            ++n2;
        }
        throw new IllegalArgumentException("Invalid value " + n);
    }

    private void sanityCheck() {
        int n = 0;
        while (n < this.mapping.length) {
            if (this.mapping[n].length != 2) {
                throw new IllegalStateException();
            }
            ++n;
        }
        if (this.soValuesSorted) {
            int n2 = 1;
            while (n2 < this.mapping.length) {
                if (this.mapping[n2][1] < this.mapping[n2 - 1][1]) {
                    throw new IllegalStateException();
                }
                ++n2;
            }
        }
    }
}

