/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XStatusListener;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.StatusListenerImpl;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.util.Locale;

public class LocaleUtilities {
    private static int m_nCurrentLanguage = 0;
    private static Locale m_aCurrentLocale = null;
    static /* synthetic */ Class class$com$sun$star$util$XURLTransformer;
    static /* synthetic */ Class class$com$sun$star$frame$XDispatchProvider;

    public static Locale getCurrentLocale() {
        if (m_aCurrentLocale == null) {
            m_aCurrentLocale = Locale.getDefault();
        }
        return m_aCurrentLocale;
    }

    public static Locale createLocaleFromLanguageID(int n) {
        Locale locale = null;
        switch (n) {
            case 3081: 
            case 4105: 
            case 5129: 
            case 6153: 
            case 7177: 
            case 8201: 
            case 9225: 
            case 10249: 
            case 11273: 
            case 12297: 
            case 13321: {
                locale = new Locale("en", "", "");
                break;
            }
            case 1033: {
                locale = new Locale("en", "US", "");
                break;
            }
            case 2057: {
                locale = new Locale("en", "GB", "");
                break;
            }
            case 2055: 
            case 3079: 
            case 4103: 
            case 5127: {
                locale = new Locale("de", "", "");
                break;
            }
            case 1031: {
                locale = new Locale("de", "DE", "");
                break;
            }
            case 2070: {
                locale = new Locale("pt", "", "");
                break;
            }
            case 1049: 
            case 1059: 
            case 2073: {
                locale = new Locale("ru", "", "");
                break;
            }
            case 1032: {
                locale = new Locale("el", "", "");
                break;
            }
            case 1043: 
            case 1122: 
            case 2067: {
                locale = new Locale("nl", "", "");
                break;
            }
            case 1036: 
            case 2060: 
            case 3084: 
            case 4108: 
            case 5132: 
            case 6156: 
            case 7180: 
            case 8204: 
            case 9228: 
            case 10252: 
            case 11276: 
            case 12300: 
            case 13324: {
                locale = new Locale("fr", "", "");
                break;
            }
            case 1034: 
            case 2058: 
            case 3082: 
            case 4106: 
            case 5130: 
            case 6154: 
            case 7178: 
            case 8202: 
            case 9226: 
            case 10250: 
            case 11274: 
            case 12298: 
            case 13322: 
            case 14346: 
            case 15370: 
            case 16394: 
            case 17418: 
            case 18442: 
            case 19466: 
            case 20490: {
                locale = new Locale("es", "", "");
                break;
            }
            case 1035: {
                locale = new Locale("fi", "", "");
                break;
            }
            case 1038: {
                locale = new Locale("hu", "", "");
                break;
            }
            case 1027: {
                locale = new Locale("ca", "", "");
                break;
            }
            case 1040: {
                locale = new Locale("it", "", "");
                break;
            }
            case 1029: {
                locale = new Locale("cs", "", "");
                break;
            }
            case 1051: {
                locale = new Locale("sk", "", "");
                break;
            }
            case 1030: {
                locale = new Locale("da", "", "");
                break;
            }
            case 1053: 
            case 2077: {
                locale = new Locale("sv", "", "");
                break;
            }
            case 1044: 
            case 2068: {
                locale = new Locale("no", "", "");
                break;
            }
            case 1045: {
                locale = new Locale("pl", "", "");
                break;
            }
            case 1060: {
                locale = new Locale("sl", "SI", "");
                break;
            }
            case 3098: {
                locale = new Locale("sr", "YU", "");
                break;
            }
            case 2074: {
                locale = new Locale("sh", "YU", "");
                break;
            }
            case 1046: {
                locale = new Locale("pt", "BR", "");
                break;
            }
            case 1054: {
                locale = new Locale("th", "", "");
                break;
            }
            case 1061: {
                locale = new Locale("et", "", "");
                break;
            }
            case 1050: {
                locale = new Locale("hr", "HR", "");
                break;
            }
            case 1058: {
                locale = new Locale("uk", "UA", "");
                break;
            }
            case 1041: {
                locale = new Locale("ja", "", "");
                break;
            }
            case 1042: {
                locale = new Locale("ko", "", "");
                break;
            }
            case 3076: 
            case 4100: 
            case 5124: {
                locale = new Locale("zh", "", "");
                break;
            }
            case 2052: {
                locale = new Locale("zh", "CN", "");
                break;
            }
            case 1028: {
                locale = new Locale("zh", "TW", "");
                break;
            }
            case 1055: {
                locale = new Locale("tr", "", "");
                break;
            }
            case 1081: {
                locale = new Locale("hi", "IN", "");
                break;
            }
            case 1025: 
            case 2049: 
            case 3073: 
            case 4097: 
            case 5121: 
            case 6145: 
            case 7169: 
            case 8193: 
            case 9217: 
            case 10241: 
            case 11265: 
            case 12289: 
            case 13313: 
            case 14337: 
            case 15361: 
            case 16385: {
                locale = new Locale("ar", "", "");
                break;
            }
            case 1037: {
                locale = new Locale("he", "", "");
                break;
            }
            case 0: 
            case 1024: 
            case 1026: 
            case 1039: 
            case 1047: 
            case 1048: 
            case 1052: 
            case 1056: 
            case 1057: 
            case 1062: 
            case 1063: 
            case 1064: 
            case 1065: 
            case 1066: 
            case 1067: 
            case 1068: 
            case 1069: 
            case 1070: 
            case 1071: 
            case 1072: 
            case 1073: 
            case 1074: 
            case 1075: 
            case 1076: 
            case 1077: 
            case 1078: 
            case 1079: 
            case 1080: 
            case 1082: 
            case 1083: 
            case 1084: 
            case 1086: 
            case 1087: 
            case 1088: 
            case 1089: 
            case 1090: 
            case 1091: 
            case 1092: 
            case 1093: 
            case 1094: 
            case 1095: 
            case 1096: 
            case 1097: 
            case 1098: 
            case 1099: 
            case 1100: 
            case 1101: 
            case 1102: 
            case 1103: 
            case 1104: 
            case 1105: 
            case 1106: 
            case 1107: 
            case 1108: 
            case 1109: 
            case 1110: 
            case 1111: 
            case 1112: 
            case 1113: 
            case 1120: 
            case 1121: 
            case 2064: 
            case 2072: 
            case 2092: 
            case 2108: 
            case 2110: 
            case 2115: {
                DebugHelper.writeInfo("Can't convert LanguageID (" + n + ") to a real Locale.");
                locale = Locale.getDefault();
                break;
            }
            default: {
                locale = Locale.getDefault();
            }
        }
        return locale;
    }

    public static int getLanguage() throws BasicErrorException {
        int n = 9999999;
        try {
            XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
            XURLTransformer xURLTransformer = (XURLTransformer)OptionalParamUtility.getObject(class$com$sun$star$util$XURLTransformer == null ? (class$com$sun$star$util$XURLTransformer = LocaleUtilities.class$("com.sun.star.util.XURLTransformer")) : class$com$sun$star$util$XURLTransformer, xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer"));
            XFrame xFrame = ApplicationImpl.getXDesktop().getCurrentFrame();
            XDispatchProvider xDispatchProvider = (XDispatchProvider)OptionalParamUtility.getObject(class$com$sun$star$frame$XDispatchProvider == null ? (class$com$sun$star$frame$XDispatchProvider = LocaleUtilities.class$("com.sun.star.frame.XDispatchProvider")) : class$com$sun$star$frame$XDispatchProvider, xFrame);
            StatusListenerImpl statusListenerImpl = new StatusListenerImpl();
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = ".uno:Language";
            xURLTransformer.parseStrict(uRLArray);
            XDispatch xDispatch = xDispatchProvider.queryDispatch(uRLArray[0], "_self", 0);
            xDispatch.addStatusListener((XStatusListener)statusListenerImpl, uRLArray[0]);
            n = statusListenerImpl.getStatus();
            xDispatch.removeStatusListener((XStatusListener)statusListenerImpl, uRLArray[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (n < 0) {
            n += 65536;
        }
        return n;
    }

    public static int getCountry() throws BasicErrorException {
        Locale locale = LocaleUtilities.getCurrentLocale();
        String string = locale.getCountry().toLowerCase();
        int n = 0;
        if (string.equals("de")) {
            n = 49;
        } else if (string.equals("en") || string.equals("us")) {
            n = 1;
        } else if (string.equals("nl")) {
            n = 31;
        } else if (string.equals("fr")) {
            n = 33;
        } else if (string.equals("es")) {
            n = 34;
        } else if (string.equals("fi")) {
            n = 358;
        } else if (string.equals("it")) {
            n = 39;
        } else if (string.equals("en-gb")) {
            n = 44;
        } else if (string.equals("da")) {
            n = 45;
        } else if (string.equals("sv")) {
            n = 46;
        } else if (string.equals("no")) {
            n = 47;
        } else if (string.equals("pt_br")) {
            n = 55;
        } else if (string.equals("ja")) {
            n = 81;
        } else if (string.equals("ko")) {
            n = 82;
        } else if (string.equals("zh_cn")) {
            n = 86;
        } else if (string.equals("zh_tw")) {
            n = 886;
        } else {
            n = 1;
            DebugHelper.writeInfo("Warning: Use the default 'WdCountry.wdUS', because for '" + string + "' doesn't exist a right value.");
        }
        if (n == 0) {
            DebugHelper.exception(447, "");
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

