/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.helper.common.DebugHelper;
import com.sun.star.script.BasicErrorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class IniFile {
    String m_sFilename;
    ArrayList m_aList;
    boolean m_bListContainUnsavedChanges = false;

    public IniFile(String string) throws BasicErrorException {
        this.m_sFilename = string;
        this.m_aList = this.loadLines();
    }

    ArrayList loadLines() throws BasicErrorException {
        File file = new File(this.m_sFilename);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!file.exists()) {
            DebugHelper.writeInfo("couldn't find file " + this.m_sFilename);
            return arrayList;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            String string = "";
            while (string != null) {
                string = randomAccessFile.readLine();
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            DebugHelper.writeInfo("couldn't open file " + this.m_sFilename);
            DebugHelper.writeInfo("Message: " + fileNotFoundException.getMessage());
            DebugHelper.exception(53, "");
        }
        catch (IOException iOException) {
            DebugHelper.writeInfo("Exception occurs while reading from file " + this.m_sFilename);
            DebugHelper.writeInfo("Message: " + iOException.getMessage());
            DebugHelper.exception(51, iOException.getMessage());
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            DebugHelper.writeInfo("Couldn't close file " + this.m_sFilename);
            DebugHelper.writeInfo("Message: " + iOException.getMessage());
            DebugHelper.exception(51, iOException.getMessage());
        }
        return arrayList;
    }

    public boolean is() {
        return this.m_aList.size() > 1;
    }

    boolean isRemark(String string) {
        return string.length() < 2 || string.startsWith("#") || string.startsWith(";");
    }

    String getItem(int n) {
        return (String)this.m_aList.get(n);
    }

    String buildSectionName(String string) {
        String string2 = "[" + string + "]";
        return string2;
    }

    String toLowerIfNeed(String string) {
        return string.toLowerCase();
    }

    int findSection(String string) {
        String string2 = this.toLowerIfNeed(this.buildSectionName(string));
        int n = 0;
        while (n < this.m_aList.size()) {
            String string3 = this.toLowerIfNeed(this.getItem(n).trim());
            if (!this.isRemark(string3) && string3.startsWith(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int findKey(String string, String string2) {
        int n = this.findSection(string);
        if (n == -1) {
            return -1;
        }
        return this.findKeyFromKnownSection(n, string2);
    }

    int findKeyFromKnownSection(int n, String string) {
        string = this.toLowerIfNeed(string);
        int n2 = n + 1;
        while (n2 < this.m_aList.size()) {
            String string2 = this.getItem(n2).trim();
            if (!this.isRemark(string2)) {
                String string3;
                if (string2.startsWith("[")) break;
                int n3 = string2.indexOf("=");
                if (n3 >= 0 && (string3 = this.toLowerIfNeed(string2.substring(0, n3).trim())).equals(string)) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    int findLastKnownKeyIndex(int n, String string) {
        int n2;
        string = this.toLowerIfNeed(string);
        int n3 = n2 = n + 1;
        while (n3 < this.m_aList.size()) {
            String string2 = this.getItem(n3).trim();
            if (!this.isRemark(string2)) {
                String string3;
                if (string2.startsWith("[")) {
                    return n3;
                }
                int n4 = string2.indexOf("=");
                if (n4 >= 0 && (string3 = this.toLowerIfNeed(string2.substring(0, n4).trim())).equals(string)) {
                    return n3;
                }
            }
            ++n3;
        }
        return n2;
    }

    String getValue(int n) {
        String string = this.getItem(n).trim();
        if (this.isRemark(string)) {
            return "";
        }
        int n2 = string.indexOf("=");
        if (n2 >= 0) {
            String string2 = string.substring(0, n2).trim();
            String string3 = string.substring(n2 + 1).trim();
            return string3;
        }
        return "";
    }

    public String getValue(String string, String string2) {
        String string3 = "";
        int n = this.findKey(string, string2);
        if (n == -1) {
            return "";
        }
        string3 = this.getValue(n);
        return string3;
    }

    public void store() throws BasicErrorException {
        if (!this.m_bListContainUnsavedChanges) {
            return;
        }
        File file = new File(this.m_sFilename);
        if (file.exists()) {
            file.delete();
            if (file.exists()) {
                DebugHelper.writeInfo("Couldn't delete the file " + this.m_sFilename);
                DebugHelper.exception(51, "Couldn't delete the file " + this.m_sFilename);
            }
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            int n = 0;
            while (n < this.m_aList.size()) {
                String string = this.getItem(n);
                randomAccessFile.writeBytes(string);
                randomAccessFile.writeByte(10);
                ++n;
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DebugHelper.writeInfo("couldn't open file for writing " + this.m_sFilename);
            DebugHelper.writeInfo("Message: " + fileNotFoundException.getMessage());
            DebugHelper.exception(53, "");
        }
        catch (IOException iOException) {
            DebugHelper.writeInfo("Exception occurs while writing to file " + this.m_sFilename);
            DebugHelper.writeInfo("Message: " + iOException.getMessage());
            DebugHelper.exception(51, iOException.getMessage());
        }
    }

    public void insertValue(String string, String string2, String string3) throws BasicErrorException {
        int n = this.findSection(string);
        if (n == -1) {
            String string4 = this.buildSectionName(string);
            this.m_aList.add(string4);
            String string5 = string2 + "=" + string3;
            this.m_aList.add(string5);
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        int n2 = this.findKeyFromKnownSection(n, string2);
        if (n2 == -1) {
            n2 = this.findLastKnownKeyIndex(n, string2);
            String string6 = string2 + "=" + string3;
            this.m_aList.add(n2, string6);
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        String string7 = string2 + "=" + string3;
        this.m_aList.set(n2, string7);
        this.m_bListContainUnsavedChanges = true;
    }

    public static void main(String[] stringArray) {
        try {
            IniFile iniFile = new IniFile("/tmp/inifile");
            String string = iniFile.getValue("Section", "Key");
            iniFile.insertValue("Section", "Key2", "a new value in a existing section");
            iniFile.insertValue("Section", "Key", "replaced value");
            iniFile.insertValue("New Section", "Key", "a new key value pair");
            String string2 = iniFile.getValue("Section2", "Key");
            iniFile.store();
        }
        catch (BasicErrorException basicErrorException) {}
    }
}

