/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.StringHelper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public abstract class Filename {
    private String m_sDeviceLetter;
    private String m_sPath;
    private String m_sBasename;
    private String m_sExtension;
    private String m_sCheckExtensions;
    private String m_sURLPrefix;
    private boolean m_bHTTP = false;
    private static String m_sGlobalFileSeparator = null;

    public static String getGlobalFileSeparator() {
        if (m_sGlobalFileSeparator == null) {
            m_sGlobalFileSeparator = System.getProperty("file.separator");
        }
        return m_sGlobalFileSeparator;
    }

    protected Filename() {
    }

    void initialise(String string, String string2) {
        this.m_sCheckExtensions = string2.trim();
        string = this.removeURLAndSetDeviceLetter(string);
        string = string.replace('\\', Filename.getGlobalFileSeparator().charAt(0));
        string = string.replace('/', Filename.getGlobalFileSeparator().charAt(0));
        this.m_sBasename = Filename.getNameNoSuffix(Filename.getBasename(string));
        this.m_sExtension = Filename.getSuffix(string);
        this.m_sPath = Filename.getPathFromName(string);
    }

    public static String getNameNoSuffix(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getSuffix(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n);
        }
        return "";
    }

    public static String getBasename(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(Filename.getGlobalFileSeparator());
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String getPathFromName(String string) {
        if (string == null) {
            return "";
        }
        int n = string.lastIndexOf(Filename.getGlobalFileSeparator());
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    String getWorkingDirectory() {
        String string = ApplicationImpl.getWorkingDirectory();
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        string = this.removeURLAndSetDeviceLetter(string);
        return string;
    }

    String removeURLAndSetDeviceLetter(String string) {
        if (string.toLowerCase().startsWith("file:///")) {
            string = string.substring(7);
            string = Filename.decodeOOoFilename(string);
        } else if (string.toLowerCase().startsWith("http://")) {
            this.m_sURLPrefix = string.substring(0, 7);
            this.m_bHTTP = true;
        }
        if (string.length() > 0 && string.charAt(1) == ':') {
            this.m_sDeviceLetter = new String(new char[]{string.charAt(0)});
            string = string.substring(2);
        } else if (string.length() > 1 && string.charAt(2) == ':') {
            this.m_sDeviceLetter = new String(new char[]{string.charAt(1)});
            string = string.substring(3);
        } else {
            this.m_sDeviceLetter = "";
        }
        return string;
    }

    public boolean checkExistanceForRead() {
        boolean bl = false;
        if (this.m_sExtension.length() == 0 && this.m_sCheckExtensions.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.m_sCheckExtensions, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string;
                this.m_sExtension = string = stringTokenizer.nextToken();
                if (!this.checkExistanceMaybeChangePath()) continue;
                bl = true;
                break;
            }
        } else {
            bl = this.checkExistanceMaybeChangePath();
        }
        return bl;
    }

    public void prepareToWrite(String string) {
        if (string == null) {
            string = "";
        }
        if (string.length() > 0) {
            this.m_sExtension = !string.startsWith(".") ? "." + string : string;
        }
        if (this.m_sExtension.length() == 0 && this.m_sCheckExtensions.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.m_sCheckExtensions, " ");
            if (stringTokenizer.hasMoreTokens()) {
                String string2;
                this.m_sExtension = string2 = stringTokenizer.nextToken();
            }
        }
        this.prepareForWriteMaybeChangePath();
    }

    void prepareForWriteMaybeChangePath() {
        if (this.m_sPath.length() == 0) {
            this.m_sPath = this.getWorkingDirectory();
        } else if (!this.m_sPath.startsWith(Filename.getGlobalFileSeparator())) {
            this.m_sPath = this.getWorkingDirectory() + Filename.getGlobalFileSeparator() + this.m_sPath;
        }
    }

    boolean checkExistanceMaybeChangePath() {
        String string = this.m_sPath;
        if (this.m_sPath.length() == 0) {
            this.m_sPath = this.getWorkingDirectory();
            if (this.checkExistanceOnDisk(this.getAbsoluteFilename())) {
                return true;
            }
            this.m_sPath = string;
            return false;
        }
        if (!this.m_sPath.startsWith(Filename.getGlobalFileSeparator()) && !this.m_bHTTP) {
            this.m_sPath = this.getWorkingDirectory() + Filename.getGlobalFileSeparator() + this.m_sPath;
            if (this.checkExistanceOnDisk(this.getAbsoluteFilename())) {
                return true;
            }
            this.m_sPath = string;
            return false;
        }
        return this.checkExistanceOnDisk(this.getAbsoluteFilename());
    }

    boolean checkExistanceOnDisk(String string) {
        if (this.m_bHTTP) {
            DebugHelper.writeInfo("Filename.checkExistanceOnDisk() of : '" + string + "'. HTTP will not checked here.");
            return true;
        }
        File file = new File(string);
        if (file.exists()) {
            DebugHelper.writeInfo("Filename.checkExistanceOnDisk() of : '" + string + "' found.");
            return true;
        }
        DebugHelper.writeInfo("Filename.checkExistanceOnDisk() of : '" + string + "' not found.");
        return false;
    }

    public String getURL() {
        DebugHelper.writeInfo("Filename.getURL()      Path: " + this.m_sPath);
        DebugHelper.writeInfo("Filename.getURL()  Basename: " + this.m_sBasename);
        DebugHelper.writeInfo("Filename.getURL() Extension: " + this.m_sExtension);
        String string = this.getAbsoluteFilename();
        if (!this.m_bHTTP) {
            string = Filename.encodeOOoFilename(string);
            string = HelperUtilities.getURLForFileName(string);
        }
        return string;
    }

    public String getAbsoluteFilename() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = CommonUtilities.isWindows();
        if (bl && !this.m_bHTTP && this.m_sDeviceLetter.length() > 0) {
            stringBuffer.append(this.m_sDeviceLetter).append(":");
        }
        if (this.m_sPath.length() > 0) {
            stringBuffer.append(this.m_sPath);
            stringBuffer.append(Filename.getGlobalFileSeparator());
        } else if (bl) {
            stringBuffer.append(Filename.getGlobalFileSeparator());
        }
        stringBuffer.append(this.getName());
        String string = stringBuffer.toString();
        string = this.replaceSlashByBackslashIfNeed(string);
        return string;
    }

    String getInternalPath() {
        StringBuffer stringBuffer = new StringBuffer();
        if (CommonUtilities.isWindows() && !this.m_bHTTP) {
            stringBuffer.append(this.m_sDeviceLetter).append(":");
        }
        if (this.m_sPath.length() > 0) {
            stringBuffer.append(this.m_sPath);
        }
        return stringBuffer.toString();
    }

    String replaceSlashByBackslashIfNeed(String string) {
        if (CommonUtilities.isWindows() && !this.m_bHTTP) {
            string = string.replace(Filename.getGlobalFileSeparator().charAt(0), '\\');
        }
        return string;
    }

    public String getPath() {
        String string = this.getInternalPath();
        string = this.replaceSlashByBackslashIfNeed(string);
        return string;
    }

    public String getName() {
        String string = this.m_sBasename;
        if (this.m_sExtension.length() > 0) {
            if (!this.m_sExtension.startsWith(".")) {
                DebugHelper.writeInfo("Filename.getName() internal problem, extension '" + this.m_sExtension + "' doesn't start with a dot.");
                string = string + ".";
            }
            string = string + this.m_sExtension;
        }
        return string;
    }

    public static String encodeOOoFilename(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        string2 = StringHelper.replaceAll13(string2, "+", "%20");
        string2 = StringHelper.replaceAll13(string2, "%2F", "/");
        string2 = StringHelper.replaceAll13(string2, "%3A", ":");
        string2 = StringHelper.replaceAll13(string2, "%5C", "\\");
        return string2;
    }

    public static String decodeOOoFilename(String string) {
        String string2 = StringHelper.replaceAll13(string, "+", "%2B");
        string2 = StringHelper.replaceAll13(string2, "%20", "+");
        string2 = StringHelper.replaceAll13(string2, ":", "%3A");
        try {
            string2 = URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string2;
    }

    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUniqueFileName(String string) throws com.sun.star.io.IOException {
        String string2 = null;
        String string3 = null;
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(".");
            if (n != -1 && n != 0 && n != string.length() - 1) {
                string2 = string.substring(0, n);
                string3 = string.substring(n);
            } else {
                string2 = string;
            }
        }
        return Filename.getUniqueFileName(string2, string3);
    }

    public static String getUniqueFileName(String string, String string2) throws com.sun.star.io.IOException {
        File file = null;
        if (string == null || string.length() == 0) {
            string = "tmp";
        }
        while (string.length() <= 2) {
            string = string + "_";
        }
        try {
            file = File.createTempFile(string, string2);
        }
        catch (SecurityException securityException) {
            throw new com.sun.star.io.IOException(securityException.getMessage());
        }
        catch (IOException iOException) {
            throw new com.sun.star.io.IOException(iOException.getMessage());
        }
        return file.getAbsolutePath();
    }

    public void clearCurrentExtension() {
        this.m_sExtension = "";
    }
}

