/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XEnumeration;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.UNOUtility;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.util.XModifiable;
import java.util.ArrayList;

public class DocumentUtilities {
    static /* synthetic */ Class class$com$sun$star$util$XModifiable;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$frame$XComponentLoader;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$util$XCloseable;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;

    public static boolean isComponentDocument(Object object) {
        return HelperUtilities.supportsService(object, "com.sun.star.document.OfficeDocument");
    }

    public static String getModelDocumentType(XModel xModel) {
        if (HelperUtilities.supportsService((Object)xModel, "com.sun.star.text.TextDocument")) {
            return "swriter";
        }
        if (HelperUtilities.supportsService((Object)xModel, "com.sun.star.sheet.SpreadsheetDocument")) {
            return "scalc";
        }
        if (HelperUtilities.supportsService((Object)xModel, "com.sun.star.drawing.DrawingDocument")) {
            return "sdraw";
        }
        if (HelperUtilities.supportsService((Object)xModel, "com.sun.star.formula.FormulaProperties")) {
            return "smath";
        }
        if (HelperUtilities.supportsService((Object)xModel, "com.sun.star.chart.ChartDocument")) {
            return "chart";
        }
        if (HelperUtilities.supportsService((Object)xModel, "com.sun.star.script.BasicIDE")) {
            return "BasicIDE";
        }
        UNOUtility.printInterfaceNames("unknown Service", xModel, DebugHelper.getPrintStream());
        return null;
    }

    public static void saveDocument(XModel xModel) throws BasicErrorException {
        DocumentUtilities.saveDocument(xModel, true);
    }

    public static void saveDocument(XModel xModel, boolean bl) throws BasicErrorException {
        block5: {
            XModifiable xModifiable;
            boolean bl2 = true;
            if (!bl) {
                try {
                    xModifiable = (XModifiable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XModifiable == null ? (class$com$sun$star$util$XModifiable = DocumentUtilities.class$("com.sun.star.util.XModifiable")) : class$com$sun$star$util$XModifiable), (Object)xModel);
                    bl2 = xModifiable.isModified();
                }
                catch (Exception exception) {
                    HelperUtilities.exception(exception);
                }
            }
            if (!bl2) break block5;
            try {
                xModifiable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentUtilities.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)xModel);
                xModifiable.store();
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public static boolean isModified(XModel xModel) {
        boolean bl = false;
        XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XModifiable == null ? (class$com$sun$star$util$XModifiable = DocumentUtilities.class$("com.sun.star.util.XModifiable")) : class$com$sun$star$util$XModifiable), (Object)xModel);
        bl = xModifiable.isModified();
        return bl;
    }

    public static void saveDocumentAs(XModel xModel, String string) throws BasicErrorException {
        DocumentUtilities.saveDocumentAs(xModel, string, new PropertyValue[0]);
    }

    public static void saveDocumentAs(XModel xModel, String string, PropertyValue[] propertyValueArray) throws BasicErrorException {
        try {
            XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentUtilities.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)xModel);
            xStorable.storeAsURL(string, propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public static XModel openDocument(String string) throws BasicErrorException {
        return DocumentUtilities.openDocument(string, false, null);
    }

    public static XModel openDocument(String string, boolean bl, ArrayList arrayList) throws BasicErrorException {
        Object object;
        String string2 = HelperUtilities.getURLForFileName(string);
        XModel xModel = HelperUtilities.findModelForURL(string2);
        if (bl) {
            DocumentUtilities.closeDocument(xModel, 0, 1);
            xModel = null;
        }
        if (xModel != null) {
            return xModel;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<PropertyValue>();
        }
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = DocumentUtilities.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader), (Object)ApplicationImpl.getXDesktop());
        XComponent xComponent = null;
        try {
            if (string2 != null) {
                object = new PropertyValue();
                object.Name = "MacroExecutionMode";
                object.Value = new Short(4);
                arrayList.add((PropertyValue)object);
                PropertyValue[] propertyValueArray = CommonUtilities.createPropertyValueArrayFormArrayList(arrayList);
                xComponent = xComponentLoader.loadComponentFromURL(string2, "_blank", 0, propertyValueArray);
            }
        }
        catch (IOException iOException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)iOException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        if (xComponent == null) {
            object = new IOException("Error opening " + string2 + " for document " + string);
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)object));
        }
        return (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = DocumentUtilities.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), xComponent);
    }

    public static boolean closeDocument(XModel xModel, int n, int n2) throws BasicErrorException {
        XController xController;
        if (xModel == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        switch (n) {
            case 0: {
                bl3 = true;
                break;
            }
            case -1: {
                DocumentUtilities.saveDocument(xModel, false);
                DebugHelper.writeInfo("close(), document is writen.");
                bl2 = true;
                bl3 = true;
                break;
            }
            case -2: {
                bl4 = true;
                break;
            }
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (bl2) break;
                bl4 = true;
                break;
            }
        }
        if (bl4) {
            boolean bl5 = true;
            xController = xModel.getCurrentController();
            bl3 = xController.suspend(true);
            if (!bl3) {
                DebugHelper.writeInfo("close(): User interaction: User cancelled close of document.");
            }
        }
        if (bl3) {
            XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XCloseable == null ? (class$com$sun$star$util$XCloseable = DocumentUtilities.class$("com.sun.star.util.XCloseable")) : class$com$sun$star$util$XCloseable), (Object)xModel);
            if (xCloseable != null) {
                try {
                    xCloseable.close(bl2);
                    return true;
                }
                catch (CloseVetoException closeVetoException) {
                    DebugHelper.writeInfo("close(), CloseVetoException caught. " + closeVetoException.getMessage());
                }
            } else {
                xController = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = DocumentUtilities.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)xModel);
                xController.dispose();
                return true;
            }
        }
        return false;
    }

    public static synchronized boolean close(String string, int n, int n2, boolean bl) throws BasicErrorException {
        XEnumeration xEnumeration = ApplicationImpl.getXDesktop().getComponents().createEnumeration();
        boolean bl2 = true;
        while (xEnumeration.hasMoreElements()) {
            try {
                XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? DocumentUtilities.class$("com.sun.star.frame.XModel") : class$com$sun$star$frame$XModel), (Object)xEnumeration.nextElement());
                boolean bl3 = false;
                if (string == null) {
                    bl3 = true;
                } else {
                    String string2 = HelperUtilities.getModelDocumentType(xModel);
                    if (string2 != null && string2.equals(string)) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    if (bl) {
                        // empty if block
                    }
                    if (DocumentUtilities.closeDocument(xModel, n, n2)) continue;
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return bl2;
    }

    public static synchronized void exit(String string, int n, int n2, boolean bl) throws BasicErrorException {
        boolean bl2 = DocumentUtilities.close(string, n, n2, bl);
        if (bl2) {
            ApplicationImpl.getXDesktop().terminate();
        } else {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new WrappedTargetException("We must stop here.")));
        }
    }

    public static void createDocument(String string, ArrayList arrayList, String string2, ArrayList arrayList2) throws BasicErrorException {
        XModel xModel;
        Object object;
        XComponentLoader xComponentLoader;
        if (arrayList == null) {
            arrayList = new ArrayList<XComponentLoader>();
            DebugHelper.writeInfo("Documents.Add(): Visible:=false");
            xComponentLoader = new PropertyValue();
            xComponentLoader.Name = "Hidden";
            xComponentLoader.Value = Boolean.TRUE;
            arrayList.add(xComponentLoader);
        }
        xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = DocumentUtilities.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader), (Object)ApplicationImpl.getXDesktop());
        XComponent xComponent = null;
        try {
            if (string != null) {
                object = CommonUtilities.createPropertyValueArrayFormArrayList(arrayList);
                xComponent = xComponentLoader.loadComponentFromURL(string, "_blank", 0, object);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        if (xComponent == null) {
            object = new IOException("Error opening " + string + " for document " + string2);
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)object));
        }
        if (arrayList2 == null) {
            arrayList2 = new ArrayList();
        }
        if ((object = HelperUtilities.getURLForFileName(string2)).length() > 0) {
            try {
                xModel = CommonUtilities.createPropertyValueArrayFormArrayList(arrayList2);
                XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DocumentUtilities.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)xComponent);
                xStorable.storeAsURL((String)object, (PropertyValue[])xModel);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
        } else {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("No filename given, for store.")));
        }
        xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = DocumentUtilities.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), (Object)xComponent);
        DocumentUtilities.closeDocument(xModel, 0, 1);
    }

    public static synchronized void save(String string, boolean bl, int n, boolean bl2) throws BasicErrorException {
        XEnumeration xEnumeration = ApplicationImpl.getXDesktop().getComponents().createEnumeration();
        while (xEnumeration.hasMoreElements()) {
            try {
                XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? DocumentUtilities.class$("com.sun.star.frame.XModel") : class$com$sun$star$frame$XModel), (Object)xEnumeration.nextElement());
                boolean bl3 = false;
                if (string == null) {
                    bl3 = true;
                } else {
                    String string2 = DocumentUtilities.getModelDocumentType(xModel);
                    if (string2 != null && string2.equals(string)) {
                        bl3 = true;
                    }
                }
                if (!bl3) continue;
                if (bl2) {
                    // empty if block
                }
                DocumentUtilities.saveDocument(xModel, false);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

