/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.helper.common.BasicErrorMessage;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.script.BasicErrorException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class DebugHelper {
    private static Boolean DEBUG;
    private static PrintStream DebugFile;
    private static String m_sLogFileName;
    static /* synthetic */ Class class$com$sun$star$helper$common$DebugHelper;

    public static void exception(String string, com.sun.star.uno.Exception exception, int n, String string2) throws BasicErrorException {
        if (string == null || string.length() == 0) {
            string = BasicErrorMessage.getByIndex(n);
        }
        if (string2 != null && string2.length() > 0) {
            string = string.replaceAll("PLACE_HOLDER", string2);
        }
        DebugFile = DebugHelper.getLogStream();
        if (exception != null) {
            DebugFile.println("#" + DebugHelper.getLastCalledClassName() + "# EXCEPTION:");
            DebugFile.flush();
            exception.printStackTrace(DebugFile);
        }
        throw new BasicErrorException(string, null, n, string2);
    }

    public static void exception(int n, String string) throws BasicErrorException {
        DebugHelper.exception("", null, n, string);
    }

    public static void exception(com.sun.star.uno.Exception exception) throws BasicErrorException {
        DebugHelper.exception("", exception, 51, "( " + DebugHelper.getLogFileName() + " )");
    }

    public static void warning(com.sun.star.uno.Exception exception) {
        DebugFile = DebugHelper.getLogStream();
        if (exception != null) {
            DebugFile.println(DebugHelper.getLastCalledClassName() + "WARNING:");
            DebugFile.flush();
            exception.printStackTrace(DebugFile);
        }
    }

    public static void writeInfo(String string) {
        DebugFile = DebugHelper.getLogStream();
        DebugFile.println(DebugHelper.getLastCalledClassName() + "INFO: " + string);
        DebugFile.flush();
    }

    public static void writeDebug(String string) {
        if (DebugHelper.isCompiledWithDebugInformation()) {
            DebugFile = DebugHelper.getLogStream();
            DebugFile.println(DebugHelper.getLastCalledClassName() + "DEBUG: " + string);
            DebugFile.flush();
        }
    }

    public static void writeDebugWarning(Exception exception) {
        if (exception != null && DebugHelper.isCompiledWithDebugInformation()) {
            DebugFile = DebugHelper.getLogStream();
            DebugFile.println(DebugHelper.getLastCalledClassName() + "WARNING:");
            DebugFile.flush();
            exception.printStackTrace(DebugFile);
        }
    }

    public static PrintStream getPrintStream() {
        return DebugHelper.getLogStream();
    }

    public static boolean isCompiledWithDebugInformation() {
        if (DEBUG == null) {
            String string = DebugHelper.getManifestProperty("Debug");
            DEBUG = string.length() == 0 || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no") ? Boolean.FALSE : Boolean.TRUE;
        }
        return DEBUG;
    }

    public static String getBuildID() {
        return DebugHelper.getManifestProperty("BuildID");
    }

    public static String getHelperAPIVersion() {
        return DebugHelper.getManifestProperty("Implementation-Version");
    }

    public static String getRuntimeName() {
        String string = DebugHelper.getManifestProperty("Implementation-Title");
        string = string + "\n" + DebugHelper.getManifestProperty("Implementation-Vendor");
        return string;
    }

    private static PrintStream getLogStream() {
        if (DebugFile != null) {
            return DebugFile;
        }
        String string = DebugHelper.getLogFileName();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        PrintStream printStream = new PrintStream(fileOutputStream);
        String string2 = DebugHelper.getHelperAPIVersion();
        printStream.println("---------- MSOffice Macro Runtime Library version " + string2 + " ----------");
        printStream.println(DebugHelper.getDateString("EEE, d MMM yyyy HH:mm:ss zzzz"));
        return printStream;
    }

    private static String getDateString(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = new Locale("en", "US");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, locale);
        stringBuffer = simpleDateFormat.format(gregorianCalendar.getTime(), stringBuffer, new FieldPosition(0));
        return stringBuffer.toString();
    }

    private static String getLogFileName() {
        if (m_sLogFileName == null) {
            String string = System.getProperty("java.io.tmpdir");
            String string2 = System.getProperty("file.separator");
            String string3 = System.getProperty("user.name");
            if (!string.endsWith(string2)) {
                string = string + string2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append("msoMRLDebug").append(CommonUtilities.getVersion()).append('_').append(string3).append(".out");
            m_sLogFileName = stringBuffer.toString();
        }
        return m_sLogFileName;
    }

    private static String getLastCalledClassName() {
        Throwable throwable = new Throwable();
        throwable.fillInStackTrace();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        boolean bl = false;
        String string = null;
        int n = 0;
        while (!bl && n < stackTraceElementArray.length) {
            string = stackTraceElementArray[n].getClassName();
            if (!string.equals((class$com$sun$star$helper$common$DebugHelper == null ? DebugHelper.class$("com.sun.star.helper.common.DebugHelper") : class$com$sun$star$helper$common$DebugHelper).getName())) {
                int n2 = stackTraceElementArray[n].getLineNumber();
                bl = true;
                string = n2 < 0 ? "#" + string + "# " : "#" + string + ",line " + n2 + "# ";
            }
            ++n;
        }
        return string;
    }

    private static String getManifestProperty(String string) {
        String string2 = null;
        DebugHelper debugHelper = new DebugHelper();
        String string3 = "/" + debugHelper.getClass().getName().replace('.', '/') + ".class";
        URL uRL = debugHelper.getClass().getResource(string3);
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            Manifest manifest = jarURLConnection.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            string2 = attributes.getValue(string);
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        m_sLogFileName = null;
    }
}

