/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc.range;

import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.SheetImpl;
import com.sun.star.helper.calc.SpreadsheetImpl;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;

public class AddressImpl {
    RangeImpl mxCalcRange;
    SpreadsheetImpl moCalcSpreadsheet;
    XSpreadsheet mxAPISpreadsheet;
    SheetImpl moSheetImpl;
    String sColumnR1C1StartSymbol;
    String sColumnR1C1EndSymbol;
    String sRowR1C1StartSymbol;
    String sRowR1C1EndSymbol;
    int ReferenceColumn;
    int ReferenceRow;
    int nVBAStartRow;
    int nVBAEndRow;
    int nVBAStartColumn;
    int nVBAEndColumn;
    int nVBARefStartRow;
    int nVBARefStartColumn;
    boolean bRowAbsolute;
    boolean bColumnAbsolute;
    boolean bExternal;
    boolean bRelativeTo;
    String sRowAbsoluteSymbol;
    String sColumnAbsoluteSymbol;
    int nReferenceStyle;
    int nSpreadsheetColumnsCount;
    int nSpreadsheetRowsCount;
    int nColumnsCount;
    int nRowsCount;

    public AddressImpl(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        block14: {
            this.sColumnR1C1StartSymbol = "C";
            this.sColumnR1C1EndSymbol = "";
            this.sRowR1C1StartSymbol = "R";
            this.sRowR1C1EndSymbol = "";
            this.ReferenceColumn = 0;
            this.ReferenceRow = 0;
            this.nVBAStartRow = 0;
            this.nVBAEndRow = 0;
            this.nVBAStartColumn = 0;
            this.nVBAEndColumn = 0;
            this.bRowAbsolute = true;
            this.bColumnAbsolute = true;
            this.bExternal = false;
            this.bRelativeTo = false;
            this.sRowAbsoluteSymbol = "$";
            this.sColumnAbsoluteSymbol = "$";
            this.nReferenceStyle = 1;
            try {
                Object object6;
                this.mxCalcRange = rangeImpl;
                this.mxAPISpreadsheet = this.mxCalcRange.getXSpreadsheet();
                this.moSheetImpl = (SheetImpl)this.mxCalcRange.getWorksheet();
                this.moCalcSpreadsheet = CalcImpl.getSpreadsheet(this.mxCalcRange.getXModel());
                this.nSpreadsheetColumnsCount = CalcHelper.getMaxColumnCount(this.mxAPISpreadsheet);
                this.nSpreadsheetRowsCount = CalcHelper.getMaxRowCount(this.mxAPISpreadsheet);
                if (!AnyConverter.isVoid((Object)object) && object != null) {
                    this.bRowAbsolute = AnyConverter.toBoolean((Object)object);
                }
                if (!AnyConverter.isVoid((Object)object2) && object2 != null) {
                    this.bColumnAbsolute = AnyConverter.toBoolean((Object)object2);
                }
                if (!AnyConverter.isVoid((Object)object3) && object3 != null) {
                    this.nReferenceStyle = AnyConverter.toInt((Object)object3);
                    if (this.nReferenceStyle != 1 && this.nReferenceStyle != -4150) {
                        DebugHelper.exception(14, "");
                    }
                }
                if (!AnyConverter.isVoid((Object)object4) && object4 != null) {
                    this.bExternal = AnyConverter.toBoolean((Object)object4);
                }
                if (!AnyConverter.isVoid((Object)object5) && object5 != null) {
                    if (((Any)object5).getObject() instanceof XCalcRange) {
                        object6 = (XCalcRange)((Any)object5).getObject();
                        this.nVBARefStartColumn = object6.getColumn();
                        this.nVBARefStartRow = object6.getRow();
                        this.bRelativeTo = true;
                    } else {
                        DebugHelper.exception(14, "");
                    }
                }
                if (!this.bRowAbsolute) {
                    this.sRowAbsoluteSymbol = "";
                    this.sRowR1C1StartSymbol = "R[";
                    this.sRowR1C1EndSymbol = "]";
                }
                if (!this.bColumnAbsolute) {
                    this.sColumnAbsoluteSymbol = "";
                    this.sColumnR1C1StartSymbol = "C[";
                    this.sColumnR1C1EndSymbol = "]";
                }
                object6 = this.mxCalcRange.getXCellRangeAddressable().getRangeAddress();
                this.nVBAStartRow = ((CellRangeAddress)object6).StartRow + 1;
                this.nVBAEndRow = ((CellRangeAddress)object6).EndRow + 1;
                this.nVBAStartColumn = ((CellRangeAddress)object6).StartColumn + 1;
                this.nVBAEndColumn = ((CellRangeAddress)object6).EndColumn + 1;
                if (this.nReferenceStyle != -4150) break block14;
                if (this.bRelativeTo && !this.bRowAbsolute) {
                    this.nVBAStartRow -= this.nVBARefStartRow;
                    this.nVBAEndRow -= this.nVBARefStartRow;
                }
                if (this.bRelativeTo && !this.bColumnAbsolute) {
                    this.nVBAStartColumn -= this.nVBARefStartColumn;
                    this.nVBAEndColumn -= this.nVBARefStartColumn;
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(14, "");
            }
        }
    }

    private String getColumnSymbol(int n) {
        String string = "";
        string = this.nReferenceStyle == 1 ? this.sColumnAbsoluteSymbol + CalcHelper.getStringForNumber(n) : this.sColumnR1C1StartSymbol + Integer.toString(n) + this.sColumnR1C1EndSymbol;
        return string;
    }

    private String getRowSymbol(int n) {
        String string = "";
        string = this.nReferenceStyle == 1 ? this.sRowAbsoluteSymbol + n : this.sRowR1C1StartSymbol + Integer.toString(n) + this.sRowR1C1EndSymbol;
        return string;
    }

    public String getAddressforSingleCell() {
        if (this.nReferenceStyle == 1) {
            return this.getColumnSymbol(this.nVBAStartColumn) + this.getRowSymbol(this.nVBAStartRow);
        }
        return this.getRowSymbol(this.nVBAStartRow) + this.getColumnSymbol(this.nVBAStartColumn);
    }

    public String getAddressforSeveralRows() {
        return this.getAddressforRow(this.nVBAStartRow) + "." + this.getAddressforRow(this.nVBAEndRow);
    }

    protected String getAddressforRow(int n) {
        String string;
        String string2 = "";
        string2 = string = this.getRowSymbol(n);
        if (this.nColumnsCount == this.nSpreadsheetColumnsCount) {
            if (this.nReferenceStyle == 1) {
                string2 = string + ":" + string;
            }
        } else {
            string2 = this.getAddressforRange();
        }
        return string2;
    }

    public String getAddressforRow() {
        return this.getAddressforRow(this.nVBAStartRow);
    }

    public String getAddressforSeveralColumns() {
        return this.getAddressforColumn(this.nVBAStartColumn) + "." + this.getAddressforColumn(this.nVBAEndColumn);
    }

    protected String getAddressforColumn(int n) {
        String string;
        String string2 = "";
        string2 = string = this.getColumnSymbol(n);
        if (this.nRowsCount == this.nSpreadsheetRowsCount) {
            if (this.nReferenceStyle == 1) {
                string2 = string + ":" + string;
            }
        } else {
            string2 = this.getAddressforRange();
        }
        return string2;
    }

    public String getAddressforColumn() {
        return this.getAddressforColumn(this.nVBAStartColumn);
    }

    public String getAddressforRange() {
        String string = this.getColumnSymbol(this.nVBAStartColumn);
        String string2 = this.getColumnSymbol(this.nVBAEndColumn);
        String string3 = this.getRowSymbol(this.nVBAStartRow);
        String string4 = this.getRowSymbol(this.nVBAEndRow);
        String string5 = "";
        string5 = this.nVBAStartRow == 1 && this.nVBAEndRow == this.nSpreadsheetRowsCount && this.nVBAStartColumn == 1 && this.nVBAEndColumn == this.nSpreadsheetColumnsCount ? string3 + ":" + string4 : (this.nVBAStartRow == 1 && this.nVBAEndRow == this.nSpreadsheetRowsCount ? string + ":" + string2 : (this.nVBAStartColumn == 1 && this.nVBAEndColumn == this.nSpreadsheetColumnsCount ? string3 + ":" + string4 : (this.nVBAStartColumn == this.nVBAEndColumn && this.nVBAStartRow == this.nVBAEndRow ? this.getAddressforSingleCell() : (this.nReferenceStyle == 1 ? string + string3 + ":" + string2 + string4 : string3 + string + ":" + string4 + string2))));
        return string5;
    }

    private String addExternalReference(String string) {
        String string2 = string;
        if (this.bExternal) {
            string2 = "[" + this.moCalcSpreadsheet.Name() + "]" + this.moSheetImpl.getName() + "!" + string;
        }
        return string2;
    }

    public static String getAddressforRange(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        AddressImpl addressImpl = new AddressImpl(rangeImpl, object, object2, object3, object4, object5);
        return addressImpl.getAddressforRange();
    }

    public static String getAddressforColumn(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        AddressImpl addressImpl = new AddressImpl(rangeImpl, object, object2, object3, object4, object5);
        return addressImpl.getAddressforColumn();
    }

    public static String getAddressforSeveralColumns(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        AddressImpl addressImpl = new AddressImpl(rangeImpl, object, object2, object3, object4, object5);
        return addressImpl.getAddressforSeveralColumns();
    }

    public static String getAddressforSeveralRows(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        AddressImpl addressImpl = new AddressImpl(rangeImpl, object, object2, object3, object4, object5);
        return addressImpl.getAddressforSeveralRows();
    }

    public static String getAddressforRow(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        AddressImpl addressImpl = new AddressImpl(rangeImpl, object, object2, object3, object4, object5);
        return addressImpl.getAddressforRow();
    }

    public static String getAddressforSingleCell(RangeImpl rangeImpl, Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        AddressImpl addressImpl = new AddressImpl(rangeImpl, object, object2, object3, object4, object5);
        return addressImpl.getAddressforSingleCell();
    }
}

