/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.PaneImpl;
import com.sun.star.helper.calc.SheetsImpl;
import com.sun.star.helper.calc.SpreadsheetImpl;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.XPane;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.XSheets;
import com.sun.star.helper.calc.XWindow;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XViewFreezable;
import com.sun.star.sheet.XViewPane;
import com.sun.star.sheet.XViewSplitable;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

public class WindowImpl
extends com.sun.star.helper.common.WindowImpl
implements XWindow,
XUnoAccess {
    XFrame mxFrame;
    protected static final String __serviceName = "com.sun.star.helper.calc.Window";
    protected XPropertySet mxSpreadSheetDocumentPropertySet;
    protected XController mxController;
    protected XPane mxPane;
    protected XViewPane mxViewPane;
    protected XModel mxModel;
    protected XViewSplitable mxSplitable;
    protected XViewFreezable mxFreezable;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$sheet$XViewPane;
    static /* synthetic */ Class class$com$sun$star$sheet$XViewSplitable;
    static /* synthetic */ Class class$com$sun$star$sheet$XViewFreezable;

    public WindowImpl(SpreadsheetImpl spreadsheetImpl, XFrame xFrame) {
        super(spreadsheetImpl, xFrame, __serviceName);
        if (xFrame == null || !spreadsheetImpl.getImplementationName().equals("SpreadsheetImpl")) {
            DebugHelper.writeInfo("WindowImpl incorrect args passed to ctor.");
        }
        this.mxFrame = xFrame;
        this.mxController = this.mxFrame.getController();
        this.mxModel = this.mxController.getModel();
        this.mxSpreadSheetDocumentPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WindowImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.mxController);
        this.mxViewPane = (XViewPane)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XViewPane == null ? (class$com$sun$star$sheet$XViewPane = WindowImpl.class$("com.sun.star.sheet.XViewPane")) : class$com$sun$star$sheet$XViewPane), (Object)this.mxController);
        this.mxSplitable = (XViewSplitable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XViewSplitable == null ? (class$com$sun$star$sheet$XViewSplitable = WindowImpl.class$("com.sun.star.sheet.XViewSplitable")) : class$com$sun$star$sheet$XViewSplitable), (Object)this.mxController);
        this.mxFreezable = (XViewFreezable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XViewFreezable == null ? (class$com$sun$star$sheet$XViewFreezable = WindowImpl.class$("com.sun.star.sheet.XViewFreezable")) : class$com$sun$star$sheet$XViewFreezable), (Object)this.mxController);
        this.mxPane = this.ActivePane();
    }

    public Object getUnoObject() {
        return this.mxFrame;
    }

    public XPane ActivePane() {
        return new PaneImpl(this, this.mxViewPane);
    }

    public void Close() {
        DispatchCommand.execute(".uno:CloseWin", this.getXFrame());
    }

    public void setTop(int n) {
        super.setTop(n * -1);
    }

    public int getTop() {
        return super.getTop() * -1;
    }

    public void setLeft(int n) {
        super.setLeft(n * -1);
    }

    public int getLeft() {
        return super.getLeft() * -1;
    }

    public void LargeScroll(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        this.mxPane.LargeScroll(object, object2, object3, object4);
    }

    public void SmallScroll(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        this.mxPane.SmallScroll(object, object2, object3, object4);
    }

    public Object getZoom() throws BasicErrorException {
        try {
            short s = new Short(AnyConverter.toShort((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("ZoomType")));
            if (s == 4) {
                return Boolean.TRUE;
            }
            if (s == 3) {
                Short s2 = new Short(AnyConverter.toShort((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("ZoomValue")));
                return s2;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(969, "Zoom");
        }
        return null;
    }

    public void setZoom(Object object) throws BasicErrorException {
        block4: {
            try {
                if (AnyConverter.isBoolean((Object)object) && AnyConverter.toBoolean((Object)object)) {
                    this.mxSpreadSheetDocumentPropertySet.setPropertyValue("ZoomType", (Object)new Short(4));
                    break block4;
                }
                Short s = new Short(AnyConverter.toShort((Object)object));
                this.mxSpreadSheetDocumentPropertySet.setPropertyValue("ZoomType", (Object)new Short(3));
                this.mxSpreadSheetDocumentPropertySet.setPropertyValue("ZoomValue", (Object)s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(969, "Zoom");
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public void setView(int n) throws BasicErrorException {
        boolean bl = false;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            default: {
                DebugHelper.exception(969, "View");
            }
        }
        PropertyValue[] propertyValueArray = new PropertyValue[1];
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.Name = "PagebreakMode";
        propertyValue.Value = bl;
        propertyValueArray[0] = propertyValue;
        DispatchCommand.execute(".uno:PagebreakMode", this.mxFrame, propertyValueArray);
    }

    public int getView() throws BasicErrorException {
        DebugHelper.exception(969, "View");
        return 1;
    }

    public void setDisplayGridlines(boolean bl) throws BasicErrorException {
        try {
            this.mxSpreadSheetDocumentPropertySet.setPropertyValue("ShowGrid", (Object)bl);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getDisplayGridlines() throws BasicErrorException {
        boolean bl = true;
        try {
            Object object = this.mxSpreadSheetDocumentPropertySet.getPropertyValue("ShowGrid");
            if (AnyConverter.isBoolean((Object)object)) {
                bl = AnyConverter.toBoolean((Object)object);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return bl;
    }

    public void setFreezePanes(boolean bl) throws BasicErrorException {
        if (this.mxSplitable.getIsWindowSplit()) {
            int n = this.getSplitColumn();
            int n2 = this.mxSplitable.getSplitRow();
            this.mxFreezable.freezeAtPosition(n, n2);
        } else {
            CellRangeAddress cellRangeAddress = this.mxViewPane.getVisibleRange();
            int n = cellRangeAddress.StartColumn + (cellRangeAddress.EndColumn - cellRangeAddress.StartColumn) / 2;
            int n3 = cellRangeAddress.StartRow + (cellRangeAddress.EndRow - cellRangeAddress.StartRow) / 2;
            this.mxFreezable.freezeAtPosition(n, n3);
        }
    }

    public boolean getFreezePanes() throws BasicErrorException {
        return this.mxFreezable.hasFrozenPanes();
    }

    public void setSplit(boolean bl) throws BasicErrorException {
        block3: {
            try {
                if (!bl) {
                    this.mxSplitable.splitAtPosition(0, 0);
                    break block3;
                }
                XCalcRange xCalcRange = this.ActiveCell();
                int n = xCalcRange.getRow();
                int n2 = xCalcRange.getColumn();
                boolean bl2 = this.getFreezePanes();
                this.mxFreezable.freezeAtPosition(n2 - 1, n - 1);
                this.splitAtDefinedPosition(true);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public boolean getSplit() throws BasicErrorException {
        return this.mxSplitable.getIsWindowSplit();
    }

    public void setSplitColumn(int n) throws BasicErrorException {
        try {
            if (this.getSplitColumn() != n) {
                boolean bl = this.getFreezePanes();
                this.mxFreezable.freezeAtPosition(n, 0);
                this.splitAtDefinedPosition(!bl);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getSplitColumn() throws BasicErrorException {
        return this.mxSplitable.getSplitColumn();
    }

    public void setSplitHorizontal(double d) throws BasicErrorException {
        this.mxSplitable.splitAtPosition((int)d, 0);
    }

    public double getSplitHorizontal() throws BasicErrorException {
        return this.mxSplitable.getSplitHorizontal();
    }

    public void setSplitVertical(double d) throws BasicErrorException {
        this.mxSplitable.splitAtPosition(0, (int)d);
    }

    public double getSplitVertical() throws BasicErrorException {
        return this.mxSplitable.getSplitVertical() + 1;
    }

    protected void splitAtDefinedPosition(boolean bl) {
        int n = this.mxSplitable.getSplitVertical();
        int n2 = this.mxSplitable.getSplitHorizontal();
        if (bl) {
            this.mxFreezable.freezeAtPosition(0, 0);
        }
        this.mxSplitable.splitAtPosition(n2, n);
    }

    public void setSplitRow(int n) throws BasicErrorException {
        try {
            if (this.getSplitRow() != n) {
                boolean bl = this.getFreezePanes();
                this.mxFreezable.freezeAtPosition(0, n);
                this.splitAtDefinedPosition(!bl);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getSplitRow() throws BasicErrorException {
        return this.mxSplitable.getSplitRow();
    }

    public XSheets getSelectedSheets() {
        return new SheetsImpl(this, true);
    }

    public void setDisplayWorkbookTabs(boolean bl) throws BasicErrorException {
        try {
            this.mxSpreadSheetDocumentPropertySet.setPropertyValue("HasSheetTabs", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getDisplayWorkbookTabs() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("HasSheetTabs"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public void setDisplayHorizontalScrollBar(boolean bl) throws BasicErrorException {
        try {
            this.mxSpreadSheetDocumentPropertySet.setPropertyValue("HasHorizontalScrollBar", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getDisplayHorizontalScrollBar() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("HasHorizontalScrollBar"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public void setDisplayVerticalScrollBar(boolean bl) throws BasicErrorException {
        try {
            this.mxSpreadSheetDocumentPropertySet.setPropertyValue("HasVerticalScrollBar", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getDisplayVerticalScrollBar() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("HasVerticalScrollBar"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public void setDisplayHeadings(boolean bl) throws BasicErrorException {
        try {
            this.mxSpreadSheetDocumentPropertySet.setPropertyValue("HasColumnRowHeaders", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getDisplayHeadings() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("HasColumnRowHeaders"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public void setDisplayOutline(boolean bl) throws BasicErrorException {
        try {
            this.mxSpreadSheetDocumentPropertySet.setPropertyValue("IsOutlineSymbolsSet", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getDisplayOutline() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxSpreadSheetDocumentPropertySet.getPropertyValue("IsOutlineSymbolsSet"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public void setScrollColumn(int n) throws BasicErrorException {
        this.mxPane.setScrollColumn(n);
    }

    public int getScrollColumn() throws BasicErrorException {
        return this.mxPane.getScrollColumn();
    }

    public void setScrollRow(int n) throws BasicErrorException {
        this.mxPane.setScrollRow(n);
    }

    public int getScrollRow() throws BasicErrorException {
        return this.mxPane.getScrollRow();
    }

    public XCalcRange ActiveCell() throws BasicErrorException {
        CalcImpl calcImpl = (CalcImpl)this.Application().Calc();
        return calcImpl.ActiveCell(new SpreadsheetImpl(this.getParentAdaptor(), this.mxModel), this.mxModel);
    }

    public XSheet getActiveSheet() throws BasicErrorException {
        SpreadsheetImpl spreadsheetImpl = new SpreadsheetImpl(this.getParentAdaptor(), this.mxModel);
        return spreadsheetImpl.getActiveSheet();
    }

    public Object Selection() throws BasicErrorException {
        CalcImpl calcImpl = (CalcImpl)this.Application().Calc();
        return calcImpl.Selection(new SpreadsheetImpl(this.getParentAdaptor(), this.mxModel), this.mxModel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

