/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertyState;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.XValidation;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.constant.XlDVAlertStyle;
import com.sun.star.helper.constant.XlDVType;
import com.sun.star.helper.constant.XlFormatConditionOperator;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.ConditionOperator;
import com.sun.star.sheet.ValidationAlertStyle;
import com.sun.star.sheet.ValidationType;
import com.sun.star.sheet.XSheetCondition;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

public class ValidationImpl
extends HelperInterfaceAdaptor
implements XValidation,
XlDVType,
XlDVAlertStyle,
XlFormatConditionOperator {
    protected static final String __serviceName = "com.sun.star.helper.calc.Validation";
    protected XPropertySet mxDataValidatePropertySet;
    protected XSheetCondition mxCondition;
    protected int SBINVALIDOPERATOR = -1;
    protected boolean bModificationispossible = false;
    protected XPropertySet mxRangePropertySet;
    protected boolean bNotifyRange = true;
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetCondition;
    static /* synthetic */ Class class$com$sun$star$sheet$ValidationAlertStyle;
    static /* synthetic */ Class class$com$sun$star$sheet$ValidationType;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertyState;

    public ValidationImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XPropertySet xPropertySet, XPropertySet xPropertySet2) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        this.mxDataValidatePropertySet = xPropertySet;
        this.mxRangePropertySet = xPropertySet2;
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = ValidationImpl.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)this.mxDataValidatePropertySet);
        if (!xServiceInfo.supportsService("com.sun.star.sheet.TableValidation")) {
            DebugHelper.exception(1004, "");
        } else {
            this.mxCondition = (XSheetCondition)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetCondition == null ? (class$com$sun$star$sheet$XSheetCondition = ValidationImpl.class$("com.sun.star.sheet.XSheetCondition")) : class$com$sun$star$sheet$XSheetCondition), (Object)this.mxDataValidatePropertySet);
        }
    }

    public void setType(int n) throws BasicErrorException {
        try {
            switch (n) {
                case 0: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.ANY);
                    break;
                }
                case 1: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.WHOLE);
                    break;
                }
                case 2: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.DECIMAL);
                    break;
                }
                case 3: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.LIST);
                    break;
                }
                case 4: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.DATE);
                    break;
                }
                case 5: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.TIME);
                    break;
                }
                case 6: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.TEXT_LEN);
                    break;
                }
                case 7: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.CUSTOM);
                    break;
                }
                default: {
                    this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.ANY);
                    DebugHelper.exception(1004, "");
                }
            }
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public int getType() throws BasicErrorException {
        int n = -1;
        try {
            int n2 = this.getValidationType();
            switch (n2) {
                case 1: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                case 3: {
                    n = 4;
                    break;
                }
                case 4: {
                    n = 5;
                    break;
                }
                case 5: {
                    n = 6;
                    break;
                }
                case 6: {
                    n = 3;
                    break;
                }
                case 7: {
                    n = 7;
                    break;
                }
                default: {
                    DebugHelper.exception(1004, "");
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return n;
    }

    public void setInputTitle(String string) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("InputTitle", (Object)string);
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public String getInputTitle() throws BasicErrorException {
        try {
            return AnyConverter.toString((Object)this.mxDataValidatePropertySet.getPropertyValue("InputTitle"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return "";
        }
    }

    public void setInputMessage(String string) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("InputMessage", (Object)string);
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public String getInputMessage() throws BasicErrorException {
        try {
            return AnyConverter.toString((Object)this.mxDataValidatePropertySet.getPropertyValue("InputMessage"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return "";
        }
    }

    public void setErrorMessage(String string) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("ErrorMessage", (Object)string);
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public String getErrorMessage() throws BasicErrorException {
        try {
            return AnyConverter.toString((Object)this.mxDataValidatePropertySet.getPropertyValue("ErrorMessage"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return "";
        }
    }

    public void setShowError(boolean bl) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("ShowErrorMessage", (Object)new Boolean(bl));
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public boolean getShowError() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxDataValidatePropertySet.getPropertyValue("ShowErrorMessage"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return false;
        }
    }

    public void setShowInput(boolean bl) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("ShowInputMessage", (Object)new Boolean(bl));
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public boolean getShowInput() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxDataValidatePropertySet.getPropertyValue("ShowInputMessage"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return false;
        }
    }

    public void setErrorTitle(String string) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("ErrorTitle", (Object)string);
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public String getErrorTitle() throws BasicErrorException {
        try {
            return AnyConverter.toString((Object)this.mxDataValidatePropertySet.getPropertyValue("ErrorTitle"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return "";
        }
    }

    public void setIgnoreBlank(boolean bl) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("IgnoreBlankCells", (Object)new Boolean(bl));
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public boolean getIgnoreBlank() throws BasicErrorException {
        try {
            return AnyConverter.toBoolean((Object)this.mxDataValidatePropertySet.getPropertyValue("IgnoreBlankCells"));
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return false;
        }
    }

    public int AlertStyle() throws BasicErrorException {
        int n = -1;
        try {
            ValidationAlertStyle validationAlertStyle = (ValidationAlertStyle)AnyConverter.toObject((Class)(class$com$sun$star$sheet$ValidationAlertStyle == null ? (class$com$sun$star$sheet$ValidationAlertStyle = ValidationImpl.class$("com.sun.star.sheet.ValidationAlertStyle")) : class$com$sun$star$sheet$ValidationAlertStyle), (Object)this.mxDataValidatePropertySet.getPropertyValue("ErrorAlertStyle"));
            switch (validationAlertStyle.getValue()) {
                case 2: {
                    n = 3;
                    break;
                }
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                case 3: {
                    DebugHelper.exception(1004, "Style ''Macro' is not supported");
                    break;
                }
                default: {
                    DebugHelper.exception(1004, "");
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return n;
    }

    protected void setAlertStyle(int n) throws BasicErrorException {
        try {
            switch (n) {
                case 3: {
                    this.mxDataValidatePropertySet.setPropertyValue("ErrorAlertStyle", (Object)ValidationAlertStyle.INFO);
                    break;
                }
                case 1: {
                    this.mxDataValidatePropertySet.setPropertyValue("ErrorAlertStyle", (Object)ValidationAlertStyle.STOP);
                    break;
                }
                case 2: {
                    this.mxDataValidatePropertySet.setPropertyValue("ErrorAlertStyle", (Object)ValidationAlertStyle.WARNING);
                    break;
                }
                default: {
                    DebugHelper.exception(1004, "");
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void setInCellDropdown(boolean bl) throws BasicErrorException {
        try {
            this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)ValidationType.LIST);
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    private int getValidationType() throws BasicErrorException {
        try {
            ValidationType validationType = (ValidationType)AnyConverter.toObject((Class)(class$com$sun$star$sheet$ValidationType == null ? (class$com$sun$star$sheet$ValidationType = ValidationImpl.class$("com.sun.star.sheet.ValidationType")) : class$com$sun$star$sheet$ValidationType), (Object)this.mxDataValidatePropertySet.getPropertyValue("Type"));
            return validationType.getValue();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return -1;
        }
    }

    public boolean getInCellDropdown() throws BasicErrorException {
        try {
            return this.getValidationType() == 6;
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return false;
        }
    }

    public String Formula1() throws BasicErrorException {
        return this.mxCondition.getFormula1();
    }

    public String Formula2() throws BasicErrorException {
        return this.mxCondition.getFormula2();
    }

    public int Operator() throws BasicErrorException {
        int n = -1;
        ConditionOperator conditionOperator = this.mxCondition.getOperator();
        switch (conditionOperator.getValue()) {
            case 1: {
                n = 3;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 8;
                break;
            }
            case 7: {
                n = 1;
                break;
            }
            case 8: {
                n = 2;
                break;
            }
            default: {
                DebugHelper.exception(1004, "Operator not supported");
            }
        }
        return n;
    }

    protected void setOperator(int n) throws BasicErrorException {
        switch (n) {
            case 1: {
                this.mxCondition.setOperator(ConditionOperator.BETWEEN);
                break;
            }
            case 2: {
                this.mxCondition.setOperator(ConditionOperator.NOT_BETWEEN);
                break;
            }
            case 3: {
                this.mxCondition.setOperator(ConditionOperator.EQUAL);
                break;
            }
            case 4: {
                this.mxCondition.setOperator(ConditionOperator.NOT_EQUAL);
                break;
            }
            case 5: {
                this.mxCondition.setOperator(ConditionOperator.GREATER);
                break;
            }
            case 6: {
                this.mxCondition.setOperator(ConditionOperator.LESS);
                break;
            }
            case 7: {
                this.mxCondition.setOperator(ConditionOperator.GREATER_EQUAL);
                break;
            }
            case 8: {
                this.mxCondition.setOperator(ConditionOperator.LESS_EQUAL);
                break;
            }
            default: {
                this.mxCondition.setOperator(ConditionOperator.NONE);
            }
        }
        this.notifyRange();
    }

    public void Delete() throws BasicErrorException {
        try {
            XPropertyState xPropertyState = (XPropertyState)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertyState == null ? (class$com$sun$star$beans$XPropertyState = ValidationImpl.class$("com.sun.star.beans.XPropertyState")) : class$com$sun$star$beans$XPropertyState), (Object)this.mxRangePropertySet);
            xPropertyState.setPropertyToDefault("Validation");
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
        this.bModificationispossible = false;
    }

    public void Add(int n, Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        try {
            this.bNotifyRange = false;
            this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)new Integer(n));
            this.modifyValidation(object, object2, object3, object4);
            this.setShowError(true);
            this.setShowInput(true);
            this.bModificationispossible = true;
            this.bNotifyRange = true;
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void Modify(Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        block4: {
            try {
                if (this.bModificationispossible) {
                    this.bNotifyRange = false;
                    if (object != null && NumericalHelper.isNumerical(object)) {
                        int n = (int)OptionalParamUtility.getAnyNumber("Type", object, 1L, false);
                        this.mxDataValidatePropertySet.setPropertyValue("Type", (Object)new Integer(n));
                    }
                    this.modifyValidation(object2, object3, object4, object5);
                    this.bNotifyRange = true;
                    this.notifyRange();
                    break block4;
                }
                DebugHelper.exception(1004, "");
            }
            catch (Exception exception) {
                DebugHelper.exception(1004, "");
            }
        }
    }

    protected void modifyValidation(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        try {
            int n;
            if (object != null) {
                n = NumericalHelper.toIntWithErrorMessage(object);
                this.setAlertStyle(n);
            }
            if (object2 != null) {
                n = NumericalHelper.toInt(object2);
                this.setOperator(n);
            }
            if (object3 != null && object3 instanceof String) {
                this.mxCondition.setFormula1((String)object3);
            }
            if (object4 != null && object4 instanceof String) {
                this.mxCondition.setFormula2((String)object4);
            }
            this.notifyRange();
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    public void setValue(boolean bl) throws BasicErrorException {
        DebugHelper.exception(73, "");
    }

    public boolean getValue() throws BasicErrorException {
        DebugHelper.exception(73, "");
        return false;
    }

    private void notifyRange() throws BasicErrorException {
        try {
            if (this.bNotifyRange) {
                this.mxRangePropertySet.setPropertyValue("Validation", (Object)this.mxDataValidatePropertySet);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

