/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.awt.XTopWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.ChartsImpl;
import com.sun.star.helper.calc.SheetsImpl;
import com.sun.star.helper.calc.WindowsImpl;
import com.sun.star.helper.calc.XCharts;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.XSheets;
import com.sun.star.helper.calc.XSpreadsheet;
import com.sun.star.helper.calc.XWindow;
import com.sun.star.helper.calc.XWindows;
import com.sun.star.helper.common.CalcFilename;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XSpreadsheetView;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XProtectable;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class SpreadsheetImpl
extends HelperInterfaceAdaptor
implements XSpreadsheet,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.Spreadsheet";
    protected XModel xSpreadsheetModel = null;
    protected SheetsImpl xSheets = null;
    protected ChartsImpl xCharts = null;
    protected WindowsImpl cacheWindows = null;
    boolean saved = false;
    protected int[] ColorIndizes = new int[]{0, 0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0x993366, 0xFFFFCC, 0xCCFFFF, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 128, 0xFF00FF, 0xFFFF00, 65535, 0x800080, 0x800000, 32896, 255, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheetView;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$awt$XTopWindow;
    static /* synthetic */ Class class$com$sun$star$util$XProtectable;

    public SpreadsheetImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XModel xModel) {
        super(__serviceName, helperInterfaceAdaptor);
        this.xSpreadsheetModel = xModel;
    }

    protected int swapFirstAndThirdByte(int n) {
        String string = null;
        String string2 = null;
        byte[] byArray = null;
        byte[] byArray2 = new byte[6];
        string = Integer.toHexString(n);
        if (string.length() != 6) {
            if (string.length() == 1) {
                string2 = "00000";
            }
            if (string.length() == 2) {
                string2 = "0000";
            }
            if (string.length() == 3) {
                string2 = "000";
            }
            if (string.length() == 4) {
                string2 = "00";
            }
            if (string.length() == 5) {
                string2 = "0";
            }
            string = string2.concat(string);
        }
        byArray = string.getBytes();
        byArray2[0] = byArray[4];
        byArray2[1] = byArray[5];
        byArray2[2] = byArray[2];
        byArray2[3] = byArray[3];
        byArray2[4] = byArray[0];
        byArray2[5] = byArray[1];
        string = new String(byArray2, 0, 6);
        return Integer.parseInt(string, 16);
    }

    public int getColorAtIndex(int n) {
        return this.ColorIndizes[n];
    }

    public void setPrecisionAsDisplayed(boolean bl) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xSpreadsheetModel);
            xPropertySet.setPropertyValue("CalcAsShown", (Object)new Boolean(bl));
        }
        catch (UnknownPropertyException unknownPropertyException) {
        }
        catch (WrappedTargetException wrappedTargetException) {
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public boolean getPrecisionAsDisplayed() {
        Boolean bl = null;
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xSpreadsheetModel);
            bl = (Boolean)xPropertySet.getPropertyValue("CalcAsShown");
        }
        catch (UnknownPropertyException unknownPropertyException) {
        }
        catch (WrappedTargetException wrappedTargetException) {}
        return bl;
    }

    public void ResetColors() {
        int[] nArray = new int[]{0, 0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535, 0x800000, 32768, 128, 0x808000, 0x800080, 32896, 0xC0C0C0, 0x808080, 0x9999FF, 0x993366, 0xFFFFCC, 0xCCFFFF, 0x660066, 0xFF8080, 26316, 0xCCCCFF, 128, 0xFF00FF, 0xFFFF00, 65535, 0x800080, 0x800000, 32896, 255, 52479, 0xCCFFFF, 0xCCFFCC, 0xFFFF99, 0x99CCFF, 0xFF99CC, 0xCC99FF, 0xFFCC99, 0x3366FF, 0x33CCCC, 0x99CC00, 0xFFCC00, 0xFF9900, 0xFF6600, 0x666699, 0x969696, 13158, 0x339966, 13056, 0x333300, 0x993300, 0x993366, 0x333399, 0x333333};
        this.ColorIndizes = nArray;
    }

    public void SetColors(Object object, Object object2) {
        int n = -1;
        try {
            if (!AnyConverter.isVoid((Object)object) && !AnyConverter.isVoid((Object)object2)) {
                n = AnyConverter.toInt((Object)object);
                int n2 = AnyConverter.toInt((Object)object2);
                this.ColorIndizes[n - 1] = this.swapFirstAndThirdByte(n2);
            } else {
                Object object3 = AnyConverter.toArray((Object)object);
                int n3 = 0;
                while (n3 < Array.getLength(object3)) {
                    this.ColorIndizes[n3] = (Integer)Array.get(object3, n3);
                    ++n3;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public Object Colors(Object object) {
        Any any;
        block4: {
            Integer[] integerArray = new Integer[56];
            any = null;
            try {
                if (!AnyConverter.isVoid((Object)object)) {
                    int n = AnyConverter.toInt((Object)object);
                    any = new Any(Type.LONG, (Object)new Integer(this.swapFirstAndThirdByte(this.ColorIndizes[n - 1])));
                    break block4;
                }
                int n = 0;
                while (n < 56) {
                    integerArray[n] = new Integer(this.ColorIndizes[n]);
                    ++n;
                }
                any = new Any(new Type(array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = SpreadsheetImpl.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer), (Object)integerArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return any;
    }

    public String Name() {
        XFrame xFrame = this.xSpreadsheetModel.getCurrentController().getFrame();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = SpreadsheetImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xFrame);
        String string = "";
        try {
            string = (String)xPropertySet.getPropertyValue("Title");
            int n = string.lastIndexOf("-");
            string = string.substring(0, n - 1);
        }
        catch (UnknownPropertyException unknownPropertyException) {
        }
        catch (WrappedTargetException wrappedTargetException) {}
        return string;
    }

    public int FileFormat() {
        int n = 0;
        String string = null;
        PropertyValue[] propertyValueArray = this.xSpreadsheetModel.getArgs();
        string = propertyValueArray[0].Name.equals("FilterName") ? (String)propertyValueArray[0].Value : (String)propertyValueArray[1].Value;
        if (string.equals("Text - txt - csv (StarCalc)")) {
            n = 6;
        }
        if (string.equals("DBF")) {
            n = 11;
        }
        if (string.equals("DIF")) {
            n = 9;
        }
        if (string.equals("Lotus")) {
            n = 15;
        }
        if (string.equals("MS Excel 4.0")) {
            n = 35;
        }
        if (string.equals("MS Excel 5.0/95")) {
            n = 39;
        }
        if (string.equals("MS Excel 97")) {
            n = 43;
        }
        if (string.equals("HTML (StarCalc)")) {
            n = 44;
        }
        if (string.equals("calc_StarOffice_XML_Calc_Template")) {
            n = 17;
        }
        if (string.equals("StarOffice XML (Calc)")) {
            n = -4143;
        }
        if (string.equals("calc8")) {
            n = -4143;
        }
        return n;
    }

    public String FullName() {
        boolean bl = false;
        String string = this.xSpreadsheetModel.getURL();
        CalcFilename calcFilename = new CalcFilename(string);
        string = calcFilename.getAbsoluteFilename();
        return string;
    }

    public String Path() {
        String string = this.xSpreadsheetModel.getURL();
        CalcFilename calcFilename = new CalcFilename(string);
        string = calcFilename.getPath();
        return string;
    }

    public void Close(Object object, Object object2, Object object3) throws BasicErrorException {
        boolean bl = OptionalParamUtility.getBoolean("SaveChanges", object, false, false);
        if (!AnyConverter.isVoid((Object)object2)) {
            String string = OptionalParamUtility.getString("FileName", object2, "local:default", false);
            DebugHelper.writeInfo("Spreadsheet.Close(): Filename:=" + string);
        }
        boolean bl2 = OptionalParamUtility.getBoolean("RouteDocument", object3, false, false);
        int n = -1;
        n = bl ? -1 : 0;
        HelperUtilities.closeDocument(this.getXModel(), n, 1);
    }

    public void Save() throws BasicErrorException, IOException {
        DebugHelper.writeInfo("Entering Save()");
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = SpreadsheetImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.xSpreadsheetModel);
        if (this.FullName().length() > 3) {
            DebugHelper.writeInfo("Old File, Storing to " + this.FullName());
            xStorable.store();
        } else {
            DebugHelper.writeInfo("New File, using SaveAs()");
            this.SaveAs(this.Name(), null, null, null, null, null, null, null, null, null, null);
        }
        this.saved = true;
    }

    public void SaveAs(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11) throws BasicErrorException, IOException {
        DebugHelper.writeInfo("starting SaveAs");
        String string = OptionalParamUtility.getString("filename", object, "local:default", false);
        if (string.equals("local:default")) {
            DebugHelper.warning((Exception)((Object)new IllegalArgumentException("Parameter FileName not set.")));
        }
        int n = 0;
        ArrayList<CalcFilename> arrayList = new ArrayList<CalcFilename>();
        try {
            PropertyValue propertyValue;
            String string2;
            CalcFilename calcFilename;
            String string3 = "";
            String string4 = "";
            if (CommonUtilities.isVersion8()) {
                string4 = "calc8";
                string3 = ".ods";
            } else {
                string4 = "StarOffice XML (Calc)";
                string3 = ".sxc";
            }
            if (NumericalHelper.isNumerical(object2)) {
                n = NumericalHelper.toInt(object2);
                switch (n) {
                    case -4158: 
                    case 6: 
                    case 22: 
                    case 23: 
                    case 24: {
                        string4 = "Text - txt - csv (StarCalc)";
                        string3 = ".csv";
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 11: {
                        string4 = "DBF";
                        string3 = ".dbf";
                        break;
                    }
                    case 9: {
                        string4 = "DIF";
                        string3 = ".dif";
                        break;
                    }
                    case 4: {
                        string4 = "Lotus";
                        string3 = ".wks";
                        break;
                    }
                    case 29: 
                    case 33: {
                        string4 = "MS Excel 4.0";
                        string3 = ".xls";
                        break;
                    }
                    case 39: 
                    case 43: {
                        string4 = "MS Excel 97";
                        string3 = ".xls";
                        break;
                    }
                    case 44: {
                        string4 = "HTML (StarCalc)";
                        string3 = ".htm";
                        break;
                    }
                    case 17: {
                        if (CommonUtilities.isVersion8()) {
                            string4 = "calc8_template";
                            string3 = ".ots";
                        } else {
                            string4 = "calc_StarOffice_XML_Calc_Template";
                            string3 = ".stc";
                        }
                        calcFilename = new PropertyValue();
                        ((PropertyValue)calcFilename).Name = "AsTemplate";
                        ((PropertyValue)calcFilename).Value = Boolean.TRUE;
                        arrayList.add(calcFilename);
                        break;
                    }
                }
            }
            calcFilename = new CalcFilename(string);
            calcFilename.prepareToWrite(string3);
            PropertyValue propertyValue2 = new PropertyValue();
            propertyValue2.Name = "FilterName";
            propertyValue2.Value = string4;
            arrayList.add((CalcFilename)propertyValue2);
            if (AnyConverter.isString((Object)object3) && (string2 = OptionalParamUtility.getString("Password", object3, "", false)).length() > 0) {
                propertyValue = new PropertyValue();
                propertyValue.Name = "Password";
                propertyValue.Value = (String)object3;
                arrayList.add((CalcFilename)propertyValue);
                DebugHelper.writeInfo("Spreadsheet.SaveAs(): Property 'Password' := 'XXXXXX'");
            }
            string2 = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = SpreadsheetImpl.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable), (Object)this.xSpreadsheetModel);
            propertyValue = CommonUtilities.createPropertyValueArrayFormArrayList(arrayList);
            String string5 = calcFilename.getURL();
            DebugHelper.writeInfo("storing to: " + string5);
            string2.storeAsURL(string5, (PropertyValue[])propertyValue);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        this.saved = true;
    }

    public boolean Saved() {
        if (HelperUtilities.isModified(this.xSpreadsheetModel)) {
            this.saved = false;
        }
        return this.saved;
    }

    public XSheets getSheets() {
        if (this.xSheets == null) {
            this.xSheets = new SheetsImpl(this);
        }
        return this.xSheets;
    }

    public XSheet getActiveSheet() throws BasicErrorException {
        XSheet xSheet = null;
        XSpreadsheetView xSpreadsheetView = (XSpreadsheetView)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetView == null ? (class$com$sun$star$sheet$XSpreadsheetView = SpreadsheetImpl.class$("com.sun.star.sheet.XSpreadsheetView")) : class$com$sun$star$sheet$XSpreadsheetView), (Object)this.getXModel().getCurrentController());
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = SpreadsheetImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)xSpreadsheetView.getActiveSheet());
        xSheet = this.getSheets().Item(xNamed.getName());
        return xSheet;
    }

    public XCharts Charts() {
        if (this.xCharts == null) {
            this.xCharts = new ChartsImpl(this);
        }
        return this.xCharts;
    }

    public XModel getXModel() {
        return this.xSpreadsheetModel;
    }

    public static CalcImpl getInstance() {
        return ApplicationImpl.getCalcImpl();
    }

    public void Activate() {
        XModel xModel = this.getXModel();
        XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XTopWindow == null ? (class$com$sun$star$awt$XTopWindow = SpreadsheetImpl.class$("com.sun.star.awt.XTopWindow")) : class$com$sun$star$awt$XTopWindow), (Object)xModel.getCurrentController().getFrame().getContainerWindow());
        xTopWindow.toFront();
    }

    public void Protect(Object object, Object object2, Object object3) {
        String string = OptionalParamUtility.getString("password", object, "", false);
        XModel xModel = this.getXModel();
        XProtectable xProtectable = (XProtectable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XProtectable == null ? (class$com$sun$star$util$XProtectable = SpreadsheetImpl.class$("com.sun.star.util.XProtectable")) : class$com$sun$star$util$XProtectable), (Object)xModel);
        xProtectable.protect(string);
    }

    public void Unprotect(Object object) throws BasicErrorException {
        try {
            String string = OptionalParamUtility.getString("password", object, "", false);
            XModel xModel = this.getXModel();
            XProtectable xProtectable = (XProtectable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XProtectable == null ? (class$com$sun$star$util$XProtectable = SpreadsheetImpl.class$("com.sun.star.util.XProtectable")) : class$com$sun$star$util$XProtectable), (Object)xModel);
            xProtectable.unprotect(string);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public XWindows getWindows() {
        return this.getWindowsImpl();
    }

    WindowsImpl getWindowsImpl() {
        if (this.cacheWindows == null) {
            this.cacheWindows = new WindowsImpl(this);
        }
        return this.cacheWindows;
    }

    public XWindow getActiveWindow() {
        Object object;
        XFrame xFrame = ApplicationImpl.getXDesktop().getCurrentFrame();
        if (xFrame != null && (object = xFrame.getController().getModel()) == this.getXModel()) {
            return this.getWindowsImpl().getWindow(xFrame);
        }
        object = null;
        try {
            object = ((WindowsImpl)this.getWindows()).Item(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        return object;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xSpreadsheetModel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

