/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNamed;
import com.sun.star.document.XExporter;
import com.sun.star.document.XFilter;
import com.sun.star.document.XImporter;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.SheetImpl;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.XSheets;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XSheetCellRanges;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheetView;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XProtectable;
import com.sun.star.util.XRefreshListener;
import com.sun.star.util.XRefreshable;
import com.sun.star.util.XURLTransformer;
import com.sun.star.view.XPrintable;
import com.sun.star.view.XSelectionSupplier;
import com.sun.star.xml.sax.XDocumentHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SheetsImpl
extends HelperInterfaceAdaptor
implements XSheets {
    private static final String __serviceName = "com.sun.star.helper.calc.Sheets";
    private boolean selected = false;
    public SheetsCache sheetNames = null;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheetDocument;
    static /* synthetic */ Class class$com$sun$star$util$XProtectable;
    static /* synthetic */ Class class$com$sun$star$container$XNameContainer;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheet;
    static /* synthetic */ Class class$com$sun$star$document$XImporter;
    static /* synthetic */ Class class$com$sun$star$xml$sax$XDocumentHandler;
    static /* synthetic */ Class class$com$sun$star$document$XExporter;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$document$XFilter;
    static /* synthetic */ Class class$com$sun$star$frame$XDispatchProvider;
    static /* synthetic */ Class class$com$sun$star$util$XURLTransformer;
    static /* synthetic */ Class class$com$sun$star$view$XPrintable;
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetCellRanges;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeAddressable;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$helper$calc$XSheet;
    static /* synthetic */ Class class$com$sun$star$sheet$XSpreadsheetView;
    static /* synthetic */ Class class$com$sun$star$helper$calc$SheetImpl;

    public SheetsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, boolean bl) {
        super(__serviceName, helperInterfaceAdaptor);
        this.sheetNames = new SheetsCache(this, this.getXSpreadsheets(), bl);
        this.selected = bl;
    }

    public SheetsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        this(helperInterfaceAdaptor, false);
    }

    public int Count() throws BasicErrorException {
        int n = 0;
        if (this.selected) {
            short[] sArray = this.sheetNames.getSelectedSheets();
            if (sArray != null) {
                n = sArray.length;
            }
        } else {
            String[] stringArray;
            XSpreadsheets xSpreadsheets = this.getXSpreadsheets();
            if (xSpreadsheets != null && (stringArray = xSpreadsheets.getElementNames()) != null) {
                n = stringArray.length;
            }
        }
        return n;
    }

    public void Delete() throws BasicErrorException {
        this.sheetNames.refresh();
        String[] stringArray = this.sheetNames.getSheetNames();
        this.Delete(stringArray);
    }

    void Delete(String[] stringArray) throws BasicErrorException {
        XModel xModel = this.getXModel();
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetDocument == null ? (class$com$sun$star$sheet$XSpreadsheetDocument = SheetsImpl.class$("com.sun.star.sheet.XSpreadsheetDocument")) : class$com$sun$star$sheet$XSpreadsheetDocument), (Object)xModel);
        XProtectable xProtectable = (XProtectable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XProtectable == null ? (class$com$sun$star$util$XProtectable = SheetsImpl.class$("com.sun.star.util.XProtectable")) : class$com$sun$star$util$XProtectable), (Object)xModel);
        if (xProtectable.isProtected()) {
            DebugHelper.exception(new Exception("Sheets cannot be deleted since document is protected."));
        }
        XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
        XNameContainer xNameContainer = (XNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = SheetsImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer), (Object)xSpreadsheets);
        int n = 0;
        while (n < stringArray.length) {
            try {
                xNameContainer.removeByName(stringArray[n]);
            }
            catch (NoSuchElementException noSuchElementException) {
                DebugHelper.exception((Exception)((Object)noSuchElementException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.exception((Exception)((Object)wrappedTargetException));
            }
            try {
                this.sheetNames.removeByName(stringArray[n]);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            ++n;
        }
    }

    public XSheet Item(Object object) throws BasicErrorException {
        this.sheetNames.refresh();
        if (object != null && !AnyConverter.isVoid((Object)object)) {
            try {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    return this.Item(string);
                }
                int n = (int)OptionalParamUtility.getAnyNumber("Index", object, 1L, true);
                return this.Item(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        }
        return null;
    }

    private XSheet Item(int n) throws BasicErrorException {
        SheetImpl sheetImpl;
        block3: {
            sheetImpl = null;
            if (n > 0) {
                --n;
            }
            if (n >= this.Count()) break block3;
            try {
                String string = this.sheetNames.getSheetNames()[n];
                sheetImpl = (SheetImpl)this.sheetNames.getByName(string);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return sheetImpl;
    }

    private XSheet Item(String string) throws BasicErrorException {
        SheetImpl sheetImpl = null;
        try {
            String[] stringArray = this.sheetNames.getSheetNames();
            int n = 0;
            while (n < stringArray.length) {
                if (0 == string.compareToIgnoreCase(stringArray[n])) {
                    sheetImpl = (SheetImpl)this.sheetNames.getByName(string);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return sheetImpl;
    }

    public XSheet Add(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        XSheet xSheet;
        short s = this.getNewIndex(object, object2);
        short s2 = 1;
        try {
            if (!AnyConverter.isVoid((Object)object3)) {
                s2 = AnyConverter.toShort((Object)object3);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            DebugHelper.exception(969, "Type not supported");
        }
        if ((xSheet = this.AddByName(s, s2)) != null) {
            xSheet.Activate();
        }
        return xSheet;
    }

    public void Copy(Object object, Object object2) throws BasicErrorException {
        String[] stringArray = this.sheetNames.getSheetNames();
        if (stringArray == null) {
            return;
        }
        this.Copy(stringArray, object, object2);
    }

    void Copy(String[] stringArray, Object object, Object object2) throws BasicErrorException {
        block11: {
            block10: {
                this.sheetNames.refresh();
                short s = this.getNewIndex(object, object2);
                if (AnyConverter.isVoid((Object)object2) && AnyConverter.isVoid((Object)object)) {
                    s = -1;
                }
                if (s == -1) break block10;
                XSpreadsheets xSpreadsheets = this.getXSpreadsheets();
                XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = SheetsImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)xSpreadsheets);
                String string = null;
                int n = 0;
                while (n < stringArray.length) {
                    int n2 = 2;
                    String string2 = stringArray[n];
                    while (xNameAccess.hasByName(string2)) {
                        string2 = stringArray[n] + "_" + n2 + "_";
                        ++n2;
                    }
                    short s2 = s;
                    s = (short)(s + 1);
                    xSpreadsheets.copyByName(stringArray[n], string2, s2);
                    if (n == 0) {
                        try {
                            XSpreadsheet xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheet == null ? SheetsImpl.class$("com.sun.star.sheet.XSpreadsheet") : class$com$sun$star$sheet$XSpreadsheet), (Object)xNameAccess.getByName(string2));
                            this.AddNewToCache(string2, xSpreadsheet);
                            string = string2;
                        }
                        catch (Exception exception) {
                            DebugHelper.exception(exception);
                        }
                    }
                    ++n;
                }
                SheetImpl sheetImpl = null;
                try {
                    sheetImpl = (SheetImpl)this.sheetNames.getByName(string);
                }
                catch (Exception exception) {
                    DebugHelper.exception(exception);
                }
                if (sheetImpl == null) break block11;
                sheetImpl.Activate();
                break block11;
            }
            this.cloneSheetsInNewDocument(stringArray);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void cloneSheetsInNewDocument(String[] stringArray) throws BasicErrorException {
        if (stringArray.length == 0) {
            return;
        }
        try {
            XDesktop xDesktop = this.Application().XDesktop();
            ApplicationImpl cfr_ignored_0 = (ApplicationImpl)this.Application();
            XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetDocument == null ? (class$com$sun$star$sheet$XSpreadsheetDocument = SheetsImpl.class$("com.sun.star.sheet.XSpreadsheetDocument")) : class$com$sun$star$sheet$XSpreadsheetDocument), (Object)this.getXModel());
            XModel xModel = HelperUtilities.openDocument("private:factory/scalc");
            XSpreadsheetDocument xSpreadsheetDocument2 = (XSpreadsheetDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetDocument == null ? (class$com$sun$star$sheet$XSpreadsheetDocument = SheetsImpl.class$("com.sun.star.sheet.XSpreadsheetDocument")) : class$com$sun$star$sheet$XSpreadsheetDocument), (Object)xModel);
            Object object = xMultiServiceFactory.createInstance("com.sun.star.comp.Calc.XMLImporter");
            XImporter xImporter = (XImporter)UnoRuntime.queryInterface((Class)(class$com$sun$star$document$XImporter == null ? (class$com$sun$star$document$XImporter = SheetsImpl.class$("com.sun.star.document.XImporter")) : class$com$sun$star$document$XImporter), (Object)object);
            XDocumentHandler xDocumentHandler = (XDocumentHandler)UnoRuntime.queryInterface((Class)(class$com$sun$star$xml$sax$XDocumentHandler == null ? (class$com$sun$star$xml$sax$XDocumentHandler = SheetsImpl.class$("com.sun.star.xml.sax.XDocumentHandler")) : class$com$sun$star$xml$sax$XDocumentHandler), (Object)object);
            Any any = new Any(new Type(class$com$sun$star$xml$sax$XDocumentHandler == null ? (class$com$sun$star$xml$sax$XDocumentHandler = SheetsImpl.class$("com.sun.star.xml.sax.XDocumentHandler")) : class$com$sun$star$xml$sax$XDocumentHandler), (Object)xDocumentHandler);
            Object object2 = xMultiServiceFactory.createInstanceWithArguments("com.sun.star.comp.Calc.XMLExporter", new Object[]{any});
            XExporter xExporter = (XExporter)UnoRuntime.queryInterface((Class)(class$com$sun$star$document$XExporter == null ? (class$com$sun$star$document$XExporter = SheetsImpl.class$("com.sun.star.document.XExporter")) : class$com$sun$star$document$XExporter), (Object)object2);
            xImporter.setTargetDocument((XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = SheetsImpl.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)xSpreadsheetDocument2));
            xExporter.setSourceDocument((XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = SheetsImpl.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)xSpreadsheetDocument));
            XFilter xFilter = (XFilter)UnoRuntime.queryInterface((Class)(class$com$sun$star$document$XFilter == null ? (class$com$sun$star$document$XFilter = SheetsImpl.class$("com.sun.star.document.XFilter")) : class$com$sun$star$document$XFilter), (Object)object2);
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "FilterName";
            propertyValueArray[0].Value = "scalc: StarOffice XML (spreadsheet)";
            xFilter.filter(propertyValueArray);
            XSpreadsheets xSpreadsheets = xSpreadsheetDocument2.getSheets();
            String[] stringArray2 = xSpreadsheets.getElementNames();
            int n = 0;
            while (n < stringArray2.length) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray2[n].equals(stringArray[n2])) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    xSpreadsheets.removeByName(stringArray2[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void Move(Object object, Object object2) throws BasicErrorException {
        this.sheetNames.refresh();
        String[] stringArray = this.sheetNames.getSheetNames();
        if (stringArray == null) {
            return;
        }
        this.Move(stringArray, object, object2);
    }

    void Move(String[] stringArray, Object object, Object object2) throws BasicErrorException {
        int n;
        short s = this.getNewIndex(object, object2);
        String string = null;
        if (AnyConverter.isVoid((Object)object2) && AnyConverter.isVoid((Object)object)) {
            s = -1;
        }
        if (s != -1) {
            n = 0;
            while (n < stringArray.length) {
                this.getXSpreadsheets().moveByName(stringArray[n], s);
                s = this.getNewIndex(object, object2);
                if (!AnyConverter.isVoid((Object)object2)) {
                    s = (short)(s + n + 1);
                }
                if (n == 0) {
                    string = stringArray[0];
                }
                ++n;
            }
        } else {
            this.cloneSheetsInNewDocument(stringArray);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n = 0;
            while (n < stringArray.length) {
                try {
                    this.getXSpreadsheets().removeByName(stringArray[n]);
                }
                catch (Exception exception) {
                    DebugHelper.exception(exception);
                }
                ++n;
            }
        }
        if (string != null) {
            SheetImpl sheetImpl = null;
            try {
                sheetImpl = (SheetImpl)this.sheetNames.getByName(stringArray[0]);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            if (sheetImpl != null) {
                sheetImpl.Activate();
            }
        }
    }

    public void PrintOut(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws BasicErrorException {
        PropertyValue[] propertyValueArray;
        Short s;
        StringBuffer stringBuffer = new StringBuffer("");
        short s2 = -1;
        String string = "";
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        if (!AnyConverter.isVoid((Object)object) && !AnyConverter.isVoid((Object)object2)) {
            try {
                if (AnyConverter.isVoid((Object)object)) {
                    stringBuffer.append("1-");
                } else {
                    stringBuffer.append(Integer.toString(AnyConverter.toInt((Object)object)) + "-");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(969, "From");
            }
            try {
                if (!AnyConverter.isVoid((Object)object2)) {
                    stringBuffer.append(Integer.toString(AnyConverter.toInt((Object)object2)));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(969, "To");
            }
            ++n2;
        }
        try {
            if (!AnyConverter.isVoid((Object)object3)) {
                s = new Short(AnyConverter.toShort((Object)object3));
                s2 = s;
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception(969, "Copies");
        }
        try {
            if (!AnyConverter.isVoid((Object)object4) && AnyConverter.toBoolean((Object)object4)) {
                s = this.getXModel();
                if (s == null) {
                    DebugHelper.exception(new Exception("Failed to get XModel when trying to open print preview"));
                }
                XController xController = s.getCurrentController();
                ApplicationImpl cfr_ignored_0 = (ApplicationImpl)this.Application();
                XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
                XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XDispatchProvider == null ? (class$com$sun$star$frame$XDispatchProvider = SheetsImpl.class$("com.sun.star.frame.XDispatchProvider")) : class$com$sun$star$frame$XDispatchProvider), (Object)xController);
                XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XURLTransformer == null ? (class$com$sun$star$util$XURLTransformer = SheetsImpl.class$("com.sun.star.util.XURLTransformer")) : class$com$sun$star$util$XURLTransformer), (Object)xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer"));
                URL[] uRLArray = new URL[]{new URL()};
                uRLArray[0].Complete = ".uno:PrintPreview";
                xURLTransformer.parseStrict(uRLArray);
                URL uRL = uRLArray[0];
                XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
                if (xDispatch != null) {
                    PropertyValue[] propertyValueArray2 = new PropertyValue[]{};
                    xDispatch.dispatch(uRL, propertyValueArray2);
                }
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        try {
            if (!AnyConverter.isVoid((Object)object5)) {
                string = AnyConverter.toString((Object)object5);
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        try {
            if (!AnyConverter.isVoid((Object)object6) && AnyConverter.toBoolean((Object)object6)) {
                if (AnyConverter.isString((Object)object8)) {
                    string2 = AnyConverter.toString((Object)object8);
                    ++n2;
                } else {
                    DebugHelper.exception((Exception)((Object)new NoSupportException("PrintToFile with no PrToFileName specified is not supported")));
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        try {
            if (!AnyConverter.isVoid((Object)object7)) {
                bl = true;
                bl2 = AnyConverter.toBoolean((Object)object7);
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        s = (XPrintable)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XPrintable == null ? (class$com$sun$star$view$XPrintable = SheetsImpl.class$("com.sun.star.view.XPrintable")) : class$com$sun$star$view$XPrintable), (Object)this.getXModel());
        if (n > 0 && string.length() > 0) {
            propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "Name";
            propertyValueArray[0].Value = string;
            try {
                s.setPrinter(propertyValueArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        }
        if (n2 > 0) {
            int n3 = 0;
            PropertyValue[] propertyValueArray3 = new PropertyValue[n2];
            if (stringBuffer.length() > 0) {
                propertyValueArray3[n3] = new PropertyValue();
                propertyValueArray3[n3].Name = "Pages";
                propertyValueArray3[n3].Value = stringBuffer.toString();
                ++n3;
            }
            if (s2 > -1) {
                propertyValueArray3[n3] = new PropertyValue();
                propertyValueArray3[n3].Name = "CopyCount";
                propertyValueArray3[n3].Value = new Short(s2);
                ++n3;
            }
            if (string2 != null) {
                propertyValueArray3[n3] = new PropertyValue();
                propertyValueArray3[n3].Name = "FileName";
                propertyValueArray3[n3].Value = string2;
                ++n3;
            }
            if (bl) {
                propertyValueArray3[n3] = new PropertyValue();
                propertyValueArray3[n3].Name = "Collate";
                propertyValueArray3[n3].Value = bl2;
                ++n3;
            }
            try {
                s.print(propertyValueArray3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        } else {
            propertyValueArray = new PropertyValue[]{};
            try {
                s.print(propertyValueArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        }
    }

    void addToSelection(String string) throws BasicErrorException {
        XNamed xNamed;
        XSpreadsheets xSpreadsheets = this.getXSpreadsheets();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = SheetsImpl.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess), (Object)xSpreadsheets);
        int n = xIndexAccess.getCount();
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            try {
                xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? SheetsImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed), (Object)xIndexAccess.getByIndex(n3));
                if (xNamed != null && string.equals(xNamed.getName())) {
                    n2 = n3;
                    break;
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        xNamed = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = SheetsImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)this.getXModel().getCurrentController());
        if (xNamed == null) {
            DebugHelper.exception(new Exception("No XSelectionSupplier"));
        }
        Object object = xNamed.getSelection();
        XSheetCellRanges xSheetCellRanges = (XSheetCellRanges)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetCellRanges == null ? (class$com$sun$star$sheet$XSheetCellRanges = SheetsImpl.class$("com.sun.star.sheet.XSheetCellRanges")) : class$com$sun$star$sheet$XSheetCellRanges), (Object)object);
        try {
            XMultiServiceFactory xMultiServiceFactory;
            XCellRangeAddressable xCellRangeAddressable;
            if (xSheetCellRanges == null) {
                XNameContainer xNameContainer;
                xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable == null ? (class$com$sun$star$sheet$XCellRangeAddressable = SheetsImpl.class$("com.sun.star.sheet.XCellRangeAddressable")) : class$com$sun$star$sheet$XCellRangeAddressable), (Object)object);
                if (xCellRangeAddressable == null) {
                    DebugHelper.exception(new Exception("No selection?"));
                }
                if ((xNameContainer = (XNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = SheetsImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer), (Object)(xSheetCellRanges = (XSheetCellRanges)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetCellRanges == null ? (class$com$sun$star$sheet$XSheetCellRanges = SheetsImpl.class$("com.sun.star.sheet.XSheetCellRanges")) : class$com$sun$star$sheet$XSheetCellRanges), (Object)(xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = SheetsImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)this.getXModel())).createInstance("com.sun.star.sheet.SheetCellRanges"))))) == null) {
                    // empty if block
                }
                xNameContainer.insertByName("existing", (Object)xCellRangeAddressable);
            }
            if ((xCellRangeAddressable = (XNameContainer)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameContainer == null ? (class$com$sun$star$container$XNameContainer = SheetsImpl.class$("com.sun.star.container.XNameContainer")) : class$com$sun$star$container$XNameContainer), (Object)xSheetCellRanges)) == null) {
                DebugHelper.exception(new Exception("No XNameContainer for selection?"));
            }
            if ((xMultiServiceFactory = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = SheetsImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)xIndexAccess.getByIndex(n2))) == null) {
                DebugHelper.exception(new Exception("No XCellRange for selection?"));
            }
            xCellRangeAddressable.insertByName("new", (Object)xMultiServiceFactory.getCellByPosition(0, 0));
            xNamed.select((Object)xSheetCellRanges);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private XSpreadsheets getXSpreadsheets() {
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetDocument == null ? (class$com$sun$star$sheet$XSpreadsheetDocument = SheetsImpl.class$("com.sun.star.sheet.XSpreadsheetDocument")) : class$com$sun$star$sheet$XSpreadsheetDocument), (Object)this.getXModel());
        XSpreadsheets xSpreadsheets = xSpreadsheetDocument.getSheets();
        return xSpreadsheets;
    }

    private short getNewIndex(Object object, Object object2) throws BasicErrorException {
        short s;
        XSpreadsheet xSpreadsheet;
        XSheet xSheet;
        short s2 = -1;
        if (!AnyConverter.isVoid((Object)object2) && !AnyConverter.isVoid((Object)object)) {
            DebugHelper.exception(969, "Specify one of Before/After");
        }
        if (!AnyConverter.isVoid((Object)object2)) {
            xSheet = (XSheet)UnoRuntime.queryInterface((Class)(class$com$sun$star$helper$calc$XSheet == null ? (class$com$sun$star$helper$calc$XSheet = SheetsImpl.class$("com.sun.star.helper.calc.XSheet")) : class$com$sun$star$helper$calc$XSheet), (Object)object2);
            if (xSheet == null) {
                DebugHelper.exception(969, "After");
            }
            xSpreadsheet = xSheet.getXSpreadsheet();
            s = this.getSheetIndex(xSpreadsheet);
            s2 = (short)(s + 1);
        }
        if (!AnyConverter.isVoid((Object)object)) {
            xSheet = (XSheet)UnoRuntime.queryInterface((Class)(class$com$sun$star$helper$calc$XSheet == null ? (class$com$sun$star$helper$calc$XSheet = SheetsImpl.class$("com.sun.star.helper.calc.XSheet")) : class$com$sun$star$helper$calc$XSheet), (Object)object);
            if (xSheet == null) {
                DebugHelper.exception(969, "Before");
            }
            xSpreadsheet = xSheet.getXSpreadsheet();
            s2 = s = this.getSheetIndex(xSpreadsheet);
        }
        if (s2 == -1) {
            s2 = this.getActiveSheetIndex();
        }
        return s2;
    }

    private void AddNewToCache(String string, XSpreadsheet xSpreadsheet) throws BasicErrorException {
        try {
            SheetImpl sheetImpl = new SheetImpl(this, xSpreadsheet);
            this.sheetNames.replaceByName(string, sheetImpl);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private XSheet AddByName(short s, short n) throws BasicErrorException {
        SheetImpl sheetImpl = null;
        XSpreadsheets xSpreadsheets = this.getXSpreadsheets();
        XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = SheetsImpl.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess), (Object)xSpreadsheets);
        int n2 = xIndexAccess.getCount();
        short s2 = (short)(n2 + 1);
        int n3 = 0;
        while (n3 < n) {
            String string = "Sheet" + s2;
            while (xSpreadsheets.hasByName(string) && s2 < 32766) {
                s2 = (short)(s2 + 1);
                string = "Sheet" + s2;
            }
            s2 = (short)(s2 + 1);
            xSpreadsheets.insertNewByName(string, s);
            try {
                Object object = xSpreadsheets.getByName(string);
                XSpreadsheet xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheet == null ? SheetsImpl.class$("com.sun.star.sheet.XSpreadsheet") : class$com$sun$star$sheet$XSpreadsheet), (Object)object);
                SheetImpl sheetImpl2 = new SheetImpl(this, xSpreadsheet);
                this.sheetNames.replaceByName(string, sheetImpl2);
                sheetImpl = sheetImpl2;
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
            ++n3;
        }
        return sheetImpl;
    }

    private short getActiveSheetIndex() {
        XSpreadsheetView xSpreadsheetView = (XSpreadsheetView)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheetView == null ? (class$com$sun$star$sheet$XSpreadsheetView = SheetsImpl.class$("com.sun.star.sheet.XSpreadsheetView")) : class$com$sun$star$sheet$XSpreadsheetView), (Object)this.getXModel().getCurrentController());
        return this.getSheetIndex(xSpreadsheetView.getActiveSheet());
    }

    private short getSheetIndex(Object object) {
        XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable == null ? (class$com$sun$star$sheet$XCellRangeAddressable = SheetsImpl.class$("com.sun.star.sheet.XCellRangeAddressable")) : class$com$sun$star$sheet$XCellRangeAddressable), (Object)object);
        return xCellRangeAddressable.getRangeAddress().Sheet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class SheetsCache
    implements XNameContainer,
    XRefreshable {
        private Hashtable cache = new Hashtable();
        private XSpreadsheets xSpreadsheets = null;
        private SheetsImpl parent = null;
        private boolean selected = false;

        public SheetsCache(SheetsImpl sheetsImpl2, XSpreadsheets xSpreadsheets, boolean bl) {
            this.xSpreadsheets = xSpreadsheets;
            this.parent = sheetsImpl2;
            this.selected = bl;
        }

        public Object getByName(String string) throws NoSuchElementException, WrappedTargetException {
            if (this.hasByName(string)) {
                return this.cache.get(string);
            }
            throw new NoSuchElementException("There is no sheet with the name " + string);
        }

        public String[] getElementNames() {
            int n = this.cache.size();
            String[] stringArray = new String[n];
            Enumeration enumeration = this.cache.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray[n2] = (String)enumeration.nextElement();
                ++n2;
            }
            return stringArray;
        }

        public Type getElementType() {
            return new Type(class$com$sun$star$helper$calc$SheetImpl == null ? (class$com$sun$star$helper$calc$SheetImpl = SheetsImpl.class$("com.sun.star.helper.calc.SheetImpl")) : class$com$sun$star$helper$calc$SheetImpl);
        }

        public boolean hasByName(String string) {
            return this.cache.containsKey(string);
        }

        public boolean hasElements() {
            return this.cache.size() > 0;
        }

        public void addRefreshListener(XRefreshListener xRefreshListener) {
        }

        protected String[] getSheetNames() throws BasicErrorException {
            String[] stringArray = null;
            if (this.selected) {
                short[] sArray = this.getSelectedSheets();
                stringArray = new String[sArray.length];
                int n = 0;
                while (n < sArray.length) {
                    XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XIndexAccess == null ? SheetsImpl.class$("com.sun.star.container.XIndexAccess") : class$com$sun$star$container$XIndexAccess), (Object)this.xSpreadsheets);
                    if (xIndexAccess == null) {
                        // empty if block
                    }
                    try {
                        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? SheetsImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed), (Object)xIndexAccess.getByIndex((int)sArray[n]));
                        if (xNamed == null) {
                            // empty if block
                        }
                        stringArray[n] = xNamed.getName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
            } else {
                stringArray = this.xSpreadsheets.getElementNames();
            }
            return stringArray;
        }

        public short[] getSelectedSheets() throws BasicErrorException {
            Object object;
            XSheetCellRanges xSheetCellRanges;
            short[] sArray = null;
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = SheetsImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)SheetsImpl.this.getXModel().getCurrentController());
            if (xSelectionSupplier == null) {
                DebugHelper.exception(new Exception("No XSelectionSupplier"));
            }
            if ((xSheetCellRanges = (XSheetCellRanges)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetCellRanges == null ? (class$com$sun$star$sheet$XSheetCellRanges = SheetsImpl.class$("com.sun.star.sheet.XSheetCellRanges")) : class$com$sun$star$sheet$XSheetCellRanges), (Object)(object = xSelectionSupplier.getSelection()))) != null) {
                CellRangeAddress[] cellRangeAddressArray = xSheetCellRanges.getRangeAddresses();
                Vector<Short> vector = new Vector<Short>();
                int n = 0;
                while (n < cellRangeAddressArray.length) {
                    Short s = new Short(cellRangeAddressArray[n].Sheet);
                    if (vector.indexOf(s) == -1) {
                        vector.add(s);
                    }
                    ++n;
                }
                sArray = new short[vector.size()];
                int n2 = 0;
                while (n2 < vector.size()) {
                    sArray[n2] = (Short)vector.elementAt(n2);
                    ++n2;
                }
            } else {
                XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable == null ? (class$com$sun$star$sheet$XCellRangeAddressable = SheetsImpl.class$("com.sun.star.sheet.XCellRangeAddressable")) : class$com$sun$star$sheet$XCellRangeAddressable), (Object)object);
                if (xCellRangeAddressable != null) {
                    CellRangeAddress cellRangeAddress = xCellRangeAddressable.getRangeAddress();
                    sArray = new short[]{cellRangeAddress.Sheet};
                } else {
                    DebugHelper.exception(new Exception("Unknown selection type"));
                }
            }
            return sArray;
        }

        public void refresh() {
            try {
                String[] stringArray = this.getSheetNames();
                int n = 0;
                while (n < stringArray.length) {
                    if (!this.cache.containsKey(stringArray[n])) {
                        this.cache.put(stringArray[n], new SheetImpl(this.parent, (XSpreadsheet)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSpreadsheet == null ? SheetsImpl.class$("com.sun.star.sheet.XSpreadsheet") : class$com$sun$star$sheet$XSpreadsheet), (Object)this.xSpreadsheets.getByName(stringArray[n]))));
                    }
                    ++n;
                }
            }
            catch (Exception exception) {}
        }

        public void removeRefreshListener(XRefreshListener xRefreshListener) {
        }

        public void insertByName(String string, Object object) throws IllegalArgumentException, ElementExistException, WrappedTargetException {
            this.cache.put(string, object);
        }

        public void removeByName(String string) throws NoSuchElementException, WrappedTargetException {
            this.cache.remove(string);
        }

        public void replaceByName(String string, Object object) throws IllegalArgumentException, NoSuchElementException, WrappedTargetException {
            if (this.hasByName(string)) {
                this.cache.remove(string);
            }
            this.cache.put(string, object);
        }
    }
}

