/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.QueryTableDescriptor;
import com.sun.star.helper.calc.QueryTableType;
import com.sun.star.helper.calc.XQueryTable;
import com.sun.star.helper.calc.XQueryTables;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.StringHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.lang.XComponent;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.DataImportMode;
import com.sun.star.sheet.SheetLinkMode;
import com.sun.star.sheet.XAreaLinks;
import com.sun.star.sheet.XSheetLinkable;
import com.sun.star.ui.dialogs.XExecutableDialog;
import com.sun.star.ui.dialogs.XFilePicker;
import com.sun.star.ui.dialogs.XFilterManager;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XImportable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class QueryTableImpl
extends HelperInterfaceAdaptor
implements XQueryTable,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.QueryTable";
    static final int XlTextParsingType_xlDelimited = 1;
    static final int XlTextParsingType_xlFixedWidth = 2;
    static final int xlColumnDataType_xlYMDFormat = 5;
    static final int xlColumnDataType_xlYDMFormat = 8;
    static final int xlColumnDataType_xlMYDFormat = 6;
    static final int xlColumnDataType_xlMDYFormat = 3;
    static final int xlColumnDataType_xlEMDFormat = 10;
    static final int xlColumnDataType_xlDYMFormat = 7;
    static final int xlColumnDataType_xlDMYFormat = 4;
    static final int xlColumnDataType_xlSkipColumn = 9;
    static final int xlColumnDataType_xlTextFormat = 2;
    static final int xlColumnDataType_xlGeneralFormat = 1;
    static final int XlPlatform_xlWindows = 2;
    static final int XlPlatform_xlMSDOS = 3;
    static final int XlPlatform_xlMacintosh = 1;
    static final int XlTextQualifier_xlTextQualifierSingleQuote = 2;
    static final int XlTextQualifier_xlTextQualifierDoubleQuote = 1;
    static final int XlTextQualifier_xlTextQualifierNone = -4142;
    QueryTableDescriptor desc;
    XComponent xComponent;
    XQueryTables parent;
    boolean m_TextFileCommaDelimiter = false;
    boolean m_TextFileTabDelimiter = false;
    boolean m_TextFileConsecutiveDelimiter = false;
    boolean m_TextFileSemicolonDelimiter = false;
    boolean m_TextFileSpaceDelimiter = false;
    int m_TextFileParseType = 1;
    int m_TextFileTextQualifier = 1;
    int m_TextFilePlatform = 3;
    int m_TextFileStartRow = 1;
    int[] m_TextFileColumnDataTypes = new int[]{1, 1};
    boolean m_TextFilePromptOnRefresh = false;
    static /* synthetic */ Class class$com$sun$star$sheet$XAreaLinks;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetLinkable;
    static /* synthetic */ Class class$com$sun$star$util$XImportable;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XExecutableDialog;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XFilePicker;
    static /* synthetic */ Class class$com$sun$star$ui$dialogs$XFilterManager;

    public QueryTableImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, QueryTableDescriptor queryTableDescriptor, XComponent xComponent) {
        super(__serviceName, helperInterfaceAdaptor);
        this.parent = (XQueryTables)((Object)helperInterfaceAdaptor);
        this.desc = queryTableDescriptor;
        this.xComponent = xComponent;
    }

    public void refresh(Object object) {
        if (this.desc.Type == QueryTableType.WEB) {
            this.refresh_web();
        } else if (this.desc.Type == QueryTableType.FILE) {
            this.refresh_file();
        }
        if (this.desc.Type == QueryTableType.DATABASE) {
            this.refresh_db();
        }
    }

    private void refresh_web() {
        XAreaLinks xAreaLinks = (XAreaLinks)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XAreaLinks == null ? (class$com$sun$star$sheet$XAreaLinks = QueryTableImpl.class$("com.sun.star.sheet.XAreaLinks")) : class$com$sun$star$sheet$XAreaLinks), (Object)this.desc.UnoInterface);
        xAreaLinks.insertAtPosition(this.desc.Destination, this.desc.link, "html_all", "calc_HTML_WebQuery", "");
    }

    private void refresh_file() {
        if (this.m_TextFilePromptOnRefresh) {
            this.desc.link = this.getFileForTextQuery(this.desc.link);
        }
        XSheetLinkable xSheetLinkable = (XSheetLinkable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetLinkable == null ? (class$com$sun$star$sheet$XSheetLinkable = QueryTableImpl.class$("com.sun.star.sheet.XSheetLinkable")) : class$com$sun$star$sheet$XSheetLinkable), (Object)this.desc.UnoInterface);
        DebugHelper.writeInfo("refreshing file query");
        String string = QueryTableImpl.encodeFilename(HelperUtilities.getURLForFileName(this.desc.link));
        DebugHelper.writeInfo("\tLink " + string);
        DebugHelper.writeInfo("\tOptions " + this.getFilterOptions());
        xSheetLinkable.link(string, "", "Text - txt - csv (StarCalc)", this.getFilterOptions(), SheetLinkMode.NORMAL);
    }

    private void refresh_db() {
        PropertyValue[] propertyValueArray = new PropertyValue[4];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "DatabaseName";
        propertyValueArray[0].Value = this.desc.link;
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "SourceType";
        propertyValueArray[1].Value = DataImportMode.SQL;
        propertyValueArray[2] = new PropertyValue();
        propertyValueArray[2].Name = "SourceObject";
        propertyValueArray[2].Value = this.desc.sql;
        propertyValueArray[3] = new PropertyValue();
        propertyValueArray[3].Name = "IsNative";
        propertyValueArray[3].Value = Boolean.TRUE;
        XImportable xImportable = (XImportable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XImportable == null ? (class$com$sun$star$util$XImportable = QueryTableImpl.class$("com.sun.star.util.XImportable")) : class$com$sun$star$util$XImportable), (Object)this.desc.UnoInterface);
        xImportable.doImport(propertyValueArray);
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = QueryTableImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xComponent);
            Object object = xPropertySet.getPropertyValue("DatabaseRanges");
            XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = QueryTableImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)object);
            String[] stringArray = xNameAccess.getElementNames();
            AnyConverter anyConverter = new AnyConverter();
            int n = 0;
            while (n < stringArray.length) {
                Object object2 = xNameAccess.getByName(stringArray[n]);
                XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? QueryTableImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet), (Object)object2);
                boolean bl = AnyConverter.toBoolean((Object)xPropertySet2.getPropertyValue("IsUserDefined"));
                if (!bl) {
                    XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? QueryTableImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed), (Object)object2);
                    xNamed.setName("external_" + this.desc.link);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    private String getFilterOptions() {
        return this.getFieldSeparator() + "," + this.getTextDelimiter() + "," + this.getCharSet() + "," + this.m_TextFileStartRow + "," + this.getFormatCodes();
    }

    private String getFormatCodes() {
        String string = "";
        int n = 0;
        while (n < this.m_TextFileColumnDataTypes.length) {
            string = string + (n + 1) + "/" + this.transform(this.m_TextFileColumnDataTypes[n]) + "/";
            ++n;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private int transform(int n) {
        int n2 = 1;
        if (n == 1) {
            n2 = 1;
        } else if (n == 2) {
            n2 = 2;
        } else if (n == 9) {
            n2 = 9;
        } else if (n == 4) {
            n2 = 4;
        } else if (n == 7) {
            n2 = 1;
        } else if (n == 10) {
            n2 = 1;
        } else if (n == 3) {
            n2 = 3;
        } else if (n == 6) {
            n2 = 1;
        } else if (n == 8) {
            n2 = 1;
        } else if (n == 5) {
            n2 = 5;
        }
        return n2;
    }

    private String getCharSet() {
        String string = "0";
        if (this.m_TextFilePlatform == 3) {
            string = "25";
        } else if (this.m_TextFilePlatform == 1) {
            string = "42";
        } else if (this.m_TextFilePlatform == 2) {
            string = "1";
        }
        return string;
    }

    private String getTextDelimiter() {
        String string = "";
        if (this.m_TextFileTextQualifier == 1) {
            string = "34";
        } else if (this.m_TextFileTextQualifier == 2) {
            string = "39";
        }
        return string;
    }

    private String getFieldSeparator() {
        if (this.m_TextFileParseType == 2) {
            return "FIX";
        }
        String string = "";
        if (this.m_TextFileCommaDelimiter) {
            string = "44/";
        }
        if (this.m_TextFileSemicolonDelimiter) {
            string = string + "59/";
        }
        if (this.m_TextFileTabDelimiter) {
            string = string + "9/";
        }
        if (this.m_TextFileSpaceDelimiter) {
            string = string + "32/";
        }
        if (this.m_TextFileConsecutiveDelimiter) {
            string = string + "MSG";
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getFileForTextQuery(String string) {
        String string2 = string;
        Object object = null;
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        try {
            object = ApplicationImpl.getXMultiServiceFactory().createInstance("com.sun.star.ui.dialogs.FilePicker");
            XExecutableDialog xExecutableDialog = (XExecutableDialog)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XExecutableDialog == null ? (class$com$sun$star$ui$dialogs$XExecutableDialog = QueryTableImpl.class$("com.sun.star.ui.dialogs.XExecutableDialog")) : class$com$sun$star$ui$dialogs$XExecutableDialog), (Object)object);
            xExecutableDialog.setTitle("Choose a file for the QueryTable");
            XFilePicker xFilePicker = (XFilePicker)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XFilePicker == null ? (class$com$sun$star$ui$dialogs$XFilePicker = QueryTableImpl.class$("com.sun.star.ui.dialogs.XFilePicker")) : class$com$sun$star$ui$dialogs$XFilePicker), (Object)object);
            xFilePicker.setDisplayDirectory(string3);
            xFilePicker.setDefaultName(string4);
            XFilterManager xFilterManager = (XFilterManager)UnoRuntime.queryInterface((Class)(class$com$sun$star$ui$dialogs$XFilterManager == null ? (class$com$sun$star$ui$dialogs$XFilterManager = QueryTableImpl.class$("com.sun.star.ui.dialogs.XFilterManager")) : class$com$sun$star$ui$dialogs$XFilterManager), (Object)object);
            xFilterManager.appendFilter("Text CSV (*.txt;*.csv)", "*.csv;*.txt");
            xFilterManager.appendFilter("All files", "*.*");
            xExecutableDialog.execute();
            if (xFilePicker.getFiles().length > 0) {
                string2 = CommonUtilities.getSystemPathFromURL(xFilePicker.getFiles()[0]);
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        return string2;
    }

    public int[] getTextFileColumnDataTypes() {
        return this.m_TextFileColumnDataTypes;
    }

    public boolean getTextFileCommaDelimiter() {
        return this.m_TextFileCommaDelimiter;
    }

    public boolean getTextFileConsecutiveDelimiter() {
        return this.m_TextFileConsecutiveDelimiter;
    }

    public int getTextFileParseType() {
        return this.m_TextFileParseType;
    }

    public int getTextFilePlatform() {
        return this.m_TextFilePlatform;
    }

    public boolean getTextFilePromptOnRefresh() {
        return this.m_TextFilePromptOnRefresh;
    }

    public boolean getTextFileSemicolonDelimiter() {
        return this.m_TextFileSemicolonDelimiter;
    }

    public boolean getTextFileSpaceDelimiter() {
        return this.m_TextFileSpaceDelimiter;
    }

    public int getTextFileStartRow() {
        return this.m_TextFileStartRow;
    }

    public boolean getTextFileTabDelimiter() {
        return this.m_TextFileTabDelimiter;
    }

    public int getTextFileTextQualifier() {
        return this.m_TextFileTextQualifier;
    }

    public void setTextFileColumnDataTypes(int[] nArray) {
        this.m_TextFileColumnDataTypes = nArray;
    }

    public void setTextFileCommaDelimiter(boolean bl) {
        this.m_TextFileCommaDelimiter = bl;
    }

    public void setTextFileConsecutiveDelimiter(boolean bl) {
        this.m_TextFileConsecutiveDelimiter = bl;
    }

    public void setTextFileParseType(int n) {
        this.m_TextFileParseType = n;
    }

    public void setTextFilePlatform(int n) {
        this.m_TextFilePlatform = n;
    }

    public void setTextFilePromptOnRefresh(boolean bl) {
        this.m_TextFilePromptOnRefresh = bl;
    }

    public void setTextFileSemicolonDelimiter(boolean bl) {
        this.m_TextFileSemicolonDelimiter = bl;
    }

    public void setTextFileSpaceDelimiter(boolean bl) {
        this.m_TextFileSpaceDelimiter = bl;
    }

    public void setTextFileStartRow(int n) {
        this.m_TextFileStartRow = n;
    }

    public void setTextFileTabDelimiter(boolean bl) {
        this.m_TextFileTabDelimiter = bl;
    }

    public void setTextFileTextQualifier(int n) {
        this.m_TextFileTextQualifier = n;
    }

    private static String encodeFilename(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string;
        }
        string2 = StringHelper.replaceAll13(string2, "+", "%20");
        string2 = StringHelper.replaceAll13(string2, "%2F", "/");
        string2 = StringHelper.replaceAll13(string2, "%3A", ":");
        string2 = StringHelper.replaceAll13(string2, "%5C", "\\");
        return string2;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xComponent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

