/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.awt.Size;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;

public class PaperFormat {
    private static final Size a_3 = new Size(29700, 42000);
    private static final Size a_4 = new Size(21000, 29700);
    private static final Size a_5 = new Size(14800, 21000);
    private static final Size b_4_iso = new Size(25000, 35300);
    private static final Size b_5_iso = new Size(17600, 25000);
    private static final Size b_6_iso = new Size(12500, 17600);
    private static final Size b_4_jis = new Size(25700, 36400);
    private static final Size b_5_jis = new Size(18200, 25700);
    private static final Size b_6_jis = new Size(12800, 18200);
    private static final Size tabloid = new Size(27960, 43130);
    private static final Size letter = new Size(21590, 27940);
    private static final Size legal = new Size(21590, 35570);
    private static final Size dl = new Size(11000, 22000);
    private static final Size envMonarch = new Size(98400, 19050);
    private static final Size env9 = new Size(98400, 22540);
    private static final Size env10 = new Size(10480, 24130);
    private static final Size env11 = new Size(11430, 26350);
    private static final Size env12 = new Size(12070, 27940);
    private static final Size c_65 = new Size(11400, 22700);
    private static final Size c_4 = new Size(22900, 32400);
    private static final Size c_5 = new Size(16200, 22900);
    private static final Size c_6 = new Size(11400, 16200);
    private static final Size size11x17 = new Size(11000, 17000);
    private static final Size size10x14 = new Size(10000, 14000);
    private static final int tolerance = 4;

    private PaperFormat() {
    }

    public static Size getSizeForFormat(int n) throws IllegalArgumentException, NoSupportException {
        Size size = null;
        switch (n) {
            case 1: {
                size = letter;
                break;
            }
            case 3: {
                size = tabloid;
                break;
            }
            case 5: {
                size = legal;
                break;
            }
            case 8: {
                size = a_3;
                break;
            }
            case 9: {
                size = a_4;
                break;
            }
            case 11: {
                size = a_5;
                break;
            }
            case 12: {
                size = b_4_iso;
                break;
            }
            case 13: {
                size = b_5_iso;
                break;
            }
            case 19: {
                size = env9;
                break;
            }
            case 20: {
                size = env10;
                break;
            }
            case 21: {
                size = env11;
                break;
            }
            case 22: {
                size = env12;
                break;
            }
            case 37: {
                size = envMonarch;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                throw new NoSupportException("Paper type not supported by StarOffice");
            }
            default: {
                throw new IllegalArgumentException("Unknown paper format: " + n);
            }
        }
        return size;
    }

    public static int getFormatForSize(Size size) {
        int n = 256;
        if (size == null) {
            return n;
        }
        if (Math.abs(size.Height - PaperFormat.letter.Height) < 4 && Math.abs(size.Width - PaperFormat.letter.Width) < 4) {
            n = 1;
        } else if (Math.abs(size.Height - PaperFormat.tabloid.Height) < 4 && Math.abs(size.Width - PaperFormat.tabloid.Width) < 4) {
            n = 3;
        } else if (Math.abs(size.Height - PaperFormat.legal.Height) < 4 && Math.abs(size.Width - PaperFormat.legal.Width) < 4) {
            n = 5;
        } else if (Math.abs(size.Height - PaperFormat.a_3.Height) < 4 && Math.abs(size.Width - PaperFormat.a_3.Width) < 4) {
            n = 8;
        } else if (Math.abs(size.Height - PaperFormat.a_4.Height) < 4 && Math.abs(size.Width - PaperFormat.a_4.Width) < 4) {
            n = 9;
        } else if (Math.abs(size.Height - PaperFormat.a_5.Height) < 4 && Math.abs(size.Width - PaperFormat.a_5.Width) < 4) {
            n = 11;
        } else if (Math.abs(size.Height - PaperFormat.b_4_iso.Height) < 4 && Math.abs(size.Width - PaperFormat.b_4_iso.Width) < 4) {
            n = 12;
        } else if (Math.abs(size.Height - PaperFormat.b_5_iso.Height) < 4 && Math.abs(size.Width - PaperFormat.b_5_iso.Width) < 4) {
            n = 13;
        } else if (Math.abs(size.Height - PaperFormat.env9.Height) < 4 && Math.abs(size.Width - PaperFormat.env9.Width) < 4) {
            n = 19;
        } else if (Math.abs(size.Height - PaperFormat.env10.Height) < 4 && Math.abs(size.Width - PaperFormat.env10.Width) < 4) {
            n = 20;
        } else if (Math.abs(size.Height - PaperFormat.env11.Height) < 4 && Math.abs(size.Width - PaperFormat.env11.Width) < 4) {
            n = 21;
        } else if (Math.abs(size.Height - PaperFormat.env12.Height) < 4 && Math.abs(size.Width - PaperFormat.env12.Width) < 4) {
            n = 22;
        } else if (Math.abs(size.Height - PaperFormat.envMonarch.Height) < 4 && Math.abs(size.Width - PaperFormat.envMonarch.Width) < 4) {
            n = 37;
        }
        return n;
    }
}

