/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.awt.Size;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.CalcUtilities;
import com.sun.star.helper.calc.PaperFormat;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.XPageSetup;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.range.RangeHelperImpl;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XCellRangeAddressable;
import com.sun.star.sheet.XHeaderFooterContent;
import com.sun.star.sheet.XPrintAreas;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XText;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import java.util.StringTokenizer;

public class PageSetupImpl
extends HelperInterfaceAdaptor
implements XPageSetup,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.PageSetup";
    private static final int LETTERS_IN_ALPHABET = 26;
    private static final int ASCII_OFFSET = 64;
    private static final int ZOOM_MIN = 10;
    private static final int ZOOM_MAX = 400;
    XSheet parent;
    XPropertySet xProps;
    String styleName;
    XStyleFamiliesSupplier xStyleFamiliesSup;
    XNameAccess xStyleFamilies;
    XNameAccess xPagestyle;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$style$XStyleFamiliesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$sheet$XPrintAreas;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellRangeAddressable;
    static /* synthetic */ Class class$com$sun$star$sheet$XHeaderFooterContent;

    public PageSetupImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XSpreadsheet xSpreadsheet) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        this.parent = (XSheet)((Object)helperInterfaceAdaptor);
        if (this.parent == null || xSpreadsheet == null) {
            DebugHelper.exception(new Exception("parent object or xSheet object in ctor is null."));
        }
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = PageSetupImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xSpreadsheet);
        this.styleName = "";
        try {
            this.styleName = (String)xPropertySet.getPropertyValue("PageStyle");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        try {
            this.xStyleFamiliesSup = (XStyleFamiliesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$style$XStyleFamiliesSupplier == null ? (class$com$sun$star$style$XStyleFamiliesSupplier = PageSetupImpl.class$("com.sun.star.style.XStyleFamiliesSupplier")) : class$com$sun$star$style$XStyleFamiliesSupplier), (Object)this.getXModel());
            if (this.xStyleFamiliesSup == null) {
                throw new Exception("Couldn't get document XStyleFamiliesSupplier");
            }
            this.xStyleFamilies = this.xStyleFamiliesSup.getStyleFamilies();
            if (this.xStyleFamilies == null) {
                throw new Exception("Couldn't get document XStyleFamiliesSupplier");
            }
            this.xPagestyle = (XNameAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = PageSetupImpl.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess), (Object)this.xStyleFamilies.getByName("PageStyles"));
            if (this.xStyleFamilies == null) {
                throw new Exception("Couldn't get document PageStyles");
            }
            this.xProps = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = PageSetupImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.xPagestyle.getByName(this.styleName));
            if (this.xProps == null) {
                throw new Exception("Couldn't get document PageStyles");
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getPrintArea() {
        String string = "";
        XPrintAreas xPrintAreas = (XPrintAreas)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XPrintAreas == null ? (class$com$sun$star$sheet$XPrintAreas = PageSetupImpl.class$("com.sun.star.sheet.XPrintAreas")) : class$com$sun$star$sheet$XPrintAreas), (Object)this.parent.getXSpreadsheet());
        boolean bl = false;
        CellRangeAddress[] cellRangeAddressArray = xPrintAreas.getPrintAreas();
        int n = 0;
        while (n < cellRangeAddressArray.length) {
            String string2 = "$" + PageSetupImpl.getStringForNumber(cellRangeAddressArray[n].StartColumn + 1);
            int n2 = cellRangeAddressArray[n].StartRow + 1;
            String string3 = "$" + PageSetupImpl.getStringForNumber(cellRangeAddressArray[n].EndColumn + 1);
            int n3 = cellRangeAddressArray[n].EndRow + 1;
            if (bl) {
                string = string + ",";
            }
            string = string + string2 + "$" + n2 + ":" + string3 + "$" + n3;
            bl = true;
            ++n;
        }
        return string;
    }

    public void setPrintArea(String string) throws BasicErrorException {
        XPrintAreas xPrintAreas = (XPrintAreas)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XPrintAreas == null ? (class$com$sun$star$sheet$XPrintAreas = PageSetupImpl.class$("com.sun.star.sheet.XPrintAreas")) : class$com$sun$star$sheet$XPrintAreas), (Object)this.parent.getXSpreadsheet());
        XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = PageSetupImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)this.parent.getXSpreadsheet());
        String string2 = "";
        try {
            string2 = AnyConverter.toString((Object)string);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            XCellRange xCellRange2 = xCellRange.getCellRangeByName(stringTokenizer.nextToken());
            XCellRangeAddressable xCellRangeAddressable = (XCellRangeAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellRangeAddressable == null ? PageSetupImpl.class$("com.sun.star.sheet.XCellRangeAddressable") : class$com$sun$star$sheet$XCellRangeAddressable), (Object)xCellRange2);
            cellRangeAddressArray[n] = xCellRangeAddressable.getRangeAddress();
            ++n;
        }
        xPrintAreas.setPrintAreas(cellRangeAddressArray);
    }

    public void setTopMargin(double d) throws BasicErrorException {
        int n = CalcUtilities.pointsToHundredthsMillimeter(d);
        boolean bl = false;
        int n2 = 0;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("HeaderIsOn"));
            if (bl) {
                n2 = (Integer)this.xProps.getPropertyValue("HeaderHeight");
                n -= n2;
            }
            this.xProps.setPropertyValue("TopMargin", (Object)new Integer(n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getTopMargin() throws BasicErrorException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("HeaderIsOn"));
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("TopMargin"));
            if (bl) {
                n2 = (Integer)this.xProps.getPropertyValue("HeaderHeight");
                n += n2;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return CalcUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setBottomMargin(double d) throws BasicErrorException {
        int n = CalcUtilities.pointsToHundredthsMillimeter(d);
        boolean bl = false;
        int n2 = 0;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("FooterIsOn"));
            if (bl) {
                n2 = AnyConverter.toInt((Object)this.xProps.getPropertyValue("FooterHeight"));
                n -= n2;
            }
            this.xProps.setPropertyValue("BottomMargin", (Object)new Integer(n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getBottomMargin() throws BasicErrorException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("FooterIsOn"));
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("BottomMargin"));
            if (bl) {
                n2 = AnyConverter.toInt((Object)this.xProps.getPropertyValue("FooterHeight"));
                n += n2;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return CalcUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setHeaderMargin(double d) throws BasicErrorException {
        int n = CalcUtilities.pointsToHundredthsMillimeter(d);
        try {
            this.xProps.setPropertyValue("TopMargin", (Object)new Integer(n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getHeaderMargin() throws BasicErrorException {
        int n = 0;
        try {
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("TopMargin"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return CalcUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setFooterMargin(double d) throws BasicErrorException {
        int n = CalcUtilities.pointsToHundredthsMillimeter(d);
        try {
            this.xProps.setPropertyValue("BottomMargin", (Object)new Integer(n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getFooterMargin() throws BasicErrorException {
        int n = 0;
        try {
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("BottomMargin"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return CalcUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setRightMargin(double d) throws BasicErrorException {
        int n = CalcUtilities.pointsToHundredthsMillimeter(d);
        try {
            this.xProps.setPropertyValue("RightMargin", (Object)new Integer(n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getRightMargin() throws BasicErrorException {
        int n = 0;
        try {
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("RightMargin"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return CalcUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setLeftMargin(double d) throws BasicErrorException {
        int n = CalcUtilities.pointsToHundredthsMillimeter(d);
        try {
            this.xProps.setPropertyValue("LeftMargin", (Object)new Integer(n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getLeftMargin() throws BasicErrorException {
        int n = 0;
        try {
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("LeftMargin"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return CalcUtilities.hundredthsMillimeterToPoints(n);
    }

    public void setOrientation(int n) throws BasicErrorException {
        if (n != 2 && n != 1) {
            DebugHelper.exception(969, "Orientation: orientation must be one of: xlLandscape, xlPortrait.");
        }
        try {
            boolean bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("IsLandscape"));
            boolean bl2 = false;
            if (bl && n != 2 || !bl && n != 1) {
                bl2 = true;
            }
            if (bl2) {
                this.xProps.setPropertyValue("IsLandscape", (Object)(!bl ? 1 : 0));
                Integer n2 = (Integer)this.xProps.getPropertyValue("Width");
                Integer n3 = (Integer)this.xProps.getPropertyValue("Height");
                this.xProps.setPropertyValue("Width", (Object)n3);
                this.xProps.setPropertyValue("Height", (Object)n2);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getOrientation() throws BasicErrorException {
        int n = 1;
        try {
            boolean bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("IsLandscape"));
            if (bl) {
                n = 2;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public Object getFitToPagesTall() throws BasicErrorException {
        short s = 0;
        try {
            s = AnyConverter.toShort((Object)this.xProps.getPropertyValue("ScaleToPagesY"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (s == 0) {
            return Boolean.FALSE;
        }
        return new Short(s);
    }

    public void setFitToPagesTall(Object object) throws BasicErrorException {
        Short s = new Short(0);
        try {
            s = AnyConverter.isBoolean((Object)object) && !AnyConverter.toBoolean((Object)object) ? new Short(0) : new Short(AnyConverter.toShort((Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        try {
            this.xProps.setPropertyValue("ScaleToPagesY", (Object)s);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public Object getFitToPagesWide() throws BasicErrorException {
        short s = 0;
        try {
            s = AnyConverter.toShort((Object)this.xProps.getPropertyValue("ScaleToPagesX"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (s == 0) {
            return Boolean.FALSE;
        }
        return new Short(s);
    }

    public void setFitToPagesWide(Object object) throws BasicErrorException {
        Short s = new Short(0);
        try {
            s = AnyConverter.isBoolean((Object)object) && !AnyConverter.toBoolean((Object)object) ? new Short(0) : new Short(AnyConverter.toShort((Object)object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        try {
            this.xProps.setPropertyValue("ScaleToPagesX", (Object)s);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public Object getZoom() throws BasicErrorException {
        short s = 0;
        try {
            s = (Short)this.xProps.getPropertyValue("PageScale");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (s == 0) {
            return Boolean.FALSE;
        }
        return new Short(s);
    }

    public void setZoom(Object object) throws BasicErrorException {
        Short s = new Short(0);
        if (AnyConverter.isBoolean((Object)object)) {
            try {
                if (AnyConverter.toBoolean((Object)object)) {
                    DebugHelper.exception(969, "Zoom(false,10-400)");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(969, "Zoom(false,10-400)");
            }
        } else {
            try {
                s = new Short(AnyConverter.toShort((Object)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(969, "Zoom(false,10-400)");
            }
            if (s < 10 || s > 400) {
                DebugHelper.exception(969, "Zoom(10-400)");
            }
        }
        try {
            this.xProps.setPropertyValue("ScaleToPages", (Object)new Short(0));
            this.xProps.setPropertyValue("ScaleToPagesX", (Object)new Short(0));
            this.xProps.setPropertyValue("ScaleToPagesY", (Object)new Short(0));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            if (s.intValue() == 0) {
                DebugHelper.exception((Exception)((Object)unknownPropertyException));
            } else {
                DebugHelper.writeInfo("Error when setting properties: ScaleToPages, ScaleToPagesX, ScaleToPagesY. These are only available in StarOffice 8 or later.");
            }
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("Error when setting properties: ScaleToPages, ScaleToPagesX, ScaleToPagesY.");
        }
        try {
            this.xProps.setPropertyValue("PageScale", (Object)s);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getLeftHeader() throws BasicErrorException {
        String string = "";
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageHeaderContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getLeftText();
                string = xText.getString();
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setLeftHeader(String string) throws BasicErrorException {
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageHeaderContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getLeftText();
                xText.setString(string);
                this.xProps.setPropertyValue("RightPageHeaderContent", (Object)xHeaderFooterContent);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getCenterHeader() throws BasicErrorException {
        String string = "";
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageHeaderContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getCenterText();
                string = xText.getString();
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setCenterHeader(String string) throws BasicErrorException {
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageHeaderContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getCenterText();
                xText.setString(string);
                this.xProps.setPropertyValue("RightPageHeaderContent", (Object)xHeaderFooterContent);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getRightHeader() throws BasicErrorException {
        String string = "";
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageHeaderContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getRightText();
                string = xText.getString();
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setRightHeader(String string) throws BasicErrorException {
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageHeaderContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getRightText();
                xText.setString(string);
                this.xProps.setPropertyValue("RightPageHeaderContent", (Object)xHeaderFooterContent);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getLeftFooter() throws BasicErrorException {
        String string = "";
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageFooterContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getLeftText();
                string = xText.getString();
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setLeftFooter(String string) throws BasicErrorException {
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageFooterContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getLeftText();
                xText.setString(string);
                this.xProps.setPropertyValue("RightPageFooterContent", (Object)xHeaderFooterContent);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getCenterFooter() throws BasicErrorException {
        String string = "";
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageFooterContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getCenterText();
                string = xText.getString();
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setCenterFooter(String string) throws BasicErrorException {
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageFooterContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getCenterText();
                xText.setString(string);
                this.xProps.setPropertyValue("RightPageFooterContent", (Object)xHeaderFooterContent);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getRightFooter() throws BasicErrorException {
        String string = "";
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageFooterContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getRightText();
                string = xText.getString();
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setRightFooter(String string) throws BasicErrorException {
        try {
            XHeaderFooterContent xHeaderFooterContent = (XHeaderFooterContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XHeaderFooterContent == null ? (class$com$sun$star$sheet$XHeaderFooterContent = PageSetupImpl.class$("com.sun.star.sheet.XHeaderFooterContent")) : class$com$sun$star$sheet$XHeaderFooterContent), (Object)this.xProps.getPropertyValue("RightPageFooterContent"));
            if (xHeaderFooterContent != null) {
                XText xText = xHeaderFooterContent.getRightText();
                xText.setString(string);
                this.xProps.setPropertyValue("RightPageFooterContent", (Object)xHeaderFooterContent);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void setPaperSize(int n) throws BasicErrorException {
        Size size = null;
        try {
            size = PaperFormat.getSizeForFormat(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception(969, "PaperSize unknown.");
        }
        catch (NoSupportException noSupportException) {
            DebugHelper.exception(969, "PaperSize not supported.");
        }
        if (size != null) {
            try {
                this.xProps.setPropertyValue("Size", (Object)size);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        } else {
            DebugHelper.exception(51, "Error setting property: PaperSize. This paperformat is unknown or not available.");
        }
    }

    public int getPaperSize() throws BasicErrorException {
        Size size = null;
        try {
            size = (Size)this.xProps.getPropertyValue("Size");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        int n = PaperFormat.getFormatForSize(size);
        return n;
    }

    public int getOrder() throws BasicErrorException {
        int n = 1;
        try {
            if (!AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("PrintDownFirst"))) {
                n = 2;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public void setOrder(int n) throws BasicErrorException {
        boolean bl = true;
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                DebugHelper.exception(969, "Order. Must be one of xlDownThenOver, xlOverThenDown.");
            }
        }
        try {
            this.xProps.setPropertyValue("PrintDownFirst", (Object)bl);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getFirstPageNumber() throws BasicErrorException {
        int n = 0;
        try {
            n = AnyConverter.toInt((Object)this.xProps.getPropertyValue("FirstPageNumber"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (n == 0) {
            n = -4105;
        }
        return n;
    }

    public void setFirstPageNumber(int n) throws BasicErrorException {
        if (n < 0) {
            DebugHelper.exception(969, "FirstPageNumber.");
        }
        if (n == -4105) {
            n = 0;
        }
        try {
            this.xProps.setPropertyValue("FirstPageNumber", (Object)new Short((short)n));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getCenterVertically() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("CenterVertically"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return bl;
    }

    public void setCenterVertically(boolean bl) throws BasicErrorException {
        try {
            this.xProps.setPropertyValue("CenterVertically", (Object)bl);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getCenterHorizontally() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("CenterHorizontally"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return bl;
    }

    public void setCenterHorizontally(boolean bl) throws BasicErrorException {
        try {
            this.xProps.setPropertyValue("CenterHorizontally", (Object)bl);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getPrintHeadings() throws BasicErrorException {
        boolean bl = false;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("PrintHeaders"));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return bl;
    }

    public void setPrintHeadings(boolean bl) throws BasicErrorException {
        try {
            this.xProps.setPropertyValue("PrintHeaders", (Object)bl);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public Object getPrintTitleRows() throws BasicErrorException {
        String string = "";
        XPrintAreas xPrintAreas = (XPrintAreas)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XPrintAreas == null ? (class$com$sun$star$sheet$XPrintAreas = PageSetupImpl.class$("com.sun.star.sheet.XPrintAreas")) : class$com$sun$star$sheet$XPrintAreas), (Object)this.parent.getXSpreadsheet());
        if (xPrintAreas == null) {
            DebugHelper.exception(new Exception("Cannot get XPrintAreas."));
        }
        if (!xPrintAreas.getPrintTitleRows()) {
            return string;
        }
        CellRangeAddress cellRangeAddress = xPrintAreas.getTitleRows();
        string = "$" + (cellRangeAddress.StartRow + 1) + ":$" + (cellRangeAddress.EndRow + 1);
        return string;
    }

    public Object getPrintTitleColumns() throws BasicErrorException {
        String string = "";
        XPrintAreas xPrintAreas = (XPrintAreas)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XPrintAreas == null ? (class$com$sun$star$sheet$XPrintAreas = PageSetupImpl.class$("com.sun.star.sheet.XPrintAreas")) : class$com$sun$star$sheet$XPrintAreas), (Object)this.parent.getXSpreadsheet());
        if (xPrintAreas == null) {
            DebugHelper.exception(new Exception("Cannot get XPrintAreas."));
        }
        if (!xPrintAreas.getPrintTitleColumns()) {
            return string;
        }
        CellRangeAddress cellRangeAddress = xPrintAreas.getTitleColumns();
        string = "$" + (cellRangeAddress.StartColumn + 1) + ":$" + (cellRangeAddress.EndColumn + 1);
        return string;
    }

    public void setPrintTitleRows(Object object) throws BasicErrorException {
        String string = "";
        XPrintAreas xPrintAreas = (XPrintAreas)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XPrintAreas == null ? (class$com$sun$star$sheet$XPrintAreas = PageSetupImpl.class$("com.sun.star.sheet.XPrintAreas")) : class$com$sun$star$sheet$XPrintAreas), (Object)this.parent.getXSpreadsheet());
        if (xPrintAreas == null) {
            DebugHelper.exception(new Exception("Cannot get XPrintAreas."));
        }
        try {
            if (AnyConverter.isBoolean((Object)object)) {
                if (!AnyConverter.toBoolean((Object)object)) {
                    xPrintAreas.setPrintTitleRows(false);
                    return;
                }
                DebugHelper.exception(969, "PrintTitleRows");
            }
            if (!AnyConverter.isString((Object)object)) {
                DebugHelper.exception(969, "PrintTitleRows");
            }
            string = AnyConverter.toString((Object)object);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (string.equals("")) {
            xPrintAreas.setPrintTitleRows(false);
            return;
        }
        XCalcRange xCalcRange = this.parent.Range(string, Any.VOID);
        RangeImpl rangeImpl = (RangeImpl)xCalcRange;
        CellRangeAddress cellRangeAddress = RangeHelperImpl.getRangeAddress(rangeImpl.getUnoObject());
        xPrintAreas.setTitleRows(cellRangeAddress);
    }

    public void setPrintTitleColumns(Object object) throws BasicErrorException {
        String string = "";
        XPrintAreas xPrintAreas = (XPrintAreas)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XPrintAreas == null ? (class$com$sun$star$sheet$XPrintAreas = PageSetupImpl.class$("com.sun.star.sheet.XPrintAreas")) : class$com$sun$star$sheet$XPrintAreas), (Object)this.parent.getXSpreadsheet());
        if (xPrintAreas == null) {
            DebugHelper.exception(new Exception("Cannot get XPrintAreas."));
        }
        try {
            if (AnyConverter.isBoolean((Object)object)) {
                if (!AnyConverter.toBoolean((Object)object)) {
                    xPrintAreas.setPrintTitleColumns(false);
                    return;
                }
                DebugHelper.exception(969, "PrintTitleColumns");
            }
            if (!AnyConverter.isString((Object)object)) {
                DebugHelper.exception(969, "PrintTitleColumns");
            }
            string = AnyConverter.toString((Object)object);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (string.equals("")) {
            xPrintAreas.setPrintTitleColumns(false);
            return;
        }
        XCalcRange xCalcRange = this.parent.Range(string, Any.VOID);
        RangeImpl rangeImpl = (RangeImpl)xCalcRange;
        CellRangeAddress cellRangeAddress = RangeHelperImpl.getRangeAddress(rangeImpl.getUnoObject());
        xPrintAreas.setTitleColumns(cellRangeAddress);
    }

    public void setPrintGridlines(boolean bl) {
        try {
            this.xProps.setPropertyValue("PrintGrid", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getPrintGridlines() {
        boolean bl = false;
        try {
            bl = AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("PrintGrid"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public void setPrintDraft(boolean bl) {
        try {
            this.xProps.setPropertyValue("PrintObjects", (Object)new Boolean(!bl));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getPrintDraft() {
        boolean bl = false;
        try {
            bl = !AnyConverter.toBoolean((Object)this.xProps.getPropertyValue("PrintObjects"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private static String getStringForNumber(int n) {
        String string = "";
        int n2 = 0;
        int n3 = 0;
        if (n <= 26) {
            string = new String(new char[]{(char)(n + 64)});
        } else {
            n2 = n / 26;
            n3 = n % 26;
            if (n3 == 0) {
                n3 = n / n2;
                --n2;
            }
            string = new String(new char[]{(char)(n2 + 64), (char)(n3 + 64)});
        }
        return string;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xProps;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

