/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.DashStyle;
import com.sun.star.drawing.LineDash;
import com.sun.star.drawing.LineStyle;
import com.sun.star.drawing.XShape;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.BackColorImpl;
import com.sun.star.helper.calc.ForeColorImpl;
import com.sun.star.helper.calc.XColorFormat;
import com.sun.star.helper.calc.XLineFormat;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Millimeter;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

public class LineFormatImpl
extends HelperInterfaceAdaptor
implements XLineFormat,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.LineFormat";
    XShape myShape;
    HelperInterfaceAdaptor myParentObject;
    private BackColorImpl backColor;
    private ForeColorImpl foreColor;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public LineFormatImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XShape xShape) {
        super(__serviceName, helperInterfaceAdaptor);
        this.myShape = xShape;
        this.myParentObject = helperInterfaceAdaptor;
        this.backColor = new BackColorImpl(this, this.myShape);
        this.foreColor = new ForeColorImpl(this, this.myShape, 0);
    }

    public XColorFormat getBackColor() {
        return this.backColor;
    }

    public short getDashStyle() throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        int n = 1;
        LineDash lineDash = null;
        LineStyle lineStyle = null;
        try {
            lineDash = (LineDash)xPropertySet.getPropertyValue("LineDash");
            lineStyle = (LineStyle)xPropertySet.getPropertyValue("LineStyle");
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        if (lineStyle == LineStyle.SOLID) {
            n = 1;
        } else if (lineDash.DashLen == 200 && lineDash.Dashes == 1 && lineDash.Dots == 0 && lineDash.Distance == 150) {
            n = 4;
        } else if (lineDash.DashLen == 150 && lineDash.Dashes == 1 && lineDash.Dots == 1 && lineDash.Distance == 150) {
            n = 5;
        } else if (lineDash.DashLen == 150 && lineDash.Dashes == 1 && lineDash.Dots == 2 && lineDash.Distance == 150) {
            n = 6;
        } else if (lineDash.Dashes == 0 && lineDash.Dots == 1 && lineDash.Distance == 50) {
            n = 3;
        } else if (lineDash.DashLen == 50 && lineDash.Dashes == 1 && lineDash.Dots == 0 && lineDash.Distance == 50) {
            n = 2;
        }
        return (short)n;
    }

    public XColorFormat getForeColor() {
        return this.foreColor;
    }

    public short getStyle() {
        return 1;
    }

    public double getTransparency() throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        short s = 0;
        double d = 0.0;
        try {
            s = AnyConverter.toShort((Object)xPropertySet.getPropertyValue("LineTransparence"));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        d = s;
        return d /= 100.0;
    }

    public boolean getVisible() throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        boolean bl = true;
        LineStyle lineStyle = null;
        try {
            lineStyle = (LineStyle)xPropertySet.getPropertyValue("LineStyle");
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        if (lineStyle == LineStyle.NONE) {
            bl = false;
        }
        return bl;
    }

    public short getWeight() throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        long l = 0L;
        try {
            l = AnyConverter.toLong((Object)xPropertySet.getPropertyValue("LineWidth"));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        short s = (short)(Millimeter.getInPoints((short)l) + 1.0);
        return s;
    }

    public void setBackColor(XColorFormat xColorFormat) throws BasicErrorException {
        this.backColor.update(xColorFormat);
    }

    public void setDashStyle(short s) throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        LineDash lineDash = new LineDash();
        LineStyle lineStyle = null;
        switch (s) {
            case 4: {
                lineDash.Style = DashStyle.RECT;
                lineDash.DashLen = 200;
                lineDash.Dashes = 1;
                lineDash.Dots = 0;
                lineDash.Distance = 150;
                lineStyle = LineStyle.DASH;
                break;
            }
            case 5: {
                lineDash.Style = DashStyle.RECT;
                lineDash.DashLen = 150;
                lineDash.Dashes = 1;
                lineDash.Dots = 1;
                lineDash.Distance = 150;
                lineStyle = LineStyle.DASH;
                break;
            }
            case 6: {
                lineDash.Style = DashStyle.RECT;
                lineDash.DashLen = 150;
                lineDash.Dashes = 1;
                lineDash.Dots = (short)2;
                lineDash.Distance = 150;
                lineStyle = LineStyle.DASH;
                break;
            }
            case -2: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 3: {
                lineDash.Dashes = 0;
                lineDash.Dots = 1;
                lineDash.Distance = 50;
                lineStyle = LineStyle.DASH;
                break;
            }
            case 1: {
                lineStyle = LineStyle.SOLID;
                break;
            }
            case 2: {
                lineDash.Style = DashStyle.RECT;
                lineDash.DashLen = 50;
                lineDash.Dashes = 1;
                lineDash.Dots = 0;
                lineDash.Distance = 50;
                lineStyle = LineStyle.DASH;
                break;
            }
            default: {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Unknown dash type " + s);
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
        }
        try {
            xPropertySet.setPropertyValue("LineDash", (Object)lineDash);
            xPropertySet.setPropertyValue("LineStyle", (Object)lineStyle);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    public void setForeColor(XColorFormat xColorFormat) throws BasicErrorException {
        this.foreColor.update(xColorFormat);
    }

    public void setStyle(short s) {
    }

    public void setTransparency(double d) throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        try {
            short s = (short)(d * 100.0);
            xPropertySet.setPropertyValue("LineTransparence", (Object)new Short(s));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    public void setVisible(boolean bl) throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        LineStyle lineStyle = null;
        try {
            lineStyle = (LineStyle)xPropertySet.getPropertyValue("LineStyle");
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        try {
            if (!bl) {
                xPropertySet.setPropertyValue("Linestyle", (Object)LineStyle.NONE);
            } else if (lineStyle == LineStyle.NONE) {
                xPropertySet.setPropertyValue("Linestyle", (Object)LineStyle.SOLID);
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    public void setWeight(short s) throws BasicErrorException {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = LineFormatImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.myShape);
        try {
            xPropertySet.setPropertyValue("LineWidth", (Object)new Integer(Millimeter.getInHundredthsOfOneMillimeter(s)));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.exception((Exception)((Object)propertyVetoException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    protected void update(XLineFormat xLineFormat) throws BasicErrorException {
        this.setBackColor(xLineFormat.getBackColor());
        this.setForeColor(xLineFormat.getForeColor());
        this.setDashStyle(xLineFormat.getDashStyle());
        this.setStyle(xLineFormat.getStyle());
        this.setWeight(xLineFormat.getWeight());
        this.setTransparency(xLineFormat.getTransparency());
        this.setVisible(xLineFormat.getVisible());
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.myShape;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

