/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.ChartDataRowSource;
import com.sun.star.chart.XAxisXSupplier;
import com.sun.star.chart.XAxisYSupplier;
import com.sun.star.chart.XAxisZSupplier;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.chart.XTwoAxisXSupplier;
import com.sun.star.chart.XTwoAxisYSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.AxesImpl;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.ChartObjectImpl;
import com.sun.star.helper.calc.ChartTitleImpl;
import com.sun.star.helper.calc.DataLabelsImpl;
import com.sun.star.helper.calc.SeriesCollectionImpl;
import com.sun.star.helper.calc.SeriesImpl;
import com.sun.star.helper.calc.XAxes;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.XChart;
import com.sun.star.helper.calc.XChartTitle;
import com.sun.star.helper.calc.XDataLabels;
import com.sun.star.helper.calc.XSeriesCollection;
import com.sun.star.helper.calc.XSheet;
import com.sun.star.helper.calc.XSheets;
import com.sun.star.helper.common.ContainerUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.constant.XlAxisGroup;
import com.sun.star.helper.constant.XlAxisType;
import com.sun.star.helper.constant.XlChartType;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XTableChart;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

public class ChartImpl
extends HelperInterfaceAdaptor
implements XChart,
XlChartType,
XlAxisGroup,
XlAxisType,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.calc.Chart";
    protected XTableChart mxTableChart = null;
    protected XCalcRange sourceData = null;
    protected XSpreadsheet chartSheet = null;
    protected String chartName = null;
    protected XPropertySet xDiagramPropertySet = null;
    protected XComponent mxChartComponent;
    protected XPropertySet mxChartPropertySet;
    protected XMultiServiceFactory xMSF;
    protected XChartDocument mxChartDocument;
    protected XChartDataArray xChartDataArray;
    protected XAxisXSupplier xAxisXSupplier;
    protected XAxisYSupplier xAxisYSupplier;
    protected XAxisZSupplier xAxisZSupplier;
    protected XTwoAxisXSupplier xTwoAxisXSupplier;
    protected XTwoAxisYSupplier xTwoAxisYSupplier;
    protected double[][] dblValues;
    static /* synthetic */ Class class$com$sun$star$chart$XChartDocument;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$chart$XDiagram;
    static /* synthetic */ Class class$com$sun$star$chart$XAxisXSupplier;
    static /* synthetic */ Class class$com$sun$star$chart$XAxisYSupplier;
    static /* synthetic */ Class class$com$sun$star$chart$XAxisZSupplier;
    static /* synthetic */ Class class$com$sun$star$chart$XTwoAxisXSupplier;
    static /* synthetic */ Class class$com$sun$star$chart$XTwoAxisYSupplier;
    static /* synthetic */ Class class$com$sun$star$chart$XChartDataArray;
    static /* synthetic */ Class class$com$sun$star$chart$ChartDataRowSource;

    public ChartImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XComponent xComponent, XTableChart xTableChart) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        this.mxChartComponent = xComponent;
        this.mxTableChart = xTableChart;
        this.mxChartDocument = (XChartDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDocument == null ? (class$com$sun$star$chart$XChartDocument = ChartImpl.class$("com.sun.star.chart.XChartDocument")) : class$com$sun$star$chart$XChartDocument), (Object)this.mxChartComponent);
        this.mxChartPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ChartImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.mxChartComponent);
        this.xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ChartImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory), (Object)this.mxChartDocument);
        this.setHasTitle(false);
        this.setHasLegend(true);
    }

    private boolean isStacked() throws BasicErrorException {
        try {
            return (Boolean)this.xDiagramPropertySet.getPropertyValue("Stacked");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    protected boolean is100PercentStacked() throws BasicErrorException {
        try {
            return (Boolean)this.xDiagramPropertySet.getPropertyValue("Percent");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    protected boolean is3D() throws BasicErrorException {
        try {
            return (Boolean)this.xDiagramPropertySet.getPropertyValue("Dim3D");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    protected int getStockUpDownValue(int n, int n2) throws BasicErrorException {
        try {
            boolean bl = (Boolean)this.xDiagramPropertySet.getPropertyValue("UpDown");
            if (bl) {
                return n;
            }
            return n2;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return n2;
        }
    }

    protected boolean hasMarkers() throws BasicErrorException {
        int n = HelperUtilities.getIntegerProperty(this.xDiagramPropertySet, "SymbolType");
        return n != -3;
    }

    protected int getMarkerType(int n, int n2) throws BasicErrorException {
        if (this.hasMarkers()) {
            return n;
        }
        return n2;
    }

    protected int getStackedType(int n, int n2, int n3) throws BasicErrorException {
        if (this.isStacked()) {
            if (this.is100PercentStacked()) {
                return n2;
            }
            return n;
        }
        return n3;
    }

    protected int getSolidType(int n, int n2, int n3, int n4, int n5, int n6, int n7) throws BasicErrorException {
        boolean bl = true;
        try {
            bl = (Boolean)this.xDiagramPropertySet.getPropertyValue("Vertical");
            boolean bl2 = (Boolean)this.xDiagramPropertySet.getPropertyValue("Deep");
            if (bl2) {
                return n;
            }
            if (bl) {
                return this.getStackedType(n2, n3, n4);
            }
            return this.getStackedType(n5, n6, n7);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            if (bl) {
                return n2;
            }
            return n5;
        }
    }

    public int getChartType() throws BasicErrorException {
        int n = -1;
        try {
            String string = this.mxChartDocument.getDiagram().getDiagramType();
            this.xDiagramPropertySet = this.getDiagramPropertySet();
            if (string.equals("com.sun.star.chart.AreaDiagram")) {
                n = this.is3D() ? this.getStackedType(78, 79, -4098) : this.getStackedType(76, 77, 1);
            } else if (string.equals("com.sun.star.chart.PieDiagram")) {
                n = this.is3D() ? -4102 : 5;
            } else if (string.equals("com.sun.star.chart.BarDiagram")) {
                int n2 = 0;
                if (this.xDiagramPropertySet.getPropertySetInfo().hasPropertyByName("SolidType") && this.is3D()) {
                    n2 = (Integer)this.xDiagramPropertySet.getPropertyValue("SolidType");
                }
                switch (n2) {
                    case 2: {
                        n = this.getSolidType(105, 100, 101, 99, 103, 104, 102);
                        break;
                    }
                    case 1: {
                        n = this.getSolidType(98, 93, 94, 92, 96, 97, 95);
                        break;
                    }
                    case 3: {
                        n = this.getSolidType(112, 107, 108, 106, 110, 111, 109);
                        break;
                    }
                    default: {
                        if (this.is3D()) {
                            n = this.getSolidType(-4100, 55, 56, 54, 61, 62, 60);
                            break;
                        }
                        n = this.getSolidType(51, 52, 53, 51, 58, 59, 57);
                        break;
                    }
                }
            } else if (string.equals("com.sun.star.chart.StockDiagram")) {
                boolean bl = AnyConverter.toBoolean((Object)this.xDiagramPropertySet.getPropertyValue("Volume"));
                n = bl ? this.getStockUpDownValue(91, 90) : this.getStockUpDownValue(89, 88);
            } else if (string.equals("com.sun.star.chart.XYDiagram")) {
                boolean bl = (Boolean)this.xDiagramPropertySet.getPropertyValue("Lines");
                int n3 = (Integer)this.xDiagramPropertySet.getPropertyValue("SplineType");
                n = n3 == 1 ? this.getMarkerType(72, 73) : (bl ? this.getMarkerType(74, 75) : -4169);
            } else if (string.equals("com.sun.star.chart.LineDiagram")) {
                n = this.is3D() ? -4101 : (this.hasMarkers() ? this.getStackedType(66, 67, 65) : this.getStackedType(63, 64, 4));
            } else if (string.equals("com.sun.star.chart.DonutDiagram")) {
                n = -4120;
            } else if (string.equals("com.sun.star.chart.NetDiagram")) {
                n = this.getMarkerType(81, -4151);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public void setChartType(int n) throws BasicErrorException {
        try {
            String string = this.mxChartDocument.getDiagram().getDiagramType();
            block1 : switch (n) {
                case -4100: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: {
                    this.setDiagram("com.sun.star.chart.BarDiagram");
                    break;
                }
                case -4101: 
                case 4: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: {
                    this.setDiagram("com.sun.star.chart.LineDiagram");
                    break;
                }
                case -4098: 
                case 1: 
                case 76: 
                case 77: 
                case 78: 
                case 79: {
                    this.setDiagram("com.sun.star.chart.AreaDiagram");
                    break;
                }
                case -4120: 
                case 80: {
                    this.setDiagram("com.sun.star.chart.DonutDiagram");
                    break;
                }
                case 88: 
                case 89: 
                case 90: 
                case 91: {
                    this.setDiagram("com.sun.star.chart.StockDiagram");
                    this.xDiagramPropertySet.setPropertyValue("UpDown", (Object)new Boolean(n == 89 || n == 91));
                    this.xDiagramPropertySet.setPropertyValue("Volume", (Object)new Boolean(n == 90 || n == 91));
                    break;
                }
                case -4102: 
                case 5: 
                case 68: 
                case 69: 
                case 70: 
                case 71: {
                    this.setDiagram("com.sun.star.chart.PieDiagram");
                    break;
                }
                case -4151: 
                case 81: 
                case 82: {
                    this.setDiagram("com.sun.star.chart.NetDiagram");
                    break;
                }
                case -4169: 
                case 15: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 87: {
                    this.setDiagram("com.sun.star.chart.XYDiagram");
                    switch (n) {
                        case -4169: 
                        case 15: 
                        case 87: {
                            this.xDiagramPropertySet.setPropertyValue("Lines", (Object)Boolean.FALSE);
                            break block1;
                        }
                        case 74: 
                        case 75: {
                            this.xDiagramPropertySet.setPropertyValue("Lines", (Object)Boolean.TRUE);
                            break block1;
                        }
                        case 72: 
                        case 73: {
                            this.xDiagramPropertySet.setPropertyValue("SplineType", (Object)new Integer(1));
                            break block1;
                        }
                    }
                    break;
                }
                default: {
                    DebugHelper.exception(13, "");
                }
            }
            switch (n) {
                case -4169: 
                case 15: 
                case 65: 
                case 66: 
                case 67: 
                case 72: 
                case 74: 
                case 81: 
                case 87: {
                    this.xDiagramPropertySet.setPropertyValue("SymbolType", (Object)new Integer(-2));
                    break;
                }
                default: {
                    if (!this.xDiagramPropertySet.getPropertySetInfo().hasPropertyByName("SymbolType")) break;
                    this.xDiagramPropertySet.setPropertyValue("SymbolType", (Object)new Integer(-3));
                }
            }
            switch (n) {
                case -4100: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 98: 
                case 105: 
                case 112: {
                    this.xDiagramPropertySet.setPropertyValue("Deep", (Object)Boolean.TRUE);
                    break;
                }
                default: {
                    if (!this.xDiagramPropertySet.getPropertySetInfo().hasPropertyByName("Deep")) break;
                    this.xDiagramPropertySet.setPropertyValue("Deep", (Object)Boolean.FALSE);
                }
            }
            switch (n) {
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    this.xDiagramPropertySet.setPropertyValue("SolidType", (Object)new Integer(2));
                    break;
                }
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: {
                    this.xDiagramPropertySet.setPropertyValue("SolidType", (Object)new Integer(3));
                    break;
                }
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: {
                    this.xDiagramPropertySet.setPropertyValue("SolidType", (Object)new Integer(1));
                    break;
                }
                default: {
                    if (!this.xDiagramPropertySet.getPropertySetInfo().hasPropertyByName("SolidType")) break;
                    this.xDiagramPropertySet.setPropertyValue("SolidType", (Object)new Integer(0));
                }
            }
            switch (n) {
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 92: 
                case 93: 
                case 94: 
                case 99: 
                case 100: 
                case 101: 
                case 105: 
                case 106: 
                case 107: 
                case 108: {
                    this.xDiagramPropertySet.setPropertyValue("Vertical", (Object)Boolean.TRUE);
                    break;
                }
                default: {
                    if (!this.xDiagramPropertySet.getPropertySetInfo().hasPropertyByName("Vertical")) break;
                    this.xDiagramPropertySet.setPropertyValue("Vertical", (Object)Boolean.FALSE);
                }
            }
            switch (n) {
                case 52: 
                case 55: 
                case 58: 
                case 61: 
                case 63: 
                case 66: 
                case 76: 
                case 78: 
                case 93: 
                case 96: 
                case 100: 
                case 103: 
                case 107: 
                case 110: {
                    this.xDiagramPropertySet.setPropertyValue("Percent", (Object)Boolean.FALSE);
                    this.xDiagramPropertySet.setPropertyValue("Stacked", (Object)Boolean.TRUE);
                    break;
                }
                case 53: 
                case 56: 
                case 59: 
                case 62: 
                case 64: 
                case 67: 
                case 77: 
                case 79: 
                case 94: 
                case 97: 
                case 101: 
                case 104: 
                case 108: 
                case 111: {
                    this.xDiagramPropertySet.setPropertyValue("Stacked", (Object)Boolean.TRUE);
                    this.xDiagramPropertySet.setPropertyValue("Percent", (Object)Boolean.TRUE);
                    break;
                }
                default: {
                    this.xDiagramPropertySet.setPropertyValue("Percent", (Object)Boolean.FALSE);
                    this.xDiagramPropertySet.setPropertyValue("Stacked", (Object)Boolean.FALSE);
                }
            }
            switch (n) {
                case -4102: 
                case -4101: 
                case -4100: 
                case -4098: 
                case 54: 
                case 55: 
                case 56: 
                case 60: 
                case 61: 
                case 62: 
                case 70: 
                case 78: 
                case 79: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: {
                    this.xDiagramPropertySet.setPropertyValue("Dim3D", (Object)Boolean.TRUE);
                    break;
                }
                default: {
                    if (this.xDiagramPropertySet.getPropertySetInfo().hasPropertyByName("Dim3D")) {
                        this.xDiagramPropertySet.setPropertyValue("Dim3D", (Object)Boolean.FALSE);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private void setDefaultChartType() throws BasicErrorException {
        this.setChartType(51);
    }

    private void setDiagram(String string) throws BasicErrorException {
        try {
            this.mxChartDocument.setDiagram((XDiagram)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XDiagram == null ? (class$com$sun$star$chart$XDiagram = ChartImpl.class$("com.sun.star.chart.XDiagram")) : class$com$sun$star$chart$XDiagram), (Object)this.xMSF.createInstance(string)));
            this.xDiagramPropertySet = this.getDiagramPropertySet();
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public XDiagram getDiagram() {
        return this.mxChartDocument.getDiagram();
    }

    protected XPropertySet getDiagramPropertySet() {
        if (this.xDiagramPropertySet == null) {
            this.xDiagramPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ChartImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)this.mxChartDocument.getDiagram());
            this.xAxisXSupplier = (XAxisXSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XAxisXSupplier == null ? (class$com$sun$star$chart$XAxisXSupplier = ChartImpl.class$("com.sun.star.chart.XAxisXSupplier")) : class$com$sun$star$chart$XAxisXSupplier), (Object)this.xDiagramPropertySet);
            this.xAxisYSupplier = (XAxisYSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XAxisYSupplier == null ? (class$com$sun$star$chart$XAxisYSupplier = ChartImpl.class$("com.sun.star.chart.XAxisYSupplier")) : class$com$sun$star$chart$XAxisYSupplier), (Object)this.xDiagramPropertySet);
            this.xAxisZSupplier = (XAxisZSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XAxisZSupplier == null ? (class$com$sun$star$chart$XAxisZSupplier = ChartImpl.class$("com.sun.star.chart.XAxisZSupplier")) : class$com$sun$star$chart$XAxisZSupplier), (Object)this.xDiagramPropertySet);
            this.xTwoAxisXSupplier = (XTwoAxisXSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XTwoAxisXSupplier == null ? (class$com$sun$star$chart$XTwoAxisXSupplier = ChartImpl.class$("com.sun.star.chart.XTwoAxisXSupplier")) : class$com$sun$star$chart$XTwoAxisXSupplier), (Object)this.xDiagramPropertySet);
            this.xTwoAxisYSupplier = (XTwoAxisYSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XTwoAxisYSupplier == null ? (class$com$sun$star$chart$XTwoAxisYSupplier = ChartImpl.class$("com.sun.star.chart.XTwoAxisYSupplier")) : class$com$sun$star$chart$XTwoAxisYSupplier), (Object)this.xDiagramPropertySet);
        }
        return this.xDiagramPropertySet;
    }

    public void setSourceData(XCalcRange xCalcRange, Object object) throws BasicErrorException {
        try {
            CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[1];
            CellRangeAddress cellRangeAddress = new CellRangeAddress();
            short s = 1;
            XSheet xSheet = xCalcRange.getWorksheet();
            String string = xSheet.getName();
            CalcImpl calcImpl = (CalcImpl)this.Application().Calc();
            XSheets xSheets = CalcImpl.getSpreadsheet(this.getXModel()).getSheets();
            int n = 1;
            while (n <= xSheets.Count()) {
                if (xSheets.Item(new Integer(n)).getName().equals(string)) {
                    s = (short)n;
                    break;
                }
                ++n;
            }
            cellRangeAddress.StartRow = xCalcRange.getRow() - 1;
            cellRangeAddress.EndRow = xCalcRange.getRow() - 1 + xCalcRange.Rows().getCount() - 1;
            cellRangeAddress.StartColumn = xCalcRange.getColumn() - 1;
            cellRangeAddress.EndColumn = xCalcRange.getColumn() - 1 + xCalcRange.Columns().getCount() - 1;
            cellRangeAddress.Sheet = (short)(s - 1);
            cellRangeAddressArray[0] = cellRangeAddress;
            this.mxTableChart.setRanges(cellRangeAddressArray);
            boolean bl = false;
            boolean bl2 = false;
            if (xCalcRange.Columns().getCount() > 1) {
                XCalcRange xCalcRange2 = xCalcRange.Cells().Item(new Integer(1), new Integer(2));
                bl2 = !this.isCellValueNumeric(xCalcRange2);
            }
            this.mxTableChart.setHasColumnHeaders(bl2);
            if (xCalcRange.Rows().getCount() > 1) {
                XCalcRange xCalcRange3 = xCalcRange.Cells().Item(new Integer(2), new Integer(1));
                bl = !this.isCellValueNumeric(xCalcRange3);
            }
            this.mxTableChart.setHasRowHeaders(bl);
            if (!bl2 || !bl) {
                this.xChartDataArray = (XChartDataArray)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDataArray == null ? (class$com$sun$star$chart$XChartDataArray = ChartImpl.class$("com.sun.star.chart.XChartDataArray")) : class$com$sun$star$chart$XChartDataArray), (Object)this.mxChartDocument.getData());
                if (!bl2) {
                    this.xChartDataArray.setColumnDescriptions(this.getDefaultSeriesDescriptions(this.xChartDataArray.getColumnDescriptions().length));
                }
                if (!bl) {
                    this.xChartDataArray.setRowDescriptions(this.getDefaultSeriesDescriptions(this.xChartDataArray.getRowDescriptions().length));
                }
            }
            if (!AnyConverter.isVoid((Object)object)) {
                this.setPlotBy(AnyConverter.toInt((Object)object));
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    protected void setDefaultSeriesDescriptionLabels() {
    }

    private String[] getDefaultSeriesDescriptions(int n) {
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = "Series" + (n2 + 1);
            ++n2;
        }
        return stringArray;
    }

    private boolean isCellValueNumeric(XCalcRange xCalcRange) throws BasicErrorException {
        try {
            Object object = xCalcRange.getValue();
            if (AnyConverter.isString((Object)object)) {
                String string = AnyConverter.toString((Object)object);
                try {
                    Double d = Double.valueOf(string);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public int Location() {
        return this.getLocation();
    }

    public int getLocation() {
        return -1;
    }

    public void Activate() throws BasicErrorException {
        ChartObjectImpl chartObjectImpl = (ChartObjectImpl)this.getParentAdaptor();
        chartObjectImpl.Activate();
    }

    public int getPlotBy() throws BasicErrorException {
        try {
            Object object = this.xDiagramPropertySet.getPropertyValue("DataRowSource");
            ChartDataRowSource chartDataRowSource = (ChartDataRowSource)AnyConverter.toObject((Class)(class$com$sun$star$chart$ChartDataRowSource == null ? (class$com$sun$star$chart$ChartDataRowSource = ChartImpl.class$("com.sun.star.chart.ChartDataRowSource")) : class$com$sun$star$chart$ChartDataRowSource), (Object)object);
            if (chartDataRowSource.equals(ChartDataRowSource.COLUMNS)) {
                return 2;
            }
            return 1;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return 2;
        }
    }

    public void setPlotBy(int n) throws BasicErrorException {
        try {
            if (this.xDiagramPropertySet == null) {
                this.setDefaultChartType();
            }
            switch (n) {
                case 1: {
                    this.xDiagramPropertySet.setPropertyValue("DataRowSource", (Object)ChartDataRowSource.ROWS);
                    break;
                }
                case 2: {
                    this.xDiagramPropertySet.setPropertyValue("DataRowSource", (Object)ChartDataRowSource.COLUMNS);
                    break;
                }
                default: {
                    DebugHelper.exception(1004, "");
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void setLocation(int n, Object object) {
    }

    public void setHasTitle(boolean bl) throws BasicErrorException {
        try {
            this.mxChartPropertySet.setPropertyValue("HasMainTitle", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getHasTitle() throws BasicErrorException {
        try {
            return (Boolean)this.mxChartPropertySet.getPropertyValue("HasMainTitle");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public void setHasLegend(boolean bl) throws BasicErrorException {
        try {
            this.mxChartPropertySet.setPropertyValue("HasLegend", (Object)new Boolean(bl));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getHasLegend() throws BasicErrorException {
        try {
            return (Boolean)this.mxChartPropertySet.getPropertyValue("HasLegend");
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    public XChartTitle getChartTitle() {
        XShape xShape = this.mxChartDocument.getTitle();
        return new ChartTitleImpl(this, xShape);
    }

    public XSeriesCollection SeriesCollection() {
        return new SeriesCollectionImpl(this);
    }

    private boolean isSeriesIndexValid(int n) throws BasicErrorException {
        boolean bl = false;
        try {
            this.xChartDataArray = (XChartDataArray)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDataArray == null ? (class$com$sun$star$chart$XChartDataArray = ChartImpl.class$("com.sun.star.chart.XChartDataArray")) : class$com$sun$star$chart$XChartDataArray), (Object)this.mxChartDocument.getData());
            if (this.xChartDataArray != null) {
                if (this.getPlotBy() == 1) {
                    if (n < this.xChartDataArray.getRowDescriptions().length && n >= 0) {
                        bl = true;
                    }
                } else if (n < this.xChartDataArray.getColumnDescriptions().length && n >= 0) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        if (!bl) {
            DebugHelper.exception(9, "");
        }
        return bl;
    }

    private boolean areIndicesValid(int n, int n2) throws BasicErrorException {
        try {
            if (this.isSeriesIndexValid(n)) {
                this.dblValues = this.xChartDataArray.getData();
                return n2 < this.dblValues[n].length;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return false;
    }

    protected void setSeriesName(int n, String string) throws BasicErrorException {
        if (this.isSeriesIndexValid(n)) {
            String[] stringArray = this.xChartDataArray.getColumnDescriptions();
            stringArray[n] = string;
            this.xChartDataArray.setColumnDescriptions(stringArray);
        }
    }

    protected int getSeriesIndex(String string) throws BasicErrorException {
        this.xChartDataArray = (XChartDataArray)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDataArray == null ? (class$com$sun$star$chart$XChartDataArray = ChartImpl.class$("com.sun.star.chart.XChartDataArray")) : class$com$sun$star$chart$XChartDataArray), (Object)this.mxChartDocument.getData());
        if (this.getPlotBy() == 1) {
            return ContainerUtilities.FieldInList(this.xChartDataArray.getRowDescriptions(), string);
        }
        return ContainerUtilities.FieldInList(this.xChartDataArray.getColumnDescriptions(), string);
    }

    protected int getSeriesCount() throws BasicErrorException {
        this.xChartDataArray = (XChartDataArray)UnoRuntime.queryInterface((Class)(class$com$sun$star$chart$XChartDataArray == null ? (class$com$sun$star$chart$XChartDataArray = ChartImpl.class$("com.sun.star.chart.XChartDataArray")) : class$com$sun$star$chart$XChartDataArray), (Object)this.mxChartDocument.getData());
        if (this.getPlotBy() == 1) {
            return this.xChartDataArray.getRowDescriptions().length;
        }
        return this.xChartDataArray.getColumnDescriptions().length;
    }

    protected String getSeriesName(int n) throws BasicErrorException {
        String[] stringArray = null;
        if (this.isSeriesIndexValid(n)) {
            stringArray = this.getPlotBy() == 1 ? this.xChartDataArray.getRowDescriptions() : this.xChartDataArray.getColumnDescriptions();
            return stringArray[n];
        }
        return "";
    }

    protected double getValue(int n, int n2) throws BasicErrorException {
        if (this.areIndicesValid(n, n2)) {
            if (this.getPlotBy() == 1) {
                return this.dblValues[n][n2];
            }
            return this.dblValues[n2][n];
        }
        return -1.0;
    }

    protected int getValuesCount(int n) throws BasicErrorException {
        if (this.isSeriesIndexValid(n)) {
            this.dblValues = this.xChartDataArray.getData();
            if (this.getPlotBy() == 1) {
                return this.dblValues[n].length;
            }
            return this.dblValues.length;
        }
        return 0;
    }

    protected XDataLabels DataLabels(SeriesImpl seriesImpl) throws BasicErrorException {
        return new DataLabelsImpl(seriesImpl, this);
    }

    protected boolean getHasDataCaption(XPropertySet xPropertySet) throws BasicErrorException {
        try {
            int n = AnyConverter.toInt((Object)xPropertySet.getPropertyValue("DataCaption"));
            return n != 0;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return false;
        }
    }

    protected void setHasDataCaption(XPropertySet xPropertySet, boolean bl) throws BasicErrorException {
        block3: {
            try {
                if (bl) {
                    xPropertySet.setPropertyValue("DataCaption", (Object)new Integer(1));
                    break block3;
                }
                xPropertySet.setPropertyValue("DataCaption", (Object)new Integer(0));
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public XAxes Axes() {
        return new AxesImpl(this);
    }

    protected XPropertySet getAxisPropertySet(int n, int n2) throws BasicErrorException {
        this.getDiagramPropertySet();
        switch (n) {
            case 1: {
                if (n2 == 1) {
                    return this.xAxisXSupplier.getXAxis();
                }
                if (n2 != 2) break;
                return this.xTwoAxisXSupplier.getSecondaryXAxis();
            }
            case 3: {
                return this.xAxisZSupplier.getZAxis();
            }
            case 2: {
                if (n2 == 1) {
                    return this.xAxisYSupplier.getYAxis();
                }
                if (n2 != 2) break;
                return this.xTwoAxisYSupplier.getSecondaryYAxis();
            }
            default: {
                return null;
            }
        }
        return null;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.mxTableChart;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

