/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DocumentUtilities;
import com.sun.star.helper.common.UNOUtility;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JOptionPane;

public class HelperUtilities {
    public static final PropertyValue[] EMPTY_PROPERTIES = new PropertyValue[0];
    public static final Integer INTEGER_MINUSONE = new Integer(-1);
    public static final Integer INTEGER_ZERO = new Integer(0);
    public static final Integer INTEGER_ONE = new Integer(1);
    public static final Byte BYTE_MINUSONE = new Byte(-1);
    public static final Byte BYTE_ZERO = new Byte(0);
    public static final Byte BYTE_ONE = new Byte(1);
    public static final Any ANY_VOID = Any.VOID;
    public static final String PARAGRAPH_END = "\r\n";
    public static Boolean True = Boolean.TRUE;
    public static Boolean False = Boolean.FALSE;
    private static XDesktop xDesktop = null;
    private static final String[] BAD_FRAMES = new String[]{"OFFICE_HELP", "OFFICE_HELP_TASK"};
    public static PrintStream out = DebugHelper.getPrintStream();
    public static int iDebugLevel = 0;
    public static boolean bInfo = true;
    public static boolean bError = true;
    public static boolean bStackOnError = false;
    public static boolean bDebug = true;
    public static boolean bDebugMore = true;
    public static boolean bExceptionTitle = true;
    public static boolean bExceptionTrace = true;
    public static String PROP_PREFIX = "HelperDebug.";
    public static String PRINT_PREFIX = "Helper";
    public static String PRINT_PREFIX_INFO = " Info:";
    public static String PRINT_PREFIX_DEBUG = " Debug:";
    public static String PRINT_PREFIX_ERROR = " ERROR:";
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$frame$XDesktop;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$frame$XComponentLoader;
    static /* synthetic */ Class class$com$sun$star$frame$XFramesSupplier;
    static /* synthetic */ Class class$com$sun$star$helper$HelperUtilities;
    static /* synthetic */ Class class$java$io$PrintStream;

    private HelperUtilities() {
    }

    public static boolean supportsService(Object object, String string) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = HelperUtilities.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)object);
        if (xServiceInfo != null) {
            return xServiceInfo.supportsService(string);
        }
        return false;
    }

    public static int supportsService(Object object, String[] stringArray) {
        XServiceInfo xServiceInfo = (XServiceInfo)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = HelperUtilities.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo), (Object)object);
        String string = "";
        if (xServiceInfo != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (xServiceInfo.supportsService(stringArray[n])) {
                    return n;
                }
                if (iDebugLevel >= 0) {
                    if (string.length() > 0) {
                        string = string + ";";
                    }
                    string = string + stringArray[n];
                }
                ++n;
            }
        }
        if (iDebugLevel >= 0) {
            out.println("Object supports none of the following services: " + string);
            UNOUtility.printInterfaceNames("Object", object, out);
        }
        return -1;
    }

    public static XDesktop getXDesktop(XMultiServiceFactory xMultiServiceFactory) {
        if (xDesktop != null) {
            return xDesktop;
        }
        XInterface xInterface = null;
        if (xMultiServiceFactory != null) {
            try {
                xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
                xDesktop = (XDesktop)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XDesktop == null ? (class$com$sun$star$frame$XDesktop = HelperUtilities.class$("com.sun.star.frame.XDesktop")) : class$com$sun$star$frame$XDesktop), (Object)xInterface);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.warning(exception);
            }
            catch (Exception exception) {
                DebugHelper.writeInfo(exception.getMessage());
            }
        } else {
            DebugHelper.writeInfo("Can't create a desktop. null pointer !");
        }
        return xDesktop;
    }

    public static XEnumeration getEnumeration(Object object) {
        XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = HelperUtilities.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess), (Object)object);
        if (xEnumerationAccess != null) {
            XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
            if (xEnumeration != null) {
                return xEnumeration;
            }
            HelperUtilities.error("Does not support XEnumerationAccess");
        } else {
            HelperUtilities.error("Failed to create enumeration");
        }
        return null;
    }

    public static int getToggleValue(int n) {
        switch (n) {
            case 9999999: {
                return -1;
            }
            case -1: {
                return 0;
            }
            case 0: {
                return -1;
            }
        }
        throw new java.lang.IllegalArgumentException("Unknown boolean value " + n);
    }

    public static int copyAllProperties(XPropertySet xPropertySet, XPropertySet xPropertySet2) {
        return HelperUtilities.copyPropertiesByPrefix(null, xPropertySet, xPropertySet2);
    }

    public static int copyPropertiesByPrefix(String string, Object object, Object object2) {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = HelperUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
        XPropertySet xPropertySet2 = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = HelperUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object2);
        if (xPropertySet != null && xPropertySet2 != null && xPropertySet != xPropertySet2) {
            return HelperUtilities.copyPropertiesByPrefix(string, xPropertySet, xPropertySet2);
        }
        return -1;
    }

    public static int copyPropertiesByPrefix(String string, XPropertySet xPropertySet, XPropertySet xPropertySet2) {
        XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
        XPropertySetInfo xPropertySetInfo2 = xPropertySet2.getPropertySetInfo();
        Property[] propertyArray = xPropertySetInfo.getProperties();
        int n = 0;
        int n2 = 0;
        while (n2 < propertyArray.length) {
            String string2 = propertyArray[n2].Name;
            if ((string == null || string2.startsWith(string)) && xPropertySetInfo2.hasPropertyByName(string2)) {
                try {
                    Property property = xPropertySetInfo2.getPropertyByName(string2);
                    if (property.Type.equals((Object)propertyArray[n2].Type)) {
                        xPropertySet2.setPropertyValue(string2, xPropertySet.getPropertyValue(string2));
                        ++n;
                    }
                }
                catch (Exception exception) {
                    HelperUtilities.exception(exception);
                }
            }
            ++n2;
        }
        return n;
    }

    public static boolean setProperty(Object object, String string, Object object2) {
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = HelperUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
        if (xPropertySet != null) {
            try {
                xPropertySet.setPropertyValue(string, object2);
                return true;
            }
            catch (com.sun.star.uno.Exception exception) {
                HelperUtilities.exception(exception);
            }
        } else {
            HelperUtilities.error("Object " + object + " does not support XPropertySet!");
        }
        throw new java.lang.IllegalArgumentException("attempt to set property " + string + " on " + object + " to " + object2);
    }

    public static Object getProperty(Object object, String string) {
        try {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = HelperUtilities.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            Object object2 = xPropertySet.getPropertyValue(string);
            return object2;
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
            throw new java.lang.IllegalArgumentException(string + " not found in " + object);
        }
    }

    public static boolean isPropertyVoid(Object object) {
        if (object == null) {
            return true;
        }
        return AnyConverter.isVoid((Object)object);
    }

    public static Object getObjectValue(Class clazz, Object object, boolean bl, Object object2) {
        if (object == null) {
            if (bl) {
                return object2;
            }
        } else if (AnyConverter.isBoolean((Object)object)) {
            try {
                return AnyConverter.toObject((Class)clazz, (Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (AnyConverter.isVoid((Object)object) && bl) {
            return object2;
        }
        throw new java.lang.IllegalArgumentException("invalid value for boolean: " + object);
    }

    public static boolean getBooleanValue(Object object) {
        return HelperUtilities.getBooleanValue(object, true, false);
    }

    public static boolean getBooleanValue(Object object, boolean bl, boolean bl2) {
        if (object == null) {
            if (bl) {
                return bl2;
            }
        } else if (AnyConverter.isBoolean((Object)object)) {
            try {
                return AnyConverter.toBoolean((Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (AnyConverter.isVoid((Object)object) && bl) {
            return bl2;
        }
        throw new java.lang.IllegalArgumentException("invalid value for boolean: " + object);
    }

    public static boolean getBooleanProperty(Object object, String string) {
        return HelperUtilities.getBooleanValue(HelperUtilities.getProperty(object, string));
    }

    public static void setBooleanProperty(Object object, String string, Boolean bl) {
        HelperUtilities.setProperty(object, string, bl);
    }

    public static void setBooleanProperty(Object object, String string, boolean bl) {
        HelperUtilities.setProperty(object, string, new Boolean(bl));
    }

    public static int getIntegerValue(Object object) {
        return HelperUtilities.getIntegerValue(object, true, 0);
    }

    public static int getIntegerValue(Object object, boolean bl, int n) {
        if (object == null) {
            if (bl) {
                return n;
            }
        } else if (AnyConverter.isInt((Object)object)) {
            try {
                return AnyConverter.toInt((Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (AnyConverter.isVoid((Object)object) && bl) {
            return n;
        }
        throw new java.lang.IllegalArgumentException("invalid value for integer: " + object);
    }

    public static int getIntegerProperty(Object object, String string) {
        return HelperUtilities.getIntegerValue(HelperUtilities.getProperty(object, string));
    }

    public static void setIntegerProperty(Object object, String string, Integer n) {
        HelperUtilities.setProperty(object, string, n);
    }

    public static void setIntegerProperty(Object object, String string, int n) {
        HelperUtilities.setProperty(object, string, new Integer(n));
    }

    public static short getShortValue(Object object) {
        return HelperUtilities.getShortValue(object, true, (short)0);
    }

    public static short getShortValue(Object object, boolean bl, short s) {
        if (object == null) {
            if (bl) {
                return s;
            }
        } else if (AnyConverter.isShort((Object)object)) {
            try {
                return AnyConverter.toShort((Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (AnyConverter.isVoid((Object)object) && bl) {
            return s;
        }
        throw new java.lang.IllegalArgumentException("invalid value for short: " + object);
    }

    public static short getShortProperty(Object object, String string) {
        return HelperUtilities.getShortValue(HelperUtilities.getProperty(object, string));
    }

    public static void setShortProperty(Object object, String string, Short s) {
        HelperUtilities.setProperty(object, string, s);
    }

    public static void setShortProperty(Object object, String string, short s) {
        HelperUtilities.setProperty(object, string, new Short(s));
    }

    public static long getLongValue(Object object) {
        return HelperUtilities.getLongValue(object, true, 0L);
    }

    public static long getLongValue(Object object, boolean bl, long l) {
        if (object == null) {
            if (bl) {
                return l;
            }
        } else if (AnyConverter.isLong((Object)object)) {
            try {
                return AnyConverter.toLong((Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (AnyConverter.isVoid((Object)object) && bl) {
            return l;
        }
        throw new java.lang.IllegalArgumentException("invalid value for long: " + object);
    }

    public static long getLongProperty(Object object, String string) {
        return HelperUtilities.getLongValue(HelperUtilities.getProperty(object, string));
    }

    public static void setLongProperty(Object object, String string, long l) {
        HelperUtilities.setProperty(object, string, new Long(l));
    }

    public static void setLongProperty(Object object, String string, Long l) {
        HelperUtilities.setProperty(object, string, l);
    }

    public static float getFloatValue(Object object) {
        return HelperUtilities.getFloatValue(object, true, 0.0f);
    }

    public static float getFloatValue(Object object, boolean bl, float f) {
        if (object == null) {
            if (bl) {
                return f;
            }
        } else if (AnyConverter.isFloat((Object)object)) {
            try {
                return AnyConverter.toFloat((Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (AnyConverter.isVoid((Object)object) && bl) {
            return f;
        }
        throw new java.lang.IllegalArgumentException("invalid value for float: " + object);
    }

    public static float getFloatProperty(Object object, String string) {
        Object object2 = HelperUtilities.getProperty(object, string);
        return HelperUtilities.getFloatValue(object2);
    }

    public static void setFloatProperty(Object object, String string, float f) {
        HelperUtilities.setProperty(object, string, new Float(f));
    }

    public static void setFloatProperty(Object object, String string, Float f) {
        HelperUtilities.setProperty(object, string, f);
    }

    public static String getStringValue(Object object) {
        return HelperUtilities.getStringValue(object, true, "");
    }

    public static String getStringValue(Object object, boolean bl, String string) {
        if (object == null) {
            if (bl) {
                return string;
            }
        } else if (AnyConverter.isString((Object)object)) {
            try {
                return AnyConverter.toString((Object)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        } else if (bl && AnyConverter.isVoid((Object)object)) {
            return string;
        }
        throw new IllegalStateException("PropertySet: Expected String, found " + object);
    }

    public static String getStringProperty(Object object, String string) {
        return HelperUtilities.getStringValue(HelperUtilities.getProperty(object, string));
    }

    public static void setStringProperty(Object object, String string, String string2) {
        HelperUtilities.setProperty(object, string, string2);
    }

    public static String getURLForFileName(String string) {
        String string2;
        Object object;
        if (string.startsWith("file:///")) {
            return string;
        }
        String string3 = null;
        URL uRL = null;
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 1) {
            if (n2 == n + 1) {
                try {
                    uRL = new URL(string);
                    string3 = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (n == "private".length() && string.startsWith("private")) {
                string3 = string;
            }
        } else if (string.indexOf(File.separatorChar) == -1) {
            object = HelperUtilities.getCurrentModel();
            string2 = null;
            if (object != null) {
                string2 = object.getURL();
                int n3 = string2.lastIndexOf(47);
                string2 = n3 != -1 ? string2.substring(0, n3) : "file://";
                string3 = string2 + "/" + string;
            }
        }
        if (string3 == null) {
            object = new File(string);
            string2 = ((File)object).getAbsolutePath();
            if (File.separatorChar == '\\' && (string2 = string2.replace('\\', '/')).charAt(1) == ':') {
                string2 = "/" + Character.toUpperCase(string2.charAt(0)) + string2.substring(1);
            }
            string3 = "file://" + string2;
        }
        return string3;
    }

    public static XModel findModelForURL(String string) {
        return HelperUtilities.findModelForURLOrName(string, false);
    }

    public static XModel findModelForName(String string) {
        return HelperUtilities.findModelForURLOrName(string, true);
    }

    private static XModel findModelForURLOrName(String string, boolean bl) {
        XEnumeration xEnumeration = ApplicationImpl.getXDesktop().getComponents().createEnumeration();
        HelperUtilities.debug("Looking for URL " + string);
        while (xEnumeration.hasMoreElements()) {
            try {
                XComponent xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? HelperUtilities.class$("com.sun.star.lang.XComponent") : class$com$sun$star$lang$XComponent), (Object)xEnumeration.nextElement());
                if (!DocumentUtilities.isComponentDocument(xComponent)) continue;
                XStorable xStorable = (XStorable)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XStorable == null ? HelperUtilities.class$("com.sun.star.frame.XStorable") : class$com$sun$star$frame$XStorable), (Object)xComponent);
                String string2 = xStorable.getLocation();
                if (bl) {
                    if (HelperUtilities.compareFileNameToURL(string, string2)) {
                        HelperUtilities.debug(" Found Name " + string + " = " + string2);
                        return (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = HelperUtilities.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), (Object)xStorable);
                    }
                } else if (HelperUtilities.compareURLs(string, string2)) {
                    HelperUtilities.debug(" Found URL " + string2);
                    return (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = HelperUtilities.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), (Object)xStorable);
                }
                HelperUtilities.debug(" Checked URL " + string2);
            }
            catch (Exception exception) {
                HelperUtilities.exception(exception);
            }
        }
        return null;
    }

    public static XModel openDocument(String string) throws IOException {
        return HelperUtilities.openDocument(string, false, false);
    }

    public static XModel openDocument(String string, boolean bl, boolean bl2) throws IOException {
        Object object;
        XModel xModel;
        String string2 = HelperUtilities.getURLForFileName(string);
        if (!bl2 && (xModel = HelperUtilities.findModelForURL(string2)) != null) {
            return xModel;
        }
        xModel = (XComponentLoader)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XComponentLoader == null ? (class$com$sun$star$frame$XComponentLoader = HelperUtilities.class$("com.sun.star.frame.XComponentLoader")) : class$com$sun$star$frame$XComponentLoader), (Object)ApplicationImpl.getXDesktop());
        XComponent xComponent = null;
        try {
            if (string2 != null) {
                object = new PropertyValue();
                object.Name = "MacroExecutionMode";
                object.Value = new Short(4);
                PropertyValue propertyValue = new PropertyValue();
                propertyValue.Name = "Hidden";
                propertyValue.Value = new Boolean(bl);
                PropertyValue[] propertyValueArray = new PropertyValue[]{object, propertyValue};
                xComponent = xModel.loadComponentFromURL(string2, "_blank", 0, propertyValueArray);
            }
        }
        catch (IOException iOException) {
            HelperUtilities.exception(0, iOException);
            throw iOException;
        }
        catch (Exception exception) {
            HelperUtilities.exception(0, exception);
        }
        if (xComponent == null) {
            object = new IOException("Error opening " + string2 + " for document " + string);
            HelperUtilities.exception(0, (Throwable)object);
            throw object;
        }
        return (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = HelperUtilities.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), xComponent);
    }

    public static boolean isDocumentFrame(XFrame xFrame) {
        String string = xFrame.getName();
        int n = 0;
        while (n < BAD_FRAMES.length) {
            if (BAD_FRAMES[n].equals(string)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static synchronized void appendOpenWindows(String string, List list) {
        try {
            XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XFramesSupplier == null ? (class$com$sun$star$frame$XFramesSupplier = HelperUtilities.class$("com.sun.star.frame.XFramesSupplier")) : class$com$sun$star$frame$XFramesSupplier), (Object)ApplicationImpl.getXDesktop());
            XFrame[] xFrameArray = xFramesSupplier.getFrames().queryFrames(4);
            int n = 0;
            while (n < xFrameArray.length) {
                if (HelperUtilities.isDocumentFrame(xFrameArray[n])) {
                    if (string == null) {
                        list.add(xFrameArray[n]);
                    } else {
                        String string2 = DocumentUtilities.getModelDocumentType(xFrameArray[n].getController().getModel());
                        if (string2 != null && string2.equals(string)) {
                            list.add(xFrameArray[n]);
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public static synchronized void appendOpenDocumentWindows(List list, XModel xModel) {
        try {
            XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XFramesSupplier == null ? (class$com$sun$star$frame$XFramesSupplier = HelperUtilities.class$("com.sun.star.frame.XFramesSupplier")) : class$com$sun$star$frame$XFramesSupplier), (Object)ApplicationImpl.getXDesktop());
            XFrame[] xFrameArray = xFramesSupplier.getFrames().queryFrames(4);
            int n = 0;
            while (n < xFrameArray.length) {
                if (HelperUtilities.isDocumentFrame(xFrameArray[n]) && xModel == xFrameArray[n].getController().getModel()) {
                    list.add(xFrameArray[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public static synchronized boolean close(String string, int n, int n2, boolean bl) {
        XEnumeration xEnumeration = ApplicationImpl.getXDesktop().getComponents().createEnumeration();
        boolean bl2 = true;
        while (xEnumeration.hasMoreElements()) {
            try {
                XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? HelperUtilities.class$("com.sun.star.frame.XModel") : class$com$sun$star$frame$XModel), (Object)xEnumeration.nextElement());
                boolean bl3 = false;
                if (string == null) {
                    bl3 = true;
                } else {
                    String string2 = DocumentUtilities.getModelDocumentType(xModel);
                    if (string2 != null && string2.equals(string)) {
                        bl3 = true;
                    }
                }
                if (bl3) {
                    if (bl) {
                        // empty if block
                    }
                    if (DocumentUtilities.closeDocument(xModel, n, n2)) continue;
                    bl2 = false;
                    continue;
                }
                bl2 = false;
            }
            catch (Exception exception) {
                HelperUtilities.exception(exception);
            }
        }
        return bl2;
    }

    public static synchronized void exit(String string, int n, int n2, boolean bl) {
        boolean bl2 = HelperUtilities.close(string, n, n2, bl);
        if (string == null && bl2) {
            ApplicationImpl.getXDesktop().terminate();
        }
    }

    public static XModel getCurrentModel() {
        ApplicationImpl.getInstance();
        XComponent xComponent = ApplicationImpl.getXDesktop().getCurrentComponent();
        try {
            return (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = HelperUtilities.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel), (Object)xComponent);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
            return null;
        }
    }

    public static void announce(PrintStream printStream) {
        printStream.println("Helper log: " + new Date().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    HelperUtilities.configureProp(string, (String)hashtable.get(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        HelperUtilities.announce(out);
    }

    public static void configureProp(String string, String string2) {
        block6: {
            try {
                String string3;
                if (!string.startsWith(PROP_PREFIX)) break block6;
                Field field = (class$com$sun$star$helper$HelperUtilities == null ? (class$com$sun$star$helper$HelperUtilities = HelperUtilities.class$("com.sun.star.helper.HelperUtilities")) : class$com$sun$star$helper$HelperUtilities).getField(string3 = string.substring(PROP_PREFIX.length()));
                if (field.getType().equals(Integer.TYPE)) {
                    int n = Integer.parseInt(string2);
                    field.setInt(null, n);
                    break block6;
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    boolean bl = string2.equals("true");
                    field.setBoolean(null, bl);
                    break block6;
                }
                if (!field.getType().equals(class$java$io$PrintStream == null ? (class$java$io$PrintStream = HelperUtilities.class$("java.io.PrintStream")) : class$java$io$PrintStream)) break block6;
                try {
                    PrintStream printStream;
                    FileOutputStream fileOutputStream = new FileOutputStream(string2);
                    out = printStream = new PrintStream(fileOutputStream);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void print(String string) {
        out.print(string);
    }

    public static void println(String string) {
        out.println(string);
    }

    public static boolean isDebugEnabled(int n) {
        return bDebug && n <= iDebugLevel;
    }

    public static void info(int n, String string) {
        if (n > iDebugLevel) {
            return;
        }
        if (bInfo) {
            out.println(PRINT_PREFIX + PRINT_PREFIX_INFO + string);
        }
    }

    public static void error(int n, String string) {
        if (n > iDebugLevel) {
            return;
        }
        if (bError) {
            out.println(PRINT_PREFIX + PRINT_PREFIX_ERROR + string + (bStackOnError ? " - Stack:" : ""));
            if (bStackOnError) {
                Throwable throwable = new Throwable();
                throwable.printStackTrace(out);
            }
        }
    }

    public static void debug(int n, String string) {
        if (n > iDebugLevel) {
            return;
        }
        if (bDebug) {
            out.println(PRINT_PREFIX + PRINT_PREFIX_DEBUG + string);
        }
    }

    public static void debugWithStack(int n, String string) {
        if (n > iDebugLevel) {
            return;
        }
        if (bDebug) {
            out.println(PRINT_PREFIX + PRINT_PREFIX_DEBUG + string + " - Stack:");
            Throwable throwable = new Throwable();
            throwable.printStackTrace(out);
        }
    }

    public static void debugMore(int n, String string) {
        if (n > iDebugLevel) {
            return;
        }
        if (bDebugMore) {
            out.println("+" + string);
        }
    }

    public static void exception(int n, Throwable throwable, String string) {
        if (n > iDebugLevel) {
            return;
        }
        if (bExceptionTitle) {
            out.println(PRINT_PREFIX + " Exception: " + throwable);
        }
        HelperUtilities.debug(n, string);
        if (bExceptionTrace) {
            throwable.printStackTrace(out);
        }
    }

    public static void exception(int n, Throwable throwable) {
        if (n > iDebugLevel) {
            return;
        }
        if (bExceptionTitle) {
            out.println(PRINT_PREFIX + " Exception: " + throwable);
        }
        if (bExceptionTrace) {
            throwable.printStackTrace(out);
        }
    }

    public static void info(String string) {
        HelperUtilities.info(0, string);
    }

    public static void error(String string) {
        HelperUtilities.error(0, string);
    }

    public static void debugWithStack(String string) {
        HelperUtilities.debugWithStack(0, string);
    }

    public static void debug(String string) {
        HelperUtilities.debug(0, string);
    }

    public static void debugMore(String string) {
        HelperUtilities.debugMore(0, string);
    }

    public static void exception(Throwable throwable, String string) {
        HelperUtilities.debug(0, string);
        HelperUtilities.exception(0, throwable);
    }

    public static void exception(Throwable throwable) {
        HelperUtilities.exception(0, throwable);
    }

    public static boolean compareURLs(String string, String string2) {
        if (File.separatorChar == '/') {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean compareFileNameToURL(String string, String string2) {
        String string3 = string2.substring(string2.lastIndexOf(47) + 1);
        if (File.separatorChar == '/') {
            return string.equals(string3);
        }
        return string.equalsIgnoreCase(string3);
    }

    public static synchronized void appendOpenComponents(String string, List list) {
        XEnumeration xEnumeration = ApplicationImpl.getXDesktop().getComponents().createEnumeration();
        while (xEnumeration.hasMoreElements()) {
            try {
                Object object = xEnumeration.nextElement();
                XModel xModel = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? HelperUtilities.class$("com.sun.star.frame.XModel") : class$com$sun$star$frame$XModel), (Object)object);
                boolean bl = false;
                if (string == null) {
                    bl = true;
                } else {
                    String string2 = DocumentUtilities.getModelDocumentType(xModel);
                    if (string2 != null && string2.equals(string)) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                int n = 0;
                while (n < list.size()) {
                    if (list.get(n) == xModel) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
                if (!bl) continue;
                list.add(xModel);
            }
            catch (Exception exception) {
                HelperUtilities.exception(exception);
            }
        }
    }

    public static synchronized void appendOpenDocumentComponents(List list, XModel xModel) {
        try {
            XEnumeration xEnumeration = ApplicationImpl.getXDesktop().getComponents().createEnumeration();
            while (xEnumeration.hasMoreElements()) {
                XComponent xComponent;
                XModel xModel2 = (XModel)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XModel == null ? HelperUtilities.class$("com.sun.star.frame.XModel") : class$com$sun$star$frame$XModel), (Object)(xComponent = (XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? HelperUtilities.class$("com.sun.star.lang.XComponent") : class$com$sun$star$lang$XComponent), (Object)xEnumeration.nextElement())));
                if (xModel != xModel2) continue;
                list.add(xComponent);
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public static void MessageBox(String string) {
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("os.name");
        JOptionPane.showMessageDialog(null, string, string2 + " - " + string3, 1);
    }

    public static String getModelDocumentType(XModel xModel) {
        return DocumentUtilities.getModelDocumentType(xModel);
    }

    public static boolean closeDocument(XModel xModel, int n, int n2) throws BasicErrorException {
        return DocumentUtilities.closeDocument(xModel, n, n2);
    }

    public static boolean isModified(XModel xModel) {
        return DocumentUtilities.isModified(xModel);
    }

    public static boolean isComponentDocument(Object object) {
        return DocumentUtilities.isComponentDocument(object);
    }

    public static void saveDocument(XModel xModel, boolean bl) throws BasicErrorException {
        DocumentUtilities.saveDocument(xModel, bl);
    }

    public static void saveDocument(XModel xModel) throws BasicErrorException {
        DocumentUtilities.saveDocument(xModel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

