/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper;

import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentInfo;
import com.sun.star.document.XDocumentInfoSupplier;
import com.sun.star.helper.DocumentPropertyImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XDocumentProperties;
import com.sun.star.helper.XDocumentProperty;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertiesMapping;
import com.sun.star.helper.common.UNOUtility;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NullPointerException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;

public class DocumentPropertiesImpl
extends HelperInterfaceAdaptor
implements XDocumentProperties {
    private static final String[][] MSO2SO_MAPPING = new String[][]{{"Title", "Title"}, {"Subject", "Subject"}, {"Author", "Author"}, {"Keywords", "Keywords"}, {"Comments", "Description"}, {"Template", "Template"}, {"Last author", ":"}, {"Revision number", ".1"}, {"Application name", "Generator"}, {"Last print date", "PrintDate"}, {"Creation date", "CreationDate"}, {"Last save time", "ModifyDate"}, {"Total editing time", ".0"}, {"Number of pages", "!nPAGES"}, {"Number of words", "!nWORDS"}, {"Number of characters", "!nCHARACTERS"}, {"Security", "%.0"}, {"Category", "%:"}, {"Format", "!FORMAT"}, {"Manager", "%:"}, {"Company", "%:"}, {"Number of bytes", "!nBYTES"}, {"Number of lines", "!nLINES"}, {"Number of paragraphs", "!nPARAGRAPHS"}, {"Number of slides", ":0"}, {"Number of notes", "!nNOTES"}, {"Number of hidden Slides", ".0"}, {"Number of multimedia clips", ".0"}, {"Hyperlink base", "AutoloadURL"}};
    private DocumentPropertyImpl[] cacheProperties;
    private XPropertySet builtInProperties;
    private XDocumentInfo customProperties;
    private boolean forceUpdate;
    private final PropertiesMapping mso2SOMapping;
    static /* synthetic */ Class class$com$sun$star$document$XDocumentInfoSupplier;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;

    public DocumentPropertiesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, boolean bl) {
        super(null, helperInterfaceAdaptor);
        XDocumentInfoSupplier xDocumentInfoSupplier = (XDocumentInfoSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$document$XDocumentInfoSupplier == null ? (class$com$sun$star$document$XDocumentInfoSupplier = DocumentPropertiesImpl.class$("com.sun.star.document.XDocumentInfoSupplier")) : class$com$sun$star$document$XDocumentInfoSupplier), (Object)helperInterfaceAdaptor.getXModel());
        XDocumentInfo xDocumentInfo = xDocumentInfoSupplier.getDocumentInfo();
        if (bl) {
            this.customProperties = xDocumentInfo;
            this.mso2SOMapping = null;
        } else {
            this.builtInProperties = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DocumentPropertiesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)xDocumentInfo);
            this.mso2SOMapping = new PropertiesMapping(MSO2SO_MAPPING, this.builtInProperties);
            UNOUtility.printInterfaceNames("Document Properties", this.builtInProperties, HelperUtilities.out);
        }
    }

    public XHelperInterface getParent() {
        return this.getParentAdaptor();
    }

    void deleteProperty(int n) {
        if (!this.isCustom()) {
            throw new java.lang.IllegalArgumentException("Cannot delete a built-in property");
        }
        try {
            this.updateCustomCache();
            this.customProperties.setUserFieldValue((short)n, "");
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    void renameProperty(int n, String string) {
        if (!this.isCustom()) {
            throw new java.lang.IllegalArgumentException("Cannot delete a built-in property");
        }
        try {
            this.updateCustomCache();
            this.customProperties.setUserFieldName((short)(--n), string);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    boolean isCustom() {
        return this.builtInProperties == null;
    }

    public int Count() {
        if (this.isCustom()) {
            return this.customProperties.getUserFieldCount();
        }
        return this.mso2SOMapping.size();
    }

    private String getLocalizedIndexErrorMessage(int n) {
        return "Invalid property index '" + n + "'";
    }

    private String getLocalizedNameErrorMessage(String string) {
        return "Unknown property '" + string + "'";
    }

    private byte getBuiltInPropertyType(String string) {
        if (string.endsWith("date") || string.endsWith("time")) {
            return 3;
        }
        if (string.startsWith("Number") || string.equals("Security")) {
            return 1;
        }
        return 4;
    }

    private byte getCustomPropertyType(String string) {
        if (string == null) {
            return -1;
        }
        return 4;
    }

    private String getCustomPropertyName(String string) {
        return string;
    }

    private void updateCache() {
        if (this.isCustom()) {
            this.updateCustomCache();
        } else {
            this.updateBuiltInCache();
        }
    }

    private void initCacheArray() {
        if (this.cacheProperties == null) {
            this.cacheProperties = new DocumentPropertyImpl[this.Count()];
        }
    }

    private void removeProperty(int n) {
        int n2;
        if (this.cacheProperties == null || this.cacheProperties.length < n) {
            return;
        }
        DocumentPropertyImpl[] documentPropertyImplArray = new DocumentPropertyImpl[this.cacheProperties.length - 1];
        if (n > 0) {
            System.arraycopy(this.cacheProperties, 0, documentPropertyImplArray, 0, n);
        }
        if ((n2 = this.cacheProperties.length - (n + 1)) > 0) {
            System.arraycopy(this.cacheProperties, n + 1, documentPropertyImplArray, n, n2);
        }
        this.cacheProperties = documentPropertyImplArray;
    }

    private void updateBuiltInCache() {
        this.initCacheArray();
    }

    private void updateCustomCache() {
        if (this.cacheProperties == null) {
            this.initCacheArray();
        } else if (!this.forceUpdate && this.customProperties.getUserFieldCount() == this.cacheProperties.length) {
            return;
        }
        int n = this.customProperties.getUserFieldCount();
        DocumentPropertyImpl documentPropertyImpl = null;
        try {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                String string = this.customProperties.getUserFieldName((short)n3);
                string = this.getCustomPropertyName(string);
                while (n2 < this.cacheProperties.length) {
                    documentPropertyImpl = this.cacheProperties[n2];
                    if (documentPropertyImpl == null || string.equals(documentPropertyImpl.getName())) break;
                    documentPropertyImpl.setIndex(-1);
                    this.removeProperty(n2);
                }
                if (n3 != n2) {
                    n2 = n3;
                }
                if (documentPropertyImpl == null) {
                    this.cacheProperties[n3] = new DocumentPropertyImpl(this, this.getCustomPropertyType(string), string, n3);
                    ++n2;
                } else {
                    documentPropertyImpl.setIndex(n3);
                    documentPropertyImpl = null;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
    }

    public void refreshCachedValues() {
        this.forceUpdate = true;
        this.updateCache();
        int n = 0;
        while (n < this.cacheProperties.length) {
            DocumentPropertyImpl documentPropertyImpl = this.getPropertyObject(n);
            documentPropertyImpl.setPropertyValue(this.getPropertyValue(n));
            ++n;
        }
        this.forceUpdate = false;
    }

    private int findCustomIndex(String string) {
        int n = 0;
        while (n < this.cacheProperties.length) {
            DocumentPropertyImpl documentPropertyImpl = this.cacheProperties[n];
            if (string.equals(documentPropertyImpl.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    Object setPropertyValue(DocumentPropertyImpl documentPropertyImpl, Object object) {
        try {
            if (this.isCustom()) {
                this.customProperties.setUserFieldValue((short)documentPropertyImpl.getIndex(), object.toString());
            } else {
                this.builtInProperties.setPropertyValue(MSO2SO_MAPPING[documentPropertyImpl.getIndex()][1], object);
            }
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
        }
        documentPropertyImpl.setPropertyValue(object);
        return object;
    }

    private Integer getCalculatedProperty(String string) {
        string = string.substring(2);
        if (this.getParent() instanceof XDocument) {
            DocumentImpl documentImpl = (DocumentImpl)this.getParent();
            switch (string.charAt(0)) {
                case 'B': {
                    return new Integer(documentImpl.getStatisticLineCount(1) * 2);
                }
                case 'C': {
                    return new Integer(documentImpl.getStatisticLineCount(1));
                }
                case 'L': {
                    return new Integer(documentImpl.getStatisticLineCount(5));
                }
                case 'N': {
                    return HelperUtilities.INTEGER_ZERO;
                }
                case 'P': {
                    switch (string.charAt(2)) {
                        case 'G': {
                            return new Integer(documentImpl.getStatisticLineCount(7));
                        }
                        case 'R': {
                            return new Integer(documentImpl.getStatisticLineCount(4));
                        }
                    }
                    return HelperUtilities.INTEGER_ZERO;
                }
                case 'W': {
                    return new Integer(documentImpl.getStatisticLineCount(2));
                }
            }
            return HelperUtilities.INTEGER_ZERO;
        }
        return HelperUtilities.INTEGER_ZERO;
    }

    private Object getPropertyValue(int n) {
        try {
            if (this.isCustom()) {
                return this.customProperties.getUserFieldValue((short)n);
            }
            String string = MSO2SO_MAPPING[n][1];
            char c = string.charAt(0);
            if (c == '%') {
                string = string.substring(1);
                c = string.charAt(0);
            }
            switch (c) {
                case '!': {
                    return this.getCalculatedProperty(string);
                }
                case ':': {
                    return string.substring(1);
                }
                case '.': {
                    return Integer.valueOf(string.substring(1));
                }
            }
            return this.builtInProperties.getPropertyValue(string);
        }
        catch (Exception exception) {
            HelperUtilities.exception(0, exception, "should never happen");
            throw new java.lang.IllegalArgumentException(this.getLocalizedIndexErrorMessage(n));
        }
    }

    private DocumentPropertyImpl getPropertyObject(int n) {
        DocumentPropertyImpl documentPropertyImpl = this.cacheProperties[n];
        if (documentPropertyImpl == null) {
            if (this.isCustom()) {
                DebugHelper.warning((com.sun.star.uno.Exception)new NullPointerException("isCustom() is set."));
                return null;
            }
            String string = MSO2SO_MAPPING[n][0];
            this.cacheProperties[n] = documentPropertyImpl = new DocumentPropertyImpl(this, this.getBuiltInPropertyType(string), string, n);
        }
        return documentPropertyImpl;
    }

    private DocumentPropertyImpl addCustomProperty(String string) {
        int n = this.cacheProperties.length;
        DocumentPropertyImpl[] documentPropertyImplArray = new DocumentPropertyImpl[n + 1];
        System.arraycopy(this.cacheProperties, 0, documentPropertyImplArray, 0, n);
        documentPropertyImplArray[n] = new DocumentPropertyImpl(this, 4, string, n);
        this.cacheProperties = documentPropertyImplArray;
        return this.cacheProperties[n];
    }

    public DocumentPropertyImpl getProperty(String string, boolean bl) {
        this.updateCache();
        int n = this.isCustom() ? this.findCustomIndex(string) : this.mso2SOMapping.findMSOIndex(string);
        if (n == -1) {
            throw new java.lang.IllegalArgumentException(this.getLocalizedNameErrorMessage(string));
        }
        DocumentPropertyImpl documentPropertyImpl = this.getPropertyObject(n);
        if (bl || documentPropertyImpl.getValue() == null) {
            documentPropertyImpl.setValue(this.getPropertyValue(n));
        }
        return documentPropertyImpl;
    }

    public DocumentPropertyImpl getProperty(int n, boolean bl) {
        this.updateCache();
        if (--n < 0 || n >= this.cacheProperties.length) {
            throw new java.lang.IllegalArgumentException(this.getLocalizedIndexErrorMessage(n + 1));
        }
        DocumentPropertyImpl documentPropertyImpl = this.getPropertyObject(n);
        if (bl || documentPropertyImpl.getValue() == null) {
            documentPropertyImpl.setValue(this.getPropertyValue(n));
        }
        return documentPropertyImpl;
    }

    public XDocumentProperty Item(Object object) {
        DocumentPropertyImpl documentPropertyImpl;
        block3: {
            documentPropertyImpl = null;
            if (object == null || AnyConverter.isVoid((Object)object)) break block3;
            try {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    documentPropertyImpl = this.getProperty(string, false);
                    break block3;
                }
                int n = (int)OptionalParamUtility.getAnyNumber("Index", object, 1L, true);
                documentPropertyImpl = this.getProperty(n, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        }
        return documentPropertyImpl;
    }

    public XDocumentProperty Add(String string, boolean bl, byte by, Object object) {
        if (!this.isCustom()) {
            throw new IllegalStateException("Cannot add property '" + string + "' to built-in properties (use CustomDocumentProperties)");
        }
        this.updateCache();
        DocumentPropertyImpl documentPropertyImpl = this.addCustomProperty(string);
        short s = this.customProperties.getUserFieldCount();
        try {
            this.customProperties.setUserFieldName((short)documentPropertyImpl.getIndex(), string);
            this.customProperties.setUserFieldValue((short)documentPropertyImpl.getIndex(), string);
        }
        catch (Exception exception) {
            HelperUtilities.exception(exception);
            throw new IllegalStateException("Unable to create custom property " + string);
        }
        if (this.customProperties.getUserFieldCount() != s + 1) {
            HelperUtilities.debug("Failed to add custom property " + string + "; prop count is still " + this.customProperties.getUserFieldCount());
        }
        documentPropertyImpl.setLinkToContent(bl);
        documentPropertyImpl.setType(by);
        if (bl) {
            documentPropertyImpl.setLinkSource(object);
        }
        return documentPropertyImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

