/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;
import com.sun.star.wizards.db.FieldColumn;
import java.util.HashMap;
import java.util.Vector;

public class QueryMetaData
extends CommandMetaData {
    public Vector QueryFields;
    FieldColumn CurFieldColumn;
    public String Command;
    Vector CommandNames;
    public PropertyValue[][] FilterConditions = new PropertyValue[0][];
    public PropertyValue[][] GroupByFilterConditions = new PropertyValue[0][];
    public String[] FieldTitles = new String[0];
    public String[] UniqueAggregateFieldNames = new String[0];
    public int Type = 1;

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory, Locale locale, NumberFormatter numberFormatter) {
        super(xMultiServiceFactory, locale, numberFormatter);
        this.QueryFields = new Vector(0);
    }

    public QueryMetaData(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory);
        this.QueryFields = new Vector(0);
    }

    public void setFilterConditions(PropertyValue[][] propertyValueArray) {
        this.FilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getFilterConditions() {
        return this.FilterConditions;
    }

    public void setGroupByFilterConditions(PropertyValue[][] propertyValueArray) {
        this.GroupByFilterConditions = propertyValueArray;
    }

    public PropertyValue[][] getGroupByFilterConditions() {
        return this.GroupByFilterConditions;
    }

    public Vector getQueryFields() {
        return this.QueryFields;
    }

    void removeQueryField() {
    }

    public void setFieldNames(String[] stringArray, XNameAccess xNameAccess) {
        int n = stringArray.length;
        this.FieldNames = new String[n];
        this.QueryFields.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this.CurFieldColumn = new FieldColumn((CommandMetaData)this, xNameAccess, stringArray[n2]);
            this.QueryFields.add(this.QueryFields.size(), this.CurFieldColumn);
            this.FieldNames[n2] = stringArray[n2];
            ++n2;
        }
    }

    public void setFieldNames(String[] stringArray) {
        int n = stringArray.length;
        this.FieldNames = new String[n];
        this.QueryFields.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this.CurFieldColumn = new FieldColumn(this, stringArray[n2]);
            this.QueryFields.add(this.QueryFields.size(), this.CurFieldColumn);
            this.FieldNames[n2] = stringArray[n2];
            if (this.FieldTitleSet != null && this.FieldTitleSet.containsKey(this.FieldNames[n2])) {
                this.CurFieldColumn.AliasName = (String)this.FieldTitleSet.get(this.FieldNames[n2]);
                if (this.CurFieldColumn.AliasName == null) {
                    this.CurFieldColumn.AliasName = stringArray[n2];
                    this.FieldTitleSet.put(this.FieldNames[n2], stringArray[n2]);
                }
            }
            ++n2;
        }
    }

    public String[] getIncludedCommandNames() {
        this.CommandNames = new Vector(1);
        int n = 0;
        while (n < this.QueryFields.size()) {
            FieldColumn fieldColumn = (FieldColumn)this.QueryFields.elementAt(n);
            String string = fieldColumn.getCommandName();
            if (!this.CommandNames.contains(string)) {
                this.CommandNames.addElement(string);
            }
            ++n;
        }
        String[] stringArray = new String[this.CommandNames.size()];
        this.CommandNames.toArray(stringArray);
        return stringArray;
    }

    public static String[] getIncludedCommandNames(String[] stringArray) {
        Object object;
        Vector<String[]> vector = new Vector<String[]>(1);
        int n = 0;
        while (n < stringArray.length) {
            object = "";
            String[] stringArray2 = JavaTools.ArrayoutofString(stringArray[n], ".");
            if (stringArray2.length > 1) {
                int n2 = 0;
                while (n2 < stringArray2.length - 1) {
                    object = (String)object + stringArray2[n2];
                    ++n2;
                }
                if (!vector.contains(object)) {
                    vector.addElement((String[])object);
                }
            }
            ++n;
        }
        object = new String[vector.size()];
        vector.toArray((T[])object);
        return object;
    }

    public String[] getAllFieldNames() {
        return this.AllFieldNames;
    }

    public void setAllIncludedFieldNames(boolean bl) {
        try {
            this.getIncludedCommandNames();
            if (this.FieldTitleSet == null) {
                this.FieldTitleSet = new HashMap();
            }
            int n = 0;
            while (n < this.CommandNames.size()) {
                DBMetaData.CommandObject commandObject = this.getTableByName((String)this.CommandNames.elementAt(n));
                String[] stringArray = commandObject.xColumns.getElementNames();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    String string = "";
                    string = bl ? (String)this.CommandNames.elementAt(n) + "." + stringArray[n2] : stringArray[n2];
                    if (!this.FieldTitleSet.containsKey(string)) {
                        this.FieldTitleSet.put(string, null);
                    }
                    ++n2;
                }
                ++n;
            }
            this.FieldTitleSet.keySet().toArray(this.AllFieldNames);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public FieldColumn getFieldColumnByDisplayName(String string) {
        int n = 0;
        while (n < this.QueryFields.size()) {
            FieldColumn fieldColumn = (FieldColumn)this.QueryFields.elementAt(n);
            if (fieldColumn.DisplayFieldName.equals(string)) {
                return fieldColumn;
            }
            ++n;
        }
        return null;
    }

    public String[] getUniqueAggregateFieldNames() {
        Vector<String> vector = new Vector<String>(0);
        int n = 0;
        while (n < this.AggregateFieldNames.length) {
            if (!vector.contains(this.AggregateFieldNames[n][0])) {
                vector.add(this.AggregateFieldNames[n][0]);
            }
            ++n;
        }
        this.UniqueAggregateFieldNames = new String[vector.size()];
        vector.toArray(this.UniqueAggregateFieldNames);
        return this.UniqueAggregateFieldNames;
    }

    public boolean hasNumericalFields() {
        FieldColumn fieldColumn = null;
        int n = 0;
        while (n < this.QueryFields.size()) {
            fieldColumn = (FieldColumn)this.QueryFields.elementAt(n);
            if (fieldColumn.bIsNumberFormat) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void setfieldtitles() {
        this.FieldTitles = new String[this.FieldNames.length];
        int n = 0;
        while (n < this.FieldNames.length) {
            if (this.FieldTitleSet.containsKey(this.FieldNames[n])) {
                String string = (String)this.FieldTitleSet.get(this.FieldNames[n]);
                if (string == null || string.equals(this.FieldNames[n])) {
                    string = this.FieldNames[n];
                } else {
                    this.CurFieldColumn = this.getFieldColumnByDisplayName(this.FieldNames[n]);
                    this.CurFieldColumn.AliasName = string;
                }
                this.FieldTitles[n] = string;
            }
            ++n;
        }
    }

    public int getAggregateIndex(String string) {
        int n = -1;
        if (this.Type == 0) {
            n = JavaTools.FieldInTable(this.AggregateFieldNames, string);
        }
        return n;
    }

    public String getFieldName(String string) {
        int n = JavaTools.FieldInList(this.FieldTitles, string);
        if (n > -1) {
            return this.FieldNames[n];
        }
        return null;
    }

    public static interface QueryType {
        public static final int SOSUMMARYQUERY = 0;
        public static final int SODETAILQUERY = 1;
    }
}

