/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.util.registry;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.DocumentDeserializerFactory;
import org.openoffice.xmerge.DocumentMergerFactory;
import org.openoffice.xmerge.DocumentSerializerFactory;
import org.openoffice.xmerge.PluginFactory;
import org.openoffice.xmerge.util.registry.RegistryException;

public class ConverterInfo {
    private static String[] validOfficeTypes;
    public static String SxwType;
    public static String SxcType;
    private String piJarName;
    private String piOfficeMime;
    private Vector piDeviceMime;
    private String piDisplayName;
    private String piDescription;
    private String piVersion;
    private String piVendor;
    private String piClassImpl;
    private String piXsltSerial;
    private String piXsltDeserial;
    private boolean piCanSerialize = false;
    private boolean piCanDeserialize = false;
    private boolean piCanMerge = false;
    private ClassLoader piClassLoader = null;
    private PluginFactory piPluginFactory;
    static /* synthetic */ Class class$org$openoffice$xmerge$util$registry$ConverterInfo;

    public ConverterInfo(String string, String string2, Vector vector, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws RegistryException {
        if (!ConverterInfo.isValidOfficeType(string2.trim())) {
            RegistryException registryException = new RegistryException("Invalid office type");
            throw registryException;
        }
        this.piJarName = string.trim();
        this.piOfficeMime = string2.trim();
        this.piDeviceMime = vector;
        this.piDisplayName = string3.trim();
        this.piDescription = string4.trim();
        this.piVersion = string5.trim();
        this.piVendor = string6.trim();
        this.piXsltSerial = string8.trim();
        this.piXsltDeserial = string9.trim();
        this.piClassImpl = string7.trim();
        this.piClassLoader = this.getClass().getClassLoader();
        try {
            URL uRL = new URL(string);
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, this.piClassLoader);
            Class<?> clazz = uRLClassLoader.loadClass(this.piClassImpl);
            Class[] classArray = new Class[]{class$org$openoffice$xmerge$util$registry$ConverterInfo == null ? (class$org$openoffice$xmerge$util$registry$ConverterInfo = ConverterInfo.class$("org.openoffice.xmerge.util.registry.ConverterInfo")) : class$org$openoffice$xmerge$util$registry$ConverterInfo};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            this.piPluginFactory = (PluginFactory)constructor.newInstance(objectArray);
            Class<?>[] classArray2 = this.piPluginFactory.getClass().getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                if (classArray2[n].getName().equals("org.openoffice.xmerge.DocumentSerializerFactory")) {
                    this.piCanSerialize = true;
                }
                if (classArray2[n].getName().equals("org.openoffice.xmerge.DocumentDeserializerFactory")) {
                    this.piCanDeserialize = true;
                }
                if (classArray2[n].getName().equals("org.openoffice.xmerge.DocumentMergerFactory")) {
                    this.piCanMerge = true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            RegistryException registryException = new RegistryException("Class implementation of the plug-in cannot be loaded.");
            throw registryException;
        }
    }

    public ConverterInfo(String string, String string2, Vector vector, String string3, String string4, String string5, String string6, String string7) throws RegistryException {
        if (!ConverterInfo.isValidOfficeType(string2.trim())) {
            RegistryException registryException = new RegistryException("Invalid office type");
            throw registryException;
        }
        this.piJarName = string.trim();
        this.piOfficeMime = string2.trim();
        this.piDeviceMime = vector;
        this.piDisplayName = string3.trim();
        this.piDescription = string4.trim();
        this.piVersion = string5.trim();
        this.piVendor = string6.trim();
        this.piClassImpl = string7.trim();
        this.piClassLoader = this.getClass().getClassLoader();
        try {
            URL uRL = new URL(string);
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, this.piClassLoader);
            Class<?> clazz = uRLClassLoader.loadClass(this.piClassImpl);
            Class[] classArray = new Class[]{class$org$openoffice$xmerge$util$registry$ConverterInfo == null ? (class$org$openoffice$xmerge$util$registry$ConverterInfo = ConverterInfo.class$("org.openoffice.xmerge.util.registry.ConverterInfo")) : class$org$openoffice$xmerge$util$registry$ConverterInfo};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{this};
            this.piPluginFactory = (PluginFactory)constructor.newInstance(objectArray);
            Class<?>[] classArray2 = this.piPluginFactory.getClass().getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                if (classArray2[n].getName().equals("org.openoffice.xmerge.DocumentSerializerFactory")) {
                    this.piCanSerialize = true;
                }
                if (classArray2[n].getName().equals("org.openoffice.xmerge.DocumentDeserializerFactory")) {
                    this.piCanDeserialize = true;
                }
                if (classArray2[n].getName().equals("org.openoffice.xmerge.DocumentMergerFactory")) {
                    this.piCanMerge = true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            RegistryException registryException = new RegistryException("Class implementation of the plug-in cannot be loaded.");
            throw registryException;
        }
    }

    private ConverterInfo() {
    }

    public DocumentSerializerFactory getDocSerializerFactory() {
        return (DocumentSerializerFactory)((Object)this.piPluginFactory);
    }

    public DocumentDeserializerFactory getDocDeserializerFactory() {
        return (DocumentDeserializerFactory)((Object)this.piPluginFactory);
    }

    public DocumentMergerFactory getDocMergerFactory() {
        return (DocumentMergerFactory)((Object)this.piPluginFactory);
    }

    public String getJarName() {
        return this.piJarName;
    }

    public String getOfficeMime() {
        return this.piOfficeMime;
    }

    public Enumeration getDeviceMime() {
        return this.piDeviceMime.elements();
    }

    public String getDisplayName() {
        return this.piDisplayName;
    }

    public String getDescription() {
        return this.piDescription;
    }

    public String getVersion() {
        return this.piVersion;
    }

    public String getVendor() {
        return this.piVendor;
    }

    public String getClassImpl() {
        return this.piClassImpl;
    }

    public PluginFactory getPluginFactory() {
        return this.piPluginFactory;
    }

    public boolean canSerialize() {
        return this.piCanSerialize;
    }

    public boolean canDeserialize() {
        return this.piCanDeserialize;
    }

    public boolean canMerge() {
        return this.piCanMerge;
    }

    public static boolean isValidOfficeType(String string) {
        boolean bl = false;
        int n = 0;
        while (n < validOfficeTypes.length) {
            if (string.equals(validOfficeTypes[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public String getXsltSerial() {
        return this.piXsltSerial;
    }

    public String getXsltDeserial() {
        return this.piXsltDeserial;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SxwType = "staroffice/sxw";
        SxcType = "staroffice/sxc";
        validOfficeTypes = new String[2];
        ConverterInfo.validOfficeTypes[0] = SxwType;
        ConverterInfo.validOfficeTypes[1] = SxcType;
    }
}

