/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.TwipsConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RowStyle
extends Style
implements Cloneable {
    private int rowHeight = 255;
    private static String[] ignored = new String[]{"fo:break-before", "fo:keep-with-next"};

    public RowStyle(Node node, StyleCatalog styleCatalog) {
        super(node, styleCatalog);
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            n = 0;
            while (n < n2) {
                Node node2 = namedNodeMap.item(n);
                this.handleAttribute(node2.getNodeName(), node2.getNodeValue());
                ++n;
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            n = nodeList.getLength();
            int n3 = 0;
            while (n3 < n) {
                NamedNodeMap namedNodeMap2;
                Node node3 = nodeList.item(n3);
                String string = node3.getNodeName();
                if (string.equals("style:properties") && (namedNodeMap2 = node3.getAttributes()) != null) {
                    int n4 = namedNodeMap2.getLength();
                    int n5 = 0;
                    while (n5 < n4) {
                        Node node4 = namedNodeMap2.item(n5);
                        this.handleAttribute(node4.getNodeName(), node4.getNodeValue());
                        ++n5;
                    }
                }
                ++n3;
            }
        }
    }

    public RowStyle(String string, String string2, String string3, int n, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        this.rowHeight = n;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int n) {
        this.rowHeight = this.rowHeight;
    }

    private int parseRowHeight(String string) {
        int n = 255;
        if (string.indexOf("cm") != -1) {
            float f = Float.parseFloat(string.substring(0, string.indexOf("c")));
            n = TwipsConverter.cm2twips(f);
        } else if (string.indexOf("inch") != -1) {
            float f = Float.parseFloat(string.substring(0, string.indexOf("i")));
            n = TwipsConverter.inches2twips(f);
        }
        return n;
    }

    private void handleAttribute(String string, String string2) {
        if (string.equals("style:row-height")) {
            this.rowHeight = this.parseRowHeight(string2);
        } else {
            Debug.log(1, "RowStyle Unhandled: " + string + "=" + string2);
        }
    }

    public Style getResolved() {
        RowStyle rowStyle = null;
        try {
            rowStyle = (RowStyle)this.clone();
        }
        catch (Exception exception) {
            Debug.log(2, "Can't clone", exception);
        }
        RowStyle rowStyle2 = null;
        if (this.sc != null) {
            if (this.parent != null) {
                rowStyle2 = (RowStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (rowStyle2 == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    rowStyle2 = (RowStyle)rowStyle2.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                rowStyle2 = (RowStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (rowStyle2 != null) {
            rowStyle2 = (RowStyle)rowStyle2.getResolved();
            if (this.rowHeight == 0 && rowStyle2.getRowHeight() != 0) {
                rowStyle.setRowHeight(rowStyle2.getRowHeight());
            }
        }
        return rowStyle;
    }

    public Node createNode(Document document, String string) {
        Element element = document.createElement(string);
        this.writeAttributes(element);
        return element;
    }

    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        RowStyle rowStyle = (RowStyle)style;
        return this.rowHeight == rowStyle.getRowHeight();
    }

    public void writeAttributes(Element element) {
        if (this.rowHeight != 0) {
            String string = TwipsConverter.twips2cm(this.rowHeight) + "cm";
            element.setAttribute("style:row-height", string);
        }
    }

    private boolean isIgnored(String string) {
        int n = 0;
        while (n < ignored.length) {
            if (ignored[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

