/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Enumeration;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;

public class HsqlDatabaseProperties
extends HsqlProperties {
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_NEW = 2;
    private static HashSet fullyProtectedProperties = new HashSet();
    private static HashSet setProtectedProperties = new HashSet();
    private static HashSet booleanProperties = new HashSet();
    private static HashSet integralProperties = new HashSet();
    private static HashSet stringProperties = new HashSet();
    public static final String VERSION_STRING_1_7_0 = "1.7.0";
    public static final String VERSION_STRING_1_8_0 = "1.8.0";
    public static final String FIRST_COMPATIBLE_VERSION = "1.8.0";
    public static final String THIS_VERSION = "1.8.0";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final int MAJOR = 1;
    public static final int MINOR = 8;
    public static final int REVISION = 0;
    public static final String db_version = "version";
    private static final String db_readonly = "readonly";
    private static final String db_modified = "modified";
    private static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String hsqldb_applog = "hsqldb.applog";
    public static final String hsqldb_cache_scale = "hsqldb.cache_scale";
    public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
    public static final String hsqldb_cache_size_scale = "hsqldb.cache_size_scale";
    public static final String hsqldb_cache_version = "hsqldb.cache_version";
    private static final String hsqldb_catalogs = "hsqldb.catalogs";
    public static final String hsqldb_compatible_version = "hsqldb.compatible_version";
    public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
    public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
    private static final String hsqldb_files_readonly = "hsqldb.files_readonly";
    public static final String hsqldb_log_size = "hsqldb.log_size";
    public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
    private static final String hsqldb_max_nio_scale = "hsqldb.max_nio_scale";
    private static final String hsqldb_original_version = "hsqldb.original_version";
    public static final String hsqldb_script_format = "hsqldb.script_format";
    private static final String sql_compare_in_locale = "sql.compare_in_locale";
    private static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_tx_no_multi_write = "sql.tx_no_multi_rewrite";
    public static final String textdb_cache_scale = "textdb.cache_scale";
    public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
    public static final String textdb_all_quoted = "textdb.all_quoted";
    public static final String textdb_allow_full_path = "textdb.allow_full_path";
    public static final String textdb_encoding = "textdb.encoding";
    public static final String textdb_ignore_first = "textdb.ignore_first";
    public static final String textdb_quoted = "textdb.quoted";
    public static final String textdb_fs = "textdb.fs";
    public static final String textdb_vs = "textdb.vs";
    public static final String textdb_lvs = "textdb.lvs";
    private Database database;

    public HsqlDatabaseProperties(Database database) {
        super(database.getPath(), database.isStoredFileAccess() ? database.getFileAccess() : null, database.isFilesInJar());
        this.database = database;
        this.setProperty(sql_enforce_strict_size, false);
        this.setProperty(db_version, "1.8.0");
        this.setProperty(hsqldb_compatible_version, "1.8.0");
        this.setProperty(hsqldb_cache_version, VERSION_STRING_1_7_0);
        this.setProperty(hsqldb_original_version, "1.8.0");
        this.setProperty(runtime_gc_interval, 0);
        this.setProperty(hsqldb_cache_file_scale, 1);
        this.setProperty(hsqldb_cache_size_scale, 8);
        this.setProperty(hsqldb_cache_scale, 14);
        this.setProperty(hsqldb_log_size, "200");
        this.setProperty(hsqldb_script_format, 0);
        this.setProperty(db_readonly, false);
        this.setProperty(db_modified, "no-new-files");
        this.setProperty(hsqldb_nio_data_file, true);
        this.setProperty(hsqldb_default_table_type, "memory");
        if (database.isStoredFileAccess()) {
            this.setProperty(hsqldb_default_table_type, "cached");
            this.setProperty(hsqldb_cache_scale, 13);
            this.setProperty(hsqldb_log_size, 10);
            this.setProperty(sql_enforce_strict_size, true);
            this.setProperty(hsqldb_nio_data_file, false);
        }
    }

    public boolean load() throws HsqlException {
        boolean bl;
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType())) {
            return true;
        }
        try {
            bl = super.load();
        }
        catch (Exception exception) {
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
        if (!bl) {
            return false;
        }
        this.filterLoadedProperties();
        String string = this.getProperty(hsqldb_compatible_version);
        int n = string.substring(0, 5).compareTo("1.8.0");
        Trace.check(n <= 0, 30);
        string = this.getProperty(db_version);
        if (string.charAt(2) == '6') {
            this.setProperty(hsqldb_cache_version, "1.6.0");
        }
        JavaSystem.gcFrequency = this.getIntegerProperty(runtime_gc_interval, 0);
        return true;
    }

    public void setDatabaseVariables() {
        if (this.isPropertyTrue(db_readonly)) {
            this.database.setReadOnly();
        }
        if (this.isPropertyTrue(hsqldb_files_readonly)) {
            this.database.setFilesReadOnly();
        }
        this.database.sqlEnforceStrictSize = this.isPropertyTrue(sql_enforce_strict_size);
        if (this.isPropertyTrue(sql_compare_in_locale)) {
            this.stringProps.remove(sql_compare_in_locale);
            this.database.collation.setCollationAsLocale();
        }
        this.database.txManager.setReWriteProtection(this.isPropertyTrue(sql_tx_no_multi_write));
        this.database.setMetaDirty(false);
    }

    public void save() throws HsqlException {
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType()) || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            super.save();
        }
        catch (Exception exception) {
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
    }

    void filterLoadedProperties() {
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            boolean bl;
            String string = (String)enumeration.nextElement();
            boolean bl2 = bl = fullyProtectedProperties.contains(string) || setProtectedProperties.contains(string) || booleanProperties.contains(string) || integralProperties.contains(string) || stringProperties.contains(string);
            if (bl) continue;
            this.stringProps.remove(string);
        }
    }

    public void setURLProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties != null) {
            Enumeration enumeration = hsqlProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!this.isBoolean(string) && !this.isIntegral(string) && !this.isString(string) && !db_readonly.equals(string)) continue;
                this.setProperty(string, hsqlProperties.getProperty(string));
            }
        }
    }

    public boolean isSetPropertyAllowed(String string) {
        return !fullyProtectedProperties.contains(string) && !setProtectedProperties.contains(string);
    }

    public boolean isBoolean(String string) {
        return booleanProperties.contains(string);
    }

    public boolean isIntegral(String string) {
        return integralProperties.contains(string);
    }

    public boolean isString(String string) {
        return stringProperties.contains(string);
    }

    public Set getBooleanPropertyNames() {
        return booleanProperties;
    }

    public Set getIntegralPropertyNames() {
        return integralProperties;
    }

    public Set getStringPropertyNames() {
        return stringProperties;
    }

    public String setProperty(String string, String string2) {
        string2 = super.setProperty(string, string2);
        return string2;
    }

    public int getDefaultWriteDelay() {
        return this.database.isStoredFileAccess() ? 2000 : 20000;
    }

    public void setDBModified(int n) throws HsqlException {
        String string = "no";
        if (n == 1) {
            string = "yes";
        } else if (n == 2) {
            string = "no-new-files";
        }
        this.setProperty(db_modified, string);
        this.save();
    }

    public int getDBModified() throws HsqlException {
        String string = this.getProperty(db_modified);
        if ("yes".equals(string)) {
            return 1;
        }
        if ("no-new-files".equals(string)) {
            return 2;
        }
        return 0;
    }

    static {
        Object[] objectArray = new String[]{db_version, hsqldb_compatible_version, hsqldb_cache_version, hsqldb_original_version, hsqldb_files_readonly, db_readonly, db_modified, sql_compare_in_locale, textdb_allow_full_path};
        fullyProtectedProperties.addAll(objectArray);
        Object[] objectArray2 = new String[]{hsqldb_log_size, hsqldb_script_format, hsqldb_defrag_limit};
        setProtectedProperties.addAll(objectArray2);
        Object[] objectArray3 = new String[]{hsqldb_nio_data_file, hsqldb_catalogs, sql_enforce_strict_size, textdb_quoted, textdb_all_quoted, textdb_ignore_first, sql_tx_no_multi_write};
        booleanProperties.addAll(objectArray3);
        Object[] objectArray4 = new String[]{runtime_gc_interval, hsqldb_applog, hsqldb_max_nio_scale, hsqldb_cache_file_scale, hsqldb_cache_scale, hsqldb_cache_size_scale, hsqldb_log_size, textdb_cache_scale, textdb_cache_size_scale};
        integralProperties.addAll(objectArray4);
        Object[] objectArray5 = new String[]{textdb_fs, textdb_vs, textdb_lvs, textdb_encoding, hsqldb_default_table_type};
        stringProperties.addAll(objectArray5);
    }
}

