/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.GroupedResult;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;

class Select {
    boolean isDistinctSelect;
    boolean isAggregated;
    private boolean isGrouped;
    private HashSet groupColumnNames;
    TableFilter[] tFilter;
    Expression limitCondition;
    Expression queryCondition;
    Expression havingCondition;
    Expression[] exprColumns;
    int iResultLen;
    int iGroupLen;
    int iHavingLen;
    int iOrderLen;
    int[] sortOrder;
    int[] sortDirection;
    boolean sortUnion;
    HsqlNameManager.HsqlName sIntoTable;
    int intoType;
    Select[] unionArray;
    int unionMaxDepth;
    Select unionSelect;
    int unionType;
    int unionDepth;
    static final int NOUNION = 0;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    private boolean simpleLimit;
    Result.ResultMetaData resultMetaData;
    boolean isResolved = false;

    Select() {
    }

    HashMap getColumnAliases() {
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.iResultLen) {
            String string = this.exprColumns[n].getAlias();
            if (string != null) {
                hashMap.put(string, this.exprColumns[n]);
            }
            ++n;
        }
        return hashMap;
    }

    void resolve(Session session) throws HsqlException {
        this.resolveTables();
        this.resolveTypes(session);
        this.setFilterConditions(session);
    }

    private void resolveTables() throws HsqlException {
        int n;
        int n2 = this.iResultLen;
        while (n2 < this.exprColumns.length) {
            if (this.exprColumns[n2].exprType == 2) {
                if (this.exprColumns[n2].joinedTableColumnIndex == -1) {
                    n = this.exprColumns[n2].isDescending() ? 1 : 0;
                    this.exprColumns[n2] = this.exprColumns[n2].getExpressionForAlias(this.exprColumns, this.iResultLen);
                    if (n != 0) {
                        this.exprColumns[n2].setDescending();
                    }
                }
            } else {
                this.exprColumns[n2].replaceAliases(this.exprColumns, this.iResultLen);
            }
            ++n2;
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceAliases(this.exprColumns, this.iResultLen);
        }
        n = this.tFilter.length;
        int n3 = 0;
        while (n3 < n) {
            this.resolveTables(this.tFilter[n3]);
            ++n3;
        }
    }

    void resolveTypes(Session session) throws HsqlException {
        int n = this.exprColumns.length;
        int n2 = 0;
        while (n2 < n) {
            this.exprColumns[n2].resolveTypes(session);
            ++n2;
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTypes(session);
        }
    }

    void resolveTablesUnion(TableFilter tableFilter) throws HsqlException {
        if (this.unionArray == null) {
            this.resolveTables(tableFilter);
        } else {
            int n = 0;
            while (n < this.unionArray.length) {
                this.unionArray[n].resolveTables(tableFilter);
                ++n;
            }
        }
    }

    void resolveTables(TableFilter tableFilter) throws HsqlException {
        int n = this.exprColumns.length;
        int n2 = 0;
        while (n2 < n) {
            this.exprColumns[n2].resolveTables(tableFilter);
            ++n2;
        }
        if (this.queryCondition != null) {
            this.queryCondition.resolveTables(tableFilter);
        }
    }

    private void setFilterConditions(Session session) throws HsqlException {
        if (this.queryCondition == null) {
            return;
        }
        int n = 0;
        while (n < this.tFilter.length) {
            this.tFilter[n].setConditions(session, this.queryCondition);
            ++n;
        }
    }

    boolean checkResolved(boolean bl) throws HsqlException {
        boolean bl2 = true;
        int n = this.exprColumns.length;
        int n2 = 0;
        while (n2 < n) {
            bl2 = bl2 && this.exprColumns[n2].checkResolved(bl);
            ++n2;
        }
        if (this.queryCondition != null) {
            boolean bl3 = bl2 = bl2 && this.queryCondition.checkResolved(bl);
        }
        if (this.havingCondition != null) {
            bl2 = bl2 && this.havingCondition.checkResolved(bl);
        }
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            if (this.tFilter[n3].filterIndex == null) {
                this.tFilter[n3].filterIndex = this.tFilter[n3].filterTable.getPrimaryIndex();
            }
            ++n3;
        }
        return bl2;
    }

    Object getValue(Session session, int n) throws HsqlException {
        this.resolve(session);
        Result result = this.getResult(session, 2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        if (n3 == 1) {
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1) {
                Object object = result.rRoot.data[0];
                return result.metaData.colTypes[0] == n ? object : Column.convertObject(object, n);
            }
            throw Trace.error(17);
        }
        HsqlException hsqlException = Trace.error(17);
        throw new HsqlInternalException(hsqlException);
    }

    void prepareResult(Session session) throws HsqlException {
        int n;
        this.resolveAll(session, true);
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
            this.groupColumnNames = new HashSet();
            n = this.iResultLen;
            while (n < this.iResultLen + this.iGroupLen) {
                this.exprColumns[n].collectAllColumnNames(this.groupColumnNames);
                ++n;
            }
        }
        n = this.exprColumns.length;
        Result.ResultMetaData resultMetaData = this.resultMetaData = new Result.ResultMetaData(n);
        int n2 = this.iResultLen;
        int n3 = n2 + this.iGroupLen;
        int n4 = n3 + this.iHavingLen;
        int n5 = n4 + this.iOrderLen;
        int n6 = 0;
        while (n6 < n) {
            Expression expression = this.exprColumns[n6];
            resultMetaData.colTypes[n6] = expression.getDataType();
            resultMetaData.colSizes[n6] = expression.getColumnSize();
            resultMetaData.colScales[n6] = expression.getColumnScale();
            if (expression.isAggregate()) {
                this.isAggregated = true;
            }
            if (n6 >= n2 && n6 < n3 && !this.exprColumns[n6].canBeInGroupBy()) {
                Trace.error(68, this.exprColumns[n6]);
            }
            if (n6 >= n3 && n6 < n3 + this.iHavingLen && !this.exprColumns[n6].isConditional()) {
                Trace.error(69, this.exprColumns[n6]);
            }
            if (n6 >= n4 && n6 < n5 && !this.exprColumns[n6].canBeInOrderBy()) {
                Trace.error(70, this.exprColumns[n6]);
            }
            if (n6 < this.iResultLen) {
                resultMetaData.colLabels[n6] = expression.getAlias();
                resultMetaData.isLabelQuoted[n6] = expression.isAliasQuoted();
                resultMetaData.schemaNames[n6] = expression.getTableSchemaName();
                resultMetaData.tableNames[n6] = expression.getTableName();
                resultMetaData.colNames[n6] = expression.getColumnName();
                if (resultMetaData.isTableColumn(n6)) {
                    resultMetaData.colNullable[n6] = expression.nullability;
                    resultMetaData.isIdentity[n6] = expression.isIdentity;
                    resultMetaData.isWritable[n6] = expression.isWritable;
                }
                resultMetaData.classNames[n6] = expression.getValueClassName();
            }
            ++n6;
        }
        this.checkAggregateOrGroupByColumns(0, this.iResultLen);
        this.checkAggregateOrGroupByColumns(n3, n4);
        this.checkAggregateOrGroupByColumns(n4, n5);
        this.prepareSort();
        this.simpleLimit = !this.isDistinctSelect && !this.isGrouped && this.unionSelect == null && this.iOrderLen == 0;
    }

    void prepareUnions() throws HsqlException {
        int n = 0;
        Select select = this;
        while (select != null) {
            select = select.unionSelect;
            ++n;
        }
        if (n == 1) {
            if (this.unionDepth != 0) {
                throw Trace.error(121);
            }
            return;
        }
        this.unionArray = new Select[n];
        n = 0;
        Select select2 = this;
        while (select2 != null) {
            this.unionArray[n] = select2;
            this.unionMaxDepth = select2.unionDepth > this.unionMaxDepth ? select2.unionDepth : this.unionMaxDepth;
            select2 = select2.unionSelect;
            ++n;
        }
        if (this.unionArray[this.unionArray.length - 1].unionDepth != 0) {
            throw Trace.error(121);
        }
    }

    Result getResult(Session session, int n) throws HsqlException {
        Result result;
        if (this.unionArray == null) {
            result = this.getSingleResult(session, n);
        } else {
            result = this.getResultMain(session);
            if (this.sortUnion) {
                this.sortResult(session, result);
                result.trimResult(this.getLimitStart(session), this.getLimitCount(session, n));
            }
        }
        result.setColumnCount(this.iResultLen);
        return result;
    }

    private Result getResultMain(Session session) throws HsqlException {
        Result[] resultArray = new Result[this.unionArray.length];
        int n = 0;
        while (n < this.unionArray.length) {
            resultArray[n] = this.unionArray[n].getSingleResult(session, Integer.MAX_VALUE);
            ++n;
        }
        int n2 = this.unionMaxDepth;
        while (n2 >= 0) {
            int n3 = 0;
            while (n3 < 2) {
                int n4 = 0;
                while (n4 < this.unionArray.length - 1) {
                    if (!(resultArray[n4] == null || this.unionArray[n4].unionDepth < n2 || n3 == 0 && this.unionArray[n4].unionType != 3 || n3 == 1 && this.unionArray[n4].unionType == 3)) {
                        int n5 = n4 + 1;
                        while (n5 < this.unionArray.length) {
                            if (resultArray[n5] != null) break;
                            ++n5;
                        }
                        if (n5 == this.unionArray.length) break;
                        this.unionArray[n4].mergeResults(session, resultArray[n4], resultArray[n5]);
                        resultArray[n5] = resultArray[n4];
                        resultArray[n4] = null;
                    }
                    ++n4;
                }
                ++n3;
            }
            --n2;
        }
        return resultArray[resultArray.length - 1];
    }

    private void mergeResults(Session session, Result result, Result result2) throws HsqlException {
        switch (this.unionType) {
            case 1: {
                result.append(result2);
                result.removeDuplicates(session, this.iResultLen);
                break;
            }
            case 2: {
                result.append(result2);
                break;
            }
            case 3: {
                result.removeDifferent(session, result2, this.iResultLen);
                break;
            }
            case 4: {
                result.removeSecond(session, result2, this.iResultLen);
            }
        }
    }

    int getLimitStart(Session session) throws HsqlException {
        Integer n;
        if (this.limitCondition != null && (n = (Integer)this.limitCondition.getArg().getValue(session)) != null) {
            return n;
        }
        return 0;
    }

    int getLimitCount(Session session, int n) throws HsqlException {
        Integer n2;
        int n3 = 0;
        if (this.limitCondition != null && (n2 = (Integer)this.limitCondition.getArg2().getValue(session)) != null) {
            n3 = n2;
        }
        if (n != 0 && (n3 == 0 || n < n3)) {
            n3 = n;
        }
        return n3;
    }

    int getMaxRowCount(Session session, int n) throws HsqlException {
        int n2 = this.getLimitStart(session);
        int n3 = this.getLimitCount(session, n);
        if (!this.simpleLimit) {
            n = Integer.MAX_VALUE;
        } else {
            if (n == 0) {
                n = n3;
            }
            n = n == 0 || n > Integer.MAX_VALUE - n2 ? Integer.MAX_VALUE : (n += n2);
        }
        return n;
    }

    private Result getSingleResult(Session session, int n) throws HsqlException {
        if (this.resultMetaData == null) {
            this.prepareResult(session);
        }
        Result result = this.buildResult(session, this.getMaxRowCount(session, n));
        if (this.isDistinctSelect) {
            result.removeDuplicates(session, this.iResultLen);
        }
        if (!this.sortUnion) {
            this.sortResult(session, result);
            result.trimResult(this.getLimitStart(session), this.getLimitCount(session, n));
        }
        return result;
    }

    private void prepareSort() {
        int n;
        if (this.iOrderLen == 0) {
            return;
        }
        this.sortOrder = new int[this.iOrderLen];
        this.sortDirection = new int[this.iOrderLen];
        int n2 = n = this.iResultLen + this.iGroupLen + this.iHavingLen;
        int n3 = 0;
        while (n3 < this.iOrderLen) {
            int n4 = n2;
            if (this.exprColumns[n2].joinedTableColumnIndex != -1) {
                n4 = this.exprColumns[n2].joinedTableColumnIndex;
            }
            this.sortOrder[n3] = n4;
            this.sortDirection[n3] = this.exprColumns[n2].isDescending() ? -1 : 1;
            ++n2;
            ++n3;
        }
    }

    private void sortResult(Session session, Result result) throws HsqlException {
        if (this.iOrderLen == 0) {
            return;
        }
        result.sortResult(session, this.sortOrder, this.sortDirection);
    }

    private void checkAggregateOrGroupByColumns(int n, int n2) throws HsqlException {
        if (n < n2) {
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            int n3 = n;
            while (n3 < n2) {
                this.exprColumns[n3].collectInGroupByExpressions(hsqlArrayList);
                ++n3;
            }
            int n4 = 0;
            int n5 = hsqlArrayList.size();
            while (n4 < n5) {
                Expression expression = (Expression)hsqlArrayList.get(n4);
                if (!this.inAggregateOrGroupByClause(expression)) {
                    if (this.isDistinctSelect) {
                        throw Trace.error(71, expression);
                    }
                    throw Trace.error(67, expression);
                }
                ++n4;
            }
        }
    }

    private boolean inAggregateOrGroupByClause(Expression expression) {
        if (this.isGrouped) {
            return this.isSimilarIn(expression, this.iResultLen, this.iResultLen + this.iGroupLen) || Select.allColumnsAreDefinedIn(expression, this.groupColumnNames);
        }
        if (this.isAggregated) {
            return expression.canBeInAggregate();
        }
        if (this.isDistinctSelect) {
            return this.isSimilarIn(expression, 0, this.iResultLen);
        }
        return true;
    }

    private boolean isSimilarIn(Expression expression, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (expression.similarTo(this.exprColumns[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static boolean allColumnsAreDefinedIn(Expression expression, HashSet hashSet) {
        HashSet hashSet2 = new HashSet();
        expression.collectAllColumnNames(hashSet2);
        if (hashSet2.size() > 0 && hashSet == null) {
            return false;
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private Result buildResult(Session var1_1, int var2_2) throws HsqlException {
        var3_3 = new GroupedResult(this, this.resultMetaData);
        var4_4 = this.exprColumns.length;
        var5_5 = this.tFilter.length;
        var6_6 = new boolean[var5_5];
        var7_7 = new boolean[var5_5];
        var8_8 = 0;
        var9_9 = this.queryCondition == null || this.queryCondition.isFixedConditional() == false || this.queryCondition.testCondition(var1_1) != false;
        while (var9_9 && var8_8 >= 0) {
            var10_10 = this.tFilter[var8_8];
            if (!var6_6[var8_8]) {
                var11_11 = var10_10.findFirst(var1_1);
                var12_14 = var10_10.isOuterJoin != false && var11_11 == 0 && var7_7[var8_8] == false && var10_10.nonJoinIsNull == false && var10_10.nextOuter(var1_1) != false ? 1 : 0;
                var7_7[var8_8] = var12_14;
                var6_6[var8_8] = var11_11;
            } else {
                var11_11 = var10_10.next(var1_1);
                var12_14 = var10_10.isOuterJoin != false && var11_11 == 0 && var6_6[var8_8] == false && var7_7[var8_8] == false && var10_10.nonJoinIsNull == false && var10_10.nextOuter(var1_1) != false ? 1 : 0;
                var7_7[var8_8] = var12_14;
                var6_6[var8_8] = var11_11;
            }
            if (var11_11 == 0 && var12_14 == 0) {
                --var8_8;
                continue;
            }
            if (var8_8 >= var5_5 - 1) ** GOTO lbl27
            ++var8_8;
            continue;
lbl-1000:
            // 1 sources

            {
                var7_7[var8_8--] = false;
lbl27:
                // 2 sources

                ** while (var7_7[var8_8])
            }
lbl28:
            // 1 sources

            if (this.queryCondition != null && !this.queryCondition.testCondition(var1_1)) continue;
            try {
                var13_15 = new Object[var4_4];
                var14_17 = var3_3.groupBegin;
                while (var14_17 < var3_3.groupEnd) {
                    var13_15[var14_17] = this.exprColumns[var14_17].getValue(var1_1);
                    ++var14_17;
                }
                var13_15 = var3_3.getRow(var13_15);
                var15_18 = 0;
                while (var15_18 < var3_3.groupBegin) {
                    var13_15[var15_18] = this.isAggregated != false && this.exprColumns[var15_18].isAggregate() != false ? this.exprColumns[var15_18].updateAggregatingValue(var1_1, var13_15[var15_18]) : this.exprColumns[var15_18].getValue(var1_1);
                    ++var15_18;
                }
                var16_19 = var3_3.groupEnd;
                while (var16_19 < var4_4) {
                    var13_15[var16_19] = this.isAggregated != false && this.exprColumns[var16_19].isAggregate() != false ? this.exprColumns[var16_19].updateAggregatingValue(var1_1, var13_15[var16_19]) : this.exprColumns[var16_19].getValue(var1_1);
                    ++var16_19;
                }
                var3_3.addRow(var13_15);
                if (var3_3.size() < var2_2) continue;
                break;
            }
            catch (HsqlInternalException var13_16) {
                // empty catch block
            }
        }
        if (this.isAggregated && !this.isGrouped && var3_3.size() == 0) {
            var10_10 = new Object[var4_4];
            var11_11 = 0;
            while (var11_11 < var4_4) {
                var10_10[var11_11] = this.exprColumns[var11_11].isAggregate() != false ? null : this.exprColumns[var11_11].getValue(var1_1);
                ++var11_11;
            }
            var3_3.addRow(var10_10);
        }
        var10_10 = var3_3.iterator();
        while (var10_10.hasNext()) {
            var11_13 = (Object[])var10_10.next();
            if (this.isAggregated) {
                var12_14 = 0;
                while (var12_14 < var4_4) {
                    if (this.exprColumns[var12_14].isAggregate()) {
                        var11_13[var12_14] = this.exprColumns[var12_14].getAggregatedValue(var1_1, var11_13[var12_14]);
                    }
                    ++var12_14;
                }
            }
            if (this.iHavingLen <= 0 || Boolean.TRUE.equals(var11_13[this.iResultLen + this.iGroupLen])) continue;
            var10_10.remove();
        }
        return var3_3.getResult();
    }

    public StringBuffer getDDL() throws HsqlException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT").append(' ');
        int n = 0;
        while (n < this.iResultLen) {
            stringBuffer.append(this.exprColumns[n].getDDL());
            if (n < this.iResultLen - 1) {
                stringBuffer.append(',');
            }
            ++n;
        }
        stringBuffer.append("FROM");
        int n2 = 0;
        while (n2 < this.tFilter.length) {
            TableFilter tableFilter = this.tFilter[n2];
            if (n2 != 0 && tableFilter.isOuterJoin) {
                stringBuffer.append("FROM").append(' ');
                stringBuffer.append("JOIN").append(' ');
            }
            stringBuffer.append(',');
            ++n2;
        }
        stringBuffer.append(' ').append("WHERE").append(' ');
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            TableFilter tableFilter = this.tFilter[n3];
            ++n3;
        }
        stringBuffer.append(' ').append("GROUP").append(' ');
        int n4 = this.iResultLen;
        while (n4 < this.iResultLen + this.iGroupLen) {
            stringBuffer.append(this.exprColumns[n4].getDDL());
            if (n4 < this.iResultLen + this.iGroupLen - 1) {
                stringBuffer.append(',');
            }
            ++n4;
        }
        stringBuffer.append(' ').append("HAVING").append(' ');
        int n5 = this.iResultLen + this.iGroupLen;
        while (n5 < this.iResultLen + this.iGroupLen + this.iHavingLen) {
            stringBuffer.append(this.exprColumns[n5].getDDL());
            if (n5 < this.iResultLen + this.iGroupLen - 1) {
                stringBuffer.append(',');
            }
            ++n5;
        }
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(' ').append("EXCEPT").append(' ');
                    break;
                }
                case 3: {
                    stringBuffer.append(' ').append("INTERSECT").append(' ');
                    break;
                }
                case 1: {
                    stringBuffer.append(' ').append("UNION").append(' ');
                    break;
                }
                case 2: {
                    stringBuffer.append(' ').append("UNION").append(' ').append("ALL").append(' ');
                }
            }
        }
        int n6 = this.iResultLen + this.iGroupLen;
        int n7 = n6 + this.iHavingLen;
        int n8 = n7 + this.iOrderLen;
        stringBuffer.append(' ').append("ORDER").append("BY").append(' ');
        int n9 = n7;
        while (n9 < n8) {
            stringBuffer.append(this.exprColumns[n9].getDDL());
            if (n9 < this.iResultLen + this.iGroupLen - 1) {
                stringBuffer.append(',');
            }
            ++n9;
        }
        return stringBuffer;
    }

    boolean resolveAll(Session session, boolean bl) throws HsqlException {
        if (this.isResolved) {
            return true;
        }
        this.resolve(session);
        this.isResolved = this.checkResolved(bl);
        if (this.unionSelect != null) {
            if (this.unionSelect.iResultLen != this.iResultLen) {
                throw Trace.error(5);
            }
            int n = 0;
            while (n < this.iResultLen) {
                Expression expression = this.exprColumns[n];
                if (!expression.isTypeEqual(this.unionSelect.exprColumns[n])) {
                    this.unionSelect.exprColumns[n] = new Expression(this.unionSelect.exprColumns[n], expression.getDataType(), expression.getColumnSize(), expression.getColumnScale());
                }
                ++n;
            }
            this.isResolved &= this.unionSelect.resolveAll(session, bl);
        }
        return this.isResolved;
    }

    boolean isResolved() {
        return this.isResolved;
    }

    public String describe(Session session) {
        try {
            this.getResult(session, 1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        if (this.sIntoTable != null) {
            stringBuffer.append("into table=[").append(this.sIntoTable.name).append("]\n");
        }
        if (this.limitCondition != null) {
            stringBuffer.append("offset=[").append(this.limitCondition.getArg().describe(session)).append("]\n");
            stringBuffer.append("limit=[").append(this.limitCondition.getArg2().describe(session)).append("]\n");
        }
        stringBuffer.append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuffer.append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuffer.append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuffer.append("columns=[");
        int n = this.exprColumns.length - this.iOrderLen;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.exprColumns[n2].describe(session));
            ++n2;
        }
        stringBuffer.append("\n]\n");
        stringBuffer.append("tableFilters=[\n");
        int n3 = 0;
        while (n3 < this.tFilter.length) {
            stringBuffer.append("[\n");
            stringBuffer.append(this.tFilter[n3].describe(session));
            stringBuffer.append("\n]");
            ++n3;
        }
        stringBuffer.append("]\n");
        String string = this.queryCondition == null ? "null" : this.queryCondition.describe(session);
        stringBuffer.append("eCondition=[").append(string).append("]\n");
        string = this.havingCondition == null ? "null" : this.havingCondition.describe(session);
        stringBuffer.append("havingCondition=[").append(string).append("]\n");
        stringBuffer.append("groupColumns=[").append(this.groupColumnNames).append("]\n");
        if (this.unionSelect != null) {
            switch (this.unionType) {
                case 4: {
                    stringBuffer.append(" EXCEPT ");
                    break;
                }
                case 3: {
                    stringBuffer.append(" INTERSECT ");
                    break;
                }
                case 1: {
                    stringBuffer.append(" UNION ");
                    break;
                }
                case 2: {
                    stringBuffer.append(" UNION ALL ");
                    break;
                }
                default: {
                    stringBuffer.append(" UNKNOWN SET OPERATION ");
                }
            }
            stringBuffer.append("[\n").append(this.unionSelect.describe(session)).append("]\n");
        }
        return stringBuffer.toString();
    }

    Result describeResult() {
        Result result = new Result(3, this.iResultLen);
        Result.ResultMetaData resultMetaData = result.metaData;
        int n = 0;
        while (n < this.iResultLen) {
            Expression expression = this.exprColumns[n];
            resultMetaData.colTypes[n] = expression.getDataType();
            resultMetaData.colSizes[n] = expression.getColumnSize();
            resultMetaData.colScales[n] = expression.getColumnScale();
            resultMetaData.colLabels[n] = expression.getAlias();
            resultMetaData.isLabelQuoted[n] = expression.isAliasQuoted();
            resultMetaData.tableNames[n] = expression.getTableName();
            resultMetaData.colNames[n] = expression.getColumnName();
            if (resultMetaData.isTableColumn(n)) {
                resultMetaData.colNullable[n] = expression.nullability;
                resultMetaData.isIdentity[n] = expression.isIdentity;
                resultMetaData.isWritable[n] = expression.isWritable;
            }
            ++n;
        }
        return result;
    }
}

