/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.NoSuchElementException;
import org.hsqldb.Collation;
import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;

public class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private final HsqlNameManager.HsqlName indexName;
    final boolean[] colCheck;
    private final int[] colIndex;
    private final int[] colType;
    final int[] pkCols;
    final int[] pkTypes;
    private final boolean isUnique;
    private final boolean useRowId;
    final boolean isConstraint;
    final boolean isForward;
    final boolean isTemp;
    private Node root;
    private int depth;
    final Collation collation;
    static IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null);
    IndexRowIterator updatableIterators;
    final boolean onCommitPreserve;

    Index(Database database, HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int[] nArray3, int[] nArray4, boolean bl5) {
        this.indexName = hsqlName;
        this.colIndex = nArray;
        this.colType = nArray2;
        this.pkCols = nArray3;
        this.pkTypes = nArray4;
        this.isUnique = bl2;
        this.isConstraint = bl3;
        this.isForward = bl4;
        this.useRowId = !this.isUnique && this.pkCols.length == 0 || this.colIndex.length == 0;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.updatableIterators.next = this.updatableIterators.last = (this.updatableIterators = new IndexRowIterator(null, null, null));
        this.collation = database.collation;
        this.isTemp = bl5;
        this.onCommitPreserve = table.onCommitPreserve;
    }

    HsqlNameManager.HsqlName getName() {
        return this.indexName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.indexName.rename(string, bl);
    }

    int getVisibleColumns() {
        return this.colIndex.length;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    boolean isConstraint() {
        return this.isConstraint;
    }

    int[] getColumns() {
        return this.colIndex;
    }

    int[] getColumnTypes() {
        return this.colType;
    }

    int size(Session session) throws HsqlException {
        int n = 0;
        RowIterator rowIterator = this.firstRow(session);
        while (rowIterator.hasNext()) {
            rowIterator.next();
            ++n;
        }
        return n;
    }

    boolean isEmpty(Session session) {
        return this.getRoot(session) == null;
    }

    public int sizeEstimate() throws HsqlException {
        this.firstRow(null);
        return (int)(1L << this.depth);
    }

    void clearAll(Session session) {
        this.setRoot(session, null);
        this.depth = 0;
        this.updatableIterators.next = this.updatableIterators.last = this.updatableIterators;
    }

    void clearIterators() {
        this.updatableIterators.next = this.updatableIterators.last = this.updatableIterators;
    }

    void setRoot(Session session, Node node) {
        if (this.isTemp) {
            session.setIndexRoot(this.indexName, this.onCommitPreserve, node);
        } else {
            this.root = node;
        }
    }

    Node getRoot(Session session) {
        if (this.isTemp && session != null) {
            return session.getIndexRoot(this.indexName, this.onCommitPreserve);
        }
        return this.root;
    }

    void insert(Session session, Row row, int n) throws HsqlException {
        Node node;
        Node node2 = node = this.getRoot(session);
        boolean bl = true;
        int n2 = -1;
        while (true) {
            if (node == null) {
                if (node2 == null) {
                    this.setRoot(session, row.getNode(n));
                    return;
                }
                break;
            }
            n2 = this.compareRowForInsert(session, row, node.getRow());
            if (n2 == 0) {
                throw Trace.error(9, this.indexName.name);
            }
            bl = n2 < 0;
            node2 = node;
            node = this.child(node2, bl);
        }
        this.set(node2, bl, row.getNode(n));
        this.balance(session, node2, bl);
    }

    private void balance(Session session, Node node, boolean bl) throws HsqlException {
        while (true) {
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case 1: {
                    node.setBalance(0);
                    return;
                }
                case 0: {
                    node.setBalance(-n);
                    break;
                }
                case -1: {
                    Node node2 = this.child(node, bl);
                    if (node2.getBalance() == -n) {
                        this.replace(session, node, node2);
                        this.set(node, bl, this.child(node2, !bl));
                        this.set(node2, !bl, node);
                        node.setBalance(0);
                        node2.setBalance(0);
                    } else {
                        Node node3 = this.child(node2, !bl);
                        this.replace(session, node, node3);
                        this.set(node2, !bl, this.child(node3, bl));
                        this.set(node3, bl, node2);
                        this.set(node, bl, this.child(node3, !bl));
                        this.set(node3, !bl, node);
                        int n2 = node3.getBalance();
                        node.setBalance(n2 == -n ? n : 0);
                        node2.setBalance(n2 == n ? -n : 0);
                        node3.setBalance(0);
                    }
                    return;
                }
            }
            if (node.equals(this.getRoot(session))) {
                return;
            }
            bl = node.isFromLeft();
            node = node.getParent();
        }
    }

    void delete(Session session, Node node) throws HsqlException {
        Node node2;
        Node node3;
        if (node == null) {
            return;
        }
        IndexRowIterator indexRowIterator = this.updatableIterators.next;
        while (indexRowIterator != this.updatableIterators) {
            indexRowIterator.updateForDelete(node);
            indexRowIterator = indexRowIterator.next;
        }
        if (node.getLeft() == null) {
            node3 = node.getRight();
        } else if (node.getRight() == null) {
            node3 = node.getLeft();
        } else {
            Node node4 = node;
            Node node5 = node = node.getLeft();
            while ((node5 = node5.getRight()) != null) {
                node = node5;
            }
            node3 = node.getLeft();
            int n = node.getBalance();
            node.setBalance(node4.getBalance());
            node4.setBalance(n);
            Node node6 = node.getParent();
            node2 = node4.getParent();
            if (node4 == this.getRoot(session)) {
                this.setRoot(session, node);
            }
            node.setParent(node2);
            if (node2 != null) {
                if (node2.getRight().equals(node4)) {
                    node2.setRight(node);
                } else {
                    node2.setLeft(node);
                }
            }
            if (node6 == node4) {
                node4.setParent(node);
                if (node4.getLeft().equals(node)) {
                    node.setLeft(node4);
                    node.setRight(node4.getRight());
                } else {
                    node.setRight(node4);
                    node.setLeft(node4.getLeft());
                }
            } else {
                node4.setParent(node6);
                node6.setRight(node4);
                node.setRight(node4.getRight());
                node.setLeft(node4.getLeft());
            }
            node.getRight().setParent(node);
            node.getLeft().setParent(node);
            node4.setLeft(node3);
            if (node3 != null) {
                node3.setParent(node4);
            }
            node4.setRight(null);
            node = node4;
        }
        boolean bl = node.isFromLeft();
        this.replace(session, node, node3);
        node3 = node.getParent();
        node.delete();
        while (node3 != null) {
            node = node3;
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case -1: {
                    node.setBalance(0);
                    break;
                }
                case 0: {
                    node.setBalance(n);
                    return;
                }
                case 1: {
                    Node node7 = this.child(node, !bl);
                    int n2 = node7.getBalance();
                    if (n2 * n >= 0) {
                        this.replace(session, node, node7);
                        this.set(node, !bl, this.child(node7, bl));
                        this.set(node7, bl, node);
                        if (n2 == 0) {
                            node.setBalance(n);
                            node7.setBalance(-n);
                            return;
                        }
                        node.setBalance(0);
                        node7.setBalance(0);
                        node = node7;
                        break;
                    }
                    node2 = this.child(node7, bl);
                    this.replace(session, node, node2);
                    n2 = node2.getBalance();
                    this.set(node7, bl, this.child(node2, !bl));
                    this.set(node2, !bl, node7);
                    this.set(node, !bl, this.child(node2, bl));
                    this.set(node2, bl, node);
                    node.setBalance(n2 == n ? -n : 0);
                    node7.setBalance(n2 == -n ? n : 0);
                    node2.setBalance(0);
                    node = node2;
                }
            }
            bl = node.isFromLeft();
            node3 = node.getParent();
        }
    }

    RowIterator findFirstRow(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        Node node = this.findNotNull(session, objectArray, nArray, true);
        return node == null ? emptyIterator : new IndexRowIterator(session, this, node);
    }

    RowIterator findFirstRowForDelete(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        Node node = this.findNotNull(session, objectArray, nArray, true);
        if (node == null) {
            return emptyIterator;
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(session, this, node);
        this.updatableIterators.link(indexRowIterator);
        return indexRowIterator;
    }

    Row findRow(Session session, Row row) throws HsqlException {
        Node node = this.search(session, row);
        return node == null ? null : node.getRow();
    }

    boolean exists(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        return this.findNotNull(session, objectArray, nArray, true) != null;
    }

    RowIterator emptyIterator() {
        return emptyIterator;
    }

    /*
     * Unable to fully structure code
     */
    private Node findNotNull(Session var1_1, Object[] var2_2, int[] var3_3, boolean var4_4) throws HsqlException {
        var5_5 = this.getRoot(var1_1);
        var7_6 = null;
        if (!Index.isNull(var2_2, var3_3)) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            var8_8 = this.compareRowNonUnique(var1_1, var2_2, var3_3, var5_5.getData());
            if (var8_8 == 0) {
                if (!var4_4) {
                    var7_6 = var5_5;
                    break;
                }
                if (var7_6 == var5_5) break;
                var7_6 = var5_5;
                var6_7 = var5_5.getLeft();
            } else {
                var6_7 = var8_8 > 0 ? var5_5.getRight() : var5_5.getLeft();
            }
            if (var6_7 == null) break;
            var5_5 = var6_7;
lbl17:
            // 2 sources

            ** while (var5_5 != null)
        }
lbl18:
        // 4 sources

        return var7_6;
    }

    static boolean isNull(Object[] objectArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[nArray[n2]] == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isNull(Object[] objectArray) {
        int n = this.colIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.colIndex[n2];
            if (objectArray[n3] == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    RowIterator findFirstRow(Session session, Object[] objectArray) throws HsqlException {
        Node node = this.getRoot(session);
        Node node2 = null;
        boolean bl = this.isUnique && !this.isNull(objectArray);
        while (node != null) {
            int n = this.compareRowNonUnique(session, objectArray, this.colIndex, node.getData());
            if (n == 0) {
                node2 = node;
                if (bl) break;
                node = node.getLeft();
                continue;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return node2 == null ? emptyIterator : new IndexRowIterator(session, this, node2);
    }

    /*
     * Unable to fully structure code
     */
    RowIterator findFirstRow(Session var1_1, Object var2_2, int var3_3) throws HsqlException {
        var4_4 = var3_3 == 21 || var3_3 == 34;
        var5_5 = this.getRoot(var1_1);
        var6_6 = 1;
        if (var3_3 == 23) {
            var6_6 = 0;
        }
        if (var2_2 != null || var4_4) ** GOTO lbl17
        return Index.emptyIterator;
lbl-1000:
        // 1 sources

        {
            v0 = var7_7 = Column.compare(this.collation, var2_2, var5_5.getData()[this.colIndex[0]], this.colType[0]) >= var6_6;
            if (var7_7) {
                var8_9 = var5_5.getRight();
                if (var8_9 == null) break;
                var5_5 = var8_9;
                continue;
            }
            var8_9 = var5_5.getLeft();
            if (var8_9 == null) break;
            var5_5 = var8_9;
lbl17:
            // 3 sources

            ** while (var5_5 != null)
        }
lbl18:
        // 5 sources

        while (var5_5 != null) {
            var7_8 = var5_5.getData()[this.colIndex[0]];
            var8_11 = Column.compare(this.collation, var2_2, var7_8, this.colType[0]);
            if (var8_11 >= var6_6) {
                var5_5 = this.next(var5_5);
                continue;
            }
            if (var4_4) {
                if (var8_11 == 0) break;
                var5_5 = null;
                break;
            }
            if (var7_8 != null) break;
            var5_5 = this.next(var5_5);
        }
        return var5_5 == null ? Index.emptyIterator : new IndexRowIterator(var1_1, this, var5_5);
    }

    RowIterator findFirstRowNotNull(Session session) throws HsqlException {
        Node node = this.getRoot(session);
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = Column.compare(this.collation, null, node.getData()[this.colIndex[0]], this.colType[0]) >= 0;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null) {
            Object object = node.getData()[this.colIndex[0]];
            if (object != null) break;
            node = this.next(node);
        }
        return node == null ? emptyIterator : new IndexRowIterator(session, this, node);
    }

    RowIterator firstRow(Session session) throws HsqlException {
        Node node;
        this.depth = 0;
        Node node2 = node = this.getRoot(session);
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
            ++this.depth;
        }
        return node == null ? emptyIterator : new IndexRowIterator(session, this, node);
    }

    Row lastRow(Session session) throws HsqlException {
        Node node;
        Node node2 = node = this.getRoot(session);
        while (node2 != null) {
            node = node2;
            node2 = node.getRight();
        }
        return node == null ? null : node.getRow();
    }

    Node next(Node node) throws HsqlException {
        if (node == null) {
            return null;
        }
        Node node2 = node.getRight();
        if (node2 != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        node = node.getParent();
        while (node != null && node4.equals(node.getRight())) {
            node4 = node;
            node = node.getParent();
        }
        return node;
    }

    private Node child(Node node, boolean bl) throws HsqlException {
        return bl ? node.getLeft() : node.getRight();
    }

    private void replace(Session session, Node node, Node node2) throws HsqlException {
        if (node.equals(this.getRoot(session))) {
            this.setRoot(session, node2);
            if (node2 != null) {
                node2.setParent(null);
            }
        } else {
            this.set(node.getParent(), node.isFromLeft(), node2);
        }
    }

    private void set(Node node, boolean bl, Node node2) throws HsqlException {
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2.setParent(node);
        }
    }

    private Node search(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        Node node = this.getRoot(session);
        while (node != null) {
            int n = this.compareRowForInsert(session, row, node.getRow());
            if (n == 0) {
                return node;
            }
            node = n < 0 ? node.getLeft() : node.getRight();
        }
        return null;
    }

    int compareRowNonUnique(Session session, Object[] objectArray, int[] nArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(this.collation, objectArray[nArray[0]], objectArray2[this.colIndex[0]], this.colType[0]);
        if (n != 0) {
            return n;
        }
        int n2 = nArray.length;
        int n3 = 1;
        while (n3 < n2) {
            n = Column.compare(this.collation, objectArray[nArray[n3]], objectArray2[this.colIndex[n3]], this.colType[n3]);
            if (n != 0) {
                return n;
            }
            ++n3;
        }
        return 0;
    }

    static int compareRows(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2) throws HsqlException {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = Column.compare(session.database.collation, objectArray[nArray[n2]], objectArray2[nArray[n2]], nArray2[nArray[n2]]);
            if (n3 != 0) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    private int compareRowForInsert(Session session, Row row, Row row2) throws HsqlException {
        int n;
        Object object;
        Object[] objectArray = row.getData();
        Object[] objectArray2 = row2.getData();
        int n2 = 0;
        boolean bl = false;
        while (n2 < this.colIndex.length) {
            object = objectArray[this.colIndex[n2]];
            n = Column.compare(this.collation, object, objectArray2[this.colIndex[n2]], this.colType[n2]);
            if (n != 0) {
                return n;
            }
            if (object == null) {
                bl = true;
            }
            ++n2;
        }
        if (this.isUnique && !this.useRowId && !bl) {
            return 0;
        }
        n2 = 0;
        while (n2 < this.pkCols.length) {
            object = objectArray[this.pkCols[n2]];
            n = Column.compare(this.collation, object, objectArray2[this.pkCols[n2]], this.pkTypes[n2]);
            if (n != 0) {
                return n;
            }
            ++n2;
        }
        if (this.useRowId) {
            int n3 = row.getPos() - row2.getPos();
            if (n3 < 0) {
                n3 = -1;
            } else if (n3 > 0) {
                n3 = 1;
            }
            return n3;
        }
        return 0;
    }

    int getIndexOrderValue() {
        boolean bl = false;
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    private RowIterator getIterator(Session session, Node node) {
        if (node == null) {
            return emptyIterator;
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(session, this, node);
        return indexRowIterator;
    }

    static class IndexRowIterator
    implements RowIterator {
        Session session;
        Index index;
        Node nextnode;
        protected IndexRowIterator last;
        protected IndexRowIterator next;

        private IndexRowIterator(Session session, Index index, Node node) {
            if (index == null) {
                return;
            }
            this.session = session;
            this.index = index;
            this.nextnode = node;
        }

        public boolean hasNext() {
            return this.nextnode != null;
        }

        public Row next() {
            if (this.hasNext()) {
                try {
                    Row row = this.nextnode.getRow();
                    this.nextnode = this.index.next(this.nextnode);
                    return row;
                }
                catch (Exception exception) {
                    throw new NoSuchElementException();
                }
            }
            return null;
        }

        void updateForDelete(Node node) {
            try {
                if (node.equals(this.nextnode)) {
                    this.nextnode = this.index.next(node);
                }
            }
            catch (Exception exception) {}
        }

        void link(IndexRowIterator indexRowIterator) {
            indexRowIterator.next = this.next;
            indexRowIterator.last = this;
            this.next.last = indexRowIterator;
            this.next = indexRowIterator;
        }

        public void release() {
            if (this.last != null) {
                this.last.next = this.next;
            }
            if (this.next != null) {
                this.next.last = this.last;
            }
        }
    }
}

