/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableColumnImpl;
import com.sun.star.helper.writer.XWriterTableColumn;
import com.sun.star.helper.writer.XWriterTableColumns;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XTableColumns;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;

public class WriterTableColumnsImpl
extends HelperInterfaceAdaptor
implements XWriterTableColumns,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Columns";
    protected XTextTable xTable = null;
    protected XTableColumns xColumns = null;
    protected Hashtable writerTableColumnCache = null;
    protected int iFirstColumnIndex;
    protected int iLastColumnIndex;

    public WriterTableColumnsImpl(TableImpl tableImpl, XTextTable xTextTable) throws BasicErrorException {
        this(tableImpl, xTextTable, -1, -1);
    }

    public WriterTableColumnsImpl(TableImpl tableImpl, XTextTable xTextTable, int n, int n2) throws BasicErrorException {
        super(__serviceName, tableImpl);
        if (xTextTable == null) {
            DebugHelper.exception(51, "Cannot instantiate with a null parameter");
        }
        this.xTable = xTextTable;
        this.xColumns = this.xTable.getColumns();
        if (n == -1 || n2 == -1) {
            this.iFirstColumnIndex = 0;
            this.iLastColumnIndex = this.xColumns.getCount() - 1;
        } else {
            this.iFirstColumnIndex = n;
            this.iLastColumnIndex = n2;
        }
        this.writerTableColumnCache = new Hashtable();
    }

    public XWriterTableColumn Item(Object object) throws BasicErrorException {
        XWriterTableColumn xWriterTableColumn = null;
        int n = -1;
        try {
            n = NumericalHelper.toInt(object) - 1;
            xWriterTableColumn = this.getColumnAtIndex(n);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return xWriterTableColumn;
    }

    public int Count() throws BasicErrorException {
        return this.iLastColumnIndex - this.iFirstColumnIndex + 1;
    }

    public void Delete() throws BasicErrorException {
        this.delete(this.iFirstColumnIndex, this.Count());
    }

    public Object getWidth() throws BasicErrorException {
        XWriterTableColumn xWriterTableColumn = this.getColumnAtIndex(this.iFirstColumnIndex);
        return xWriterTableColumn.getWidth();
    }

    public void setWidth(Object object) throws BasicErrorException {
        int n = this.iFirstColumnIndex;
        while (n <= this.iLastColumnIndex) {
            XWriterTableColumn xWriterTableColumn = this.getColumnAtIndex(n);
            xWriterTableColumn.setWidth(object);
            ++n;
        }
    }

    XWriterTableColumn getColumnAtIndex(int n) throws BasicErrorException {
        WriterTableColumnImpl writerTableColumnImpl = (WriterTableColumnImpl)this.writerTableColumnCache.get(new Integer(n));
        if (writerTableColumnImpl == null) {
            writerTableColumnImpl = new WriterTableColumnImpl(this, this.xTable, this.xColumns, n + 1);
            this.writerTableColumnCache.put(new Integer(n), writerTableColumnImpl);
        }
        return writerTableColumnImpl;
    }

    public void delete(int n, int n2) {
        this.xColumns.removeByIndex(n, n2);
        Set set = this.writerTableColumnCache.keySet();
        Object[] objectArray = new Integer[set.size()];
        objectArray = set.toArray(objectArray);
        Arrays.sort(objectArray);
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4 = (Integer)objectArray[n3];
            if (n4 >= n && n4 < n + n2) {
                this.writerTableColumnCache.remove(objectArray[n3]);
            } else if (n4 >= n + n2) {
                Integer n5 = new Integer(n4 - n2);
                Object v = this.writerTableColumnCache.remove(objectArray[n3]);
                this.writerTableColumnCache.put(n5, v);
            }
            ++n3;
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xColumns;
    }
}

