/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DispatchCommand;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.WriterTableCellsImpl;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XWriterTableCell;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.table.XCellRange;
import com.sun.star.text.XText;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.MalformedNumberFormatException;
import com.sun.star.util.XNumberFormats;
import com.sun.star.util.XNumberFormatsSupplier;
import com.sun.star.view.XSelectionSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WriterTableCellImpl
extends HelperInterfaceAdaptor
implements XWriterTableCell,
XUnoAccess {
    private static final int MS_OFFICE = 0;
    private static final int S_OFFICE = 1;
    private static final String VERT_ORIENT = "VertOrient";
    protected static final String __serviceName = "com.sun.star.helper.writer.Cell";
    private XCell m_xCell;
    private XPropertySet m_xProp;
    private String sCellName;
    private static final int[][] iVerticalAlignmentMapping = new int[][]{{3, 3}, {1, 2}, {2, 0}, {0, 1}};
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$text$XText;
    static /* synthetic */ Class class$com$sun$star$table$XCellRange;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$util$XNumberFormatsSupplier;

    public WriterTableCellImpl(TableImpl tableImpl, String string) throws BasicErrorException {
        super(__serviceName, tableImpl);
        if (string == null || string.length() == 0) {
            DebugHelper.exception(5, "Cannot create a Cell object with these parameters.");
        }
        this.sCellName = string;
        XTextTable xTextTable = tableImpl.getWrappedTable();
        this.m_xCell = xTextTable.getCellByName(string);
        if (this.m_xCell == null) {
            DebugHelper.exception(5, "Cannot create a Cell object with these parameters.");
        }
        try {
            this.m_xProp = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableCellImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.m_xCell);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    public XRange Range() throws BasicErrorException {
        XText xText = (XText)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XText == null ? (class$com$sun$star$text$XText = WriterTableCellImpl.class$("com.sun.star.text.XText")) : class$com$sun$star$text$XText), (Object)this.m_xCell);
        WriterTableCellsImpl writerTableCellsImpl = null;
        writerTableCellsImpl = new WriterTableCellsImpl(this, (TableImpl)this.getParent(), this.sCellName);
        HelperInterfaceAdaptor helperInterfaceAdaptor = (HelperInterfaceAdaptor)this.getParent();
        while (helperInterfaceAdaptor != null && !(helperInterfaceAdaptor instanceof DocumentImpl)) {
            helperInterfaceAdaptor = (HelperInterfaceAdaptor)helperInterfaceAdaptor.getParent();
        }
        if (helperInterfaceAdaptor == null) {
            DebugHelper.exception(51, "Cannot find document in parent list");
        }
        return new RangeImpl(helperInterfaceAdaptor, xText, xText.getStart(), (XTable)this.getParent(), writerTableCellsImpl);
    }

    public int getVerticalAlignment() throws BasicErrorException {
        int n = 0;
        try {
            Object object = this.m_xProp.getPropertyValue(VERT_ORIENT);
            short s = AnyConverter.toShort((Object)object);
            n = this.getVerticalAlignment(s);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public void setVerticalAlignment(int n) throws BasicErrorException {
        try {
            this.m_xProp.setPropertyValue(VERT_ORIENT, (Object)new Short(this.getCellVertJustify(n)));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getWordWrap() throws BasicErrorException {
        return true;
    }

    public void Select() throws BasicErrorException {
        TableImpl tableImpl = (TableImpl)this.getParent();
        int n = tableImpl.Rows().Count();
        int n2 = tableImpl.Columns().Count();
        if (n == 1 && n2 == 1) {
            tableImpl.Select();
        } else {
            int n3 = this.getColumnIndex();
            int n4 = this.getRowIndex();
            int[] nArray = new int[]{-1, -1};
            int n5 = 0;
            boolean bl = false;
            while (!bl && n5 < 4) {
                nArray[0] = n4 + (n5 == 0 ? 1 : 0) - (n5 == 1 ? 1 : 0);
                nArray[1] = n3 + (n5 == 2 ? 1 : 0) - (n5 == 3 ? 1 : 0);
                bl = nArray[0] >= 1 && nArray[1] >= 1 && nArray[0] <= n && nArray[1] <= n2;
                ++n5;
            }
            StringBuffer stringBuffer = new StringBuffer(TableImpl.getStringForNumber(nArray[1] - 1)).append(nArray[0]);
            StringBuffer stringBuffer2 = new StringBuffer(this.sCellName);
            stringBuffer2 = stringBuffer2.append(":").append(stringBuffer);
            DebugHelper.writeInfo(stringBuffer2.toString());
            XTextTable xTextTable = ((TableImpl)this.getParent()).getWrappedTable();
            XCellRange xCellRange = (XCellRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$table$XCellRange == null ? (class$com$sun$star$table$XCellRange = WriterTableCellImpl.class$("com.sun.star.table.XCellRange")) : class$com$sun$star$table$XCellRange), (Object)xTextTable);
            XCellRange xCellRange2 = xCellRange.getCellRangeByName(stringBuffer2.toString());
            XModel xModel = this.getXModel();
            XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = WriterTableCellImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)xModel.getCurrentController());
            try {
                xSelectionSupplier.select((Object)xCellRange2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((Exception)((Object)illegalArgumentException));
            }
            String string = null;
            switch (n5) {
                case 1: {
                    string = ".uno:GoUp";
                    break;
                }
                case 2: {
                    string = ".uno:GoDown";
                    break;
                }
                case 3: {
                    string = ".uno:GoLeft";
                    break;
                }
                default: {
                    string = ".uno:GoRight";
                }
            }
            DebugHelper.writeInfo(string);
            PropertyValue[] propertyValueArray = new PropertyValue[2];
            propertyValueArray[0] = new PropertyValue();
            propertyValueArray[0].Name = "Count";
            propertyValueArray[0].Value = new Integer(1);
            propertyValueArray[1] = new PropertyValue();
            propertyValueArray[1].Name = "Select";
            propertyValueArray[1].Value = Boolean.TRUE;
            DispatchCommand.execute(string, xModel.getCurrentController().getFrame(), propertyValueArray);
        }
    }

    public void Merge(XWriterTableCell xWriterTableCell) throws BasicErrorException {
        XHelperInterface xHelperInterface = this.getParent();
        if (xHelperInterface instanceof TableImpl) {
            TableImpl tableImpl = (TableImpl)xHelperInterface;
            String string = this.sCellName + ":" + TableImpl.getStringForNumber(xWriterTableCell.getColumnIndex() - 1) + xWriterTableCell.getRowIndex();
            WriterTableCellsImpl writerTableCellsImpl = new WriterTableCellsImpl(this, tableImpl, string);
            writerTableCellsImpl.Merge();
        } else {
            DebugHelper.exception(51, "parent of cell is not a table");
        }
    }

    public void Formula(Object object, Object object2) throws BasicErrorException {
        String string = NumericalHelper.toString(object, "");
        String string2 = NumericalHelper.toString(object2, "");
        this.m_xCell.setFormula(this.convertAndValidateFormulaString(string));
        try {
            java.util.Locale locale;
            XTextRange xTextRange = this.getXTextRange();
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableCellImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xTextRange);
            Locale locale2 = null;
            try {
                locale2 = (Locale)xPropertySet.getPropertyValue("CharLocale");
            }
            catch (Exception exception) {
                DebugHelper.warning(exception);
            }
            if (locale2 == null) {
                DebugHelper.writeInfo("Cannot get locale, using Java locale as fallback.");
                locale = java.util.Locale.getDefault();
                locale2 = new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant());
            }
            locale = (XNumberFormatsSupplier)OptionalParamUtility.getObject(class$com$sun$star$util$XNumberFormatsSupplier == null ? (class$com$sun$star$util$XNumberFormatsSupplier = WriterTableCellImpl.class$("com.sun.star.util.XNumberFormatsSupplier")) : class$com$sun$star$util$XNumberFormatsSupplier, this.getXModel());
            XNumberFormats xNumberFormats = locale.getNumberFormats();
            int n = xNumberFormats.addNew(string2, locale2);
            this.m_xProp.setPropertyValue("NumberFormat", (Object)new Integer(n));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.warning((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.warning((Exception)((Object)wrappedTargetException));
        }
        catch (MalformedNumberFormatException malformedNumberFormatException) {
            DebugHelper.warning((Exception)((Object)malformedNumberFormatException));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.warning((Exception)((Object)unknownPropertyException));
        }
        catch (PropertyVetoException propertyVetoException) {
            DebugHelper.warning((Exception)((Object)propertyVetoException));
        }
    }

    public int getColumnIndex() throws BasicErrorException {
        int n = 0;
        try {
            int n2 = Character.getNumericValue(this.sCellName.charAt(0)) + 56;
            n = n2 - 65;
        }
        catch (NumberFormatException numberFormatException) {
            DebugHelper.exception(51, numberFormatException.getMessage());
        }
        return n;
    }

    public int getRowIndex() throws BasicErrorException {
        int n = 0;
        try {
            n = new Integer(this.sCellName.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            DebugHelper.exception(51, numberFormatException.getMessage());
        }
        return n;
    }

    protected XCell getTableCell() {
        return this.m_xCell;
    }

    private int getVerticalAlignment(short s) throws BasicErrorException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < iVerticalAlignmentMapping.length && !bl) {
            if (iVerticalAlignmentMapping[n2][1] == s) {
                n = iVerticalAlignmentMapping[n2][0];
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DebugHelper.exception(51, "Did not get a mapping for this vertical alignment value.");
        }
        return n;
    }

    private short getCellVertJustify(int n) throws BasicErrorException {
        short s = -1;
        boolean bl = false;
        int n2 = 0;
        while (n2 < iVerticalAlignmentMapping.length && !bl) {
            if (iVerticalAlignmentMapping[n2][0] == n) {
                s = (short)iVerticalAlignmentMapping[n2][1];
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            DebugHelper.exception(51, "Did not get a mapping for this vertical alignment value.");
        }
        return s;
    }

    private String convertAndValidateFormulaString(String string) throws BasicErrorException {
        if ((string = string.trim()).length() == 0 || !string.startsWith("=")) {
            DebugHelper.exception(14, "Formula");
        }
        int n = 0;
        while (n < string.length()) {
            if (string.regionMatches(true, n, "above", 0, "above".length())) {
                DebugHelper.exception(73, "above");
            }
            ++n;
        }
        String string2 = "average";
        String string3 = "mean";
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.regionMatches(true, n2, string2, 0, string2.length())) {
                string = string.substring(0, n2) + string3 + string.substring(n2 + string2.length());
            }
            ++n2;
        }
        string = string.replaceAll(";", "|");
        Pattern pattern = Pattern.compile("[A-Za-z][0-9]");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (matcher.find()) {
            n3 = n4;
            n4 = matcher.start();
            stringBuffer.append(string.substring(n3, n4));
            if (string.charAt(n4 - 1) != ':') {
                stringBuffer.append("<");
            }
            n3 = n4;
            n4 = matcher.end();
            stringBuffer.append(string.substring(n3, n4));
            if (string.charAt(n4) == ':') continue;
            stringBuffer.append(">");
        }
        stringBuffer.append(string.substring(n4));
        return stringBuffer.toString();
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.m_xCell;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

