/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.BorderImpl;
import com.sun.star.helper.writer.LineDefinitionHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.BorderLine;
import com.sun.star.table.XCell;
import com.sun.star.uno.Exception;

public class WriterTableBorderHelperImpl
implements BorderImpl.BorderHelperIfc {
    private String sPropertyName;
    private XCell[][] xBorderCells;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$table$BorderLine;

    public WriterTableBorderHelperImpl(XCell[][] xCellArray, int n) throws BasicErrorException {
        boolean bl = false;
        if (xCellArray == null) {
            bl = true;
        }
        try {
            switch (n) {
                case -3: {
                    this.sPropertyName = "BottomBorder";
                    this.xBorderCells = this.getTopBottomCells(xCellArray, false);
                    break;
                }
                case -2: {
                    this.sPropertyName = "LeftBorder";
                    this.xBorderCells = this.getLeftRightCells(xCellArray, true);
                    break;
                }
                case -4: {
                    this.sPropertyName = "RightBorder";
                    this.xBorderCells = this.getLeftRightCells(xCellArray, false);
                    break;
                }
                case -1: {
                    this.sPropertyName = "TopBorder";
                    this.xBorderCells = this.getTopBottomCells(xCellArray, true);
                    break;
                }
                case -5: {
                    if (xCellArray.length != 1 || xCellArray[0].length != 0) {
                        if (xCellArray.length == 0 && xCellArray[0].length == 1) break;
                        this.sPropertyName = "TopBorder";
                        this.xBorderCells = this.getMiddleCells(xCellArray, true);
                    }
                    break;
                }
                case -6: {
                    if (xCellArray.length != 1 || xCellArray[0].length != 0) {
                        if (xCellArray.length == 0 && xCellArray[0].length == 1) break;
                        this.xBorderCells = this.getMiddleCells(xCellArray, false);
                        this.sPropertyName = "LeftBorder";
                    }
                    break;
                }
                case -8: 
                case -7: {
                    DebugHelper.exception(73, "This border type is not supported.");
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        if (bl) {
            DebugHelper.exception(14, "Cannot construct a Borders object with these parameters.");
        }
    }

    public int getLineWidth() {
        int n = 0;
        BorderLine borderLine = this.getLineStyleProperty(this.xBorderCells[0][0]);
        n = LineDefinitionHelper.getLineWidthFromBorder(borderLine);
        return n;
    }

    public void setLineWidth(int n) throws BasicErrorException {
        int n2 = 0;
        while (n2 < this.xBorderCells.length) {
            int n3 = 0;
            while (n3 < this.xBorderCells[n2].length) {
                BorderLine borderLine = this.getLineStyleProperty(this.xBorderCells[n2][n3]);
                borderLine = LineDefinitionHelper.getBorderLineFromLineWidth(n, borderLine);
                this.setLineStyleProperty(borderLine, this.xBorderCells[n2][n3]);
                ++n3;
            }
            ++n2;
        }
    }

    public int getColor() {
        int n = 0;
        BorderLine borderLine = this.getLineStyleProperty(this.xBorderCells[0][0]);
        n = borderLine.Color;
        n = CalcHelper.swapFirstAndThirdByte(n);
        return n;
    }

    public void setColor(int n) {
        n = n == -16777216 ? 0 : CalcHelper.swapFirstAndThirdByte(n);
        int n2 = 0;
        while (n2 < this.xBorderCells.length) {
            int n3 = 0;
            while (n3 < this.xBorderCells[n2].length) {
                BorderLine borderLine = this.getLineStyleProperty(this.xBorderCells[n2][n3]);
                borderLine.Color = n;
                this.setLineStyleProperty(borderLine, this.xBorderCells[n2][n3]);
                ++n3;
            }
            ++n2;
        }
    }

    public int getLineStyle() {
        int n = 0;
        BorderLine borderLine = this.getLineStyleProperty(this.xBorderCells[0][0]);
        n = LineDefinitionHelper.getLineStyleFromBorderLine(borderLine);
        return n;
    }

    public void setLineStyle(int n) throws BasicErrorException {
        int n2 = 0;
        while (n2 < this.xBorderCells.length) {
            int n3 = 0;
            while (n3 < this.xBorderCells[n2].length) {
                BorderLine borderLine = this.getLineStyleProperty(this.xBorderCells[n2][n3]);
                borderLine = LineDefinitionHelper.getBorderLineFromLineStyle(n, borderLine.Color);
                this.setLineStyleProperty(borderLine, this.xBorderCells[n2][n3]);
                ++n3;
            }
            ++n2;
        }
    }

    private XCell[][] getTopBottomCells(XCell[][] xCellArray, boolean bl) throws IllegalArgumentException {
        if (xCellArray.length == 0 || xCellArray[0].length == 0) {
            throw new IllegalArgumentException("Cannot construct an object with these parameters.");
        }
        int n = xCellArray.length;
        int n2 = bl ? 0 : xCellArray[0].length - 1;
        XCell[][] xCellArray2 = new XCell[n][1];
        int n3 = 0;
        while (n3 < n) {
            xCellArray2[n3][0] = xCellArray[n3][n2];
            ++n3;
        }
        return xCellArray2;
    }

    private XCell[][] getLeftRightCells(XCell[][] xCellArray, boolean bl) throws IllegalArgumentException {
        if (xCellArray.length == 0 || xCellArray[0].length == 0) {
            throw new IllegalArgumentException("Cannot construct an object with these parameters.");
        }
        int n = xCellArray[0].length;
        int n2 = bl ? 0 : xCellArray.length - 1;
        XCell[][] xCellArray2 = new XCell[1][n];
        int n3 = 0;
        while (n3 < n) {
            xCellArray2[0][n3] = xCellArray[n2][n3];
            ++n3;
        }
        return xCellArray2;
    }

    private XCell[][] getMiddleCells(XCell[][] xCellArray, boolean bl) throws IllegalArgumentException {
        if (xCellArray.length == 0 || xCellArray[0].length == 0) {
            throw new IllegalArgumentException("Cannot construct an object with these parameters.");
        }
        int n = bl ? 1 : 0;
        int n2 = 1 - n;
        int n3 = xCellArray.length - n;
        int n4 = xCellArray[0].length - n2;
        XCell[][] xCellArray2 = new XCell[n3][n4];
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n4) {
                xCellArray2[n5][n6] = xCellArray[n5 + n][n6 + n2];
                ++n6;
            }
            ++n5;
        }
        return xCellArray2;
    }

    private BorderLine getLineStyleProperty(XCell xCell) {
        BorderLine borderLine = new BorderLine();
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableBorderHelperImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xCell);
            Object object = xPropertySet.getPropertyValue(this.sPropertyName);
            borderLine = (BorderLine)OptionalParamUtility.getObject(class$com$sun$star$table$BorderLine == null ? (class$com$sun$star$table$BorderLine = WriterTableBorderHelperImpl.class$("com.sun.star.table.BorderLine")) : class$com$sun$star$table$BorderLine, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
        return borderLine;
    }

    private void setLineStyleProperty(BorderLine borderLine, XCell xCell) {
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = WriterTableBorderHelperImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xCell);
            xPropertySet.setPropertyValue(this.sPropertyName, (Object)borderLine);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (UnknownPropertyException unknownPropertyException) {
            HelperUtilities.exception(unknownPropertyException);
        }
        catch (PropertyVetoException propertyVetoException) {
            HelperUtilities.exception(propertyVetoException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            HelperUtilities.exception(wrappedTargetException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

