/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLayoutManager;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XApplication;
import com.sun.star.helper.common.CheckSpelling;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DocumentUtilities;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.XFileSearch;
import com.sun.star.helper.writer.DialogsImpl;
import com.sun.star.helper.writer.DictionaryLocaleMapperImpl;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.DocumentsImpl;
import com.sun.star.helper.writer.FontNamesImpl;
import com.sun.star.helper.writer.ListGalleriesImpl;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.PrintOutHelper;
import com.sun.star.helper.writer.SpellingSuggestionsImpl;
import com.sun.star.helper.writer.TemplatesImpl;
import com.sun.star.helper.writer.WindowImpl;
import com.sun.star.helper.writer.WindowsImpl;
import com.sun.star.helper.writer.XDialogs;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XDocuments;
import com.sun.star.helper.writer.XFontNames;
import com.sun.star.helper.writer.XListGalleries;
import com.sun.star.helper.writer.XOptions;
import com.sun.star.helper.writer.XPrintable;
import com.sun.star.helper.writer.XSpellingSuggestions;
import com.sun.star.helper.writer.XTemplates;
import com.sun.star.helper.writer.XWindow;
import com.sun.star.helper.writer.XWindows;
import com.sun.star.helper.writer.XWriter;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.XComponent;
import com.sun.star.linguistic2.XSpellAlternatives;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.util.ArrayList;

public class WriterImpl
extends HelperInterfaceAdaptor
implements XWriter,
XPrintable {
    protected static final String __serviceName = "com.sun.star.helper.writer.Writer";
    protected static XDocuments xDocuments = null;
    private WindowsImpl cacheWindows;
    private static XTemplates m_xTemplates = null;
    private XOptions m_xOptionsCache = null;
    private String m_sCaptionName = null;
    private XDialogs m_xDialogsCache = null;
    private XFontNames m_xFontNamesCache = null;
    private XListGalleries m_xListGalleriesCache = null;
    private int m_nDisplayAlerts = -1;
    private boolean m_bScreenUpdates = true;
    private String m_sDefaultSaveFormat;
    private boolean m_bUserControl = true;
    public static final String m_sStatusBarURL = "private:resource/statusbar/statusbar";
    private CheckSpelling m_aSpellChecker = null;
    static /* synthetic */ Class class$com$sun$star$frame$XModel;
    static /* synthetic */ Class class$com$sun$star$frame$XLayoutManager;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;

    public WriterImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public XDocuments getDocuments() throws BasicErrorException {
        if (xDocuments == null) {
            xDocuments = new DocumentsImpl(this);
        }
        return xDocuments;
    }

    public static WriterImpl getInstance() {
        return ApplicationImpl.getWriterImpl();
    }

    protected static WindowImpl getWindow(XFrame xFrame) throws BasicErrorException {
        return WriterImpl.getInstance().getWindowsImpl().getWindow(xFrame);
    }

    public static DocumentImpl getDocument(XModel xModel) throws BasicErrorException {
        return (DocumentImpl)WriterImpl.getInstance().getDocuments().getDocument(xModel);
    }

    protected DocumentsImpl getDocumentsImpl() throws BasicErrorException {
        return (DocumentsImpl)this.getDocuments();
    }

    public XDocument getActiveDocument() throws BasicErrorException {
        XDocument xDocument = null;
        XModel xModel = HelperUtilities.getCurrentModel();
        if (xModel != null) {
            try {
                if (HelperUtilities.getModelDocumentType(xModel).equals("swriter")) {
                    xDocument = WriterImpl.getDocument(xModel);
                }
            }
            catch (Exception exception) {
                HelperUtilities.exception(exception);
            }
        }
        if (xDocument == null) {
            xDocument = this.getDocumentsImpl().Item(1);
        }
        return xDocument;
    }

    public String getActivePrinter() throws BasicErrorException {
        return ApplicationImpl.getActivePrinter();
    }

    public void setActivePrinter(String string) throws java.lang.IllegalArgumentException, BasicErrorException {
        ApplicationImpl.setActivePrinter(string);
    }

    public void PrintOut(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16, Object object17, Object object18, Object object19) throws java.lang.IllegalArgumentException, NoSupportException, BasicErrorException {
        PrintOutHelper printOutHelper = new PrintOutHelper(object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14, object15, object16, object17, object18, object19);
        printOutHelper.execute();
    }

    public void Exit(Object object, Object object2, Object object3) throws BasicErrorException {
        int n = OptionalParamUtility.getInt("SaveChanges", object, -2, false);
        int n2 = OptionalParamUtility.getInt("OriginalFormat", object2, 1, false);
        boolean bl = OptionalParamUtility.getBoolean("RouteDocument", object3, false, false);
        HelperUtilities.exit("swriter", n, n2, bl);
    }

    public void Quit(Object object, Object object2, Object object3) throws BasicErrorException {
        int n = OptionalParamUtility.getInt("SaveChanges", object, -2, false);
        int n2 = OptionalParamUtility.getInt("OriginalFormat", object2, 1, false);
        boolean bl = OptionalParamUtility.getBoolean("RouteDocument", object3, false, false);
        DocumentUtilities.exit("swriter", n, n2, bl);
    }

    public XWindows getWindows() throws BasicErrorException {
        return this.getWindowsImpl();
    }

    public WindowsImpl getWindowsImpl() {
        if (this.cacheWindows == null) {
            this.cacheWindows = new WindowsImpl(this);
        }
        return this.cacheWindows;
    }

    public XWindow getActiveWindow() throws BasicErrorException {
        XComponent xComponent = ApplicationImpl.getXDesktop().getCurrentComponent();
        XModel xModel = null;
        try {
            xModel = (XModel)OptionalParamUtility.getObject(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = WriterImpl.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, xComponent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                xModel = (XModel)OptionalParamUtility.getObject(class$com$sun$star$frame$XModel == null ? (class$com$sun$star$frame$XModel = WriterImpl.class$("com.sun.star.frame.XModel")) : class$com$sun$star$frame$XModel, ApplicationImpl.ThisComponent);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException2));
            }
        }
        if ("swriter".equals(HelperUtilities.getModelDocumentType(xModel))) {
            return this.getWindowsImpl().getWindow(xModel.getCurrentController().getFrame());
        }
        return ((WindowsImpl)this.getWindows()).Item(1);
    }

    public XOptions getOptions() throws BasicErrorException {
        if (this.m_xOptionsCache == null) {
            this.m_xOptionsCache = new OptionsImpl(this);
        }
        return this.m_xOptionsCache;
    }

    public int getMailSystem() throws BasicErrorException {
        return 0;
    }

    public void setWidth(int n) throws BasicErrorException {
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            xWindow.setWidth(n);
        }
    }

    public int getWidth() throws BasicErrorException {
        int n = 0;
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            n = xWindow.getWidth();
        }
        return n;
    }

    public void setHeight(int n) throws BasicErrorException {
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            xWindow.setHeight(n);
        }
    }

    public int getHeight() throws BasicErrorException {
        int n = 0;
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            n = xWindow.getHeight();
        }
        return n;
    }

    public void setLeft(int n) throws BasicErrorException {
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            xWindow.setLeft(n);
        }
    }

    public int getLeft() throws BasicErrorException {
        int n = 0;
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            n = xWindow.getLeft();
        }
        return n;
    }

    public void setTop(int n) throws BasicErrorException {
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            xWindow.setTop(n);
        }
    }

    public int getTop() throws BasicErrorException {
        int n = 0;
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            n = xWindow.getTop();
        }
        return n;
    }

    public String getPathSeparator() throws BasicErrorException {
        return System.getProperty("file.separator");
    }

    public String getVersion() throws BasicErrorException {
        return CommonUtilities.getVersion();
    }

    public void setScreenUpdating(boolean bl) throws BasicErrorException {
        this.m_bScreenUpdates = bl;
        int n = this.getDocumentsImpl().Count();
        int n2 = 1;
        while (n2 <= n) {
            XDocument xDocument = this.getDocumentsImpl().Item(n2);
            DocumentImpl documentImpl = (DocumentImpl)xDocument;
            if (bl) {
                documentImpl.unlockControllers();
            } else {
                documentImpl.lockControllers();
            }
            ++n2;
        }
    }

    public boolean getScreenUpdating() throws BasicErrorException {
        return this.m_bScreenUpdates;
    }

    public void setDefaultSaveFormat(String string) throws NoSupportException, BasicErrorException {
        if (!(string.toLowerCase().equals("") || string.toLowerCase().equals("dot") || string.toLowerCase().equals("text") || string.toLowerCase().equals("crtext") || string.toLowerCase().equals("8text") || string.toLowerCase().equals("8crtext") || string.toLowerCase().equals("rtf") || string.toLowerCase().equals("unicode"))) {
            throw new NoSupportException("unknown DefaultSaveFormat");
        }
        this.m_sDefaultSaveFormat = string;
    }

    public String getDefaultSaveFormat() throws BasicErrorException {
        if (this.m_sDefaultSaveFormat == null) {
            this.m_sDefaultSaveFormat = "";
        }
        return this.m_sDefaultSaveFormat;
    }

    public XTemplates Templates() throws BasicErrorException {
        if (m_xTemplates == null) {
            DocumentsImpl documentsImpl = (DocumentsImpl)this.getDocuments();
            m_xTemplates = TemplatesImpl.create(documentsImpl);
        }
        return m_xTemplates;
    }

    public void Activate() throws BasicErrorException {
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            xWindow.Activate();
        }
    }

    public String getBuild() throws BasicErrorException {
        return CommonUtilities.getBuildID(this.getPath());
    }

    public String getCaption() throws BasicErrorException {
        if (this.m_sCaptionName == null) {
            String string = this.CommonApplication().getName() + " Writer";
            return string;
        }
        return this.m_sCaptionName;
    }

    public void setCaption(String string) throws BasicErrorException {
        this.m_sCaptionName = string;
        WindowImpl windowImpl = (WindowImpl)this.getActiveWindow();
        if (windowImpl != null) {
            windowImpl.setApplicationNameInWindowTitle(string);
        }
    }

    public boolean getMAPIAvailable() throws BasicErrorException {
        return CommonUtilities.isWindows();
    }

    public String getPath() throws BasicErrorException {
        XOptions xOptions = this.getOptions();
        String string = xOptions.DefaultFilePath(9);
        return string;
    }

    public String getUserName() throws BasicErrorException {
        XApplication xApplication = this.CommonApplication();
        ApplicationImpl applicationImpl = (ApplicationImpl)xApplication;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (applicationImpl.getFirstName() != null && applicationImpl.getFirstName().length() > 0) {
            stringBuffer.append(applicationImpl.getFirstName());
            bl = true;
        }
        if (applicationImpl.getFathersName() != null && applicationImpl.getFathersName().length() > 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(applicationImpl.getFathersName());
            bl = true;
        }
        if (applicationImpl.getLastName() != null && applicationImpl.getLastName().length() > 0) {
            if (bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(applicationImpl.getLastName());
        }
        return stringBuffer.toString();
    }

    public boolean getUserControl() throws BasicErrorException {
        return this.m_bUserControl;
    }

    public boolean getCheckLanguage() throws BasicErrorException {
        XApplication xApplication = this.CommonApplication();
        ApplicationImpl applicationImpl = (ApplicationImpl)xApplication;
        return applicationImpl.m_bInstalledLocales;
    }

    public void setCheckLanguage(boolean bl) throws BasicErrorException {
        XApplication xApplication = this.CommonApplication();
        ApplicationImpl applicationImpl = (ApplicationImpl)xApplication;
        applicationImpl.m_bInstalledLocales = bl;
    }

    public void setVisible(boolean bl) throws BasicErrorException {
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            xWindow.setVisible(bl);
        }
    }

    public boolean getVisible() throws BasicErrorException {
        boolean bl = true;
        XWindow xWindow = this.getActiveWindow();
        if (xWindow != null) {
            bl = xWindow.getVisible();
        }
        return bl;
    }

    public String getName() throws BasicErrorException {
        String string = this.CommonApplication().getName() + " Writer";
        return string;
    }

    protected XFrame getActiveFrame() throws BasicErrorException {
        XController xController;
        XModel xModel;
        XFrame xFrame = null;
        XDocument xDocument = this.getActiveDocument();
        if (xDocument != null && (xModel = ((DocumentImpl)xDocument).getXModel()) != null && (xController = xModel.getCurrentController()) != null) {
            xFrame = xController.getFrame();
        }
        return xFrame;
    }

    public boolean getDisplayStatusBar() throws BasicErrorException {
        XFrame xFrame;
        PropertySetHelper propertySetHelper;
        Object object;
        boolean bl = true;
        XLayoutManager xLayoutManager = (XLayoutManager)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XLayoutManager == null ? (class$com$sun$star$frame$XLayoutManager = WriterImpl.class$("com.sun.star.frame.XLayoutManager")) : class$com$sun$star$frame$XLayoutManager), (Object)(object = (propertySetHelper = new PropertySetHelper(xFrame = this.getActiveFrame())).getPropertyValueAsObject("LayoutManager")));
        if (xLayoutManager != null) {
            bl = xLayoutManager.isElementVisible(m_sStatusBarURL);
        }
        return bl;
    }

    public void setDisplayStatusBar(boolean bl) throws BasicErrorException {
        XFrame xFrame;
        PropertySetHelper propertySetHelper;
        Object object;
        boolean bl2 = true;
        XLayoutManager xLayoutManager = (XLayoutManager)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XLayoutManager == null ? (class$com$sun$star$frame$XLayoutManager = WriterImpl.class$("com.sun.star.frame.XLayoutManager")) : class$com$sun$star$frame$XLayoutManager), (Object)(object = (propertySetHelper = new PropertySetHelper(xFrame = this.getActiveFrame())).getPropertyValueAsObject("LayoutManager")));
        if (xLayoutManager != null) {
            if (bl) {
                if (!xLayoutManager.isElementVisible(m_sStatusBarURL)) {
                    xLayoutManager.createElement(m_sStatusBarURL);
                    xLayoutManager.showElement(m_sStatusBarURL);
                }
            } else if (xLayoutManager.isElementVisible(m_sStatusBarURL)) {
                xLayoutManager.hideElement(m_sStatusBarURL);
            }
        }
    }

    public boolean CheckSpelling(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) throws BasicErrorException {
        if (AnyConverter.isVoid((Object)object)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("Parameter Word not given.")));
        }
        String string = OptionalParamUtility.getString("Word", object, "", false);
        if (this.m_aSpellChecker == null) {
            this.m_aSpellChecker = new CheckSpelling();
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (!AnyConverter.isVoid((Object)object3)) {
            string = string.toUpperCase();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "IsSpellUpperCase";
            propertyValue.Value = Boolean.TRUE;
            arrayList.add(propertyValue);
            this.m_aSpellChecker.setPropertyList(arrayList);
        }
        if (!AnyConverter.isVoid((Object)object2)) {
            DebugHelper.writeInfo("CheckSpelling() Parameter CustomDictionary is not supported.");
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            DebugHelper.writeInfo("CheckSpelling() Parameter MainDictionary is not supported.");
        }
        this.m_aSpellChecker.setPropertyList(arrayList);
        return this.m_aSpellChecker.checkSentence(string);
    }

    public Object Run(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16, Object object17, Object object18, Object object19, Object object20, Object object21, Object object22, Object object23, Object object24, Object object25, Object object26, Object object27, Object object28, Object object29, Object object30) throws BasicErrorException {
        XFrame xFrame = this.getActiveFrame();
        return CommonUtilities.ApplicationRun(xFrame, string, object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14, object15, object16, object17, object18, object19, object20, object21, object22, object23, object24, object25, object26, object27, object28, object29, object30);
    }

    public int getDisplayAlerts() throws BasicErrorException {
        return this.m_nDisplayAlerts;
    }

    public void setDisplayAlerts(int n) throws BasicErrorException {
        if (n == 0 || n == -2 || n == -1) {
            this.m_nDisplayAlerts = n;
        } else {
            DebugHelper.exception(969, "Parameter: Given value is not from type WdAlertsLevel.");
        }
    }

    public XDialogs Dialogs() throws BasicErrorException {
        if (this.m_xDialogsCache == null) {
            this.m_xDialogsCache = new DialogsImpl(this);
        }
        return this.m_xDialogsCache;
    }

    public XFontNames FontNames() throws BasicErrorException {
        if (this.m_xFontNamesCache == null) {
            this.m_xFontNamesCache = new FontNamesImpl(this);
        }
        return this.m_xFontNamesCache;
    }

    public XListGalleries ListGalleries() throws BasicErrorException {
        if (this.m_xListGalleriesCache == null) {
            this.m_xListGalleriesCache = new ListGalleriesImpl(this);
        }
        return this.m_xListGalleriesCache;
    }

    public XSpellingSuggestions GetSpellingSuggestions(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13) throws BasicErrorException {
        SpellingSuggestionsImpl spellingSuggestionsImpl = null;
        try {
            XSpellAlternatives xSpellAlternatives;
            String string2;
            CheckSpelling checkSpelling = new CheckSpelling();
            if (!AnyConverter.isVoid((Object)object)) {
                DebugHelper.writeInfo("CheckSpelling() Parameter CustomDictionary is not supported.");
            }
            Locale locale = null;
            if (!AnyConverter.isVoid((Object)object3)) {
                string2 = AnyConverter.toString((Object)object3);
                locale = DictionaryLocaleMapperImpl.getLocale(string2);
            }
            if (locale == null) {
                locale = checkSpelling.getCurrentLocale();
            }
            if ((xSpellAlternatives = (string2 = checkSpelling.getSpellChecker()).spell(string, locale, checkSpelling.getCurrentProperties())) != null) {
                spellingSuggestionsImpl = new SpellingSuggestionsImpl(this, xSpellAlternatives);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return spellingSuggestionsImpl;
    }

    public void ScreenRefresh() throws BasicErrorException {
        this.m_bScreenUpdates = false;
        if (false) {
            this.setScreenUpdating(true);
            int n = this.getDocumentsImpl().Count();
            int n2 = 1;
            while (n2 <= n) {
                XDocument xDocument;
                DocumentImpl documentImpl;
                Object object;
                XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? WriterImpl.class$("com.sun.star.text.XTextDocument") : class$com$sun$star$text$XTextDocument), (Object)(object = (documentImpl = (DocumentImpl)(xDocument = this.getDocumentsImpl().Item(n2))).getUnoObject()));
                if (xTextDocument != null) {
                    xTextDocument.reformat();
                }
                ++n2;
            }
            this.setScreenUpdating(false);
        }
    }

    public void ChangeFileOpenDirectory(String string) throws BasicErrorException {
        File file = new File(string);
        if (!file.exists()) {
            DebugHelper.exception(76, string);
        }
        if (!file.isDirectory()) {
            DebugHelper.exception(51, string + " is not a directory.");
        }
        ApplicationImpl.setWorkingDirectory(string);
    }

    public double InchesToPoints(double d) throws BasicErrorException {
        return this.CommonApplication().InchesToPoints(d);
    }

    public double CentimetersToPoints(double d) throws BasicErrorException {
        return this.CommonApplication().CentimetersToPoints(d);
    }

    public double MillimetersToPoints(double d) throws BasicErrorException {
        return this.CommonApplication().MillimetersToPoints(d);
    }

    public double PointsToInches(double d) throws BasicErrorException {
        return this.CommonApplication().PointsToInches(d);
    }

    public double PointsToCentimeters(double d) throws BasicErrorException {
        return this.CommonApplication().PointsToCentimeters(d);
    }

    public double PointsToMillimeters(double d) throws BasicErrorException {
        return this.CommonApplication().PointsToMillimeters(d);
    }

    public double PointsToPixels(double d, Object object) throws BasicErrorException {
        boolean bl = NumericalHelper.toBoolean(object, true);
        WindowImpl windowImpl = (WindowImpl)this.getActiveWindow();
        return ApplicationImpl.PointsToPixels(windowImpl.mxDevice, d, bl);
    }

    public double PixelsToPoints(double d, Object object) throws BasicErrorException {
        boolean bl = NumericalHelper.toBoolean(object, true);
        WindowImpl windowImpl = (WindowImpl)this.getActiveWindow();
        return ApplicationImpl.PixelsToPoints(windowImpl.mxDevice, d, bl);
    }

    public XFileSearch FileSearch() throws BasicErrorException {
        return ApplicationImpl.getInstance().FileSearch();
    }

    public void setStartupPath(String string) throws BasicErrorException {
        try {
            XOptions xOptions = this.getOptions();
            xOptions.setDefaultFilePath(8, string);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public String getStartupPath() throws BasicErrorException {
        String string = "";
        try {
            XOptions xOptions = this.getOptions();
            string = xOptions.DefaultFilePath(8);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return string;
    }

    public void setStatusBar(String string) throws BasicErrorException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

