/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.drawing.XShape;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Millimeter;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.writer.ShapeImpl;
import com.sun.star.helper.writer.XWrapFormat;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.WrapTextMode;
import com.sun.star.uno.Exception;

public class WrapFormatImpl
extends HelperInterfaceAdaptor
implements XWrapFormat {
    protected static final String __serviceName = "com.sun.star.helper.writer.WrapFormat";
    private int m_nWrapFormatType = 0;
    private int m_nSide = 0;
    private Millimeter m_aMillimeterConverterHelper = null;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    public WrapFormatImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    private void makeWrap() throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = WrapFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            if (this.m_nSide == 1) {
                propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.LEFT);
            } else if (this.m_nSide == 2) {
                propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.RIGHT);
            } else if (this.m_nSide == 0 || this.m_nSide == 3) {
                switch (this.m_nWrapFormatType) {
                    case 3: {
                        propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.THROUGHT);
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 2: {
                        propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.THROUGHT);
                        break;
                    }
                    case 0: {
                        propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.PARALLEL);
                        propertySetHelper.setPropertyValue("SurroundContour", Boolean.FALSE);
                        break;
                    }
                    case 1: {
                        propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.PARALLEL);
                        propertySetHelper.setPropertyValue("SurroundContour", Boolean.TRUE);
                        break;
                    }
                    case 4: {
                        propertySetHelper.setPropertyValue("TextWrap", WrapTextMode.NONE);
                        break;
                    }
                    default: {
                        DebugHelper.warning((Exception)((Object)new NoSupportException("In Property WrapFormat the given type is not supported.")));
                    }
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void setType(int n) throws BasicErrorException {
        this.m_nWrapFormatType = n;
        this.makeWrap();
    }

    public int getType() throws BasicErrorException {
        int n;
        block6: {
            n = 0;
            try {
                ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
                XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = WrapFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
                PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
                WrapTextMode wrapTextMode = (WrapTextMode)propertySetHelper.getPropertyValueAsObject("TextWrap");
                if (wrapTextMode == WrapTextMode.NONE) {
                    n = 4;
                    break block6;
                }
                if (wrapTextMode == WrapTextMode.THROUGHT) {
                    n = 3;
                    break block6;
                }
                if (wrapTextMode == WrapTextMode.PARALLEL) {
                    boolean bl = propertySetHelper.getPropertyValueAsBoolean("SurroundContour", false);
                    n = bl ? 1 : 0;
                    break block6;
                }
                if (wrapTextMode == WrapTextMode.DYNAMIC || wrapTextMode == WrapTextMode.LEFT || wrapTextMode == WrapTextMode.RIGHT) {
                    n = 2;
                    break block6;
                }
                n = 0;
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return n;
    }

    public void setSide(int n) throws BasicErrorException {
        this.m_nSide = n;
        this.makeWrap();
    }

    public int getSide() throws BasicErrorException {
        int n;
        block4: {
            n = 0;
            try {
                ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
                XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = WrapFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
                PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
                WrapTextMode wrapTextMode = (WrapTextMode)propertySetHelper.getPropertyValueAsObject("TextWrap");
                if (wrapTextMode == WrapTextMode.LEFT) {
                    n = 1;
                    break block4;
                }
                if (wrapTextMode == WrapTextMode.RIGHT) {
                    n = 2;
                    break block4;
                }
                n = 0;
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return n;
    }

    Millimeter getMillimeterHelper() throws BasicErrorException {
        if (this.m_aMillimeterConverterHelper == null) {
            this.m_aMillimeterConverterHelper = new Millimeter();
        }
        return this.m_aMillimeterConverterHelper;
    }

    private double getDistance(String string) throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = WrapFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            int n = propertySetHelper.getPropertyValueAsInteger(string, 0);
            Millimeter millimeter = this.getMillimeterHelper();
            millimeter.setInHundredthsOfOneMillimeter(n);
            return millimeter.getInPoints();
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return 0.0;
        }
    }

    private void setDistance(String string, double d) throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = WrapFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            Millimeter millimeter = this.getMillimeterHelper();
            millimeter.setInPoints(d);
            propertySetHelper.setPropertyValue(string, new Integer((int)millimeter.getInHundredthsOfOneMillimeter()));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void setDistanceTop(double d) throws BasicErrorException {
        this.setDistance("TopMargin", d);
    }

    public double getDistanceTop() throws BasicErrorException {
        return this.getDistance("TopMargin");
    }

    public void setDistanceBottom(double d) throws BasicErrorException {
        this.setDistance("BottomMargin", d);
    }

    public double getDistanceBottom() throws BasicErrorException {
        return this.getDistance("BottomMargin");
    }

    public void setDistanceLeft(double d) throws BasicErrorException {
        this.setDistance("LeftMargin", d);
    }

    public double getDistanceLeft() throws BasicErrorException {
        return this.getDistance("LeftMargin");
    }

    public void setDistanceRight(double d) throws BasicErrorException {
        this.setDistance("RightMargin", d);
    }

    public double getDistanceRight() throws BasicErrorException {
        return this.getDistance("RightMargin");
    }

    public void setAllowOverlap(boolean bl) throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("AllowOverlay is not supported.")));
    }

    public boolean getAllowOverlap() throws BasicErrorException {
        DebugHelper.writeInfo("AllowOverlap returns always true.");
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

