/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.IndexAccessInterfaceAdaptor;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.TableImpl;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XTable;
import com.sun.star.helper.writer.XTables;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import java.util.Hashtable;
import java.util.Vector;

public class TablesImpl
extends IndexAccessInterfaceAdaptor
implements XTables {
    protected static final String __serviceName = "com.sun.star.helper.writer.Tables";
    private Hashtable documentTableCache = new Hashtable();
    static /* synthetic */ Class class$com$sun$star$text$XTextTablesSupplier;
    static /* synthetic */ Class class$com$sun$star$container$XEnumeration;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$text$XTextTable;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;

    public TablesImpl(DocumentImpl documentImpl) {
        this((HelperInterfaceAdaptor)documentImpl);
    }

    public TablesImpl(RangeImpl rangeImpl) {
        this((HelperInterfaceAdaptor)rangeImpl);
    }

    private TablesImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public int Count() throws BasicErrorException {
        return this.getNumTables();
    }

    public Object Item(Object object) throws BasicErrorException {
        TableImpl tableImpl;
        block10: {
            tableImpl = null;
            int n = -1;
            String string = "";
            try {
                if (object != null && !AnyConverter.isVoid((Object)object)) {
                    if (AnyConverter.isString((Object)object)) {
                        string = AnyConverter.toString((Object)object);
                    } else {
                        n = AnyConverter.toInt((Object)object) - 1;
                    }
                } else {
                    n = 0;
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(9, exception.getMessage());
            }
            try {
                if (n != -1) {
                    tableImpl = this.getTableAtIndex(n);
                    break block10;
                }
                tableImpl = this.getTableByName(string);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)indexOutOfBoundsException));
            }
            catch (NoSuchElementException noSuchElementException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)noSuchElementException));
            }
        }
        return tableImpl;
    }

    public XTable Add(XRange xRange, Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        TableImpl tableImpl = null;
        try {
            int n = AnyConverter.toInt((Object)object);
            int n2 = AnyConverter.toInt((Object)object2);
            if (n <= 0 || n2 <= 0) {
                DebugHelper.exception(9, "Rows or columns");
            }
            tableImpl = this.createTable(xRange, n, n2, object3, object4);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return tableImpl;
    }

    protected void deleteTableByName(String string) {
        try {
            XTable xTable = (XTable)this.Item(string);
            xTable.Rows().Delete();
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.warning(exception);
        }
    }

    protected void refreshTableCache() throws BasicErrorException {
        XTextTable xTextTable;
        String[] stringArray = null;
        XHelperInterface xHelperInterface = this.getParent();
        XModel xModel = this.getXModel();
        XTextTablesSupplier xTextTablesSupplier = null;
        try {
            xTextTablesSupplier = (XTextTablesSupplier)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTablesSupplier == null ? (class$com$sun$star$text$XTextTablesSupplier = TablesImpl.class$("com.sun.star.text.XTextTablesSupplier")) : class$com$sun$star$text$XTextTablesSupplier, xModel);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        XNameAccess xNameAccess = null;
        if (xTextTablesSupplier != null) {
            xNameAccess = xTextTablesSupplier.getTextTables();
            if (xHelperInterface instanceof RangeImpl) {
                XTextCursor xTextCursor = ((RangeImpl)xHelperInterface).getXTextCursor();
                xTextTable = new Vector();
                try {
                    XEnumeration xEnumeration;
                    Object object;
                    XEnumeration xEnumeration2 = (XEnumeration)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumeration == null ? (class$com$sun$star$container$XEnumeration = TablesImpl.class$("com.sun.star.container.XEnumeration")) : class$com$sun$star$container$XEnumeration, xTextCursor.getText());
                    if (xEnumeration2 != null) {
                        while (xEnumeration2.hasMoreElements()) {
                            object = xEnumeration2.nextElement();
                            if (!(object instanceof Any)) continue;
                            xEnumeration = (Any)object;
                            object = xEnumeration.getObject();
                        }
                    }
                    object = (XEnumerationAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = TablesImpl.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, xTextCursor.getText());
                    xEnumeration = object.createEnumeration();
                    while (xEnumeration.hasMoreElements()) {
                        Any any;
                        Object object2 = xEnumeration.nextElement();
                        if (object2 instanceof Any) {
                            any = (Any)object2;
                            object2 = any.getObject();
                        }
                        if (!(object2 instanceof XTextTable) && (any = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? TablesImpl.class$("com.sun.star.beans.XPropertySet") : class$com$sun$star$beans$XPropertySet, object2)) != null) {
                            try {
                                object2 = any.getPropertyValue("TextTable");
                                if (object2 != null && !AnyConverter.isVoid((Object)object2)) {
                                    object2 = (XTextTable)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTable == null ? TablesImpl.class$("com.sun.star.text.XTextTable") : class$com$sun$star$text$XTextTable, object2);
                                }
                            }
                            catch (UnknownPropertyException unknownPropertyException) {
                                DebugHelper.warning((com.sun.star.uno.Exception)((Object)unknownPropertyException));
                            }
                        }
                        if (!(object2 instanceof XTextTable) || (any = (XNamed)OptionalParamUtility.getObject(class$com$sun$star$container$XNamed == null ? TablesImpl.class$("com.sun.star.container.XNamed") : class$com$sun$star$container$XNamed, object2)) == null) continue;
                        xTextTable.add(any.getName());
                    }
                    stringArray = new String[xTextTable.size()];
                    stringArray = xTextTable.toArray(stringArray);
                }
                catch (NullPointerException nullPointerException) {
                    DebugHelper.writeInfo(nullPointerException.getMessage());
                }
                catch (ClassCastException classCastException) {
                    DebugHelper.writeInfo(classCastException.getMessage());
                }
                catch (NoSuchElementException noSuchElementException) {
                    DebugHelper.exception((com.sun.star.uno.Exception)((Object)noSuchElementException));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
                }
            } else if (xNameAccess.hasElements()) {
                stringArray = xNameAccess.getElementNames();
            }
        }
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    xTextTable = (XTextTable)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTable == null ? TablesImpl.class$("com.sun.star.text.XTextTable") : class$com$sun$star$text$XTextTable, xNameAccess.getByName(stringArray[n]));
                    this.documentTableCache.put(stringArray[n], new TableImpl(this, xTextTable, stringArray[n]));
                }
                catch (Exception exception) {
                    DebugHelper.writeInfo(exception.getMessage());
                }
                ++n;
            }
        }
    }

    protected void removeFromTableCache(String string) {
        if (string != null) {
            this.documentTableCache.remove(string);
        }
    }

    private TableImpl createTable(XRange xRange, int n, int n2, Object object, Object object2) throws com.sun.star.uno.Exception {
        this.refreshTableCache();
        XModel xModel = ((RangeImpl)xRange).getXModel();
        XTextRange xTextRange = xRange.getXTextRange();
        XTextTable xTextTable = null;
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = TablesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xModel);
        Object object3 = xMultiServiceFactory.createInstance("com.sun.star.text.TextTable");
        xTextTable = (XTextTable)OptionalParamUtility.getObject(class$com$sun$star$text$XTextTable == null ? (class$com$sun$star$text$XTextTable = TablesImpl.class$("com.sun.star.text.XTextTable")) : class$com$sun$star$text$XTextTable, object3);
        xTextTable.initialize(n, n2);
        XText xText = xTextRange.getText();
        XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = TablesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, xTextTable);
        xText.insertTextContent(xTextRange, xTextContent, true);
        TableImpl tableImpl = null;
        XNamed xNamed = (XNamed)OptionalParamUtility.getObject(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = TablesImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed, xTextTable);
        tableImpl = new TableImpl(this, xTextTable, xNamed.getName());
        this.documentTableCache.put(xNamed.getName(), tableImpl);
        return tableImpl;
    }

    protected TableImpl getTableByName(String string) throws NoSuchElementException, BasicErrorException {
        this.refreshTableCache();
        TableImpl tableImpl = (TableImpl)this.documentTableCache.get(string);
        if (tableImpl == null) {
            throw new NoSuchElementException("An element with name '" + string + "' was not found.");
        }
        return tableImpl;
    }

    private TableImpl getTableAtIndex(int n) throws IndexOutOfBoundsException, BasicErrorException {
        this.refreshTableCache();
        try {
            TableImpl[] tableImplArray = new TableImpl[this.documentTableCache.size()];
            tableImplArray = this.documentTableCache.values().toArray(tableImplArray);
            return tableImplArray[n];
        }
        catch (Exception exception) {
            throw new IndexOutOfBoundsException("An element with index '" + n + "' was not found.");
        }
    }

    private int getNumTables() throws BasicErrorException {
        this.refreshTableCache();
        return this.documentTableCache.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

