/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.awt.XBitmap;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNamed;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CollectionHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.GraphicsFilename;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.ShapeImpl;
import com.sun.star.helper.writer.ShapeNameCounter;
import com.sun.star.helper.writer.ShapeRangeImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XRange;
import com.sun.star.helper.writer.XShape;
import com.sun.star.helper.writer.XShapeRange;
import com.sun.star.helper.writer.XShapes;
import com.sun.star.helper.writer.XTextFrame;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.style.XStyle;
import com.sun.star.table.BorderLine;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.WrapTextMode;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.view.XSelectionSupplier;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ShapesImpl
extends HelperInterfaceAdaptor
implements XShapes,
ShapeNameCounter,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Shapes";
    private com.sun.star.drawing.XShapes m_xShapes = null;
    private ShapesHelperCache m_aCurrentShapesList;
    private static int sizeFactorPolyline = 20;
    private static int xyFactorPolyline = 570;
    private static double xyFactorTextbox = 14.35;
    private static short textboxBorderline = (short)5;
    private static int textboxLeftBorderlineDist = 280;
    private static int textboxTopBorderlineDist = 150;
    private static int noShapesSelected = 0;
    private int m_nShapeCount = 0;
    static /* synthetic */ Class class$com$sun$star$drawing$XShapes;
    static /* synthetic */ Class class$com$sun$star$helper$writer$XShape;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$helper$writer$XRange;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;
    static /* synthetic */ Class class$com$sun$star$awt$XBitmap;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XTextRange;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$drawing$XDrawPageSupplier;
    static /* synthetic */ Class class$com$sun$star$text$XTextFrame;

    public ShapesImpl(DocumentImpl documentImpl, com.sun.star.drawing.XShapes xShapes) throws IllegalArgumentException {
        super(__serviceName, documentImpl);
        this.m_xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = ShapesImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, xShapes);
        this.m_aCurrentShapesList = new ShapesHelperCache(this);
        this.m_nShapeCount = this.m_aCurrentShapesList.count();
    }

    public int Count() throws BasicErrorException {
        this.m_aCurrentShapesList.updateCache();
        return this.m_aCurrentShapesList.count();
    }

    public XShape Item(Object object) throws BasicErrorException {
        XShape xShape = null;
        if (AnyConverter.isString((Object)object)) {
            String string = "";
            try {
                string = AnyConverter.toString((Object)object);
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
            xShape = this.getItemByName(string);
        } else {
            try {
                int n = NumericalHelper.toInt(object);
                xShape = this.getItemByIndex(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(964, object.getClass().getName());
            }
        }
        if (xShape == null) {
            DebugHelper.exception(5, "");
        }
        return xShape;
    }

    protected XShape getItemByName(String string) throws BasicErrorException {
        Object var2_2 = null;
        this.m_aCurrentShapesList.updateCache();
        int n = this.m_aCurrentShapesList.count();
        int n2 = 0;
        while (n2 < n) {
            ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n2);
            if (shapeImpl.getName().equals(string)) {
                return shapeImpl;
            }
            ++n2;
        }
        return null;
    }

    protected XShape getItemByIndex(int n) throws BasicErrorException {
        Object var2_2 = null;
        XShape xShape = null;
        Object var4_4 = null;
        this.m_aCurrentShapesList.updateCache();
        Object object = this.m_aCurrentShapesList.item(n - 1);
        try {
            xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$helper$writer$XShape == null ? (class$com$sun$star$helper$writer$XShape = ShapesImpl.class$("com.sun.star.helper.writer.XShape")) : class$com$sun$star$helper$writer$XShape, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        return xShape;
    }

    private Point calculateTopLeftMargin(DocumentImpl documentImpl) throws BasicErrorException {
        int n;
        Point point = new Point(0, 0);
        XStyle xStyle = null;
        Object var4_4 = null;
        XModel xModel = documentImpl.getXModel();
        xStyle = WriterUtilities.getCurrentPageStyle(xModel);
        PropertySetHelper propertySetHelper = new PropertySetHelper(xStyle);
        int n2 = propertySetHelper.getPropertyValueAsInteger("TopMargin", 0);
        point.X = n = propertySetHelper.getPropertyValueAsInteger("LeftMargin", 0);
        point.Y = n2;
        return point;
    }

    public Object AddLine(int n, int n2, int n3, int n4, Object object) throws BasicErrorException {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        com.sun.star.drawing.XShape xShape = null;
        Object var9_9 = null;
        try {
            int n7 = WriterUtilities.pointsToHundredthsMillimeter(n6);
            int n8 = WriterUtilities.pointsToHundredthsMillimeter(n5);
            int n9 = WriterUtilities.pointsToHundredthsMillimeter(n);
            int n10 = WriterUtilities.pointsToHundredthsMillimeter(n2);
            xShape = this.createShape("com.sun.star.drawing.LineShape");
            this.m_xShapes.add(xShape);
            Point point = new Point(0, 0);
            XDocument xDocument = (XDocument)this.getParent();
            if (AnyConverter.isVoid((Object)object)) {
                object = xDocument.Range(new Integer(0), new Integer(1));
                point = this.calculateTopLeftMargin((DocumentImpl)xDocument);
            }
            ShapesImpl.setShape_AnchorTypeAndRangeProperty(xShape, object);
            String string = ShapeName.create("Line", this);
            this.incrementShapeCount();
            ShapesImpl.setDefaultShapeProperties(xShape);
            ShapesImpl.setShape_NameProperty(xShape, string);
            Point point2 = new Point();
            point2.X = n9 - point.X;
            point2.Y = n10 - point.Y;
            xShape.setPosition(point2);
            Size size = new Size();
            size.Height = n7;
            size.Width = n8;
            xShape.setSize(size);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        ShapeImpl shapeImpl = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, 9);
        shapeImpl.setRange(object);
        return shapeImpl;
    }

    private Object AddRectangle(int n, int n2, int n3, int n4, Object object) throws BasicErrorException {
        com.sun.star.drawing.XShape xShape = null;
        String string = "com.sun.star.drawing.RectangleShape";
        try {
            int n5 = WriterUtilities.pointsToHundredthsMillimeter(n4);
            int n6 = WriterUtilities.pointsToHundredthsMillimeter(n3);
            int n7 = WriterUtilities.pointsToHundredthsMillimeter(n);
            int n8 = WriterUtilities.pointsToHundredthsMillimeter(n2);
            xShape = this.createShape(string);
            this.m_xShapes.add(xShape);
            Point point = new Point(0, 0);
            XDocument xDocument = (XDocument)this.getParent();
            if (AnyConverter.isVoid((Object)object)) {
                object = xDocument.Range(new Integer(0), new Integer(1));
                point = this.calculateTopLeftMargin((DocumentImpl)xDocument);
            }
            ShapesImpl.setShape_AnchorTypeAndRangeProperty(xShape, object);
            String string2 = ShapeName.create("Rectangle", this);
            this.incrementShapeCount();
            ShapesImpl.setDefaultShapeProperties(xShape);
            ShapesImpl.setShape_NameProperty(xShape, string2);
            Point point2 = new Point();
            point2.X = n7 - point.X;
            point2.Y = n8 - point.Y;
            xShape.setPosition(point2);
            Size size = new Size();
            size.Height = n5;
            size.Width = n6;
            xShape.setSize(size);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        ShapeImpl shapeImpl = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, 1);
        shapeImpl.setRange(object);
        shapeImpl.setInnerTypeName(string);
        return shapeImpl;
    }

    private Object AddEllipse(int n, int n2, int n3, int n4, Object object) throws BasicErrorException {
        com.sun.star.drawing.XShape xShape = null;
        String string = "com.sun.star.drawing.EllipseShape";
        try {
            int n5 = WriterUtilities.pointsToHundredthsMillimeter(n4);
            int n6 = WriterUtilities.pointsToHundredthsMillimeter(n3);
            int n7 = WriterUtilities.pointsToHundredthsMillimeter(n);
            int n8 = WriterUtilities.pointsToHundredthsMillimeter(n2);
            xShape = this.createShape(string);
            this.m_xShapes.add(xShape);
            Point point = new Point(0, 0);
            XDocument xDocument = (XDocument)this.getParent();
            if (AnyConverter.isVoid((Object)object)) {
                object = xDocument.Range(new Integer(0), new Integer(1));
                point = this.calculateTopLeftMargin((DocumentImpl)xDocument);
            }
            ShapesImpl.setShape_AnchorTypeAndRangeProperty(xShape, object);
            String string2 = ShapeName.create("Oval", this);
            this.incrementShapeCount();
            ShapesImpl.setDefaultShapeProperties(xShape);
            ShapesImpl.setShape_NameProperty(xShape, string2);
            Point point2 = new Point();
            point2.X = n7 - point.X;
            point2.Y = n8 - point.Y;
            xShape.setPosition(point2);
            Size size = new Size();
            size.Height = n5;
            size.Width = n6;
            xShape.setSize(size);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        ShapeImpl shapeImpl = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, 1);
        shapeImpl.setRange(object);
        shapeImpl.setInnerTypeName(string);
        return shapeImpl;
    }

    public Object AddShape(int n, int n2, int n3, int n4, int n5, Object object) throws BasicErrorException {
        try {
            if (n == 1) {
                return this.AddRectangle(n2, n3, n4, n5, object);
            }
            if (n == 9) {
                return this.AddEllipse(n2, n3, n4, n5, object);
            }
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Shape type not supported.")));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        return null;
    }

    private void setShape_RightPosition(com.sun.star.drawing.XShape xShape, int n, int n2) throws BasicErrorException {
        XDocument xDocument = (XDocument)this.getParent();
        Point point = this.calculateTopLeftMargin((DocumentImpl)xDocument);
        point.X = n - point.X;
        point.Y = n2 - point.Y;
        xShape.setPosition(point);
    }

    public Object AddPolyline(int[][] nArray, Object object) throws BasicErrorException {
        Object object2;
        Point point;
        XTextDocument xTextDocument;
        XMultiServiceFactory xMultiServiceFactory = null;
        com.sun.star.drawing.XShape xShape = null;
        try {
            xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
            xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ShapesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        xTextDocument = null;
        int n = nArray.length;
        Point[] pointArray = new Point[n];
        Point point2 = new Point(0, 0);
        if (!AnyConverter.isVoid((Object)object)) {
            XDocument xDocument = (XDocument)this.getParent();
            point2 = this.calculateTopLeftMargin((DocumentImpl)xDocument);
        }
        int n2 = 0;
        while (n2 < n) {
            point = new Point();
            point.X = new Double(sizeFactorPolyline * nArray[n2][0] + xyFactorPolyline).intValue() + point2.X;
            point.Y = new Double(sizeFactorPolyline * nArray[n2][1] + xyFactorPolyline).intValue() + point2.Y;
            pointArray[n2] = point;
            ++n2;
        }
        point = new Point[1][1];
        point[0] = pointArray;
        try {
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, xMultiServiceFactory.createInstance("com.sun.star.drawing.PolyPolygonShape"));
            this.m_xShapes.add(xShape);
            if (AnyConverter.isVoid((Object)object)) {
                object2 = (XDocument)this.getParent();
                object = object2.Range(null, null);
            }
            ShapesImpl.setShape_AnchorTypeAndRangeProperty(xShape, object);
            object2 = ShapeName.create("Freeform", this);
            this.incrementShapeCount();
            XPropertySet xPropertySet = null;
            xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, xShape);
            WriterUtilities.setProperty(xPropertySet, "PolyPolygon", point);
            ShapesImpl.setDefaultShapeProperties(xPropertySet);
            ShapesImpl.setShape_NameProperty(xPropertySet, (String)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        object2 = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, 5);
        ((ShapeImpl)object2).setRange(object);
        return object2;
    }

    public Object AddTextbox(int n, int n2, int n3, int n4, int n5, Object object) throws BasicErrorException {
        Object object2;
        if (n != 1) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter textOrientation must be msoTextOrientationHorizontal.")));
        }
        int n6 = 0;
        int n7 = 0;
        com.sun.star.drawing.XShape xShape = null;
        try {
            XDocument xDocument;
            Object object3;
            object2 = this.createBaseFrame("com.sun.star.text.TextFrame");
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object2);
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object2);
            this.insertFrame(object2);
            Point point = new Point(0, 0);
            if (!AnyConverter.isVoid((Object)object)) {
                object3 = (XRange)AnyConverter.toObject((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object);
                XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, xPropertySet);
                XTextRange xTextRange = object3.getXTextRange();
                xTextContent.attach(xTextRange);
                xDocument = (XDocument)this.getParent();
                point = this.calculateTopLeftMargin((DocumentImpl)xDocument);
            }
            WriterUtilities.setProperty(xPropertySet, "AnchorType", TextContentAnchorType.AT_PARAGRAPH);
            object3 = ShapeName.create("Text Box", this);
            this.incrementShapeCount();
            int n8 = new Double(xyFactorTextbox * (double)n2).intValue() + point.X;
            int n9 = new Double(xyFactorTextbox * (double)n3).intValue() + point.Y;
            this.setFrameProperties(xPropertySet, (String)object3, n8, n9);
            n7 = WriterUtilities.pointsToHundredthsMillimeter(n4);
            n6 = WriterUtilities.pointsToHundredthsMillimeter(n5);
            WriterUtilities.setProperty(xPropertySet, "Width", new Integer(n7));
            WriterUtilities.setProperty(xPropertySet, "Height", new Integer(n6));
            xDocument = new BorderLine();
            ((BorderLine)xDocument).OuterLineWidth = textboxBorderline;
            WriterUtilities.setProperty(xPropertySet, "LeftBorder", xDocument);
            WriterUtilities.setProperty(xPropertySet, "RightBorder", xDocument);
            WriterUtilities.setProperty(xPropertySet, "TopBorder", xDocument);
            WriterUtilities.setProperty(xPropertySet, "BottomBorder", xDocument);
            WriterUtilities.setProperty(xPropertySet, "LeftBorderDistance", new Integer(textboxLeftBorderlineDist));
            WriterUtilities.setProperty(xPropertySet, "RightBorderDistance", new Integer(textboxLeftBorderlineDist));
            WriterUtilities.setProperty(xPropertySet, "TopBorderDistance", new Integer(textboxTopBorderlineDist));
            WriterUtilities.setProperty(xPropertySet, "BottomBorderDistance", new Integer(textboxTopBorderlineDist));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        object2 = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, 17);
        ((ShapeImpl)object2).setRange(object);
        return object2;
    }

    protected void incrementShapeCount() throws BasicErrorException {
        ++this.m_nShapeCount;
        ((XDocument)this.getParent()).setCountAddedShapes(((XDocument)this.getParent()).getCountAddedShapes() + 1);
    }

    protected void decrementShapeCount() throws BasicErrorException {
        ((XDocument)this.getParent()).setCountAddedShapes(((XDocument)this.getParent()).getCountAddedShapes() - 1);
    }

    protected String findFileURL(String string) throws BasicErrorException {
        if (string.startsWith("http:") || string.startsWith("file:") || string.startsWith("ftp:")) {
            return string;
        }
        GraphicsFilename graphicsFilename = new GraphicsFilename(string);
        if (graphicsFilename.checkExistanceForRead()) {
            return graphicsFilename.getURL();
        }
        String string2 = System.getProperty("user.dir");
        String string3 = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        if (!string2.endsWith(string3)) {
            stringBuffer.append(string3);
        }
        stringBuffer.append(string);
        GraphicsFilename graphicsFilename2 = new GraphicsFilename(stringBuffer.toString());
        if (graphicsFilename2.checkExistanceForRead()) {
            return graphicsFilename2.getURL();
        }
        DebugHelper.writeInfo("findFileURL(): File '" + graphicsFilename.getAbsoluteFilename() + "' not found.");
        DebugHelper.writeInfo("findFileURL(): File '" + graphicsFilename2.getAbsoluteFilename() + "' not found.");
        DebugHelper.exception(53, "");
        return "";
    }

    public Object AddPicture(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) throws BasicErrorException {
        ShapeImpl shapeImpl;
        Object object9 = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (!AnyConverter.isVoid((Object)object3)) {
            n4 = OptionalParamUtility.getInt("left", object3, 0, false);
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            n3 = OptionalParamUtility.getInt("top", object4, 0, false);
        }
        if (!AnyConverter.isVoid((Object)object5)) {
            n5 = OptionalParamUtility.getInt("width", object5, 0, false);
        }
        if (!AnyConverter.isVoid((Object)object6)) {
            n6 = OptionalParamUtility.getInt("height", object6, 0, false);
        }
        com.sun.star.drawing.XShape xShape = null;
        String string2 = "com.sun.star.drawing.GraphicObjectShape";
        try {
            XDocument xDocument;
            Object object10;
            object9 = this.createBaseFrame(string2);
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object9);
            shapeImpl = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object9);
            String string3 = ShapeName.create("Picture", this);
            this.incrementShapeCount();
            Point point = new Point(0, 0);
            if (!AnyConverter.isVoid((Object)object7)) {
                object8 = object7;
            }
            if (!AnyConverter.isVoid((Object)object8)) {
                object10 = (XRange)AnyConverter.toObject((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object8);
                XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, shapeImpl);
                XTextRange xTextRange = object10.getXTextRange();
                xTextContent.attach(xTextRange);
                xDocument = (XDocument)this.getParent();
                point = this.calculateTopLeftMargin((DocumentImpl)xDocument);
            } else {
                this.insertFrame(object9);
            }
            WriterUtilities.setProperty((XPropertySet)shapeImpl, "AnchorType", TextContentAnchorType.AT_PARAGRAPH);
            object10 = this.findFileURL(string);
            WriterUtilities.setProperty((XPropertySet)shapeImpl, "GraphicURL", object10);
            int n7 = WriterUtilities.pointsToHundredthsMillimeter(n4) + point.X;
            int n8 = WriterUtilities.pointsToHundredthsMillimeter(n3) + point.Y;
            this.setShape_RightPosition(xShape, n7, n8);
            xDocument = new Size();
            ((Size)xDocument).Height = WriterUtilities.pointsToHundredthsMillimeter(n6);
            ((Size)xDocument).Width = WriterUtilities.pointsToHundredthsMillimeter(n5);
            xShape.setSize((Size)xDocument);
            this.setFrameProperties((XPropertySet)shapeImpl, string3, n, n2);
            PropertySetHelper propertySetHelper = new PropertySetHelper(shapeImpl);
            Object object11 = propertySetHelper.getPropertyValueAsObject("GraphicObjectFillBitmap");
            XBitmap xBitmap = (XBitmap)UnoRuntime.queryInterface((Class)(class$com$sun$star$awt$XBitmap == null ? (class$com$sun$star$awt$XBitmap = ShapesImpl.class$("com.sun.star.awt.XBitmap")) : class$com$sun$star$awt$XBitmap), (Object)object11);
            if (xBitmap != null) {
                Size size = xBitmap.getSize();
                ((Size)xDocument).Height = WriterUtilities.pointsToHundredthsMillimeter(size.Height);
                ((Size)xDocument).Width = WriterUtilities.pointsToHundredthsMillimeter(size.Width);
                xShape.setSize((Size)xDocument);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        shapeImpl = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, 13);
        shapeImpl.setRange(object8);
        return shapeImpl;
    }

    private ShapeImpl cloneShape(ShapeImpl shapeImpl, String string, String string2, int n) throws BasicErrorException {
        Object object;
        if (shapeImpl == null) {
            DebugHelper.exception(5, "");
        }
        this.getXModel().lockControllers();
        com.sun.star.drawing.XShape xShape = null;
        Object object2 = shapeImpl.getRange();
        Object var7_7 = null;
        String string3 = string;
        try {
            xShape = this.createShape(string3);
            this.m_xShapes.add(xShape);
            if (AnyConverter.isVoid((Object)object2)) {
                object = (XDocument)this.getParent();
                object2 = object.Range(null, null);
            }
            ShapesImpl.setShape_AnchorTypeAndRangeProperty(xShape, object2);
            object = ShapeName.create(string2, this);
            this.incrementShapeCount();
            ShapesImpl.setShape_NameProperty(xShape, (String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        object = "Name";
        this.copyProperties(shapeImpl.getUnoObject(), xShape, (String)object);
        ShapeImpl shapeImpl2 = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, n);
        shapeImpl2.setRange(object2);
        if (n == 1) {
            shapeImpl2.setInnerTypeName(string3);
        }
        shapeImpl2.ZOrder(0);
        this.getXModel().unlockControllers();
        return shapeImpl2;
    }

    private ShapeImpl cloneRectangleShape(ShapeImpl shapeImpl) throws BasicErrorException {
        return this.cloneShape(shapeImpl, "com.sun.star.drawing.RectangleShape", "Rectangle", 1);
    }

    private ShapeImpl cloneEllipseShape(ShapeImpl shapeImpl) throws BasicErrorException {
        return this.cloneShape(shapeImpl, "com.sun.star.drawing.EllipseShape", "Oval", 1);
    }

    private ShapeImpl cloneShape_Attach(ShapeImpl shapeImpl, String string, String string2, int n) throws BasicErrorException {
        XInterface xInterface;
        String string3;
        if (shapeImpl == null) {
            DebugHelper.exception(5, "");
        }
        this.getXModel().lockControllers();
        Object object = null;
        com.sun.star.drawing.XShape xShape = null;
        Object object2 = shapeImpl.getRange();
        try {
            object = this.createBaseFrame(string);
            xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
            string3 = ShapeName.create(string2, this);
            this.incrementShapeCount();
            ShapesImpl.setShape_NameProperty(xShape, string3);
            if (!AnyConverter.isVoid((Object)object2)) {
                xInterface = (XRange)AnyConverter.toObject((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object2);
                XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, xShape);
                XTextRange xTextRange = xInterface.getXTextRange();
                xTextContent.attach(xTextRange);
            } else {
                this.insertFrame(object);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            HelperUtilities.exception(illegalArgumentException);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
        string3 = "Name";
        this.copyProperties(shapeImpl.getUnoObject(), xShape);
        xInterface = new ShapeImpl((DocumentImpl)this.getParent(), this, xShape, n);
        xInterface.setRange(object2);
        xInterface.ZOrder(0);
        this.getXModel().unlockControllers();
        return xInterface;
    }

    private ShapeImpl clonePictureShape(ShapeImpl shapeImpl) throws BasicErrorException {
        return this.cloneShape_Attach(shapeImpl, "com.sun.star.drawing.GraphicObjectShape", "Picture", 13);
    }

    private ShapeImpl cloneTextboxShape(ShapeImpl shapeImpl) throws BasicErrorException {
        return this.cloneShape_Attach(shapeImpl, "com.sun.star.text.TextFrame", "Text Box", 17);
    }

    private ShapeImpl cloneLineShape(ShapeImpl shapeImpl) throws BasicErrorException {
        return this.cloneShape(shapeImpl, "com.sun.star.drawing.LineShape", "Line", 9);
    }

    private ShapeImpl clonePolylineShape(ShapeImpl shapeImpl) throws BasicErrorException {
        return this.cloneShape(shapeImpl, "com.sun.star.drawing.PolyPolygonShape", "Freeform", 5);
    }

    public void SelectAll() throws BasicErrorException {
        XSelectionSupplier xSelectionSupplier = null;
        com.sun.star.drawing.XShapes xShapes = null;
        try {
            xSelectionSupplier = (XSelectionSupplier)OptionalParamUtility.getObject(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = ShapesImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier, this.getXModel().getCurrentController());
            this.m_aCurrentShapesList.updateCache();
            int n = this.m_aCurrentShapesList.count();
            xShapes = this.getEmptyShapesCollection();
            int n2 = 0;
            while (n2 < n) {
                ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n2);
                com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
                xShapes.add(xShape);
                ++n2;
            }
            xSelectionSupplier.select((Object)xShapes);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public XShapeRange Range(Object object) throws BasicErrorException {
        ShapeRangeImpl shapeRangeImpl;
        block13: {
            shapeRangeImpl = null;
            com.sun.star.drawing.XShapes xShapes = null;
            String string = "";
            int n = -1;
            Object var6_6 = null;
            Object var7_7 = null;
            Object var8_8 = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            bl = AnyConverter.isVoid((Object)object);
            bl2 = AnyConverter.isString((Object)object);
            bl3 = AnyConverter.isArray((Object)object);
            bl4 = NumericalHelper.isNumerical(object);
            if (object == null || bl) break block13;
            try {
                if (bl4) {
                    n = NumericalHelper.toInt(object);
                    xShapes = this.getShapeByIndex(n);
                } else if (bl2) {
                    string = AnyConverter.toString((Object)object);
                    xShapes = this.getShapeByName(string);
                } else if (bl3) {
                    String[] stringArray;
                    if (this.isStringArray(object)) {
                        stringArray = NumericalHelper.toStringArray(object);
                        xShapes = this.getShapesByNames(stringArray);
                    } else {
                        stringArray = (String[])NumericalHelper.toIntArray(object);
                        xShapes = this.getShapesByIndex((int[])stringArray);
                    }
                }
            }
            catch (com.sun.star.uno.Exception exception) {
                DebugHelper.exception(exception);
            }
            if (xShapes == null) {
                DebugHelper.exception(51, "no shapes");
            }
            if (xShapes.getCount() == noShapesSelected) {
                DebugHelper.exception(366, "The item wasn't found.");
            }
            try {
                shapeRangeImpl = new ShapeRangeImpl(this, xShapes);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
        }
        return shapeRangeImpl;
    }

    private boolean isStringArray(Object object) {
        boolean bl = false;
        if (object instanceof String[]) {
            bl = true;
        }
        return bl;
    }

    private com.sun.star.drawing.XShapes getShapeByIndex(int n) throws com.sun.star.uno.Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = null;
        this.m_aCurrentShapesList.updateCache();
        ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n - 1);
        com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
        xShapes = this.getEmptyShapesCollection();
        xShapes.add(xShape);
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getShapesByIndex(int[] nArray) throws com.sun.star.uno.Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = this.getEmptyShapesCollection();
        this.m_aCurrentShapesList.updateCache();
        int n = 0;
        while (n < nArray.length) {
            ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n);
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
            xShapes.add(xShape);
            ++n;
        }
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getShapeByName(String string) throws com.sun.star.uno.Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = null;
        xShapes = this.getEmptyShapesCollection();
        this.m_aCurrentShapesList.updateCache();
        int n = 0;
        while (n < this.m_aCurrentShapesList.count()) {
            ShapeImpl shapeImpl = (ShapeImpl)this.m_aCurrentShapesList.item(n);
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, shapeImpl.getXShape());
            String string2 = "";
            try {
                string2 = shapeImpl.getName();
            }
            catch (BasicErrorException basicErrorException) {
                // empty catch block
            }
            if (string2.equalsIgnoreCase(string)) {
                xShapes.add(xShape);
                break;
            }
            ++n;
        }
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getShapesByNames(String[] stringArray) throws com.sun.star.uno.Exception, IllegalArgumentException {
        com.sun.star.drawing.XShapes xShapes = this.getEmptyShapesCollection();
        this.m_aCurrentShapesList.updateCache();
        int n = 0;
        while (n < stringArray.length) {
            com.sun.star.drawing.XShapes xShapes2 = this.getEmptyShapesCollection();
            String string = stringArray[n];
            xShapes2 = this.getShapeByName(string);
            Object object = xShapes2.getByIndex(0);
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, object);
            xShapes.add(xShape);
            ++n;
        }
        return xShapes;
    }

    private com.sun.star.drawing.XShapes getEmptyShapesCollection() throws com.sun.star.uno.Exception, IllegalArgumentException {
        XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
        Object object = xMultiServiceFactory.createInstance("com.sun.star.drawing.ShapeCollection");
        com.sun.star.drawing.XShapes xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = ShapesImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, object);
        return xShapes;
    }

    private Object createBaseFrame(String string) throws IllegalArgumentException, com.sun.star.uno.Exception {
        XTextDocument xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ShapesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
        Object object = null;
        object = xMultiServiceFactory.createInstance(string);
        return object;
    }

    private void insertFrame(Object object) throws IllegalArgumentException {
        XTextDocument xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
        XText xText = xTextDocument.getText();
        XTextCursor xTextCursor = xText.createTextCursor();
        XTextContent xTextContent = (XTextContent)OptionalParamUtility.getObject(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = ShapesImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent, object);
        xText.insertTextContent((XTextRange)xTextCursor, xTextContent, true);
    }

    private com.sun.star.drawing.XShape createShape(String string) throws IllegalArgumentException, com.sun.star.uno.Exception, PropertyVetoException {
        XTextDocument xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, this.getXModel());
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = ShapesImpl.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
        Object object = null;
        object = xMultiServiceFactory.createInstance(string);
        com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
        return xShape;
    }

    public static void setShape_AnchorTypeAndRangeProperty(Object object, Object object2) throws BasicErrorException {
        XTextRange xTextRange = null;
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        propertySetHelper.setPropertyValueDontThrow("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
        XRange xRange = (XRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$helper$writer$XRange == null ? (class$com$sun$star$helper$writer$XRange = ShapesImpl.class$("com.sun.star.helper.writer.XRange")) : class$com$sun$star$helper$writer$XRange), (Object)object2);
        if (xRange != null) {
            xTextRange = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = ShapesImpl.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange), (Object)xRange.getXTextRange());
            if (xTextRange != null) {
                propertySetHelper.setPropertyValueDontThrow("TextRange", xTextRange.getStart());
            } else {
                DebugHelper.writeInfo("Can't set Shapes.Property 'TextRange'.");
            }
        }
    }

    public static void setShape_NameProperty(Object object, String string) {
        PropertySetHelper propertySetHelper = new PropertySetHelper(object);
        propertySetHelper.setPropertyValueDontThrow("Name", string);
    }

    public static void setDefaultShapeProperties(Object object) throws BasicErrorException {
        try {
            com.sun.star.drawing.XShape xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface((Class)(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet), (Object)object);
            WriterUtilities.setProperty(xPropertySet, "FillStyle", "SOLID");
            WriterUtilities.setProperty(xPropertySet, "FillColor", new Integer(0xFFFFFF));
            WriterUtilities.setProperty(xPropertySet, "TextWrap", WrapTextMode.THROUGHT);
            WriterUtilities.setProperty(xPropertySet, "Opaque", Boolean.TRUE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    private void setFrameProperties(XPropertySet xPropertySet, String string, int n, int n2) throws IllegalArgumentException, PropertyVetoException, BasicErrorException {
        WriterUtilities.setProperty(xPropertySet, "FillStyle", "SOLID");
        WriterUtilities.setProperty(xPropertySet, "FillColor", new Integer(0xFFFFFF));
        WriterUtilities.setProperty(xPropertySet, "TextWrap", WrapTextMode.THROUGHT);
        WriterUtilities.setProperty(xPropertySet, "Opaque", Boolean.TRUE);
        WriterUtilities.setProperty(xPropertySet, "HoriOrient", new Short(0));
        WriterUtilities.setProperty(xPropertySet, "HoriOrientRelation", new Integer(0));
        WriterUtilities.setProperty(xPropertySet, "HoriOrientPosition", new Integer(n));
        WriterUtilities.setProperty(xPropertySet, "VertOrient", new Short(0));
        WriterUtilities.setProperty(xPropertySet, "VertOrientRelation", new Integer(1));
        WriterUtilities.setProperty(xPropertySet, "VertOrientPosition", new Integer(n2));
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ShapesImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)xPropertySet);
        if (xNamed != null) {
            xNamed.setName(string);
        } else {
            WriterUtilities.setProperty(xPropertySet, "Name", string);
        }
    }

    public void remove(com.sun.star.drawing.XShape xShape) {
        this.m_xShapes.remove(xShape);
    }

    public int getCurrentShapeNameCount() {
        return this.m_nShapeCount;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.m_xShapes;
    }

    boolean checkToLeaveOut(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (!(string4.endsWith("*") ? string.startsWith(string3 = string4.substring(0, string4.length() - 1)) : string.equals(string4))) continue;
            return true;
        }
        return false;
    }

    void copyProperties(Object object, Object object2) throws BasicErrorException {
        this.copyProperties(object, object2, "");
    }

    void copyProperties(Object object, Object object2, String string) throws BasicErrorException {
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object);
            XPropertySet xPropertySet2 = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = ShapesImpl.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object2);
            XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
            Property[] propertyArray = xPropertySetInfo.getProperties();
            int n = 0;
            while (n < propertyArray.length) {
                String string2 = "";
                try {
                    string2 = propertyArray[n].Name;
                    if (!this.checkToLeaveOut(string2, string)) {
                        xPropertySet2.setPropertyValue(string2, xPropertySet.getPropertyValue(string2));
                    } else {
                        DebugHelper.writeInfo("PropertyName: " + string2 + " leave out.");
                    }
                }
                catch (UnknownPropertyException unknownPropertyException) {
                    DebugHelper.writeInfo("UnknownPropertyException caught with property: " + string2);
                    DebugHelper.writeInfo(unknownPropertyException.getMessage());
                }
                catch (PropertyVetoException propertyVetoException) {
                    DebugHelper.writeInfo("PropertyVetoException caught with property: " + string2);
                    DebugHelper.writeInfo(propertyVetoException.getMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DebugHelper.writeInfo("IllegalArgumentException caught with property: " + string2);
                    DebugHelper.writeInfo(illegalArgumentException.getMessage());
                }
                catch (WrappedTargetException wrappedTargetException) {
                    DebugHelper.writeInfo("WrappedTargetException caught with property: " + string2);
                    DebugHelper.exception((com.sun.star.uno.Exception)((Object)wrappedTargetException));
                }
                catch (com.sun.star.uno.Exception exception) {
                    DebugHelper.writeInfo("uno.Exception caught with property: " + string2);
                    DebugHelper.exception(exception);
                }
                catch (Exception exception) {
                    DebugHelper.writeInfo("ClassNotFoundException caught with property: " + string2);
                    DebugHelper.writeInfo(exception.getMessage());
                }
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)illegalArgumentException));
        }
    }

    Object createDuplicate(ShapeImpl shapeImpl) throws BasicErrorException {
        ShapeImpl shapeImpl2 = null;
        if (shapeImpl != null) {
            if (shapeImpl.getType() == 1) {
                if (shapeImpl.getInnerTypeName().equals("com.sun.star.drawing.RectangleShape")) {
                    shapeImpl2 = this.cloneRectangleShape(shapeImpl);
                } else if (shapeImpl.getInnerTypeName().equals("com.sun.star.drawing.EllipseShape")) {
                    shapeImpl2 = this.cloneEllipseShape(shapeImpl);
                } else {
                    DebugHelper.exception(51, "Shape can't duplicate.");
                }
            } else if (shapeImpl.getType() == 13) {
                shapeImpl2 = this.clonePictureShape(shapeImpl);
            } else if (shapeImpl.getType() == 17) {
                shapeImpl2 = this.cloneTextboxShape(shapeImpl);
                com.sun.star.text.XTextFrame xTextFrame = (com.sun.star.text.XTextFrame)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextFrame == null ? (class$com$sun$star$text$XTextFrame = ShapesImpl.class$("com.sun.star.text.XTextFrame")) : class$com$sun$star$text$XTextFrame), (Object)shapeImpl.getUnoObject());
                if (xTextFrame != null) {
                    XRange xRange = shapeImpl.TextFrame().TextRange();
                    XTextFrame xTextFrame2 = shapeImpl2.TextFrame();
                    XRange xRange2 = xTextFrame2.TextRange();
                    xRange2.setText(xRange.getText());
                }
            } else if (shapeImpl.getType() == 9) {
                shapeImpl2 = this.cloneLineShape(shapeImpl);
            } else if (shapeImpl.getType() == 5) {
                shapeImpl2 = this.clonePolylineShape(shapeImpl);
            } else {
                DebugHelper.exception(51, "Shape can't duplicate.");
            }
        }
        return shapeImpl2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ShapeName {
        private static final int m_nBeginningNumber = 1;

        ShapeName() {
        }

        public static String create(String string, ShapeNameCounter shapeNameCounter) {
            int n = 1 + shapeNameCounter.getCurrentShapeNameCount();
            StringBuffer stringBuffer = new StringBuffer(16);
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(String.valueOf(n));
            return stringBuffer.toString();
        }
    }

    private class ShapesHelperCache
    extends CollectionHelper {
        private HelperInterfaceAdaptor m_shapes;

        ShapesHelperCache(HelperInterfaceAdaptor helperInterfaceAdaptor) {
            super(1);
            this.m_shapes = helperInterfaceAdaptor;
        }

        public HelperInterfaceAdaptor createHelper(Object object) {
            com.sun.star.drawing.XShape xShape = null;
            ShapeImpl shapeImpl = null;
            try {
                xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
                shapeImpl = new ShapeImpl((DocumentImpl)ShapesImpl.this.getParent(), (ShapesImpl)this.m_shapes, xShape, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            catch (BasicErrorException basicErrorException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)basicErrorException));
            }
            return shapeImpl;
        }

        public void fetchImplementationObjects(ArrayList arrayList) {
            XDrawPageSupplier xDrawPageSupplier = null;
            Object var3_3 = null;
            com.sun.star.drawing.XShape xShape = null;
            XTextDocument xTextDocument = null;
            try {
                xTextDocument = (XTextDocument)OptionalParamUtility.getObject(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = ShapesImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument, ShapesImpl.this.getXModel());
                xDrawPageSupplier = (XDrawPageSupplier)OptionalParamUtility.getObject(class$com$sun$star$drawing$XDrawPageSupplier == null ? (class$com$sun$star$drawing$XDrawPageSupplier = ShapesImpl.class$("com.sun.star.drawing.XDrawPageSupplier")) : class$com$sun$star$drawing$XDrawPageSupplier, xTextDocument);
                ShapesImpl.this.m_xShapes = (com.sun.star.drawing.XShapes)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShapes == null ? (class$com$sun$star$drawing$XShapes = ShapesImpl.class$("com.sun.star.drawing.XShapes")) : class$com$sun$star$drawing$XShapes, xDrawPageSupplier.getDrawPage());
                int n = ShapesImpl.this.m_xShapes.getCount();
                int n2 = 0;
                while (n2 < n) {
                    Object object = ShapesImpl.this.m_xShapes.getByIndex(n2);
                    xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? ShapesImpl.class$("com.sun.star.drawing.XShape") : class$com$sun$star$drawing$XShape, object);
                    arrayList.add(xShape);
                    ++n2;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)indexOutOfBoundsException));
            }
            catch (WrappedTargetException wrappedTargetException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)wrappedTargetException));
            }
        }

        public boolean isValidImplementationObject(Object object) {
            boolean bl = false;
            com.sun.star.drawing.XShape xShape = null;
            try {
                xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapesImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, object);
                String string = xShape.getShapeType();
                if (!string.equalsIgnoreCase("com.sun.star.drawing.ControlShape")) {
                    bl = true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)illegalArgumentException));
            }
            return bl;
        }
    }
}

