/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.container.XNamed;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.FillFormatImpl;
import com.sun.star.helper.writer.LineFormatImpl;
import com.sun.star.helper.writer.PictureFormatImpl;
import com.sun.star.helper.writer.ShapesImpl;
import com.sun.star.helper.writer.TextFrameImpl;
import com.sun.star.helper.writer.WrapFormatImpl;
import com.sun.star.helper.writer.WriterUtilities;
import com.sun.star.helper.writer.XFillFormat;
import com.sun.star.helper.writer.XLineFormat;
import com.sun.star.helper.writer.XPictureFormat;
import com.sun.star.helper.writer.XShape;
import com.sun.star.helper.writer.XTextFrame;
import com.sun.star.helper.writer.XWrapFormat;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XSelectionSupplier;

public class ShapeImpl
extends HelperInterfaceAdaptor
implements XShape,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Shape";
    private com.sun.star.drawing.XShape m_xShape = null;
    private String m_sName = null;
    private int m_nShapeType;
    private ShapesImpl m_aShapeCollection = null;
    private Object m_aRange = null;
    private PropertySetHelper m_aPropertySetHelper = null;
    private LineFormatImpl m_aLineFormatImpl = null;
    private FillFormatImpl m_aFillFormatImpl = null;
    private WrapFormatImpl m_aWrapFormatImpl = null;
    private PictureFormatImpl m_aPictureFormatImpl = null;
    private String m_sInnerTypeName = null;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;
    static /* synthetic */ Class class$com$sun$star$text$XTextFrame;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;
    static /* synthetic */ Class class$com$sun$star$view$XSelectionSupplier;

    public ShapeImpl(DocumentImpl documentImpl, ShapesImpl shapesImpl, com.sun.star.drawing.XShape xShape, int n) throws BasicErrorException {
        super(__serviceName, documentImpl);
        this.m_aShapeCollection = shapesImpl;
        try {
            this.m_xShape = (com.sun.star.drawing.XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ShapeImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, xShape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        this.m_nShapeType = n;
    }

    public XTextFrame TextFrame() throws BasicErrorException {
        TextFrameImpl textFrameImpl = null;
        com.sun.star.text.XTextFrame xTextFrame = null;
        try {
            xTextFrame = (com.sun.star.text.XTextFrame)OptionalParamUtility.getObject(class$com$sun$star$text$XTextFrame == null ? (class$com$sun$star$text$XTextFrame = ShapeImpl.class$("com.sun.star.text.XTextFrame")) : class$com$sun$star$text$XTextFrame, this.m_xShape);
            textFrameImpl = new TextFrameImpl(this, xTextFrame);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return textFrameImpl;
    }

    protected com.sun.star.drawing.XShape getXShape() throws BasicErrorException {
        if (this.m_xShape == null) {
            DebugHelper.exception(51, "There exist no XShape");
        }
        return this.m_xShape;
    }

    public void Delete() throws BasicErrorException {
        ShapesImpl shapesImpl = this.m_aShapeCollection;
        if (shapesImpl != null) {
            shapesImpl.remove(this.m_xShape);
        }
    }

    protected PropertySetHelper getPropertySetHelper() throws BasicErrorException {
        if (this.m_aPropertySetHelper == null) {
            this.m_aPropertySetHelper = new PropertySetHelper(this.getXShape());
        }
        return this.m_aPropertySetHelper;
    }

    public String getName() throws BasicErrorException {
        if (this.m_sName == null) {
            XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ShapeImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)this.m_xShape);
            this.m_sName = xNamed != null ? xNamed.getName() : this.getPropertySetHelper().getPropertyValueAsString("Name", "");
        }
        return this.m_sName;
    }

    public void setName(String string) throws BasicErrorException {
        XNamed xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = ShapeImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)this.m_xShape);
        if (xNamed != null) {
            xNamed.setName(string);
        } else {
            this.getPropertySetHelper().setPropertyValue("Name", string);
        }
        this.m_sName = string;
    }

    protected Point getPosition() throws BasicErrorException {
        Point point = null;
        if (this.getType() == 17) {
            point = new Point();
            point.X = this.getPropertySetHelper().getPropertyValueAsInteger("HoriOrientPosition", 0);
            point.Y = this.getPropertySetHelper().getPropertyValueAsInteger("VertOrientPosition", 0);
        } else {
            com.sun.star.drawing.XShape xShape = this.getXShape();
            point = xShape.getPosition();
        }
        return point;
    }

    protected void setPosition(Point point) throws BasicErrorException {
        if (this.getType() == 17) {
            this.getPropertySetHelper().setPropertyValue("HoriOrientPosition", new Integer(point.X));
            this.getPropertySetHelper().setPropertyValue("VertOrientPosition", new Integer(point.Y));
        } else {
            com.sun.star.drawing.XShape xShape = this.getXShape();
            xShape.setPosition(point);
        }
    }

    public void setLeft(double d) throws BasicErrorException {
        Point point = this.getPosition();
        point.X = WriterUtilities.pointsToHundredthsMillimeter(d);
        this.setPosition(point);
    }

    public double getLeft() throws BasicErrorException {
        Point point = this.getPosition();
        double d = WriterUtilities.hundredthsMillimeterToPoints(point.X);
        return d;
    }

    public void setTop(double d) throws BasicErrorException {
        Point point = this.getPosition();
        point.Y = WriterUtilities.pointsToHundredthsMillimeter(d);
        this.setPosition(point);
    }

    public double getTop() throws BasicErrorException {
        Point point = this.getPosition();
        double d = WriterUtilities.hundredthsMillimeterToPoints(point.Y);
        return d;
    }

    public void setWidth(double d) throws BasicErrorException {
        com.sun.star.drawing.XShape xShape = this.getXShape();
        Size size = xShape.getSize();
        size.Width = WriterUtilities.pointsToHundredthsMillimeter(d);
        try {
            xShape.setSize(size);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public double getWidth() throws BasicErrorException {
        com.sun.star.drawing.XShape xShape = this.getXShape();
        Size size = xShape.getSize();
        double d = WriterUtilities.hundredthsMillimeterToPoints(size.Width);
        return d;
    }

    public void setHeight(double d) throws BasicErrorException {
        com.sun.star.drawing.XShape xShape = this.getXShape();
        Size size = xShape.getSize();
        size.Height = WriterUtilities.pointsToHundredthsMillimeter(d);
        try {
            xShape.setSize(size);
        }
        catch (PropertyVetoException propertyVetoException) {}
    }

    public double getHeight() throws BasicErrorException {
        com.sun.star.drawing.XShape xShape = this.getXShape();
        Size size = xShape.getSize();
        double d = WriterUtilities.hundredthsMillimeterToPoints(size.Height);
        return d;
    }

    public int getType() throws BasicErrorException {
        return this.m_nShapeType;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.m_xShape;
    }

    public XLineFormat Line() throws BasicErrorException {
        if (this.m_aLineFormatImpl == null) {
            this.m_aLineFormatImpl = new LineFormatImpl(this);
        }
        return this.m_aLineFormatImpl;
    }

    public XFillFormat Fill() throws BasicErrorException {
        if (this.m_aFillFormatImpl == null) {
            this.m_aFillFormatImpl = new FillFormatImpl(this);
        }
        return this.m_aFillFormatImpl;
    }

    public void ZOrder(int n) throws BasicErrorException {
        try {
            PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
            switch (n) {
                case 0: {
                    propertySetHelper.setPropertyValue("ZOrder", new Integer(Integer.MAX_VALUE));
                    break;
                }
                case 2: {
                    int n2 = propertySetHelper.getPropertyValueAsInteger("ZOrder", 0);
                    propertySetHelper.setPropertyValue("ZOrder", new Integer(++n2));
                    break;
                }
                case 3: {
                    int n3 = propertySetHelper.getPropertyValueAsInteger("ZOrder", 0);
                    propertySetHelper.setPropertyValue("ZOrder", new Integer(--n3));
                    break;
                }
                case 1: {
                    propertySetHelper.setPropertyValue("ZOrder", new Integer(0));
                    break;
                }
                case 4: {
                    propertySetHelper.setPropertyValue("Opaque", Boolean.TRUE);
                    break;
                }
                case 5: {
                    propertySetHelper.setPropertyValue("Opaque", Boolean.FALSE);
                    break;
                }
                default: {
                    DebugHelper.warning((Exception)((Object)new NoSupportException("In Property ZOrder this value is not supported.")));
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int ZOrderPosition() throws BasicErrorException {
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
        int n = propertySetHelper.getPropertyValueAsInteger("ZOrder", 0);
        return n + 1;
    }

    public void ScaleHeight(double d, boolean bl, int n) throws BasicErrorException {
        block5: {
            try {
                double d2 = this.getHeight();
                double d3 = d2 * d;
                if (n == 0) {
                    this.setHeight(d3);
                    break block5;
                }
                if (n == 2) {
                    double d4 = d3 - d2;
                    double d5 = this.getTop() - d4;
                    this.setTop(d5);
                    this.setHeight(d3);
                    break block5;
                }
                if (n == 1) {
                    double d6 = (d3 - d2) / 2.0;
                    double d7 = this.getTop() - d6;
                    this.setTop(d7);
                    this.setHeight(d3);
                    break block5;
                }
                DebugHelper.warning((Exception)((Object)new NoSupportException("ScaleHeight.Scale wrong value is given.")));
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public void ScaleWidth(double d, boolean bl, int n) throws BasicErrorException {
        block5: {
            try {
                double d2 = this.getWidth();
                double d3 = d2 * d;
                if (n == 0) {
                    this.setWidth(d3);
                    break block5;
                }
                if (n == 2) {
                    double d4 = d3 - d2;
                    double d5 = this.getLeft() - d4;
                    this.setLeft(d5);
                    this.setWidth(d3);
                    break block5;
                }
                if (n == 1) {
                    double d6 = (d3 - d2) / 2.0;
                    double d7 = this.getLeft() - d6;
                    this.setLeft(d7);
                    this.setWidth(d3);
                    break block5;
                }
                DebugHelper.warning((Exception)((Object)new NoSupportException("ScaleWidth.Scale wrong value is given.")));
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public XWrapFormat WrapFormat() throws BasicErrorException {
        if (this.m_aWrapFormatImpl == null) {
            this.m_aWrapFormatImpl = new WrapFormatImpl(this);
        }
        return this.m_aWrapFormatImpl;
    }

    public XPictureFormat PictureFormat() throws BasicErrorException {
        if (this.m_aPictureFormatImpl == null) {
            this.m_aPictureFormatImpl = new PictureFormatImpl(this);
        }
        return this.m_aPictureFormatImpl;
    }

    public void setRelativeHorizontalPosition(int n) throws BasicErrorException {
        try {
            DebugHelper.writeInfo("StarOffice is not be able to set RelativeHorizontalPosition and RelativeVerticalPosition different.");
            PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
            switch (n) {
                case 3: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_CHARACTER);
                    break;
                }
                case 2: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
                    break;
                }
                case 0: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
                    break;
                }
                case 1: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_PAGE);
                    break;
                }
                default: {
                    DebugHelper.warning((Exception)((Object)new NoSupportException("Shape.RelativeHorizontalPosition wrong value is given.")));
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getRelativeHorizontalPosition() throws BasicErrorException {
        int n = 0;
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
        TextContentAnchorType textContentAnchorType = (TextContentAnchorType)propertySetHelper.getPropertyValueAsObject("AnchorType");
        if (textContentAnchorType == TextContentAnchorType.AT_PARAGRAPH) {
            n = 2;
        } else if (textContentAnchorType == TextContentAnchorType.AT_PAGE) {
            n = 1;
        } else if (textContentAnchorType == TextContentAnchorType.AT_CHARACTER) {
            n = 3;
        } else if (textContentAnchorType == TextContentAnchorType.AT_FRAME) {
            n = 0;
        } else if (textContentAnchorType == TextContentAnchorType.AS_CHARACTER) {
            n = 0;
        } else {
            DebugHelper.warning((Exception)((Object)new NoSupportException("Shape.RelativeHorizontalPosition unknown internal value is set.")));
        }
        return n;
    }

    public void setRelativeVerticalPosition(int n) throws BasicErrorException {
        try {
            DebugHelper.writeInfo("StarOffice is not be able to set RelativeVerticalPosition and RelativeHorizontalPosition different.");
            PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
            switch (n) {
                case 0: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
                    break;
                }
                case 1: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_PAGE);
                    break;
                }
                case 2: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
                    break;
                }
                case 3: {
                    propertySetHelper.setPropertyValue("AnchorType", TextContentAnchorType.AT_CHARACTER);
                    break;
                }
                default: {
                    DebugHelper.warning((Exception)((Object)new NoSupportException("Shape.RelativeVerticalPosition wrong value is given.")));
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getRelativeVerticalPosition() throws BasicErrorException {
        int n = 0;
        PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
        TextContentAnchorType textContentAnchorType = (TextContentAnchorType)propertySetHelper.getPropertyValueAsObject("AnchorType");
        if (textContentAnchorType == TextContentAnchorType.AT_PARAGRAPH) {
            n = 2;
        } else if (textContentAnchorType == TextContentAnchorType.AT_PAGE) {
            n = 1;
        } else if (textContentAnchorType == TextContentAnchorType.AT_CHARACTER) {
            n = 3;
        } else if (textContentAnchorType == TextContentAnchorType.AT_FRAME) {
            n = 0;
        } else if (textContentAnchorType == TextContentAnchorType.AS_CHARACTER) {
            n = 0;
        } else {
            DebugHelper.warning((Exception)((Object)new NoSupportException("Shape.RelativeVerticalPosition unknown internal value is set.")));
        }
        return n;
    }

    public void IncrementLeft(double d) throws BasicErrorException {
        double d2 = this.getLeft();
        this.setLeft(d2 += d);
    }

    public void IncrementRotation(double d) throws BasicErrorException {
        double d2 = this.getRotation();
        this.setRotation(d2 -= d);
    }

    public void IncrementTop(double d) throws BasicErrorException {
        double d2 = this.getTop();
        this.setTop(d2 += d);
    }

    public void setRotation(double d) throws BasicErrorException {
        block2: {
            try {
                double d2 = d * 100.0;
                int n = (int)d2;
                this.getPropertySetHelper().setPropertyValue("RotateAngle", new Integer(n));
            }
            catch (Exception exception) {
                if (this.getType() == 17) break block2;
                DebugHelper.exception(exception);
            }
        }
    }

    public double getRotation() throws BasicErrorException {
        double d = 0.0;
        try {
            int n = this.getPropertySetHelper().getPropertyValueAsInteger("RotateAngle", 0);
            d = n / 100;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return d;
    }

    void setInnerTypeName(String string) {
        this.m_sInnerTypeName = string;
    }

    String getInnerTypeName() {
        return this.m_sInnerTypeName;
    }

    ShapesImpl getParentCollection() {
        return this.m_aShapeCollection;
    }

    void setRange(Object object) {
        this.m_aRange = object;
    }

    Object getRange() {
        return this.m_aRange;
    }

    public XShape Duplicate() throws BasicErrorException {
        return (XShape)this.getParentCollection().createDuplicate(this);
    }

    public void Select(Object object) throws BasicErrorException {
        block4: {
            try {
                boolean bl = NumericalHelper.toBoolean(object);
                if (!bl) break block4;
                XModel xModel = this.getXModel();
                XSelectionSupplier xSelectionSupplier = (XSelectionSupplier)UnoRuntime.queryInterface((Class)(class$com$sun$star$view$XSelectionSupplier == null ? (class$com$sun$star$view$XSelectionSupplier = ShapeImpl.class$("com.sun.star.view.XSelectionSupplier")) : class$com$sun$star$view$XSelectionSupplier), (Object)xModel.getCurrentController());
                try {
                    xSelectionSupplier.select((Object)this.m_xShape);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    DebugHelper.exception((Exception)((Object)illegalArgumentException));
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

