/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;

public class MailMergeParameter {
    public static final String MAILMERGE_RESULTDOC_PREFIX = "mailmerge_resultdoc";
    private String sOffendingParamNames;
    private String sName;
    private int iFormat;
    private boolean bConfirmConversions;
    private boolean bReadOnly;
    private boolean bLinkToSource;
    private boolean bAddToRecentFiles;
    private String sPasswordDocument;
    private String sPasswordTemplate;
    private boolean bRevert;
    private String sWritePasswordDocument;
    private String sWritePasswordTemplate;
    private String sConnection;
    private String sSQLStatement;
    private boolean bOpenExclusive;
    private int iSubType;

    public MailMergeParameter(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.sName = this.validateName(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("Name,");
        }
        try {
            this.iFormat = this.validateFormat(object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("Format,");
        }
        try {
            this.bConfirmConversions = this.validateBoolean(object3, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("ConfirmConversions,");
        }
        try {
            this.bReadOnly = this.validateBoolean(object4, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("ReadOnly,");
        }
        try {
            this.bLinkToSource = this.validateBoolean(object5, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("LinkToSource,");
        }
        try {
            this.bAddToRecentFiles = this.validateBoolean(object6, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("AddToRecentFiles,");
        }
        try {
            this.sPasswordDocument = this.validateString(object7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("PasswordDocument,");
        }
        try {
            this.sPasswordTemplate = this.validateString(object8);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("PasswordTemplate,");
        }
        try {
            this.bRevert = this.validateBoolean(object9, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("Revert,");
        }
        try {
            this.sWritePasswordDocument = this.validateString(object10);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("WritePasswordDocument,");
        }
        try {
            this.sWritePasswordTemplate = this.validateString(object11);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("WritePasswordTemplate,");
        }
        try {
            this.sConnection = this.validateString(object12);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("Connection,");
        }
        try {
            this.sSQLStatement = this.validateString(object13);
            if (!AnyConverter.isVoid((Object)object14)) {
                this.sSQLStatement = this.sSQLStatement + this.validateString(object14);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("SQLStatement,");
        }
        try {
            this.bOpenExclusive = this.validateBoolean(object15, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("OpenExclusive,");
        }
        try {
            this.iSubType = this.validateSubType(object16);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            stringBuffer.append("SubType,");
        }
        this.sOffendingParamNames = stringBuffer.length() > 0 ? stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(",")).toString() : this.plausibilityCheck();
    }

    public String getName() {
        return this.sName;
    }

    public int getFormat() {
        return this.iFormat;
    }

    public boolean getConfirmConversions() {
        return this.bConfirmConversions;
    }

    public boolean getReadOnly() {
        return this.bReadOnly;
    }

    public boolean getLinkToSource() {
        return this.bLinkToSource;
    }

    public boolean getAddToRecentFiles() {
        return this.bAddToRecentFiles;
    }

    public String getPasswordDocument() {
        return this.sPasswordDocument;
    }

    public String getPasswordTemplate() {
        return this.sPasswordTemplate;
    }

    public boolean getRevert() {
        return this.bRevert;
    }

    public String getWritePasswordDocument() {
        return this.sWritePasswordDocument;
    }

    public String getWritePasswordTemplate() {
        return this.sWritePasswordTemplate;
    }

    public String getConnection() {
        return this.sConnection;
    }

    public String getSQLStatement() {
        return this.sSQLStatement;
    }

    public boolean getOpenExclusive() {
        return this.bOpenExclusive;
    }

    public int getSubType() {
        return this.iSubType;
    }

    public String paramsAreValid() {
        return this.sOffendingParamNames;
    }

    private int validateFormat(Object object) throws IllegalArgumentException {
        int n = 0;
        if (!AnyConverter.isVoid((Object)object)) {
            n = NumericalHelper.toInt(object);
            if (n != 6 && n != 0 && n != 1 && n != 5 && n != 3 && n != 2 && n != 4 && n != 5 && n != 7) {
                throw new IllegalArgumentException();
            }
        } else {
            n = 0;
        }
        return n;
    }

    private String validateName(Object object) throws IllegalArgumentException {
        String string = NumericalHelper.toString(object);
        if (string.length() == 0) {
            throw new IllegalArgumentException();
        }
        return string;
    }

    private int validateSubType(Object object) throws IllegalArgumentException {
        int n = 0;
        if (!AnyConverter.isVoid((Object)object) && (n = NumericalHelper.toInt(object)) != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6 && n != 7 && n != 8) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    private boolean validateBoolean(Object object, boolean bl) throws IllegalArgumentException {
        boolean bl2 = bl;
        if (!AnyConverter.isVoid((Object)object)) {
            bl2 = NumericalHelper.toBoolean(object);
        }
        return bl2;
    }

    private String validateString(Object object) throws IllegalArgumentException {
        String string = null;
        if (!AnyConverter.isVoid((Object)object)) {
            string = NumericalHelper.toString(object);
        }
        return string;
    }

    private String plausibilityCheck() {
        return null;
    }
}

