/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.drawing.LineDash;
import com.sun.star.drawing.LineStyle;
import com.sun.star.drawing.XShape;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Millimeter;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.writer.ColorFormatImpl;
import com.sun.star.helper.writer.ShapeImpl;
import com.sun.star.helper.writer.XColorFormat;
import com.sun.star.helper.writer.XLineFormat;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;

public class LineFormatImpl
extends HelperInterfaceAdaptor
implements XLineFormat {
    protected static final String __serviceName = "com.sun.star.helper.writer.LineFormat";
    private int m_nLineDashStyle = 1;
    private double m_nLineWeight = 1.0;
    private Millimeter m_aMillimeterConverterHelper = null;
    private ColorFormatImpl m_aColorFormatImpl = null;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    public LineFormatImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
    }

    Millimeter getMillimeterHelper() throws BasicErrorException {
        if (this.m_aMillimeterConverterHelper == null) {
            this.m_aMillimeterConverterHelper = new Millimeter();
        }
        return this.m_aMillimeterConverterHelper;
    }

    public XColorFormat BackColor() throws BasicErrorException {
        if (this.m_aColorFormatImpl == null) {
            this.m_aColorFormatImpl = new ColorFormatImpl((HelperInterfaceAdaptor)this.getParent(), this, 2);
        } else {
            this.m_aColorFormatImpl.setColorFormat((short)2);
        }
        return this.m_aColorFormatImpl;
    }

    public XColorFormat ForeColor() throws BasicErrorException {
        if (this.m_aColorFormatImpl == null) {
            this.m_aColorFormatImpl = new ColorFormatImpl((HelperInterfaceAdaptor)this.getParent(), this, 1);
        } else {
            this.m_aColorFormatImpl.setColorFormat((short)1);
        }
        return this.m_aColorFormatImpl;
    }

    public void setVisible(boolean bl) throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            LineStyle lineStyle = (LineStyle)propertySetHelper.getPropertyValueAsObject("LineStyle");
            if (!bl) {
                propertySetHelper.setPropertyValue("LineStyle", LineStyle.NONE);
            } else if (lineStyle == LineStyle.NONE) {
                this.setDashStyle(this.m_nLineDashStyle);
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public boolean getVisible() throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            LineStyle lineStyle = (LineStyle)propertySetHelper.getPropertyValueAsObject("LineStyle");
            if (lineStyle == LineStyle.NONE) {
                return false;
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return true;
    }

    public void setWeight(double d) throws BasicErrorException {
        if (d < 0.0) {
            DebugHelper.exception(969, "Parameter: Must be positv.");
        }
        if (d == 0.0) {
            d = 0.5;
        }
        this.m_nLineWeight = d;
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            Millimeter millimeter = this.getMillimeterHelper();
            millimeter.setInPoints(d);
            propertySetHelper.setPropertyValue("LineWidth", new Integer((int)millimeter.getInHundredthsOfOneMillimeter()));
            this.setDashStyle(this.m_nLineDashStyle);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public double getWeight() throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            int n = propertySetHelper.getPropertyValueAsInteger("LineWidth", 0);
            Millimeter millimeter = this.getMillimeterHelper();
            millimeter.setInHundredthsOfOneMillimeter(n);
            return millimeter.getInPoints();
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return 0.0;
        }
    }

    public void setDashStyle(int n) throws BasicErrorException {
        block12: {
            this.m_nLineDashStyle = n;
            try {
                ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
                XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
                PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
                if (n == 1) {
                    propertySetHelper.setPropertyValue("LineStyle", LineStyle.SOLID);
                    break block12;
                }
                propertySetHelper.setPropertyValue("LineStyle", LineStyle.DASH);
                LineDash lineDash = new LineDash();
                Millimeter millimeter = this.getMillimeterHelper();
                millimeter.setInPoints(this.m_nLineWeight);
                int n2 = (int)millimeter.getInHundredthsOfOneMillimeter();
                switch (n) {
                    case 5: {
                        lineDash.Dots = 1;
                        lineDash.DotLen = n2;
                        lineDash.Dashes = 1;
                        lineDash.DashLen = 5 * n2;
                        lineDash.Distance = 4 * n2;
                        break;
                    }
                    case 8: {
                        lineDash.Dots = 1;
                        lineDash.DotLen = n2;
                        lineDash.Dashes = 1;
                        lineDash.DashLen = 10 * n2;
                        lineDash.Distance = 4 * n2;
                        break;
                    }
                    case 4: {
                        lineDash.Dots = 0;
                        lineDash.DotLen = 0;
                        lineDash.Dashes = 1;
                        lineDash.DashLen = 6 * n2;
                        lineDash.Distance = 4 * n2;
                        break;
                    }
                    case 6: {
                        lineDash.Dots = (short)2;
                        lineDash.DotLen = n2;
                        lineDash.Dashes = 1;
                        lineDash.DashLen = 10 * n2;
                        lineDash.Distance = 3 * n2;
                        break;
                    }
                    case 7: {
                        lineDash.Dots = 0;
                        lineDash.DotLen = 0;
                        lineDash.Dashes = 1;
                        lineDash.DashLen = 10 * n2;
                        lineDash.Distance = 4 * n2;
                        break;
                    }
                    case 2: {
                        lineDash.Dots = 1;
                        lineDash.DotLen = n2;
                        lineDash.Dashes = 0;
                        lineDash.DashLen = 0;
                        lineDash.Distance = n2;
                        break;
                    }
                    case 3: {
                        lineDash.Dots = 1;
                        lineDash.DotLen = n2;
                        lineDash.Dashes = 0;
                        lineDash.DashLen = 0;
                        lineDash.Distance = n2;
                        break;
                    }
                    default: {
                        DebugHelper.writeInfo("this MsoLineDashStyle is not supported.");
                        lineDash.Dots = 1;
                        lineDash.DotLen = n2;
                        lineDash.Dashes = 1;
                        lineDash.DashLen = 5 * n2;
                        lineDash.Distance = 4 * n2;
                    }
                }
                propertySetHelper.setPropertyValue("LineDash", lineDash);
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
    }

    public int getDashStyle() throws BasicErrorException {
        block7: {
            try {
                ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
                XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
                PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
                Object object = propertySetHelper.getPropertyValueAsObject("LineStyle");
                if (object == LineStyle.SOLID) {
                    this.m_nLineDashStyle = 1;
                    break block7;
                }
                LineDash lineDash = (LineDash)propertySetHelper.getPropertyValueAsObject("LineDash");
                if (lineDash.Dots == 0) {
                    this.m_nLineDashStyle = 4;
                    if (lineDash.Distance <= 0 || lineDash.DashLen / lineDash.Distance <= 1) break block7;
                    this.m_nLineDashStyle = 7;
                    break block7;
                }
                if (lineDash.Dots == 1) {
                    this.m_nLineDashStyle = 5;
                    if (lineDash.Dashes == 0) {
                        this.m_nLineDashStyle = 2;
                        break block7;
                    }
                    if (lineDash.Distance <= 0 || lineDash.DashLen / lineDash.Distance <= 1) break block7;
                    this.m_nLineDashStyle = 8;
                    break block7;
                }
                if (lineDash.Dots == 2) {
                    this.m_nLineDashStyle = 6;
                }
            }
            catch (Exception exception) {
                DebugHelper.exception(exception);
            }
        }
        return this.m_nLineDashStyle;
    }

    public double getTransparency() throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            int n = propertySetHelper.getPropertyValueAsInteger("LineTransparence", 0);
            double d = n;
            return d / 100.0;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return 0.0;
        }
    }

    public void setTransparency(double d) throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            short s = (short)(d * 100.0);
            propertySetHelper.setPropertyValue("LineTransparence", new Short(s));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    private String convertArrowheadStyleToLineStartEndName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "";
                break;
            }
            case 6: {
                string = "Circle";
                break;
            }
            case -2: {
                DebugHelper.warning((Exception)((Object)new NoSupportException("The given value 'ArrowheadStyleMixed' is not supported.")));
                string = "";
                break;
            }
            case 5: {
                string = "Square 45";
                break;
            }
            case 3: {
                string = "Line Arrow";
                break;
            }
            case 4: {
                string = "Arrow concave";
                break;
            }
            case 2: {
                string = "Small Arrow";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private int convertLineStartEndNameToArrowheadStyle(String string) {
        int n = 1;
        n = string.equals("Small Arrow") || string.equals("Arrow") || string.equals("Double Arrow") ? 2 : (string.equals("Square 45") || string.equals("Square") || string.equals("msArrowDiamondEnd") ? 5 : (string.equals("Circle") || string.equals("Dimension Lines") ? 6 : (string.equals("Arrow concave") ? 4 : (string.equals("Rounded short Arrow") || string.equals("Rounded large Arrow") || string.equals("Symmetric Arrow") || string.equals("Line Arrow") ? 3 : 1))));
        return n;
    }

    private int calculateArrowheadSize() throws BasicErrorException {
        Millimeter millimeter = this.getMillimeterHelper();
        double d = this.m_nLineWeight * (225.0 / (17.0 * this.m_nLineWeight + 14.0));
        millimeter.setInPoints(d);
        return (int)millimeter.getInHundredthsOfOneMillimeter();
    }

    public void setBeginArrowheadStyle(int n) throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            String string = this.convertArrowheadStyleToLineStartEndName(n);
            propertySetHelper.setPropertyValue("LineStartName", string);
            propertySetHelper.setPropertyValue("LineStartWidth", new Integer(this.calculateArrowheadSize()));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getBeginArrowheadStyle() throws BasicErrorException {
        int n = 1;
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            String string = propertySetHelper.getPropertyValueAsString("LineStartName", "");
            n = this.convertLineStartEndNameToArrowheadStyle(string);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public void setBeginArrowheadLength(int n) throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'BeginArrowheadLength' is not supported.")));
    }

    public void setBeginArrowheadWidth(int n) throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'BeginArrowheadWidth' is not supported.")));
    }

    public int getBeginArrowheadLength() throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'BeginArrowheadLength' is not supported.")));
        return 0;
    }

    public int getBeginArrowheadWidth() throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'BeginArrowheadWidth' is not supported.")));
        return 0;
    }

    public void setEndArrowheadStyle(int n) throws BasicErrorException {
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            String string = this.convertArrowheadStyleToLineStartEndName(n);
            propertySetHelper.setPropertyValue("LineEndName", string);
            propertySetHelper.setPropertyValue("LineEndWidth", new Integer(this.calculateArrowheadSize()));
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getEndArrowheadStyle() throws BasicErrorException {
        int n = 1;
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            XShape xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = LineFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
            PropertySetHelper propertySetHelper = new PropertySetHelper(xShape);
            String string = propertySetHelper.getPropertyValueAsString("LineEndName", "");
            n = this.convertLineStartEndNameToArrowheadStyle(string);
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return n;
    }

    public void setEndArrowheadLength(int n) throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'EndArrowheadLength' is not supported.")));
    }

    public void setEndArrowheadWidth(int n) throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'EndArrowheadWidth' is not supported.")));
    }

    public int getEndArrowheadLength() throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'EndArrowheadLength' is not supported.")));
        return 0;
    }

    public int getEndArrowheadWidth() throws BasicErrorException {
        DebugHelper.warning((Exception)((Object)new NoSupportException("Property 'EndArrowheadWidth' is not supported.")));
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

