/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XModel;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.common.CollectionHelper;
import com.sun.star.helper.common.CommonUtilities;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.DocumentUtilities;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.WriterFilename;
import com.sun.star.helper.common.WriterTemplateFilename;
import com.sun.star.helper.writer.DocumentImpl;
import com.sun.star.helper.writer.OptionsImpl;
import com.sun.star.helper.writer.TemplateImpl;
import com.sun.star.helper.writer.TemplatesImpl;
import com.sun.star.helper.writer.WriterImpl;
import com.sun.star.helper.writer.XDocument;
import com.sun.star.helper.writer.XDocuments;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.XComponent;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;

public class DocumentsImpl
extends HelperInterfaceAdaptor
implements XDocuments {
    protected static final String __serviceName = "com.sun.star.helper.writer.Documents";
    private DocumentsHelperCache itemDocuments;
    static /* synthetic */ Class class$com$sun$star$lang$XComponent;

    public DocumentsImpl(WriterImpl writerImpl) throws BasicErrorException {
        super(__serviceName, writerImpl);
        this.itemDocuments = new DocumentsHelperCache(this, writerImpl);
    }

    public XDocument Open(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16) throws BasicErrorException {
        PropertyValue propertyValue;
        String string;
        PropertyValue propertyValue2;
        boolean bl;
        WriterFilename writerFilename;
        DebugHelper.writeInfo("Documents.Open(): ");
        String string2 = OptionalParamUtility.getString("FileName", object, "local:default", false);
        if (string2.equals("local:default")) {
            DebugHelper.exception((com.sun.star.uno.Exception)((Object)new IllegalArgumentException("Parameter FileName not set.")));
        }
        DebugHelper.writeInfo("Documents.Open(): Filename:=" + string2);
        if (!AnyConverter.isVoid((Object)object2)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter ConfirmConversions is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object4)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter AddToRecentFiles is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object8)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter WritePasswordDocument is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object9)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter WritePasswordTemplate is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object13)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter OpenConflictDocument is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object14)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter OpenAndRepair is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object15)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter DocumentDirection is not supported.")));
        }
        if (!AnyConverter.isVoid((Object)object16)) {
            DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter NoEncodingDialog is not supported.")));
        }
        if (!(writerFilename = new WriterFilename(string2)).checkExistanceForRead()) {
            DebugHelper.writeInfo("Documents.Open(): File '" + writerFilename.getAbsoluteFilename() + "'not found.");
            DebugHelper.exception(53, "");
        }
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        if (!AnyConverter.isVoid((Object)object3) && (bl = OptionalParamUtility.getBoolean("ReadOnly", object3, false, false))) {
            propertyValue2 = new PropertyValue();
            propertyValue2.Name = "ReadOnly";
            propertyValue2.Value = Boolean.TRUE;
            arrayList.add(propertyValue2);
        }
        if (!AnyConverter.isVoid((Object)object12) && !(bl = OptionalParamUtility.getBoolean("Visible", object12, false, false))) {
            propertyValue2 = new PropertyValue();
            propertyValue2.Name = "Hidden";
            propertyValue2.Value = Boolean.TRUE;
            arrayList.add(propertyValue2);
        }
        if (!AnyConverter.isVoid((Object)object5)) {
            String string3 = OptionalParamUtility.getString("PasswordDocument", object5, "", false);
            propertyValue2 = new PropertyValue();
            propertyValue2.Name = "Password";
            propertyValue2.Value = string3;
            arrayList.add(propertyValue2);
        }
        if (!AnyConverter.isVoid((Object)object6)) {
            String string4 = OptionalParamUtility.getString("PasswordTemplate", object6, "", false);
            propertyValue2 = new PropertyValue();
            propertyValue2.Name = "Password";
            propertyValue2.Value = string4;
            arrayList.add(propertyValue2);
        }
        boolean bl2 = false;
        if (!AnyConverter.isVoid((Object)object7)) {
            bl2 = OptionalParamUtility.getBoolean("Revert", object7, false, false);
        }
        if (!AnyConverter.isVoid((Object)object10)) {
            int n = OptionalParamUtility.getInt("Format", object10, 0, false);
            string = "";
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: 
                case 5: {
                    string = "Text (encoded)";
                    break;
                }
                case 7: {
                    string = "HTML (StarWriter)";
                    break;
                }
                case 3: {
                    string = "Rich Text Format";
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    string = "";
                }
            }
            if (n == 2) {
                propertyValue = new PropertyValue();
                propertyValue.Name = "AsTemplate";
                propertyValue.Value = Boolean.TRUE;
                arrayList.add(propertyValue);
                DebugHelper.writeInfo("Documents.Open(): Property 'AsTemplate' := 'true'");
            }
            if (string.length() > 0) {
                propertyValue = new PropertyValue();
                propertyValue.Name = "FilterName";
                propertyValue.Value = string;
                arrayList.add(propertyValue);
                DebugHelper.writeInfo("Documents.Open(): Property 'Format' := '" + string + "'");
            }
        }
        if (!AnyConverter.isVoid((Object)object11)) {
            int n = OptionalParamUtility.getInt("Encoding", object11, 0, false);
            try {
                string = CommonUtilities.getConvertMsoEncodingToSOCharSet(n);
                propertyValue = new PropertyValue();
                propertyValue.Name = "FilterOptions";
                propertyValue.Value = string;
                arrayList.add(propertyValue);
                DebugHelper.writeInfo("Document.Open(): Property 'FilterOptions' := '" + string + "'");
            }
            catch (NoSupportException noSupportException) {
                DebugHelper.writeInfo("Documents.Open() Filename:='" + string2 + "' Warning: " + noSupportException.getMessage());
            }
        }
        try {
            return this.openAndRegisterDocument(writerFilename.getAbsoluteFilename(), "swriter", bl2, arrayList);
        }
        catch (com.sun.star.uno.Exception exception) {
            DebugHelper.exception(exception);
            return null;
        }
    }

    public void Close(Object object, Object object2, Object object3) throws BasicErrorException {
        int n = OptionalParamUtility.getInt("SaveChanges", object, -2, false);
        int n2 = OptionalParamUtility.getInt("OriginalFormat", object2, 1, false);
        boolean bl = OptionalParamUtility.getBoolean("RouteDocument", object3, false, false);
        HelperUtilities.close("swriter", n, n2, bl);
    }

    public void Save(Object object, Object object2) throws BasicErrorException {
        boolean bl = false;
        int n = 1;
        if (!AnyConverter.isVoid((Object)object)) {
            bl = OptionalParamUtility.getBoolean("NoPrompt", object, false, false);
        }
        if (!AnyConverter.isVoid((Object)object2)) {
            n = OptionalParamUtility.getInt("SaveOriginalFormat", object2, 1, false);
        }
        DocumentUtilities.save("swriter", bl, n, false);
    }

    public XDocument Add(Object object, Object object2, Object object3, Object object4) throws BasicErrorException {
        try {
            boolean bl;
            HelperInterfaceAdaptor helperInterfaceAdaptor;
            HelperInterfaceAdaptor helperInterfaceAdaptor2;
            Object object5;
            int n;
            String string = "private:factory/swriter";
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (!AnyConverter.isVoid((Object)object2) && (n = OptionalParamUtility.getBoolean("NewTemplate", object2, false, false)) != 0) {
                DebugHelper.writeInfo("Documents.Add(): NewTemplate:=true");
                DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter 'NewTemplate' is not implemented yet.")));
            }
            n = 0;
            if (!AnyConverter.isVoid((Object)object3)) {
                n = OptionalParamUtility.getInt("DocumentType", object3, 0, false);
                if (n != 0 && n != 1) {
                    DebugHelper.warning((com.sun.star.uno.Exception)((Object)new NoSupportException("Parameter DocumentType:='" + n + "' is not supported. Only NewBlank or Web")));
                    n = 0;
                }
                if (n == 1) {
                    string = "private:factory/swriter/web";
                }
            }
            TemplateImpl templateImpl = null;
            if (!AnyConverter.isVoid((Object)object) && !((String)(object5 = OptionalParamUtility.getString("Template", object, "local:default", false))).equals("local:default")) {
                DebugHelper.writeInfo("Documents.Add(): Template:=" + (String)object5);
                helperInterfaceAdaptor2 = (WriterImpl)this.getParent();
                helperInterfaceAdaptor = new OptionsImpl((WriterImpl)helperInterfaceAdaptor2);
                String string2 = ((OptionsImpl)helperInterfaceAdaptor).DefaultFilePath(2);
                WriterTemplateFilename writerTemplateFilename = new WriterTemplateFilename((String)object5, string2);
                writerTemplateFilename.clearCurrentExtension();
                if (writerTemplateFilename.checkExistanceForRead()) {
                    PropertyValue propertyValue = new PropertyValue();
                    propertyValue.Name = "AsTemplate";
                    propertyValue.Value = Boolean.TRUE;
                    arrayList.add(propertyValue);
                    string = writerTemplateFilename.getAbsoluteFilename();
                    String string3 = WriterTemplateFilename.getPathFromName(string);
                    String string4 = WriterTemplateFilename.getBasename(string);
                    TemplatesImpl templatesImpl = (TemplatesImpl)((WriterImpl)helperInterfaceAdaptor2).Templates();
                    templateImpl = templatesImpl.Add(string3, string4, 2);
                } else {
                    DebugHelper.writeInfo("Template file: '" + writerTemplateFilename.getAbsoluteFilename() + "' not found.");
                    DebugHelper.exception(53, "");
                }
            }
            if (!AnyConverter.isVoid((Object)object4) && !(bl = OptionalParamUtility.getBoolean("Visible", object4, true, false))) {
                DebugHelper.writeInfo("Documents.Add(): Visible:=false");
                helperInterfaceAdaptor2 = new PropertyValue();
                ((PropertyValue)helperInterfaceAdaptor2).Name = "Hidden";
                ((PropertyValue)helperInterfaceAdaptor2).Value = Boolean.TRUE;
                arrayList.add(helperInterfaceAdaptor2);
            }
            if (n == 0 && AnyConverter.isVoid((Object)object) && AnyConverter.isVoid((Object)object2)) {
                object5 = new PropertyValue();
                ((PropertyValue)object5).Name = "AsTemplate";
                ((PropertyValue)object5).Value = Boolean.TRUE;
                arrayList.add(object5);
                helperInterfaceAdaptor2 = (WriterImpl)this.getParent();
                helperInterfaceAdaptor = (TemplatesImpl)((WriterImpl)helperInterfaceAdaptor2).Templates();
                templateImpl = ((TemplatesImpl)helperInterfaceAdaptor).Add();
                string = templateImpl.getFullName();
            }
            object5 = this.addDocument(DocumentUtilities.openDocument(string, false, arrayList));
            helperInterfaceAdaptor2 = (DocumentImpl)object5;
            ((DocumentImpl)helperInterfaceAdaptor2).setTemplate(templateImpl);
            return object5;
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("Can't create new document. " + exception.getMessage());
            DebugHelper.exception(51, "Can't create new document. " + exception.getMessage());
            return null;
        }
    }

    public int Count() throws BasicErrorException {
        this.itemDocuments.updateCache();
        return this.itemDocuments.count();
    }

    public XDocument Item(Object object) throws BasicErrorException {
        DocumentImpl documentImpl;
        block3: {
            this.itemDocuments.updateCache();
            documentImpl = null;
            if (object == null || AnyConverter.isVoid((Object)object)) break block3;
            try {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    documentImpl = this.getDocumentByName(string);
                    break block3;
                }
                int n = (int)OptionalParamUtility.getAnyNumber("Index", object, 1L, true);
                documentImpl = (DocumentImpl)this.itemDocuments.item(n - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                HelperUtilities.exception(illegalArgumentException);
            }
        }
        return documentImpl;
    }

    public XDocument Item(int n) throws BasicErrorException {
        this.itemDocuments.updateCache();
        return (XDocument)this.itemDocuments.item(n - 1);
    }

    private DocumentImpl getDocumentByName(String string) throws BasicErrorException {
        XModel xModel = HelperUtilities.findModelForName(string);
        DocumentImpl documentImpl = null;
        if (xModel != null) {
            documentImpl = (DocumentImpl)this.itemDocuments.getHelper(xModel);
        }
        if (documentImpl == null) {
            DebugHelper.exception(14, "Unknown document " + string);
        }
        return documentImpl;
    }

    public XDocument openAndRegisterDocument(String string, String string2, boolean bl, ArrayList arrayList) throws BasicErrorException {
        XModel xModel = DocumentUtilities.openDocument(string, bl, arrayList);
        if (xModel != null) {
            String string3 = DocumentUtilities.getModelDocumentType(xModel);
            if (string3 != null && string3.equals("swriter")) {
                XDocument xDocument = this.getDocument(xModel);
                return xDocument;
            }
            DocumentUtilities.closeDocument(xModel, 0, 1);
        }
        return null;
    }

    public XDocument getDocument(XModel xModel) throws BasicErrorException {
        return (DocumentImpl)this.itemDocuments.getOrCreateHelper(xModel);
    }

    private DocumentImpl addDocument(XModel xModel) throws BasicErrorException {
        return (DocumentImpl)this.itemDocuments.addImplementationObject(xModel);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DocumentsHelperCache
    extends CollectionHelper {
        private DocumentsImpl m_docs;
        private WriterImpl m_xWriter;

        DocumentsHelperCache(DocumentsImpl documentsImpl2, WriterImpl writerImpl) {
            super(0);
            this.m_docs = documentsImpl2;
            this.m_xWriter = writerImpl;
        }

        public void fetchImplementationObjects(ArrayList arrayList) {
            HelperUtilities.appendOpenComponents("swriter", arrayList);
        }

        public boolean isValidImplementationObject(Object object) {
            return DocumentUtilities.isComponentDocument((XComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$lang$XComponent == null ? (class$com$sun$star$lang$XComponent = DocumentsImpl.class$("com.sun.star.lang.XComponent")) : class$com$sun$star$lang$XComponent), (Object)object));
        }

        public HelperInterfaceAdaptor createHelper(Object object) {
            XModel xModel = (XModel)object;
            if (!DocumentUtilities.isComponentDocument(xModel)) {
                return null;
            }
            DocumentImpl documentImpl = new DocumentImpl(this.m_docs, xModel, this.m_xWriter);
            DebugHelper.writeInfo("create new DocumentImpl entry.");
            return documentImpl;
        }
    }
}

