/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.drawing.XShape;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.calc.CalcHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.PropertySetHelper;
import com.sun.star.helper.writer.FillFormatImpl;
import com.sun.star.helper.writer.ShapeImpl;
import com.sun.star.helper.writer.XColorFormat;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.Exception;

public class ColorFormatImpl
extends HelperInterfaceAdaptor
implements XColorFormat {
    protected static final String __serviceName = "com.sun.star.helper.writer.ColorFormat";
    private XShape m_xShape = null;
    private HelperInterfaceAdaptor m_aMyInternalParent;
    private short m_nColorFormatType;
    private int m_nFillFormatBackColor = 0;
    static /* synthetic */ Class class$com$sun$star$drawing$XShape;

    public ColorFormatImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, HelperInterfaceAdaptor helperInterfaceAdaptor2, short s) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        this.m_aMyInternalParent = helperInterfaceAdaptor2;
        this.m_nColorFormatType = s;
        try {
            ShapeImpl shapeImpl = (ShapeImpl)this.getParent();
            this.m_xShape = (XShape)OptionalParamUtility.getObject(class$com$sun$star$drawing$XShape == null ? (class$com$sun$star$drawing$XShape = ColorFormatImpl.class$("com.sun.star.drawing.XShape")) : class$com$sun$star$drawing$XShape, shapeImpl.getUnoObject());
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    protected void setColorFormat(short s) {
        this.m_nColorFormatType = s;
    }

    public void setRGB(int n) throws BasicErrorException {
        int n2 = CalcHelper.swapFirstAndThirdByte(n);
        try {
            PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
            switch (this.m_nColorFormatType) {
                case 1: {
                    propertySetHelper.setPropertyValue("LineColor", new Integer(n2));
                    break;
                }
                case 2: {
                    DebugHelper.warning((Exception)((Object)new NoSupportException("The given Property 'BackColor' is not supported.")));
                    break;
                }
                case 3: {
                    propertySetHelper.setPropertyValue("FillColor", new Integer(n2));
                    FillFormatImpl fillFormatImpl = (FillFormatImpl)this.m_aMyInternalParent;
                    fillFormatImpl.setForeColorAndInternalStyle(n2);
                    break;
                }
                case 4: {
                    this.m_nFillFormatBackColor = n2;
                    FillFormatImpl fillFormatImpl = (FillFormatImpl)this.m_aMyInternalParent;
                    fillFormatImpl.setBackColorAndInternalStyle(n2);
                    break;
                }
                default: {
                    DebugHelper.exception(969, "Second parameter of ColorFormatImpl is wrong.");
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getRGB() throws BasicErrorException {
        int n = 0;
        try {
            PropertySetHelper propertySetHelper = new PropertySetHelper(this.m_xShape);
            switch (this.m_nColorFormatType) {
                case 1: {
                    n = propertySetHelper.getPropertyValueAsInteger("LineColor", 0);
                    break;
                }
                case 2: {
                    DebugHelper.warning((Exception)((Object)new NoSupportException("The given Property 'BackColor' is not supported.")));
                    break;
                }
                case 3: {
                    n = propertySetHelper.getPropertyValueAsInteger("FillColor", 0);
                    break;
                }
                case 4: {
                    n = this.m_nFillFormatBackColor;
                    break;
                }
                default: {
                    DebugHelper.exception(969, "Second parameter of ColorFormatImpl is wrong.");
                    break;
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        n = CalcHelper.swapFirstAndThirdByte(n);
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

