/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.RangeHelper;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.XCharacters;
import com.sun.star.helper.writer.XRange;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;

public class CharactersImpl
extends HelperInterfaceAdaptor
implements XCharacters,
XUnoAccess {
    protected static final String __serviceName = "com.sun.star.helper.writer.Characters";
    private RangeImpl m_rangeImpl;

    public CharactersImpl(RangeImpl rangeImpl) throws BasicErrorException {
        this(rangeImpl, null);
    }

    public CharactersImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XRange xRange) throws BasicErrorException {
        super(__serviceName, helperInterfaceAdaptor);
        if (helperInterfaceAdaptor instanceof RangeImpl && xRange == null) {
            this.m_rangeImpl = (RangeImpl)helperInterfaceAdaptor;
        } else if (xRange instanceof RangeImpl && xRange != null) {
            this.m_rangeImpl = (RangeImpl)xRange;
        } else {
            DebugHelper.exception(14, "parentObject,range");
        }
    }

    public int Count() throws BasicErrorException {
        int n = 0;
        XTextCursor xTextCursor = this.m_rangeImpl.getXText().createTextCursorByRange((XTextRange)this.m_rangeImpl.getXTextCursor());
        XTextRange xTextRange = xTextCursor.getEnd();
        xTextCursor.collapseToStart();
        boolean bl = RangeHelper.areRangesEqual(xTextCursor.getEnd(), xTextRange);
        while (!bl) {
            xTextCursor.goRight((short)1, false);
            ++n;
            bl = RangeHelper.areRangesEqual(xTextCursor.getEnd(), xTextRange);
        }
        if (this.m_rangeImpl.getMaySpanEndOfDocument()) {
            ++n;
        }
        return n;
    }

    public XRange Item(Object object) throws BasicErrorException {
        RangeImpl rangeImpl = null;
        try {
            int n = NumericalHelper.toInt(object);
            if (n <= 0 || n >= this.Count()) {
                DebugHelper.exception(5, "Index");
            }
            XTextCursor xTextCursor = this.m_rangeImpl.getXText().createTextCursorByRange((XTextRange)this.m_rangeImpl.getXTextCursor());
            xTextCursor.collapseToStart();
            int n2 = 2;
            while (n2 < n) {
                xTextCursor.goRight((short)1, false);
                ++n2;
            }
            xTextCursor.goRight((short)1, true);
            rangeImpl = new RangeImpl((HelperInterfaceAdaptor)this.m_rangeImpl, xTextCursor.getStart(), xTextCursor.getEnd());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        return rangeImpl;
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.m_rangeImpl.getXTextRange();
    }
}

