/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.writer.BordersImpl;
import com.sun.star.helper.writer.ColorTableHelper;
import com.sun.star.helper.writer.ParagraphsBorderHelperImpl;
import com.sun.star.helper.writer.WriterTableBorderHelperImpl;
import com.sun.star.helper.writer.XBorder;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.table.XCell;
import com.sun.star.text.XParagraphCursor;

public class BorderImpl
extends HelperInterfaceAdaptor
implements XBorder {
    protected static final String __serviceName = "com.sun.star.helper.writer.Border";
    private BorderHelperIfc bHelper;
    public int iLineStyle;
    public int iLineWidth;
    public int iLineColor;
    private boolean bBorderVisible = true;

    public BorderImpl(BordersImpl bordersImpl, XCell[][] xCellArray, int n) throws BasicErrorException {
        super(__serviceName, bordersImpl);
        this.bHelper = new WriterTableBorderHelperImpl(xCellArray, n);
    }

    public BorderImpl(BordersImpl bordersImpl, XParagraphCursor xParagraphCursor, int n) throws BasicErrorException {
        super(__serviceName, bordersImpl);
        this.bHelper = new ParagraphsBorderHelperImpl(xParagraphCursor, n);
    }

    public int getLineWidth() throws BasicErrorException {
        int n = this.iLineWidth;
        if (this.bBorderVisible) {
            n = this.bHelper.getLineWidth();
        }
        return n;
    }

    public void setLineWidth(int n) throws IllegalArgumentException, BasicErrorException {
        if (!this.bBorderVisible) {
            this.iLineWidth = n;
        } else {
            this.bHelper.setLineWidth(n);
        }
    }

    public int getColor() throws BasicErrorException {
        int n = this.iLineWidth;
        if (this.bBorderVisible) {
            n = this.bHelper.getColor();
        }
        return n;
    }

    public void setColor(int n) throws IllegalArgumentException, BasicErrorException {
        this.bHelper.setColor(n);
    }

    public void setColorIndex(int n) throws IndexOutOfBoundsException, BasicErrorException {
        int n2 = ColorTableHelper.getColorForIndex(n);
        try {
            this.setColor(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IndexOutOfBoundsException(illegalArgumentException.getMessage());
        }
    }

    public int getColorIndex() throws BasicErrorException {
        int n = this.getColor();
        int n2 = ColorTableHelper.getIndexFromColor(n);
        return n2;
    }

    public int getLineStyle() throws BasicErrorException {
        int n = this.iLineWidth;
        if (this.bBorderVisible) {
            n = this.bHelper.getLineStyle();
        }
        return n;
    }

    public void setLineStyle(int n) throws IllegalArgumentException, NoSupportException, BasicErrorException {
        this.bHelper.setLineStyle(n);
    }

    public void setVisible(boolean bl) throws BasicErrorException {
        int n = this.iLineStyle;
        int n2 = this.iLineWidth;
        int n3 = this.iLineColor;
        if (this.bBorderVisible != bl) {
            if (bl) {
                this.bBorderVisible = true;
                if (this.iLineStyle == 0) {
                    n = 1;
                }
                try {
                    this.setLineStyle(n);
                    this.setLineWidth(n2);
                    this.setColor(n3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    HelperUtilities.exception(illegalArgumentException);
                }
                catch (NoSupportException noSupportException) {
                    HelperUtilities.exception(noSupportException);
                }
            } else {
                this.iLineStyle = this.getLineStyle();
                this.iLineWidth = this.getLineWidth();
                this.iLineColor = this.getColor();
                try {
                    this.setLineStyle(0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    HelperUtilities.exception(illegalArgumentException);
                }
                catch (NoSupportException noSupportException) {
                    HelperUtilities.exception(noSupportException);
                }
                this.bBorderVisible = false;
            }
        }
    }

    public boolean getVisible() throws BasicErrorException {
        return this.bBorderVisible;
    }

    public static interface BorderHelperIfc {
        public int getLineWidth();

        public int getColor();

        public void setColor(int var1);

        public void setLineStyle(int var1) throws BasicErrorException;

        public int getLineStyle();

        public void setLineWidth(int var1) throws BasicErrorException;
    }
}

