/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.writer;

import com.sun.star.container.XNamed;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.XUnoAccess;
import com.sun.star.helper.writer.RangeImpl;
import com.sun.star.helper.writer.XBookmark;
import com.sun.star.helper.writer.XRange;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;

public class BookmarkImpl
extends HelperInterfaceAdaptor
implements XBookmark,
XUnoAccess {
    private XBookmarksSupplier xBookmarksSupplier = null;
    private String BookmarkName;
    private XTextContent xTextContent = null;
    private XNamed xNamed = null;
    private XRange xRange = null;
    private boolean isValid = true;
    private XText xText = null;
    private Object aBookmark;
    static /* synthetic */ Class class$com$sun$star$text$XTextDocument;
    static /* synthetic */ Class class$com$sun$star$text$XTextContent;
    static /* synthetic */ Class class$com$sun$star$container$XNamed;

    public BookmarkImpl(HelperInterfaceAdaptor helperInterfaceAdaptor, XBookmarksSupplier xBookmarksSupplier, String string) throws BasicErrorException {
        super("com.sun.star.helper.writer.BookmarkImpl", helperInterfaceAdaptor);
        this.xBookmarksSupplier = xBookmarksSupplier;
        this.BookmarkName = string;
        XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextDocument == null ? (class$com$sun$star$text$XTextDocument = BookmarkImpl.class$("com.sun.star.text.XTextDocument")) : class$com$sun$star$text$XTextDocument), (Object)this.getXModel());
        if (xTextDocument == null) {
            DebugHelper.exception((Exception)((Object)new IllegalArgumentException("works only in textdocuments")));
        }
        this.xText = xTextDocument.getText();
        try {
            this.aBookmark = this.xBookmarksSupplier.getBookmarks().getByName(this.BookmarkName.toLowerCase());
            this.xTextContent = (XTextContent)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextContent == null ? (class$com$sun$star$text$XTextContent = BookmarkImpl.class$("com.sun.star.text.XTextContent")) : class$com$sun$star$text$XTextContent), (Object)this.aBookmark);
            this.xNamed = (XNamed)UnoRuntime.queryInterface((Class)(class$com$sun$star$container$XNamed == null ? (class$com$sun$star$container$XNamed = BookmarkImpl.class$("com.sun.star.container.XNamed")) : class$com$sun$star$container$XNamed), (Object)this.aBookmark);
            this.xRange = new RangeImpl(helperInterfaceAdaptor, this.xTextContent.getAnchor().getStart(), this.xTextContent.getAnchor().getEnd());
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public int getStart() throws BasicErrorException {
        this.checkValidity();
        return this.xRange.getStart();
    }

    public int getEnd() throws BasicErrorException {
        this.checkValidity();
        return this.xRange.getEnd();
    }

    public void setStart(int n) throws BasicErrorException {
        this.checkValidity();
        this.xRange.setStart(n);
        try {
            this.xTextContent.attach(this.xRange.getXTextRange());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    public void setEnd(int n) throws BasicErrorException {
        this.checkValidity();
        this.xRange.setEnd(n);
        try {
            this.xTextContent.attach(this.xRange.getXTextRange());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    public String getName() throws BasicErrorException {
        this.checkValidity();
        return this.BookmarkName;
    }

    public void setName(String string) throws BasicErrorException {
        this.checkValidity();
        this.xNamed.setName(string);
    }

    public XRange getRange() throws BasicErrorException {
        this.checkValidity();
        return this.xRange;
    }

    public void Delete() throws BasicErrorException {
        this.checkValidity();
        try {
            this.xText.removeTextContent(this.xTextContent);
            this.isValid = false;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
    }

    public void Select() throws BasicErrorException {
        this.checkValidity();
        this.xRange.Select();
    }

    private void checkValidity() throws BasicErrorException {
        if (!this.isValid) {
            DebugHelper.exception(5, "");
        }
    }

    public Object getUnoObject() throws BasicErrorException {
        return this.xTextContent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

