/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexReplace;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.script.BasicErrorException;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;

public class PresetPropertiesForListTemplates {
    public static final int TEMPLATE_TYPE1 = 1;
    public static final int TEMPLATE_TYPE2 = 2;
    public static final int TEMPLATE_TYPE3 = 3;
    public static final int TEMPLATE_TYPE4 = 4;
    public static final int TEMPLATE_TYPE5 = 5;
    public static final int TEMPLATE_TYPE6 = 6;
    public static final int TEMPLATE_TYPE7 = 7;
    public static final int TEMPLATE_TYPE_MIN = 1;
    public static final int TEMPLATE_TYPE_MAX = 7;
    public static final int BULLET_LIST_TEMPLATES_COUNT = 1;
    public static final int NUMBERED_LIST_TEMPLATES_COUNT = 1;
    public static final int OUTLINE_LIST_TEMPLATES_COUNT = 9;
    public static final String GALLERY_NAME_BULLET_LIST = "BulletGallery";
    public static final String GALLERY_NAME_NUMBERED_LIST = "NumberGallery";
    public static final String GALLERY_NAME_OUTLINE_LIST = "OutlineNumberGallery";
    public static final int INDEX_NUMBERING_TYPE = 0;
    public static final int INDEX_SUFFIX = 1;
    public static final int INDEX_PREFIX = 2;
    public static final int INDEX_PARENT_NUMBERING = 3;
    public static final int INDEX_CHAR_STYLE_NAME = 4;
    public static final int INDEX_BULLET_ID = 5;
    public static final int INDEX_START_WITH = 6;
    public static final int INDEX_SYMBOL_TEXT_DISTANCE = 7;
    public static final int INDEX_FIRST_LINE_OFFSET = 8;
    public static final int INDEX_LEFT_MARGIN = 9;
    public static final int INDEX_COUNT = 10;
    public static final int LIST_LEVEL0 = 0;
    public static final int LIST_LEVEL1 = 1;
    public static final int LIST_LEVEL2 = 2;
    public static final int LIST_LEVEL3 = 3;
    public static final int LIST_LEVEL4 = 4;
    public static final int LIST_LEVEL5 = 5;
    public static final int LIST_LEVEL6 = 6;
    public static final int LIST_LEVEL7 = 7;
    public static final int LIST_LEVEL8 = 8;
    public static final int LIST_LEVEL_COUNT = 9;
    public static final short CHAR_CLOSED_DOT = 8226;
    public static final short CHAR_EMPTY_DOT = 111;
    public static final short CHAR_SQUARE = 9632;
    public static final short CHAR_STAR_SYMBOL = 10026;
    public static final short CHAR_FOUR_DIAMONDS = 10070;
    public static final short CHAR_DIAMOND = 10022;
    public static final short CHAR_ARROW = 10146;
    public static final short CHAR_CHECK_MARK = 10003;
    public static final int POSITION_NUMBER = 0;
    public static final int POSITION_TEXT = 1;
    public static final int POSITION_TAB = 2;
    public static final int POSITION_TRAILING_CHARACTER = 3;
    public static final int POSITION_COUNT = 4;
    private PropertyValue[][] m_pvProperties;
    private int[][] m_iPositions;
    private XIndexAccess xNumberingRules;
    private int iListType;
    static /* synthetic */ Class class$com$sun$star$container$XIndexAccess;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$container$XIndexReplace;
    static /* synthetic */ Class class$com$sun$star$lang$XMultiServiceFactory;

    public PresetPropertiesForListTemplates(XTextDocument xTextDocument, int n, int n2) throws BasicErrorException {
        if (n2 < 1 || n2 > 7) {
            DebugHelper.exception(14, "index");
        }
        this.xNumberingRules = this.createNumberingRules(xTextDocument);
        this.createPropertyPreset();
        String string = null;
        switch (n) {
            case 1: {
                this.createBulletListTemplate(n2);
                string = GALLERY_NAME_BULLET_LIST;
                break;
            }
            case 2: {
                this.createNumberedListTemplate(n2);
                string = GALLERY_NAME_NUMBERED_LIST;
                break;
            }
            case 3: {
                this.createOutlineNumberedListTemplate(n2);
                string = GALLERY_NAME_OUTLINE_LIST;
                break;
            }
            default: {
                DebugHelper.exception(14, "type");
            }
        }
        this.iListType = n;
        this.completeNumberingRules();
        this.m_iPositions = new int[9][4];
        this.initializePositions();
    }

    public PresetPropertiesForListTemplates(XPropertySet xPropertySet) throws BasicErrorException {
        try {
            this.xNumberingRules = (XIndexAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = PresetPropertiesForListTemplates.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess, xPropertySet);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        this.createPropertyPreset();
        this.iListType = 4;
        this.m_iPositions = new int[9][4];
        this.initializePositions();
    }

    public String getNumberingRulesName() throws BasicErrorException {
        String string = "";
        try {
            XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = PresetPropertiesForListTemplates.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, this.xNumberingRules);
            string = (String)xPropertySet.getPropertyValue("Name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (UnknownPropertyException unknownPropertyException) {
            DebugHelper.exception((Exception)((Object)unknownPropertyException));
        }
        return string;
    }

    public XIndexAccess getNumberingRules() throws BasicErrorException {
        this.plausibiltyCheckPositions();
        return this.xNumberingRules;
    }

    public Object getPropertyValueWithNameAndLevel(int n, int n2) throws BasicErrorException {
        if (n < 0 || n > 9) {
            DebugHelper.exception(51, "Level: " + n);
        }
        if (n2 < 0 || n2 > 10) {
            DebugHelper.exception(51, "NameIndex");
        }
        Object object = null;
        boolean bl = false;
        try {
            PropertyValue[] propertyValueArray = (PropertyValue[])this.xNumberingRules.getByIndex(n);
            int n3 = 0;
            while (!bl && n3 < propertyValueArray.length) {
                if (propertyValueArray[n3].Name.equals(this.m_pvProperties[n][n2].Name)) {
                    bl = true;
                    object = propertyValueArray[n3].Value;
                }
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        if (!bl) {
            DebugHelper.exception(51, "NameIndex");
        }
        return object;
    }

    public void setPropertyValueWithNameAndLevel(Object object, int n, int n2) throws BasicErrorException {
        if (n < 0 || n > 9) {
            DebugHelper.exception(51, "Level: " + n);
        }
        if (n2 < 0 || n2 > 10) {
            DebugHelper.exception(51, "NameIndex3");
        }
        this.m_pvProperties[n][n2].Value = object;
        try {
            PropertyValue[] propertyValueArray = (PropertyValue[])this.xNumberingRules.getByIndex(n);
            boolean bl = false;
            int n3 = 0;
            while (!bl && n3 < propertyValueArray.length) {
                if (propertyValueArray[n3].Name.equals(this.m_pvProperties[n][n2].Name)) {
                    bl = true;
                    propertyValueArray[n3].Value = this.m_pvProperties[n][n2].Value;
                    DebugHelper.writeDebug("CHANGE: " + propertyValueArray[n3].Name + "  value: " + propertyValueArray[n3].Value);
                }
                ++n3;
            }
            if (!bl) {
                DebugHelper.exception(51, "Property not replaced: " + this.m_pvProperties[n][n2].Name);
            }
            XIndexReplace xIndexReplace = (XIndexReplace)OptionalParamUtility.getObject(class$com$sun$star$container$XIndexReplace == null ? (class$com$sun$star$container$XIndexReplace = PresetPropertiesForListTemplates.class$("com.sun.star.container.XIndexReplace")) : class$com$sun$star$container$XIndexReplace, this.xNumberingRules);
            xIndexReplace.replaceByIndex(n, (Object)propertyValueArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
    }

    public void setPosition(int n, int n2, int n3) throws BasicErrorException {
        this.m_iPositions[n2][n3] = n;
        if (n3 == 3) {
            String string = (String)this.getPropertyValueWithNameAndLevel(n2, 1);
            if (string == null) {
                string = "";
            }
            string = this.m_iPositions[n2][n3] == 1 ? (string.endsWith(" ") ? string : string + " ") : (string.endsWith(" ") ? string.substring(0, string.length() - 1) : string);
            this.setPropertyValueWithNameAndLevel(string, n2, 1);
        }
        this.m_iPositions[n2][n3] = n;
    }

    public int getPosition(int n, int n2) throws BasicErrorException {
        return this.m_iPositions[n][n2];
    }

    private void plausibiltyCheckPositions() throws BasicErrorException {
        if (this.iListType != 1) {
            int n = 0;
            while (n < 9) {
                String string;
                this.m_iPositions[n] = this.plausibilityCheck(this.m_iPositions[n]);
                if (this.m_iPositions[n][3] == 1 && !(string = (String)this.getPropertyValueWithNameAndLevel(n, 1)).endsWith(" ")) {
                    string = string + " ";
                    this.setPropertyValueWithNameAndLevel(string, n, 1);
                }
                short s = (short)this.m_iPositions[n][1];
                short s2 = (short)(this.m_iPositions[n][0] - this.m_iPositions[n][1]);
                short s3 = (short)(this.m_iPositions[n][2] + this.m_iPositions[n][0]);
                this.setPropertyValueWithNameAndLevel(new Short(s), n, 9);
                this.setPropertyValueWithNameAndLevel(new Short(s2), n, 8);
                this.setPropertyValueWithNameAndLevel(new Short(s3), n, 7);
                ++n;
            }
        }
    }

    private int[] plausibilityCheck(int[] nArray) throws BasicErrorException {
        int n = 2;
        nArray[0] = 0;
        nArray[2] = 0;
        nArray[1] = 0;
        if (nArray[3] != 0) {
            nArray[2] = 0;
        } else if (nArray[2] < nArray[1]) {
            DebugHelper.exception(73, "TabPosition");
        }
        int n2 = nArray[0] - nArray[1];
        if (n2 <= n && n2 >= -n) {
            nArray[1] = nArray[0];
        }
        if ((n2 = nArray[2] - nArray[1]) <= n && n2 >= -n) {
            nArray[2] = nArray[1];
        }
        return nArray;
    }

    private void initializePositions() throws BasicErrorException {
        int n = 0;
        while (n < 9) {
            int n2 = NumericalHelper.toInt(this.getPropertyValueWithNameAndLevel(n, 9), 0);
            int n3 = NumericalHelper.toInt(this.getPropertyValueWithNameAndLevel(n, 8), 0);
            int n4 = NumericalHelper.toInt(this.getPropertyValueWithNameAndLevel(n, 7), 0);
            this.m_iPositions[n][0] = n2 + n3;
            this.m_iPositions[n][2] = n2 + n3 + n4;
            this.m_iPositions[n][1] = n2;
            this.m_iPositions[n][3] = 0;
            ++n;
        }
    }

    public int getTemplatesCount() throws BasicErrorException {
        int n = 0;
        switch (this.iListType) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 9;
                break;
            }
            default: {
                DebugHelper.exception(51, "");
            }
        }
        return n;
    }

    private void createBulletListTemplate(int n) {
        this.m_pvProperties[0][4].Value = "Bullet Symbols";
        this.m_pvProperties[0][0].Value = new Short(6);
        switch (n) {
            case 1: {
                this.m_pvProperties[0][5].Value = new Short(8226);
                break;
            }
            case 2: {
                this.m_pvProperties[0][5].Value = new Short(111);
                break;
            }
            case 3: {
                this.m_pvProperties[0][5].Value = new Short(9632);
                break;
            }
            case 4: {
                this.m_pvProperties[0][5].Value = new Short(10026);
                break;
            }
            case 5: {
                this.m_pvProperties[0][5].Value = new Short(10070);
                break;
            }
            case 6: {
                this.m_pvProperties[0][5].Value = new Short(10146);
                break;
            }
            case 7: {
                this.m_pvProperties[0][5].Value = new Short(10003);
                break;
            }
            default: {
                this.m_pvProperties[0][5].Value = new Short(8226);
            }
        }
    }

    private void createNumberedListTemplate(int n) {
        switch (n) {
            case 1: {
                this.m_pvProperties[0][0].Value = new Short(4);
                this.m_pvProperties[0][1].Value = ".";
                break;
            }
            case 2: {
                this.m_pvProperties[0][0].Value = new Short(4);
                this.m_pvProperties[0][1].Value = ")";
                break;
            }
            case 3: {
                this.m_pvProperties[0][0].Value = new Short(2);
                this.m_pvProperties[0][1].Value = ".";
                break;
            }
            case 4: {
                this.m_pvProperties[0][0].Value = new Short(0);
                this.m_pvProperties[0][1].Value = ".";
                break;
            }
            case 5: {
                this.m_pvProperties[0][0].Value = new Short(1);
                this.m_pvProperties[0][1].Value = ")";
                break;
            }
            case 6: {
                this.m_pvProperties[0][0].Value = new Short(1);
                this.m_pvProperties[0][1].Value = ".";
                break;
            }
            case 7: {
                this.m_pvProperties[0][0].Value = new Short(3);
                this.m_pvProperties[0][1].Value = ".";
                break;
            }
            default: {
                this.m_pvProperties[0][0].Value = new Short(12);
                this.m_pvProperties[0][1].Value = ".";
            }
        }
    }

    private XIndexAccess createNumberingRules(XTextDocument xTextDocument) throws BasicErrorException {
        XIndexAccess xIndexAccess = null;
        try {
            XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)OptionalParamUtility.getObject(class$com$sun$star$lang$XMultiServiceFactory == null ? (class$com$sun$star$lang$XMultiServiceFactory = PresetPropertiesForListTemplates.class$("com.sun.star.lang.XMultiServiceFactory")) : class$com$sun$star$lang$XMultiServiceFactory, xTextDocument);
            Object object = xMultiServiceFactory.createInstance("com.sun.star.text.NumberingRules");
            if (object == null) {
                DebugHelper.exception(51, "Cannote create numbering rules.");
            } else {
                xIndexAccess = (XIndexAccess)OptionalParamUtility.getObject(class$com$sun$star$container$XIndexAccess == null ? (class$com$sun$star$container$XIndexAccess = PresetPropertiesForListTemplates.class$("com.sun.star.container.XIndexAccess")) : class$com$sun$star$container$XIndexAccess, object);
                int n = xIndexAccess.getCount();
                XPropertySet xPropertySet = (XPropertySet)OptionalParamUtility.getObject(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = PresetPropertiesForListTemplates.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object);
                String string = (String)xPropertySet.getPropertyValue("Name");
                DebugHelper.writeInfo("Name: '" + string + "'  Count: " + n);
                if (n < 9) {
                    DebugHelper.exception(51, "LevelCount");
                }
            }
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
        }
        return xIndexAccess;
    }

    private void completeNumberingRules() throws BasicErrorException {
        int n;
        int n2 = 1;
        while (n2 < 9) {
            n = 0;
            while (n < 10) {
                if (AnyConverter.isVoid((Object)this.m_pvProperties[n2][n].Value)) {
                    this.m_pvProperties[n2][n] = this.m_pvProperties[0][n];
                }
                ++n;
            }
            ++n2;
        }
        try {
            n = 0;
            while (n < 9) {
                PropertyValue[] propertyValueArray = (PropertyValue[])this.xNumberingRules.getByIndex(n);
                int n3 = 0;
                while (n3 < this.m_pvProperties[0].length) {
                    if (!AnyConverter.isVoid((Object)this.m_pvProperties[n][n3].Value)) {
                        int n4 = 0;
                        while (n4 < propertyValueArray.length) {
                            if (propertyValueArray[n4].Name.equals(this.m_pvProperties[n][n3].Name)) {
                                propertyValueArray[n4].Value = this.m_pvProperties[n][n3].Value;
                                DebugHelper.writeDebug("COMPLETE: " + this.m_pvProperties[n][n3].Name + "  value: " + this.m_pvProperties[n][n3].Value);
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                XIndexReplace xIndexReplace = (XIndexReplace)OptionalParamUtility.getObject(class$com$sun$star$container$XIndexReplace == null ? PresetPropertiesForListTemplates.class$("com.sun.star.container.XIndexReplace") : class$com$sun$star$container$XIndexReplace, this.xNumberingRules);
                xIndexReplace.replaceByIndex(n, (Object)propertyValueArray);
                ++n;
            }
        }
        catch (WrappedTargetException wrappedTargetException) {
            DebugHelper.exception((Exception)((Object)wrappedTargetException));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            DebugHelper.exception((Exception)((Object)indexOutOfBoundsException));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            DebugHelper.exception((Exception)((Object)illegalArgumentException));
        }
    }

    private void createOutlineNumberedListTemplate(int n) {
        switch (n) {
            case 1: {
                this.createOutlineNumberForType1();
                break;
            }
            case 2: {
                this.createOutlineNumberForType2();
                break;
            }
            case 3: {
                this.createOutlineNumberForType3();
                break;
            }
            case 4: {
                this.createOutlineNumberForType4();
                break;
            }
            case 5: {
                this.createOutlineNumberForType5();
                break;
            }
            case 6: {
                this.createOutlineNumberForType6();
                break;
            }
            case 7: {
                this.createOutlineNumberForType7();
                break;
            }
        }
    }

    private void createOutlineNumberForType1() {
        this.m_pvProperties[0][0].Value = new Short(4);
        this.m_pvProperties[0][1].Value = ")";
        this.m_pvProperties[1][0].Value = new Short(4);
        this.m_pvProperties[1][1].Value = ")";
        this.m_pvProperties[2][0].Value = new Short(3);
        this.m_pvProperties[2][1].Value = ")";
        this.m_pvProperties[3][0].Value = new Short(4);
        this.m_pvProperties[3][2].Value = "(";
        this.m_pvProperties[3][1].Value = ")";
        this.m_pvProperties[4][0].Value = new Short(1);
        this.m_pvProperties[4][2].Value = "(";
        this.m_pvProperties[4][1].Value = ")";
        this.m_pvProperties[5][0].Value = new Short(3);
        this.m_pvProperties[5][2].Value = "(";
        this.m_pvProperties[5][1].Value = ")";
        this.m_pvProperties[6][0].Value = new Short(4);
        this.m_pvProperties[6][1].Value = ".";
        this.m_pvProperties[7][0].Value = new Short(1);
        this.m_pvProperties[7][1].Value = ".";
        this.m_pvProperties[8][0].Value = new Short(3);
        this.m_pvProperties[8][1].Value = ".";
    }

    private void createOutlineNumberForType2() {
        this.m_pvProperties[0][0].Value = new Short(4);
        this.m_pvProperties[0][1].Value = ".";
        int n = 1;
        while (n < 9) {
            this.m_pvProperties[n][0].Value = new Short(4);
            this.m_pvProperties[n][1].Value = ".";
            this.m_pvProperties[n][3].Value = new Short((short)(n - 1));
            ++n;
        }
    }

    private void createOutlineNumberForType3() {
        int n = 0;
        while (n < 9) {
            this.m_pvProperties[n][4].Value = "Bullet Symbols";
            this.m_pvProperties[n][0].Value = new Short(6);
            ++n;
        }
        this.m_pvProperties[0][5].Value = new Short(10070);
        this.m_pvProperties[1][5].Value = new Short(10146);
        this.m_pvProperties[2][5].Value = new Short(9632);
        this.m_pvProperties[3][5].Value = new Short(8226);
        this.m_pvProperties[4][5].Value = new Short(10022);
        this.m_pvProperties[5][5].Value = new Short(10146);
        this.m_pvProperties[6][5].Value = new Short(9632);
        this.m_pvProperties[7][5].Value = new Short(8226);
        this.m_pvProperties[8][5].Value = new Short(10022);
    }

    private void createOutlineNumberForType4() {
        this.m_pvProperties[0][0].Value = new Short(2);
        this.m_pvProperties[0][1].Value = ".";
        this.m_pvProperties[1][0].Value = new Short(4);
        this.m_pvProperties[1][3].Value = new Short(0);
        this.m_pvProperties[2][0].Value = new Short(1);
        this.m_pvProperties[2][2].Value = "(";
        this.m_pvProperties[2][1].Value = ")";
        this.m_pvProperties[3][0].Value = new Short(3);
        this.m_pvProperties[3][2].Value = "(";
        this.m_pvProperties[3][1].Value = ")";
        this.m_pvProperties[4][0].Value = new Short(4);
        this.m_pvProperties[4][1].Value = ")";
        this.m_pvProperties[5][0].Value = new Short(1);
        this.m_pvProperties[5][1].Value = ")";
        this.m_pvProperties[6][0].Value = new Short(3);
        this.m_pvProperties[6][1].Value = ")";
        this.m_pvProperties[7][0].Value = new Short(1);
        this.m_pvProperties[7][1].Value = ".";
        this.m_pvProperties[8][0].Value = new Short(3);
        this.m_pvProperties[8][1].Value = ".";
    }

    private void createOutlineNumberForType5() {
        this.m_pvProperties[0][0].Value = new Short(4);
        this.m_pvProperties[0][1].Value = ".";
        int n = 1;
        while (n < 9) {
            this.m_pvProperties[n][0].Value = new Short(4);
            this.m_pvProperties[n][1].Value = ".";
            this.m_pvProperties[n][3].Value = new Short((short)(n - 1));
            ++n;
        }
    }

    private void createOutlineNumberForType6() {
        this.m_pvProperties[0][0].Value = new Short(2);
        this.m_pvProperties[0][1].Value = ".";
        this.m_pvProperties[1][0].Value = new Short(0);
        this.m_pvProperties[1][1].Value = ".";
        this.m_pvProperties[2][0].Value = new Short(4);
        this.m_pvProperties[2][1].Value = ".";
        this.m_pvProperties[3][0].Value = new Short(1);
        this.m_pvProperties[3][1].Value = ")";
        this.m_pvProperties[4][0].Value = new Short(4);
        this.m_pvProperties[4][2].Value = "(";
        this.m_pvProperties[4][1].Value = ")";
        this.m_pvProperties[5][0].Value = new Short(1);
        this.m_pvProperties[5][2].Value = "(";
        this.m_pvProperties[5][1].Value = ")";
        this.m_pvProperties[6][0].Value = new Short(3);
        this.m_pvProperties[6][2].Value = "(";
        this.m_pvProperties[6][1].Value = ")";
        this.m_pvProperties[7][0].Value = new Short(1);
        this.m_pvProperties[7][2].Value = "(";
        this.m_pvProperties[7][1].Value = ")";
        this.m_pvProperties[8][0].Value = new Short(3);
        this.m_pvProperties[8][2].Value = "(";
        this.m_pvProperties[8][1].Value = ")";
    }

    private void createOutlineNumberForType7() {
        this.m_pvProperties[0][0].Value = new Short(4);
        int n = 1;
        while (n < 9) {
            this.m_pvProperties[n][0].Value = new Short(5);
            ++n;
        }
    }

    private void createPropertyPreset() {
        this.m_pvProperties = new PropertyValue[9][10];
        this.m_pvProperties[0][0] = new PropertyValue();
        this.m_pvProperties[0][0].Name = "NumberingType";
        this.m_pvProperties[0][0].Value = new Short(5);
        this.m_pvProperties[0][3] = new PropertyValue();
        this.m_pvProperties[0][3].Name = "ParentNumbering";
        this.m_pvProperties[0][2] = new PropertyValue();
        this.m_pvProperties[0][2].Name = "Prefix";
        this.m_pvProperties[0][1] = new PropertyValue();
        this.m_pvProperties[0][1].Name = "Suffix";
        this.m_pvProperties[0][6] = new PropertyValue();
        this.m_pvProperties[0][6].Name = "StartWith";
        this.m_pvProperties[0][4] = new PropertyValue();
        this.m_pvProperties[0][4].Name = "CharStyleName";
        this.m_pvProperties[0][5] = new PropertyValue();
        this.m_pvProperties[0][5].Name = "BulletId";
        this.m_pvProperties[0][7] = new PropertyValue();
        this.m_pvProperties[0][7].Name = "SymbolTextDistance";
        this.m_pvProperties[0][8] = new PropertyValue();
        this.m_pvProperties[0][8].Name = "FirstLineOffset";
        this.m_pvProperties[0][9] = new PropertyValue();
        this.m_pvProperties[0][9].Name = "LeftMargin";
        int n = 1;
        while (n < 9) {
            int n2 = 0;
            while (n2 < 10) {
                if (this.m_pvProperties[n][n2] == null) {
                    this.m_pvProperties[n][n2] = new PropertyValue();
                    this.m_pvProperties[n][n2].Name = this.m_pvProperties[0][n2].Name;
                }
                ++n2;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

