/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XDispatchResultListener;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XNotifyingDispatch;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.Filename;
import com.sun.star.helper.common.IniFile;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.helper.common.ResultListenerImpl;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.registry.InvalidRegistryException;
import com.sun.star.registry.InvalidValueException;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.registry.XSimpleRegistry;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.io.File;
import java.util.ArrayList;

public class CommonUtilities {
    private static String m_sSetupVersion = null;
    private static final int LENGTH_PROGRAM_AND_FS = 8;
    private static final int ONE_MILLISECOND = 1000;
    static /* synthetic */ Class class$com$sun$star$registry$XSimpleRegistry;
    static /* synthetic */ Class class$com$sun$star$util$XURLTransformer;
    static /* synthetic */ Class class$com$sun$star$frame$XDispatchProvider;
    static /* synthetic */ Class class$com$sun$star$frame$XNotifyingDispatch;

    public static synchronized String getVersion() {
        block9: {
            try {
                if (m_sSetupVersion != null) break block9;
                XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
                if (xMultiServiceFactory == null) {
                    return "Unknown version.";
                }
                Object object = null;
                try {
                    object = xMultiServiceFactory.createInstance("com.sun.star.configuration.ConfigurationRegistry");
                }
                catch (Exception exception) {
                    DebugHelper.exception(exception);
                }
                XSimpleRegistry xSimpleRegistry = (XSimpleRegistry)UnoRuntime.queryInterface((Class)(class$com$sun$star$registry$XSimpleRegistry == null ? (class$com$sun$star$registry$XSimpleRegistry = CommonUtilities.class$("com.sun.star.registry.XSimpleRegistry")) : class$com$sun$star$registry$XSimpleRegistry), (Object)object);
                if (xSimpleRegistry == null) break block9;
                try {
                    xSimpleRegistry.open("org.openoffice.Setup", true, false);
                    if (xSimpleRegistry.isValid()) {
                        XRegistryKey xRegistryKey = xSimpleRegistry.getRootKey();
                        m_sSetupVersion = xRegistryKey.openKey("Product/ooSetupVersion").getStringValue();
                        xSimpleRegistry.close();
                    }
                }
                catch (InvalidRegistryException invalidRegistryException) {
                    DebugHelper.exception((Exception)((Object)invalidRegistryException));
                }
                catch (InvalidValueException invalidValueException) {
                    DebugHelper.exception((Exception)((Object)invalidValueException));
                }
            }
            catch (BasicErrorException basicErrorException) {
                DebugHelper.writeInfo("can't get version info.");
            }
        }
        return m_sSetupVersion;
    }

    public static boolean isVersion8() {
        String string = CommonUtilities.getVersion();
        return string.startsWith("8");
    }

    public static boolean isVersion7() {
        String string = CommonUtilities.getVersion();
        return string.startsWith("7");
    }

    public static PropertyValue[] createPropertyValueArrayFormArrayList(ArrayList arrayList) {
        PropertyValue[] propertyValueArray = null;
        if (arrayList == null) {
            propertyValueArray = new PropertyValue[]{};
        } else if (arrayList.size() > 0) {
            propertyValueArray = new PropertyValue[arrayList.size()];
            int n = 0;
            while (n < arrayList.size()) {
                propertyValueArray[n] = (PropertyValue)arrayList.get(n);
                ++n;
            }
        } else {
            propertyValueArray = new PropertyValue[]{};
        }
        return propertyValueArray;
    }

    public static String getConvertMsoEncodingToSOCharSet(int n) throws NoSupportException {
        String string;
        String string2 = "<NS>";
        switch (n) {
            case 1256: {
                string = "iso88596";
                break;
            }
            case 708: {
                string = "asmo708";
                break;
            }
            case 720: {
                string = "asmo708";
                break;
            }
            case 1257: {
                string = "windows1257";
                break;
            }
            case 1250: {
                string = "windows1250";
                break;
            }
            case 1251: {
                string = "windows1251";
                break;
            }
            case 20420: {
                string = string2;
                break;
            }
            case 20277: {
                string = string2;
                break;
            }
            case 20278: {
                string = string2;
                break;
            }
            case 20297: {
                string = string2;
                break;
            }
            case 20273: {
                string = string2;
                break;
            }
            case 20423: {
                string = string2;
                break;
            }
            case 875: {
                string = string2;
                break;
            }
            case 20424: {
                string = string2;
                break;
            }
            case 20871: {
                string = string2;
                break;
            }
            case 500: {
                string = string2;
                break;
            }
            case 20280: {
                string = string2;
                break;
            }
            case 20290: {
                string = string2;
                break;
            }
            case 50930: {
                string = string2;
                break;
            }
            case 50939: {
                string = string2;
                break;
            }
            case 20833: {
                string = string2;
                break;
            }
            case 50933: {
                string = string2;
                break;
            }
            case 20284: {
                string = string2;
                break;
            }
            case 870: {
                string = string2;
                break;
            }
            case 20880: {
                string = string2;
                break;
            }
            case 21025: {
                string = string2;
                break;
            }
            case 50935: {
                string = string2;
                break;
            }
            case 20838: {
                string = string2;
                break;
            }
            case 20905: {
                string = string2;
                break;
            }
            case 1026: {
                string = string2;
                break;
            }
            case 20285: {
                string = string2;
                break;
            }
            case 37: {
                string = string2;
                break;
            }
            case 50931: {
                string = string2;
                break;
            }
            case 50937: {
                string = string2;
                break;
            }
            case 51936: {
                string = string2;
                break;
            }
            case 51932: {
                string = "eucjp";
                break;
            }
            case 51949: {
                string = "euckr";
                break;
            }
            case 51950: {
                string = string2;
                break;
            }
            case 29001: {
                string = string2;
                break;
            }
            case 21027: {
                string = string2;
                break;
            }
            case 1253: {
                string = "windows1253";
                break;
            }
            case 1255: {
                string = "windows1255";
                break;
            }
            case 52936: {
                string = string2;
                break;
            }
            case 20106: {
                string = string2;
                break;
            }
            case 20105: {
                string = string2;
                break;
            }
            case 20108: {
                string = string2;
                break;
            }
            case 20107: {
                string = string2;
                break;
            }
            case 50229: {
                string = "iso2022cn";
                break;
            }
            case 50227: {
                string = "iso2022cn";
                break;
            }
            case 50222: {
                string = "iso2022jp";
                break;
            }
            case 50221: {
                string = "iso2022jp";
                break;
            }
            case 50220: {
                string = "iso2022jp";
                break;
            }
            case 50225: {
                string = "iso2022kr";
                break;
            }
            case 20269: {
                string = string2;
                break;
            }
            case 28605: {
                string = "iso885915";
                break;
            }
            case 28591: {
                string = "iso88591";
                break;
            }
            case 28592: {
                string = "iso88592";
                break;
            }
            case 28593: {
                string = "iso88593";
                break;
            }
            case 28594: {
                string = "iso88594";
                break;
            }
            case 28595: {
                string = "iso88595";
                break;
            }
            case 28596: {
                string = "iso88596";
                break;
            }
            case 28597: {
                string = "iso88597";
                break;
            }
            case 28598: {
                string = "iso88598";
                break;
            }
            case 28599: {
                string = "iso88599";
                break;
            }
            case 932: {
                string = "shiftjis";
                break;
            }
            case 20866: {
                string = "koi8r";
                break;
            }
            case 21866: {
                string = "koi8u";
                break;
            }
            case 949: {
                string = "korean";
                break;
            }
            case 1361: {
                string = "cp1361";
                break;
            }
            case 10004: {
                string = "10004";
                break;
            }
            case 10082: {
                string = "10082";
                break;
            }
            case 10007: {
                string = "10007";
                break;
            }
            case 10006: {
                string = "10006";
                break;
            }
            case 10005: {
                string = "10005";
                break;
            }
            case 10079: {
                string = "10079";
                break;
            }
            case 10001: {
                string = "10001";
                break;
            }
            case 10003: {
                string = "10003";
                break;
            }
            case 10029: {
                string = "10029";
                break;
            }
            case 10000: {
                string = "10000";
                break;
            }
            case 10010: {
                string = "10010";
                break;
            }
            case 10008: {
                string = "10008";
                break;
            }
            case 10002: {
                string = "10002";
                break;
            }
            case 10081: {
                string = "10081";
                break;
            }
            case 10017: {
                string = "10017";
                break;
            }
            case 864: {
                string = string2;
                break;
            }
            case 775: {
                string = string2;
                break;
            }
            case 863: {
                string = string2;
                break;
            }
            case 855: {
                string = string2;
                break;
            }
            case 866: {
                string = string2;
                break;
            }
            case 737: {
                string = string2;
                break;
            }
            case 862: {
                string = string2;
                break;
            }
            case 861: {
                string = string2;
                break;
            }
            case 869: {
                string = string2;
                break;
            }
            case 850: {
                string = string2;
                break;
            }
            case 852: {
                string = string2;
                break;
            }
            case 865: {
                string = string2;
                break;
            }
            case 860: {
                string = string2;
                break;
            }
            case 857: {
                string = string2;
                break;
            }
            case 437: {
                string = string2;
                break;
            }
            case 936: {
                string = "gbk";
                break;
            }
            case 20261: {
                string = string2;
                break;
            }
            case 20000: {
                string = string2;
                break;
            }
            case 20002: {
                string = string2;
                break;
            }
            case 20003: {
                string = string2;
                break;
            }
            case 20001: {
                string = string2;
                break;
            }
            case 20004: {
                string = string2;
                break;
            }
            case 20005: {
                string = string2;
                break;
            }
            case 874: {
                string = "cp874";
                break;
            }
            case 950: {
                string = "big5";
                break;
            }
            case 1254: {
                string = "windows1254";
                break;
            }
            case 1201: {
                string = string2;
                break;
            }
            case 1200: {
                string = "unicode";
                break;
            }
            case 20127: {
                string = "usascii";
                break;
            }
            case 65000: {
                string = "utf7";
                break;
            }
            case 65001: {
                string = "utf8";
                break;
            }
            case 1258: {
                string = "windows1258";
                break;
            }
            case 1252: {
                string = "windows1252";
                break;
            }
            default: {
                string = string2;
            }
        }
        if (string.equals(string2)) {
            throw new NoSupportException("MsoEncoding '" + n + "' has no Charset equivalent.");
        }
        return string;
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("windows");
    }

    public static boolean isUnix() {
        String string = System.getProperty("os.name");
        if (string.equals("Linux")) {
            return true;
        }
        if (string.toLowerCase().startsWith("solaris")) {
            return true;
        }
        return !CommonUtilities.isWindows();
    }

    public static String getBuildID(String string) throws BasicErrorException {
        int n;
        String string2 = "";
        if (string.startsWith("\"")) {
            n = string.indexOf("\"", 1);
            if (n != -1) {
                string2 = string.substring(1, n);
            }
        } else {
            n = string.indexOf(" ", 1);
            string2 = n == -1 ? string : string.substring(0, n);
        }
        String string3 = System.getProperty("file.separator");
        String string4 = "";
        File file = new File(string2);
        if (file.exists()) {
            int n2 = string2.lastIndexOf(string3 + "program");
            if (n2 == -1 && CommonUtilities.isWindows()) {
                n2 = string2.toLowerCase().lastIndexOf(string3 + "program");
            }
            if ((string4 = CommonUtilities.getBuildIDFromBootstrap(string2 = string2.substring(0, n2 + 8))).length() == 0) {
                string4 = CommonUtilities.getBuildIDFromVersion(string2);
            }
        } else {
            DebugHelper.writeInfo("Office executable not found.");
        }
        return string4;
    }

    private static String getBuildIDFromBootstrap(String string) throws BasicErrorException {
        String string2 = System.getProperty("file.separator");
        String string3 = "";
        String string4 = string;
        string4 = CommonUtilities.isWindows() ? string4 + string2 + "bootstrap.ini" : string4 + string2 + "bootstraprc";
        IniFile iniFile = new IniFile(string4);
        if (iniFile.is()) {
            string3 = iniFile.getValue("Bootstrap", "buildid");
        } else {
            DebugHelper.writeInfo("Property Build, can't open file '" + string4 + "', please check.");
        }
        return string3;
    }

    private static String getBuildIDFromVersion(String string) throws BasicErrorException {
        String string2 = System.getProperty("file.separator");
        String string3 = "";
        String string4 = string;
        string4 = CommonUtilities.isWindows() ? string4 + string2 + "version.ini" : string4 + string2 + "versionrc";
        IniFile iniFile = new IniFile(string4);
        if (iniFile.is()) {
            string3 = iniFile.getValue("Version", "buildid");
        } else {
            DebugHelper.writeInfo("Property Build, can't open file '" + string4 + "', please check.");
        }
        return string3;
    }

    public static Object ApplicationRun(XFrame xFrame, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, Object object15, Object object16, Object object17, Object object18, Object object19, Object object20, Object object21, Object object22, Object object23, Object object24, Object object25, Object object26, Object object27, Object object28, Object object29, Object object30) throws BasicErrorException {
        try {
            Object object31;
            int n = 0;
            if (!AnyConverter.isVoid((Object)object)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object2)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object3)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object4)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object5)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object6)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object7)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object8)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object9)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object10)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object11)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object12)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object13)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object14)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object15)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object16)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object17)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object18)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object19)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object20)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object21)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object22)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object23)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object24)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object25)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object26)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object27)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object28)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object29)) {
                ++n;
            }
            if (!AnyConverter.isVoid((Object)object30)) {
                ++n;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Standard.").append(string);
            if (n > 0) {
                object31 = new String[n];
                int n2 = 0;
                if (!AnyConverter.isVoid((Object)object)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg1", object, "", false);
                    if (string.equals("TestMacros.SleepInSeconds")) {
                        DebugHelper.writeInfo("TestMacros.SleepInSeconds waits really in seconds. ");
                        int n3 = OptionalParamUtility.getInt("varg1", object, 0, false);
                        if (n3 != 0) {
                            CommonUtilities.SleepInSeconds(n3);
                        }
                    }
                }
                if (!AnyConverter.isVoid((Object)object2)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg2", object2, "", false);
                }
                if (!AnyConverter.isVoid((Object)object3)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg3", object3, "", false);
                }
                if (!AnyConverter.isVoid((Object)object4)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg4", object4, "", false);
                }
                if (!AnyConverter.isVoid((Object)object5)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg5", object5, "", false);
                }
                if (!AnyConverter.isVoid((Object)object6)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg6", object6, "", false);
                }
                if (!AnyConverter.isVoid((Object)object7)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg7", object7, "", false);
                }
                if (!AnyConverter.isVoid((Object)object8)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg8", object8, "", false);
                }
                if (!AnyConverter.isVoid((Object)object9)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg9", object9, "", false);
                }
                if (!AnyConverter.isVoid((Object)object10)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg10", object10, "", false);
                }
                if (!AnyConverter.isVoid((Object)object11)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg11", object11, "", false);
                }
                if (!AnyConverter.isVoid((Object)object12)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg12", object12, "", false);
                }
                if (!AnyConverter.isVoid((Object)object13)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg13", object13, "", false);
                }
                if (!AnyConverter.isVoid((Object)object14)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg14", object14, "", false);
                }
                if (!AnyConverter.isVoid((Object)object15)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg15", object15, "", false);
                }
                if (!AnyConverter.isVoid((Object)object16)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg16", object16, "", false);
                }
                if (!AnyConverter.isVoid((Object)object17)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg17", object17, "", false);
                }
                if (!AnyConverter.isVoid((Object)object18)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg18", object18, "", false);
                }
                if (!AnyConverter.isVoid((Object)object19)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg19", object19, "", false);
                }
                if (!AnyConverter.isVoid((Object)object20)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg20", object20, "", false);
                }
                if (!AnyConverter.isVoid((Object)object21)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg21", object21, "", false);
                }
                if (!AnyConverter.isVoid((Object)object22)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg22", object22, "", false);
                }
                if (!AnyConverter.isVoid((Object)object23)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg23", object23, "", false);
                }
                if (!AnyConverter.isVoid((Object)object24)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg24", object24, "", false);
                }
                if (!AnyConverter.isVoid((Object)object25)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg25", object25, "", false);
                }
                if (!AnyConverter.isVoid((Object)object26)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg26", object26, "", false);
                }
                if (!AnyConverter.isVoid((Object)object27)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg27", object27, "", false);
                }
                if (!AnyConverter.isVoid((Object)object28)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg28", object28, "", false);
                }
                if (!AnyConverter.isVoid((Object)object29)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg29", object29, "", false);
                }
                if (!AnyConverter.isVoid((Object)object30)) {
                    object31[n2++] = OptionalParamUtility.getAsStringForApplicationRun("varg30", object30, "", false);
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl = false;
                n2 = 0;
                while (n2 < n) {
                    if (bl) {
                        stringBuffer2.append(",");
                    }
                    stringBuffer2.append(object31[n2]);
                    bl = true;
                    ++n2;
                }
                stringBuffer.append("(").append(stringBuffer2).append(")");
            }
            object31 = stringBuffer.toString();
            Object object32 = CommonUtilities.runBasicMacro((String)object31, xFrame);
            return object32;
        }
        catch (Exception exception) {
            DebugHelper.exception(exception);
            return null;
        }
    }

    public static Object runBasicMacro(String string, XFrame xFrame) throws Exception {
        XMultiServiceFactory xMultiServiceFactory = ApplicationImpl.getXMultiServiceFactory();
        XURLTransformer xURLTransformer = (XURLTransformer)OptionalParamUtility.getObject(class$com$sun$star$util$XURLTransformer == null ? (class$com$sun$star$util$XURLTransformer = CommonUtilities.class$("com.sun.star.util.XURLTransformer")) : class$com$sun$star$util$XURLTransformer, xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer"));
        XDispatchProvider xDispatchProvider = (XDispatchProvider)OptionalParamUtility.getObject(class$com$sun$star$frame$XDispatchProvider == null ? (class$com$sun$star$frame$XDispatchProvider = CommonUtilities.class$("com.sun.star.frame.XDispatchProvider")) : class$com$sun$star$frame$XDispatchProvider, xFrame);
        URL[] uRLArray = new URL[]{new URL()};
        uRLArray[0].Complete = "macro://./" + string;
        xURLTransformer.parseStrict(uRLArray);
        URL uRL = uRLArray[0];
        ResultListenerImpl resultListenerImpl = new ResultListenerImpl();
        XDispatch xDispatch = xDispatchProvider.queryDispatch(uRL, "", 0);
        XNotifyingDispatch xNotifyingDispatch = (XNotifyingDispatch)UnoRuntime.queryInterface((Class)(class$com$sun$star$frame$XNotifyingDispatch == null ? (class$com$sun$star$frame$XNotifyingDispatch = CommonUtilities.class$("com.sun.star.frame.XNotifyingDispatch")) : class$com$sun$star$frame$XNotifyingDispatch), (Object)xDispatch);
        if (xNotifyingDispatch == null) {
            throw new Exception("Problems with dispatch.");
        }
        xNotifyingDispatch.dispatchWithNotification(uRL, new PropertyValue[0], (XDispatchResultListener)resultListenerImpl);
        Object object = resultListenerImpl.getResult();
        DebugHelper.writeInfo("Internal problem, the return value can not given back.");
        return object;
    }

    public static void SleepInSeconds(int n) {
        try {
            Thread.sleep(n * 1000);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static String getSystemPathFromURL(String string) {
        String string2 = "";
        int n = string.indexOf("file://");
        if (n < 0) {
            string2 = string;
        } else {
            string = Filename.decodeOOoFilename(string);
            string2 = string.substring("file://".length());
        }
        String string3 = System.getProperty("file.separator");
        if (string3.equalsIgnoreCase("\\")) {
            string2 = string2.substring(1);
            string2 = string2.replace('/', '\\');
        }
        return string2;
    }

    public static String getURLFromSystemPath(String string) {
        if (string.startsWith("http:")) {
            return string;
        }
        if (string.startsWith("file:")) {
            return string;
        }
        string = Filename.encodeOOoFilename(string);
        String string2 = null;
        if (string.startsWith("\\\\")) {
            string2 = "file:";
        }
        string = string.replace('\\', '/');
        if (string2 == null) {
            string2 = string.startsWith("//") ? "file:/" : (string.startsWith("/") ? "file://" : "file:///");
        }
        String string3 = string2 + string;
        return string3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

