/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.common;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;

public class AccessibilityTools {
    protected static XAccessibleContext SearchedContext = null;
    protected static XAccessible SearchedAccessible = null;
    private static boolean debug = DebugHelper.isCompiledWithDebugInformation();
    static /* synthetic */ Class class$com$sun$star$lang$XServiceInfo;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleComponent;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessibleContext;
    static /* synthetic */ Class class$com$sun$star$accessibility$XAccessible;

    private AccessibilityTools() {
    }

    public static XWindow getCurrentContainerWindow(XModel xModel) {
        return AccessibilityTools.getWindow(xModel, true);
    }

    public static XWindow getCurrentWindow(XModel xModel) {
        return AccessibilityTools.getWindow(xModel, false);
    }

    private static XWindow getWindow(XModel xModel, boolean bl) {
        XWindow xWindow = null;
        try {
            XFrame xFrame;
            XController xController;
            if (xModel == null) {
                DebugHelper.writeInfo("invalid model (==null)");
            }
            if ((xController = xModel.getCurrentController()) == null) {
                DebugHelper.writeInfo("can't get controller from model");
            }
            if ((xFrame = xController.getFrame()) == null) {
                DebugHelper.writeInfo("can't get frame from controller");
            }
            if ((xWindow = bl ? xFrame.getContainerWindow() : xFrame.getComponentWindow()) == null) {
                DebugHelper.writeInfo("can't get window from frame");
            }
        }
        catch (Exception exception) {
            DebugHelper.writeInfo("caught exception while getting current window" + exception);
        }
        return xWindow;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s) {
        SearchedContext = null;
        SearchedAccessible = null;
        AccessibilityTools.getAccessibleObjectForRole_(xAccessible, s);
        return SearchedContext;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, boolean bl) {
        SearchedContext = null;
        SearchedAccessible = null;
        if (bl) {
            AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing_(xAccessible, s);
        } else {
            AccessibilityTools.getAccessibleObjectForRole_(xAccessible, s);
        }
        return SearchedContext;
    }

    public static void getAccessibleObjectForRoleIgnoreShowing_(XAccessible xAccessible, short s) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessibleContext.getAccessibleRole() == s) {
            SearchedContext = xAccessibleContext;
            SearchedAccessible = xAccessible;
        } else {
            int n = xAccessibleContext.getAccessibleChildCount();
            if (xAccessibleContext.getAccessibleChildCount() > 100) {
                n = 50;
            }
            int n2 = 0;
            while (n2 < n) {
                try {
                    AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing_(xAccessibleContext.getAccessibleChild(n2), s);
                    if (SearchedContext != null) {
                        return;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    DebugHelper.writeInfo("Couldn't get Child");
                }
                ++n2;
            }
        }
    }

    public static void getAccessibleObjectForRole_(XAccessible xAccessible, short s) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        boolean bl = xAccessibleContext.getAccessibleStateSet().contains((short)25);
        if (xAccessibleContext.getAccessibleRole() == s && bl) {
            SearchedContext = xAccessibleContext;
            SearchedAccessible = xAccessible;
        } else {
            int n = xAccessibleContext.getAccessibleChildCount();
            if (xAccessibleContext.getAccessibleChildCount() > 100) {
                n = 50;
            }
            int n2 = 0;
            while (n2 < n) {
                try {
                    AccessibilityTools.getAccessibleObjectForRole_(xAccessibleContext.getAccessibleChild(n2), s);
                    if (SearchedContext != null) {
                        return;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    DebugHelper.writeInfo("Couldn't get Child");
                }
                ++n2;
            }
        }
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, String string) throws IllegalArgumentException {
        return AccessibilityTools.getAccessibleObjectForRole(xAccessible, s, string, "");
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, String string, boolean bl) throws IllegalArgumentException {
        if (bl) {
            return AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(xAccessible, s, string, "");
        }
        return AccessibilityTools.getAccessibleObjectForRole(xAccessible, s, string, "");
    }

    public static XAccessibleContext getAccessibleObjectForRoleIgnoreShowing(XAccessible xAccessible, short s, String string, String string2) throws IllegalArgumentException {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        XServiceInfo xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = AccessibilityTools.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, xAccessibleContext);
        String string3 = xServiceInfo.getImplementationName();
        if (xAccessibleContext.getAccessibleRole() == s && xAccessibleContext.getAccessibleName().indexOf(string) > -1 && string3.indexOf(string2) > -1) {
            SearchedAccessible = xAccessible;
            return xAccessibleContext;
        }
        int n = xAccessibleContext.getAccessibleChildCount();
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n = 50;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(xAccessibleContext.getAccessibleChild(n2), s, string, string2);
                if (xAccessibleContext2 != null) {
                    return xAccessibleContext2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.writeInfo("Couldn't get Child");
            }
            ++n2;
        }
        return null;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xAccessible, short s, String string, String string2) throws IllegalArgumentException {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        XServiceInfo xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = AccessibilityTools.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, xAccessibleContext);
        String string3 = xServiceInfo.getImplementationName();
        boolean bl = xAccessibleContext.getAccessibleStateSet().contains((short)25);
        if (xAccessibleContext.getAccessibleRole() == s && xAccessibleContext.getAccessibleName().indexOf(string) > -1 && string3.indexOf(string2) > -1 && bl) {
            SearchedAccessible = xAccessible;
            return xAccessibleContext;
        }
        int n = xAccessibleContext.getAccessibleChildCount();
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n = 50;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                XAccessibleContext xAccessibleContext2 = AccessibilityTools.getAccessibleObjectForRole(xAccessibleContext.getAccessibleChild(n2), s, string, string2);
                if (xAccessibleContext2 != null) {
                    return xAccessibleContext2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.writeInfo("Couldn't get Child");
            }
            ++n2;
        }
        return null;
    }

    public static void debugPrintAccessibleTree(XAccessible xAccessible) throws IllegalArgumentException {
        if (debug) {
            AccessibilityTools.printAccessibleTree(xAccessible, "");
        }
    }

    private static void printAccessibleTree(XAccessible xAccessible, String string) throws IllegalArgumentException {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        XServiceInfo xServiceInfo = (XServiceInfo)OptionalParamUtility.getObject(class$com$sun$star$lang$XServiceInfo == null ? (class$com$sun$star$lang$XServiceInfo = AccessibilityTools.class$("com.sun.star.lang.XServiceInfo")) : class$com$sun$star$lang$XServiceInfo, xAccessibleContext);
        String string2 = xServiceInfo.getImplementationName();
        DebugHelper.writeInfo(string + xAccessibleContext.getAccessibleRole() + "," + xAccessibleContext.getAccessibleName() + "(" + xAccessibleContext.getAccessibleDescription() + "):" + string2);
        XAccessibleComponent xAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleComponent == null ? (class$com$sun$star$accessibility$XAccessibleComponent = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleComponent")) : class$com$sun$star$accessibility$XAccessibleComponent), (Object)xAccessible);
        if (xAccessibleComponent != null) {
            String string3 = "(" + xAccessibleComponent.getBounds().X + "," + xAccessibleComponent.getBounds().Y + ")" + " (" + xAccessibleComponent.getBounds().Width + "," + xAccessibleComponent.getBounds().Height + ")";
            string3 = "The boundary Rectangle is " + string3;
            DebugHelper.writeInfo(string + string + string3);
        }
        boolean bl = xAccessibleContext.getAccessibleStateSet().contains((short)25);
        DebugHelper.writeInfo(string + string + "StateType contains SHOWING: " + bl);
        int n = xAccessibleContext.getAccessibleChildCount();
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n = 50;
        }
        int n2 = 0;
        while (n2 < n) {
            try {
                AccessibilityTools.printAccessibleTree(xAccessibleContext.getAccessibleChild(n2), string + "  ");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DebugHelper.writeInfo("Couldn't get Child");
            }
            ++n2;
        }
        if (xAccessibleContext.getAccessibleChildCount() > 100) {
            n = xAccessibleContext.getAccessibleChildCount();
            int n3 = xAccessibleContext.getAccessibleChildCount() - 50;
            DebugHelper.writeInfo(string + "  " + " ...... [skipped] ......");
            int n4 = n3;
            while (n4 < n) {
                try {
                    AccessibilityTools.printAccessibleTree(xAccessibleContext.getAccessibleChild(n4), string + "  ");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    DebugHelper.writeInfo("Couldn't get Child");
                }
                ++n4;
            }
        }
    }

    public static String accessibleToString(Object object) {
        XAccessibleContext xAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessibleContext == null ? (class$com$sun$star$accessibility$XAccessibleContext = AccessibilityTools.class$("com.sun.star.accessibility.XAccessibleContext")) : class$com$sun$star$accessibility$XAccessibleContext), (Object)object);
        if (xAccessibleContext != null) {
            return "" + xAccessibleContext.getAccessibleRole() + "," + xAccessibleContext.getAccessibleName() + "(" + xAccessibleContext.getAccessibleDescription() + "):";
        }
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface((Class)(class$com$sun$star$accessibility$XAccessible == null ? (class$com$sun$star$accessibility$XAccessible = AccessibilityTools.class$("com.sun.star.accessibility.XAccessible")) : class$com$sun$star$accessibility$XAccessible), (Object)object);
        if (xAccessible == null) {
            return "(Not supported)";
        }
        xAccessibleContext = xAccessible.getAccessibleContext();
        return "" + xAccessibleContext.getAccessibleRole() + "," + xAccessibleContext.getAccessibleName() + "(" + xAccessibleContext.getAccessibleDescription() + ")";
    }

    public static boolean equals(XAccessible xAccessible, XAccessible xAccessible2) {
        if (xAccessible == null || xAccessible2 == null) {
            return xAccessible == xAccessible2;
        }
        return AccessibilityTools.equals(xAccessible.getAccessibleContext(), xAccessible2.getAccessibleContext());
    }

    public static boolean equals(XAccessibleContext xAccessibleContext, XAccessibleContext xAccessibleContext2) {
        if (xAccessibleContext == null || xAccessibleContext2 == null) {
            return xAccessibleContext == xAccessibleContext2;
        }
        if (xAccessibleContext.getAccessibleRole() != xAccessibleContext2.getAccessibleRole()) {
            return false;
        }
        if (!xAccessibleContext.getAccessibleName().equals(xAccessibleContext2.getAccessibleName())) {
            return false;
        }
        if (!xAccessibleContext.getAccessibleDescription().equals(xAccessibleContext2.getAccessibleDescription())) {
            return false;
        }
        if (xAccessibleContext.getAccessibleChildCount() != xAccessibleContext2.getAccessibleChildCount()) {
            return false;
        }
        return AccessibilityTools.equals(xAccessibleContext.getAccessibleParent(), xAccessibleContext2.getAccessibleParent());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

