/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc.range;

import com.sun.star.beans.XPropertySet;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.CommentImpl;
import com.sun.star.helper.calc.SheetImpl;
import com.sun.star.helper.calc.XCalcRange;
import com.sun.star.helper.calc.XComment;
import com.sun.star.helper.calc.range.AddressImpl;
import com.sun.star.helper.calc.range.RangeImpl;
import com.sun.star.helper.calc.range.RangeRowColumnImpl;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.NumericalHelper;
import com.sun.star.script.BasicErrorException;
import com.sun.star.sheet.CellDeleteMode;
import com.sun.star.sheet.GoalResult;
import com.sun.star.sheet.XCellAddressable;
import com.sun.star.sheet.XGoalSeek;
import com.sun.star.sheet.XSheetAnnotationAnchor;
import com.sun.star.sheet.XSheetOutline;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellContentType;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.text.XText;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XMergeable;

public class RangeSingleCellImpl
extends RangeRowColumnImpl {
    protected XCell mxCell = null;
    protected XText mxText = null;
    protected XTextRange mxTextRange = null;
    static /* synthetic */ Class class$com$sun$star$text$XText;
    static /* synthetic */ Class class$com$sun$star$text$XTextRange;
    static /* synthetic */ Class class$com$sun$star$sheet$XCellAddressable;
    static /* synthetic */ Class class$com$sun$star$util$XMergeable;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetAnnotationAnchor;
    static /* synthetic */ Class class$com$sun$star$sheet$XSheetOutline;
    static /* synthetic */ Class class$com$sun$star$sheet$XGoalSeek;

    public RangeSingleCellImpl(SheetImpl sheetImpl, XPropertySet xPropertySet) throws BasicErrorException {
        super(sheetImpl, xPropertySet);
        try {
            this.mxCell = this.getXCellRange().getCellByPosition(0, 0);
            this.mxText = (XText)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XText == null ? (class$com$sun$star$text$XText = RangeSingleCellImpl.class$("com.sun.star.text.XText")) : class$com$sun$star$text$XText), (Object)this.mxCell);
            this.mxTextRange = (XTextRange)UnoRuntime.queryInterface((Class)(class$com$sun$star$text$XTextRange == null ? (class$com$sun$star$text$XTextRange = RangeSingleCellImpl.class$("com.sun.star.text.XTextRange")) : class$com$sun$star$text$XTextRange), (Object)this.mxCell);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
    }

    protected boolean isColumn() {
        return false;
    }

    public CellDeleteMode getCellDeleteMode() {
        return CellDeleteMode.LEFT;
    }

    public String Address(Object object, Object object2, Object object3, Object object4, Object object5) throws BasicErrorException {
        return AddressImpl.getAddressforSingleCell(this, object, object2, object3, object4, object5);
    }

    public Object getFormula() throws BasicErrorException {
        String string = "";
        string = this.mxCell.getFormula();
        if (string.startsWith("=")) {
            string = string.replaceAll(";", ",");
            string = string.replaceAll("\\.", "!");
        }
        return string;
    }

    public void setFormula(Object object) throws BasicErrorException {
        String string = NumericalHelper.toStringWithErrorMessage(object);
        this.mxCell.setFormula(string);
    }

    public Object getFormulaR1C1() throws BasicErrorException {
        String string = (String)this.getFormula();
        XCellAddressable xCellAddressable = (XCellAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellAddressable == null ? (class$com$sun$star$sheet$XCellAddressable = RangeSingleCellImpl.class$("com.sun.star.sheet.XCellAddressable")) : class$com$sun$star$sheet$XCellAddressable), (Object)this.mxCell);
        CellAddress cellAddress = xCellAddressable.getCellAddress();
        return ((CalcImpl)this.Application()).ConvertFastFormula(string, 1, -4150, cellAddress);
    }

    public Object HasFormula() throws BasicErrorException {
        String string = (String)this.getFormula();
        return string.startsWith("=");
    }

    public Object getValue() throws BasicErrorException {
        Object object = null;
        CellContentType cellContentType = this.mxCell.getType();
        switch (cellContentType.getValue()) {
            case 3: {
                if (this.isCellValueNumeric()) {
                    object = new Double(this.mxCell.getValue());
                    break;
                }
                object = this.mxTextRange.getString();
                break;
            }
            case 1: {
                object = new Double(this.mxCell.getValue());
                break;
            }
            case 0: {
                object = "";
                break;
            }
            case 2: {
                object = this.mxTextRange.getString();
                break;
            }
        }
        return object;
    }

    public void setValue(Object object) throws BasicErrorException {
        block6: {
            try {
                Object var2_2 = null;
                if (NumericalHelper.isNumerical(object)) {
                    this.mxCell.setValue(NumericalHelper.toDouble(object));
                    break block6;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if (string.charAt(0) == '=') {
                        this.mxCell.setFormula(string);
                    } else {
                        this.mxText.setString((String)object);
                    }
                    break block6;
                }
                DebugHelper.exception(1004, "No cells were found");
            }
            catch (Exception exception) {
                DebugHelper.exception(1004, "");
            }
        }
    }

    public boolean isCellValueNumeric() throws BasicErrorException {
        return NumericalHelper.isObjectNumericRepresentation(this.mxTextRange.getString(), this.getNumberFormatter(), this.getXRangePropertySet());
    }

    public Object Text() throws BasicErrorException {
        return this.mxText.getString();
    }

    public Object getMergeCells() throws BasicErrorException {
        XMergeable xMergeable = (XMergeable)UnoRuntime.queryInterface((Class)(class$com$sun$star$util$XMergeable == null ? (class$com$sun$star$util$XMergeable = RangeSingleCellImpl.class$("com.sun.star.util.XMergeable")) : class$com$sun$star$util$XMergeable), (Object)this.getXCellRange());
        boolean bl = xMergeable.getIsMerged();
        if (!bl) {
            bl = super.isMerged(xMergeable);
        }
        return bl;
    }

    public XComment AddComment(Object object) throws BasicErrorException {
        XComment xComment = this.getComment();
        String string = NumericalHelper.toString(object, "");
        if (!string.equals("")) {
            xComment.Text(string, new Integer(1), Boolean.TRUE);
        }
        return xComment;
    }

    public XComment getComment() throws BasicErrorException {
        XSheetAnnotationAnchor xSheetAnnotationAnchor = (XSheetAnnotationAnchor)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetAnnotationAnchor == null ? (class$com$sun$star$sheet$XSheetAnnotationAnchor = RangeSingleCellImpl.class$("com.sun.star.sheet.XSheetAnnotationAnchor")) : class$com$sun$star$sheet$XSheetAnnotationAnchor), (Object)this.mxCell);
        return new CommentImpl(this, xSheetAnnotationAnchor.getAnnotation());
    }

    public XCalcRange SpecialCells(Object object, Object object2) throws BasicErrorException {
        int n = NumericalHelper.toIntWithErrorMessage(object);
        XCalcRange xCalcRange = null;
        Object var5_5 = null;
        Object var6_6 = null;
        switch (n) {
            case -4175: 
            case -4174: 
            case -4173: 
            case -4172: 
            case 11: 
            case 12: {
                break;
            }
            case -4144: 
            case -4123: 
            case 2: 
            case 4: {
                RangeImpl rangeImpl = (RangeImpl)this.getWorksheet().UsedRange();
                if (rangeImpl == null) break;
                CellRangeAddress cellRangeAddress = rangeImpl.getXCellRangeAddressable().getRangeAddress();
                XCalcRange xCalcRange2 = this.getRangeHelper().getRange(1, 1, cellRangeAddress.EndColumn + 1, cellRangeAddress.EndRow + 1);
                xCalcRange = xCalcRange2.SpecialCells(object, object2);
                break;
            }
            default: {
                DebugHelper.exception(1004, "No cells were found");
            }
        }
        if (xCalcRange == null) {
            xCalcRange = (RangeImpl)super.SpecialCells(object, object2);
        }
        return xCalcRange;
    }

    public void AutoOutline() throws BasicErrorException {
        XSheetOutline xSheetOutline = (XSheetOutline)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XSheetOutline == null ? (class$com$sun$star$sheet$XSheetOutline = RangeSingleCellImpl.class$("com.sun.star.sheet.XSheetOutline")) : class$com$sun$star$sheet$XSheetOutline), (Object)this.getXSpreadsheet());
        xSheetOutline.autoOutline(this.getXCellRangeAddressable().getRangeAddress());
    }

    public boolean GoalSeek(Object object, XCalcRange xCalcRange) throws BasicErrorException {
        try {
            XCellAddressable xCellAddressable = (XCellAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellAddressable == null ? (class$com$sun$star$sheet$XCellAddressable = RangeSingleCellImpl.class$("com.sun.star.sheet.XCellAddressable")) : class$com$sun$star$sheet$XCellAddressable), (Object)this.mxCell);
            XCellAddressable xCellAddressable2 = (XCellAddressable)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XCellAddressable == null ? (class$com$sun$star$sheet$XCellAddressable = RangeSingleCellImpl.class$("com.sun.star.sheet.XCellAddressable")) : class$com$sun$star$sheet$XCellAddressable), (Object)((RangeImpl)xCalcRange).getXCellRange());
            XGoalSeek xGoalSeek = (XGoalSeek)UnoRuntime.queryInterface((Class)(class$com$sun$star$sheet$XGoalSeek == null ? (class$com$sun$star$sheet$XGoalSeek = RangeSingleCellImpl.class$("com.sun.star.sheet.XGoalSeek")) : class$com$sun$star$sheet$XGoalSeek), (Object)this.getXModel());
            GoalResult goalResult = xGoalSeek.seekGoal(xCellAddressable.getCellAddress(), xCellAddressable2.getCellAddress(), NumericalHelper.toString(object));
            if (goalResult != null) {
                xCalcRange.setValue(new Double(goalResult.Result));
                return true;
            }
            xCalcRange.setValue(new Double(goalResult.Result));
            return false;
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

