/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.helper.calc;

import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.helper.ApplicationImpl;
import com.sun.star.helper.HelperInterfaceAdaptor;
import com.sun.star.helper.HelperUtilities;
import com.sun.star.helper.XHelperInterface;
import com.sun.star.helper.calc.CalcImpl;
import com.sun.star.helper.calc.SpreadsheetImpl;
import com.sun.star.helper.calc.WindowImpl;
import com.sun.star.helper.calc.XCalc;
import com.sun.star.helper.calc.XSpreadsheet;
import com.sun.star.helper.calc.XWindow;
import com.sun.star.helper.calc.XWindows;
import com.sun.star.helper.common.CollectionHelper;
import com.sun.star.helper.common.DebugHelper;
import com.sun.star.helper.common.OptionalParamUtility;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.script.BasicErrorException;
import com.sun.star.uno.AnyConverter;
import java.util.ArrayList;

public class WindowsImpl
extends HelperInterfaceAdaptor
implements XWindows {
    protected static final String __serviceName = "com.sun.star.helper.calc.Windows";
    private WindowsHelperCache itemWindows = new WindowsHelperCache();

    public WindowsImpl(HelperInterfaceAdaptor helperInterfaceAdaptor) {
        super(__serviceName, helperInterfaceAdaptor);
    }

    public XWindow getActiveWindow() throws BasicErrorException {
        XModel xModel = HelperUtilities.getCurrentModel();
        XFrame xFrame = xModel.getCurrentController().getFrame();
        XHelperInterface xHelperInterface = this.getParent();
        if (xHelperInterface instanceof XSpreadsheet ? this.getXModel() == xModel : xHelperInterface instanceof XCalc && "scalc".equals(HelperUtilities.getModelDocumentType(xModel))) {
            return this.getWindow(xFrame);
        }
        XWindow xWindow = null;
        try {
            xWindow = this.Item(1);
        }
        catch (Exception exception) {
            DebugHelper.exception(1004, "");
        }
        return xWindow;
    }

    public int Count() throws BasicErrorException {
        this.itemWindows.updateCache();
        return this.itemWindows.count();
    }

    public XWindow Item(Object object) throws BasicErrorException {
        if (object != null && !AnyConverter.isLong((Object)object) && !AnyConverter.isString((Object)object)) {
            this.itemWindows.updateCache();
            try {
                if (AnyConverter.isString((Object)object)) {
                    String string = AnyConverter.toString((Object)object);
                    ApplicationImpl.getInstance();
                    SpreadsheetImpl spreadsheetImpl = (SpreadsheetImpl)ApplicationImpl.getCalcImpl().getSpreadsheets().Item(string);
                    if (spreadsheetImpl == null) {
                        DebugHelper.exception(1004, "");
                    }
                    return spreadsheetImpl.getActiveWindow();
                }
                int n = (int)OptionalParamUtility.getAnyNumber("Index", object, 1L, true);
                if (--n < 0 || n > this.itemWindows.count()) {
                    DebugHelper.exception(1004, "");
                }
                return (XWindow)this.itemWindows.item(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugHelper.exception(1004, "");
            }
        } else {
            DebugHelper.exception(1004, "");
        }
        return null;
    }

    XWindow Item(int n) throws BasicErrorException {
        this.itemWindows.updateCache();
        XWindow xWindow = (XWindow)this.itemWindows.item(n - 1);
        if (xWindow == null) {
            DebugHelper.exception(1004, "");
        }
        return xWindow;
    }

    public WindowImpl getWindow(XFrame xFrame) throws BasicErrorException {
        if (this.getParent() instanceof XSpreadsheet) {
            return CalcImpl.getWindow(xFrame);
        }
        return (WindowImpl)this.itemWindows.getOrCreateHelper(xFrame);
    }

    private class WindowsHelperCache
    extends CollectionHelper {
        WindowsHelperCache() {
            super(1);
        }

        public void fetchImplementationObjects(ArrayList arrayList) throws BasicErrorException {
            HelperInterfaceAdaptor helperInterfaceAdaptor = (HelperInterfaceAdaptor)WindowsImpl.this.getParent();
            if (helperInterfaceAdaptor instanceof XSpreadsheet) {
                XModel xModel = helperInterfaceAdaptor.getXModel();
                HelperUtilities.appendOpenDocumentWindows(arrayList, xModel);
            } else if (helperInterfaceAdaptor instanceof XCalc) {
                HelperUtilities.appendOpenWindows("scalc", arrayList);
            }
        }

        public boolean isValidImplementationObject(Object object) {
            return true;
        }

        public HelperInterfaceAdaptor createHelper(Object object) throws BasicErrorException {
            if (WindowsImpl.this.getParent() instanceof XSpreadsheet) {
                return CalcImpl.getWindow((XFrame)object);
            }
            if (object == null) {
                return null;
            }
            XModel xModel = ((XFrame)object).getController().getModel();
            SpreadsheetImpl spreadsheetImpl = CalcImpl.getSpreadsheet(xModel);
            return new WindowImpl(spreadsheetImpl);
        }
    }
}

